/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessparser;

import de.uni_freiburg.informatik.ultimate.core.lib.results.InvalidWitnessErrorResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.witnessparser.Activator;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessEdge;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessEdgeAnnotation;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessGraphAnnotation;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessLocation;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessNode;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessNodeAnnotation;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.io.GraphIOException;
import edu.uci.ics.jung.io.graphml.AbstractMetadata;
import edu.uci.ics.jung.io.graphml.EdgeMetadata;
import edu.uci.ics.jung.io.graphml.GraphMLReader2;
import edu.uci.ics.jung.io.graphml.GraphMetadata;
import edu.uci.ics.jung.io.graphml.HyperEdgeMetadata;
import edu.uci.ics.jung.io.graphml.NodeMetadata;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections15.Transformer;

public class WitnessAutomatonConstructor {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private Map<String, WitnessNode> mNodes;
    private ModelType.Type mWitnessType;
    private WitnessGraphAnnotation mGraphAnnotation;

    public WitnessAutomatonConstructor(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
    }

    public IElement constructWitnessAutomaton(File file) throws FileNotFoundException, GraphIOException {
        DirectedSparseGraph<WitnessNode, WitnessEdge> directedSparseGraph = this.getGraph(file);
        if (directedSparseGraph == null) {
            InvalidWitnessErrorResult invalidWitnessErrorResult = new InvalidWitnessErrorResult(Activator.PLUGIN_ID, "Witness file is invalid");
            this.mWitnessType = ModelType.Type.OTHER;
            this.mLogger.error((Object)invalidWitnessErrorResult);
            this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)invalidWitnessErrorResult);
            this.mServices.getProgressMonitorService().cancelToolchain();
            return null;
        }
        Set set = directedSparseGraph.getVertices().stream().filter(WitnessAutomatonConstructor::isInitialNode).collect(Collectors.toSet());
        if (set.size() > 1) {
            throw new IllegalArgumentException("This file contains a witness with more than one initial location");
        }
        if (set.isEmpty()) {
            throw new IllegalArgumentException("This file contains a witness without an initial location");
        }
        WitnessNode witnessNode = (WitnessNode)((Object)set.iterator().next());
        this.validate(witnessNode);
        this.printDebug(witnessNode);
        this.mGraphAnnotation.annotate(witnessNode);
        switch (this.mGraphAnnotation.getWitnessType()) {
            case VIOLATION_WITNESS: {
                this.mWitnessType = ModelType.Type.VIOLATION_WITNESS;
                break;
            }
            case CORRECTNESS_WITNESS: {
                this.mWitnessType = ModelType.Type.CORRECTNESS_WITNESS;
                break;
            }
            default: {
                this.mWitnessType = ModelType.Type.OTHER;
            }
        }
        return witnessNode;
    }

    private void validate(WitnessNode witnessNode) {
    }

    private void printDebug(WitnessNode witnessNode) {
        if (!this.mLogger.isDebugEnabled()) {
            return;
        }
        ArrayDeque<WitnessNode> arrayDeque = new ArrayDeque<WitnessNode>();
        HashSet<WitnessEdge> hashSet = new HashSet<WitnessEdge>();
        int n = 0;
        this.mLogger.debug((Object)witnessNode);
        for (Object object : witnessNode.getOutgoingEdges()) {
            this.mLogger.debug((Object)("\t-- " + String.valueOf(object) + "--> " + String.valueOf(object.getTarget())));
            arrayDeque.add((WitnessNode)object.getTarget());
            ++n;
        }
        while (!arrayDeque.isEmpty()) {
            Object object;
            object = (WitnessNode)((Object)arrayDeque.removeFirst());
            if (hashSet.contains(object)) continue;
            hashSet.add((WitnessEdge)((Object)object));
            this.mLogger.debug(object);
            for (Object object2 : object.getOutgoingEdges()) {
                this.mLogger.debug((Object)("\t-- " + String.valueOf(object2) + "--> " + String.valueOf(object2.getTarget())));
                arrayDeque.addFirst((WitnessNode)object2.getTarget());
                ++n;
            }
        }
        this.mLogger.debug((Object)("Graph has " + hashSet.size() + "1 nodes and " + n + " edges"));
    }

    private DirectedSparseGraph<WitnessNode, WitnessEdge> getGraph(File file) throws GraphIOException, FileNotFoundException {
        this.mNodes = new HashMap<String, WitnessNode>();
        GraphMLReader2<DirectedSparseGraph<WitnessNode, WitnessEdge>, WitnessNode, WitnessEdge> graphMLReader2 = this.getGraphMLReader(file);
        graphMLReader2.init();
        return (DirectedSparseGraph)graphMLReader2.readGraph();
    }

    private GraphMLReader2<DirectedSparseGraph<WitnessNode, WitnessEdge>, WitnessNode, WitnessEdge> getGraphMLReader(File file) throws FileNotFoundException {
        Transformer<GraphMetadata, DirectedSparseGraph<WitnessNode, WitnessEdge>> transformer = this.getGraphTransformer();
        Transformer<NodeMetadata, WitnessNode> transformer2 = this.getVertexTransformer();
        Transformer<EdgeMetadata, WitnessEdge> transformer3 = this.getEdgeTransformer();
        Transformer<HyperEdgeMetadata, WitnessEdge> transformer4 = WitnessAutomatonConstructor.getHyperEdgeTransformer();
        return new GraphMLReader2((Reader)new FileReader(file), transformer, transformer2, transformer3, transformer4);
    }

    private static Transformer<HyperEdgeMetadata, WitnessEdge> getHyperEdgeTransformer() {
        return hyperEdgeMetadata -> null;
    }

    private Transformer<EdgeMetadata, WitnessEdge> getEdgeTransformer() {
        return edgeMetadata -> {
            WitnessNode witnessNode = this.createNode(edgeMetadata.getSource());
            WitnessNode witnessNode2 = this.createNode(edgeMetadata.getTarget());
            int n = WitnessAutomatonConstructor.getIntProperty(edgeMetadata, "startline");
            int n2 = WitnessAutomatonConstructor.getIntProperty(edgeMetadata, "endline");
            String string = (String)edgeMetadata.getProperties().get("originfile");
            String string2 = (String)edgeMetadata.getProperties().get("sourcecode");
            WitnessLocation witnessLocation = new WitnessLocation(string, n, n2);
            WitnessEdge witnessEdge = new WitnessEdge(witnessNode, witnessNode2, edgeMetadata.getId(), witnessLocation, string2);
            WitnessEdgeAnnotation witnessEdgeAnnotation = new WitnessEdgeAnnotation(WitnessAutomatonConstructor.transformControlToBooleanString((String)edgeMetadata.getProperties().get("control")), (String)edgeMetadata.getProperties().get("enterLoopHead"), (String)edgeMetadata.getProperties().get("enterFunction"), (String)edgeMetadata.getProperties().get("returnFrom"), (String)edgeMetadata.getProperties().get("tokens"), (String)edgeMetadata.getProperties().get("assumption"));
            if (!witnessEdgeAnnotation.isEmpty()) {
                witnessEdgeAnnotation.annotate(witnessEdge);
            }
            return witnessEdge;
        };
    }

    private Transformer<NodeMetadata, WitnessNode> getVertexTransformer() {
        return nodeMetadata -> {
            WitnessNode witnessNode = this.createNode(nodeMetadata.getId());
            WitnessNodeAnnotation witnessNodeAnnotation = new WitnessNodeAnnotation(WitnessAutomatonConstructor.getBoolProperty(nodeMetadata, "entry"), WitnessAutomatonConstructor.getBoolProperty(nodeMetadata, "violation"), WitnessAutomatonConstructor.getBoolProperty(nodeMetadata, "sink"), (String)nodeMetadata.getProperties().get("invariant"));
            if (!witnessNodeAnnotation.isDefault()) {
                witnessNodeAnnotation.annotate(witnessNode);
            }
            return witnessNode;
        };
    }

    private Transformer<GraphMetadata, DirectedSparseGraph<WitnessNode, WitnessEdge>> getGraphTransformer() {
        return graphMetadata -> {
            String string = graphMetadata.getProperty("sourcecodelang");
            WitnessGraphAnnotation.WitnessType witnessType = (WitnessGraphAnnotation.WitnessType)this.getEnumProperty(WitnessGraphAnnotation.WitnessType.class, (AbstractMetadata)graphMetadata, "witness-type", WitnessGraphAnnotation.WitnessType.VIOLATION_WITNESS);
            this.mGraphAnnotation = new WitnessGraphAnnotation(string, witnessType);
            DirectedSparseGraph directedSparseGraph = new DirectedSparseGraph();
            for (Map.Entry entry : graphMetadata.getNodeMap().entrySet()) {
                directedSparseGraph.addVertex((Object)((WitnessNode)((Object)((Object)entry.getKey()))));
            }
            for (Map.Entry entry : graphMetadata.getEdgeMap().entrySet()) {
                WitnessEdge witnessEdge = (WitnessEdge)((Object)((Object)entry.getKey()));
                directedSparseGraph.addEdge((Object)witnessEdge, (Object)((WitnessNode)witnessEdge.getSource()), (Object)((WitnessNode)witnessEdge.getTarget()));
            }
            return directedSparseGraph;
        };
    }

    private static String transformControlToBooleanString(String string) {
        if (string == null) {
            return null;
        }
        if ("condition-true".equalsIgnoreCase(string)) {
            return "true";
        }
        if ("condition-false".equalsIgnoreCase(string)) {
            return "false";
        }
        throw new IllegalArgumentException("control cannot have this value: " + string);
    }

    private static boolean getBoolProperty(NodeMetadata nodeMetadata, String string) {
        String string2 = (String)nodeMetadata.getProperties().get(string);
        return string2 != null && Boolean.valueOf(string2) != false;
    }

    private <T extends Enum<T>> Enum<T> getEnumProperty(Class<T> clazz, AbstractMetadata abstractMetadata, String string, T t) {
        String string2 = (String)abstractMetadata.getProperties().get(string);
        if (string2 == null) {
            this.mLogger.warn((Object)("Your witness does not contain a value for " + string + " in element type " + String.valueOf(abstractMetadata.getMetadataType()) + ". Assuming default value \"" + String.valueOf(t) + "\""));
            return t;
        }
        try {
            return Enum.valueOf(clazz, string2.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.mLogger.error((Object)("Your witness contains an illegal value for " + string + " in element type " + String.valueOf(abstractMetadata.getMetadataType()) + ": \"" + string2 + "\". Assuming default value \"" + String.valueOf(t) + "\""));
            return t;
        }
    }

    private static int getIntProperty(EdgeMetadata edgeMetadata, String string) {
        String string2 = (String)edgeMetadata.getProperties().get(string);
        int n = 0;
        if (string2 != null) {
            try {
                n = Integer.valueOf(string2);
            }
            catch (Exception exception) {
                n = -1;
            }
        } else {
            n = -1;
        }
        return n;
    }

    private static boolean isInitialNode(WitnessNode witnessNode) {
        WitnessNodeAnnotation witnessNodeAnnotation = WitnessNodeAnnotation.getAnnotation((IElement)witnessNode);
        if (witnessNodeAnnotation == null) {
            return false;
        }
        return witnessNodeAnnotation.isInitial();
    }

    private WitnessNode createNode(String string) {
        WitnessNode witnessNode = this.mNodes.get(string);
        if (witnessNode == null) {
            witnessNode = new WitnessNode(string);
            this.mNodes.put(witnessNode.getName(), witnessNode);
        }
        return witnessNode;
    }

    public ModelType.Type getWitnessType() {
        return this.mWitnessType;
    }
}

