/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.counting.Counter;
import de.uni_freiburg.informatik.ultimate.automata.counting.CountingAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.counting.FinalCondition;
import de.uni_freiburg.informatik.ultimate.automata.counting.Guard;
import de.uni_freiburg.informatik.ultimate.automata.counting.InitialCondition;
import de.uni_freiburg.informatik.ultimate.automata.counting.TermType;
import de.uni_freiburg.informatik.ultimate.automata.counting.Transition;
import de.uni_freiburg.informatik.ultimate.automata.counting.Update;
import de.uni_freiburg.informatik.ultimate.automata.counting.datastructures.AtomicCounterAssingment;
import de.uni_freiburg.informatik.ultimate.automata.counting.datastructures.ConjunctiveCounterFormula;
import de.uni_freiburg.informatik.ultimate.automata.counting.datastructures.ConjunctiveTransition;
import de.uni_freiburg.informatik.ultimate.automata.counting.datastructures.CountingAutomatonDataStructure;
import de.uni_freiburg.informatik.ultimate.automata.counting.datastructures.IAtomicCounterGuard;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.DnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.UnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTermTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter.AutomataDefinitionInterpreter;
import de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter.InterpreterException;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.CountingAutomatonAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.StateConditionPairListAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.UpdateAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.UpdateListAST;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.TermParseUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CountingAutomataUtils {
    public static CountingAutomatonDataStructure<String, String> constructCountingAutomaton(IUltimateServiceProvider iUltimateServiceProvider, CountingAutomatonAST countingAutomatonAST) throws InterpreterException {
        Term term;
        Object object;
        Object object22;
        String string = (String)AutomataDefinitionInterpreter.checkForDuplicate(countingAutomatonAST.getStates());
        if (string != null) {
            throw new IllegalArgumentException("State " + string + " contained twice in states.");
        }
        string = (String)AutomataDefinitionInterpreter.checkForDuplicate(countingAutomatonAST.getAlphabet());
        if (string != null) {
            throw new IllegalArgumentException("Letter " + string + " contained twice in initial states.");
        }
        string = (String)AutomataDefinitionInterpreter.checkForDuplicate(countingAutomatonAST.getCounters());
        if (string != null) {
            throw new IllegalArgumentException("Counter " + string + " contained twice in final states.");
        }
        string = new ManagedScript(iUltimateServiceProvider, (Script)new SMTInterpol());
        string.getScript().setLogic(Logics.QF_LIA);
        for (Object object22 : countingAutomatonAST.getCounters()) {
            string.getScript().declareFun((String)object22, new Sort[0], SmtSortUtils.getIntSort((ManagedScript)string));
        }
        object22 = CountingAutomataUtils.stateCondPairList2StateConjunctionMapping(iUltimateServiceProvider, (ManagedScript)string, countingAutomatonAST.getInitialConditions());
        Map<String, LinkedHashSet<ConjunctiveCounterFormula>> map = CountingAutomataUtils.stateCondPairList2StateConjunctionMapping(iUltimateServiceProvider, (ManagedScript)string, countingAutomatonAST.getFinalConditions());
        HashSet hashSet = new HashSet(countingAutomatonAST.getAlphabet());
        HashSet hashSet2 = new HashSet(countingAutomatonAST.getCounters());
        CountingAutomatonDataStructure countingAutomatonDataStructure = new CountingAutomatonDataStructure(new AutomataLibraryServices(iUltimateServiceProvider), hashSet, hashSet2);
        for (String string2 : countingAutomatonAST.getStates()) {
            object = (Set)object22.get(string2);
            if (object == null) {
                object = Collections.emptySet();
            }
            if ((term = (Term)map.get(string2)) == null) {
                term = Collections.emptySet();
            }
            countingAutomatonDataStructure.addState((Object)string2, (Set)object, term);
        }
        for (String string2 : countingAutomatonAST.getTransitions().getTransitions()) {
            object = string2.getGuard();
            term = CountingAutomataUtils.parseAndNormalize((ManagedScript)string, (String)object);
            if (SmtUtils.isFalseLiteral(term)) continue;
            ConjunctiveCounterFormula conjunctiveCounterFormula = CountingAutomataUtils.constructConjunctiveCounterFormula((ManagedScript)string, countingAutomatonAST.getLocation(), term);
            List<AtomicCounterAssingment> list = CountingAutomataUtils.constructAssignmentList((ManagedScript)string, string2.getUpdateList());
            ConjunctiveTransition conjunctiveTransition = new ConjunctiveTransition((Object)string2.getPredecessorState(), (Object)string2.getSuccessorState(), (Object)string2.getLetter(), conjunctiveCounterFormula, list);
            countingAutomatonDataStructure.addOutgoingTransition(conjunctiveTransition);
        }
        countingAutomatonDataStructure.toString();
        return countingAutomatonDataStructure;
    }

    private static List<AtomicCounterAssingment> constructAssignmentList(ManagedScript managedScript, UpdateListAST updateListAST) throws InterpreterException {
        ArrayList<AtomicCounterAssingment> arrayList = new ArrayList<AtomicCounterAssingment>();
        for (UpdateAST updateAST : updateListAST.getUpdates()) {
            AtomicCounterAssingment atomicCounterAssingment = CountingAutomataUtils.constructAssignment(managedScript, updateAST);
            arrayList.add(atomicCounterAssingment);
        }
        return arrayList;
    }

    private static AtomicCounterAssingment constructAssignment(ManagedScript managedScript, UpdateAST updateAST) throws InterpreterException {
        String string = updateAST.getTerm();
        Term term = CountingAutomataUtils.parseAndNormalize(managedScript, string);
        AffineTerm affineTerm = (AffineTerm)new AffineTermTransformer(managedScript.getScript()).transform(term);
        String string2 = affineTerm.isConstant() ? null : CountingAutomataUtils.getPositiveCounter(updateAST.getLocation(), affineTerm.getVariable2Coefficient());
        BigInteger bigInteger = CountingAutomataUtils.extractLiteral(updateAST.getLocation(), affineTerm);
        AtomicCounterAssingment atomicCounterAssingment = new AtomicCounterAssingment(updateAST.getCounter(), string2, bigInteger);
        return atomicCounterAssingment;
    }

    private static Map<String, LinkedHashSet<ConjunctiveCounterFormula>> stateCondPairList2StateConjunctionMapping(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, StateConditionPairListAST stateConditionPairListAST) throws InterpreterException {
        HashMap<String, LinkedHashSet<ConjunctiveCounterFormula>> hashMap = new HashMap<String, LinkedHashSet<ConjunctiveCounterFormula>>();
        for (Map.Entry entry : stateConditionPairListAST.getConditions().entrySet()) {
            Term[] termArray;
            String string = (String)entry.getValue();
            Term term = CountingAutomataUtils.parseAndNormalize(managedScript, string);
            Term term2 = new DnfTransformer(managedScript, iUltimateServiceProvider).transform(term);
            LinkedHashSet<ConjunctiveCounterFormula> linkedHashSet = new LinkedHashSet<ConjunctiveCounterFormula>();
            if (SmtUtils.isFalseLiteral((Term)term2)) continue;
            Term[] termArray2 = termArray = SmtUtils.getDisjuncts((Term)term2);
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term3 = termArray2[n2];
                ConjunctiveCounterFormula conjunctiveCounterFormula = CountingAutomataUtils.constructConjunctiveCounterFormula(managedScript, stateConditionPairListAST.getLocation(), term3);
                linkedHashSet.add(conjunctiveCounterFormula);
                ++n2;
            }
            hashMap.put((String)entry.getKey(), linkedHashSet);
        }
        return hashMap;
    }

    private static Term parseAndNormalize(ManagedScript managedScript, String string) {
        Term term = TermParseUtils.parseTerm((Script)managedScript.getScript(), (String)string);
        Term term2 = new UnfTransformer(managedScript.getScript()).transform(term);
        return term2;
    }

    private static ConjunctiveCounterFormula constructConjunctiveCounterFormula(ManagedScript managedScript, ILocation iLocation, Term term) throws InterpreterException {
        if (SmtUtils.isTrueLiteral((Term)term)) {
            return new ConjunctiveCounterFormula(new LinkedHashSet());
        }
        Term[] termArray = SmtUtils.getConjuncts((Term)term);
        LinkedHashSet<IAtomicCounterGuard> linkedHashSet = new LinkedHashSet<IAtomicCounterGuard>();
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term2 = termArray2[n2];
            IAtomicCounterGuard iAtomicCounterGuard = CountingAutomataUtils.atom2acg(managedScript, iLocation, term2);
            linkedHashSet.add(iAtomicCounterGuard);
            ++n2;
        }
        return new ConjunctiveCounterFormula(linkedHashSet);
    }

    private static IAtomicCounterGuard atom2acg(ManagedScript managedScript, ILocation iLocation, Term term) throws InterpreterException {
        PolynomialRelation polynomialRelation = PolynomialRelation.of((Script)managedScript.getScript(), (Term)term);
        if (!(polynomialRelation.getPolynomialTerm() instanceof AffineTerm)) {
            throw new InterpreterException(iLocation, "Term does not have supported form");
        }
        AffineTerm affineTerm = (AffineTerm)polynomialRelation.getPolynomialTerm();
        BigInteger bigInteger = CountingAutomataUtils.extractLiteral(iLocation, affineTerm);
        return switch (polynomialRelation.getPolynomialTerm().getMonomial2Coefficient().size()) {
            case 0 -> throw new AssertionError();
            case 1 -> {
                boolean var7_9;
                Map.Entry var9_6 = affineTerm.getVariable2Coefficient().entrySet().iterator().next();
                String var8_7 = CountingAutomataUtils.extractCounter(iLocation, (Term)var9_6.getKey());
                if (((Rational)var9_6.getValue()).equals((Object)Rational.MONE)) {
                    var7_9 = true;
                } else if (((Rational)var9_6.getValue()).equals((Object)Rational.ONE)) {
                    var7_9 = false;
                } else {
                    throw new InterpreterException(iLocation, "Term does not have supported form");
                }
                if (polynomialRelation.getRelationSymbol().equals((Object)RelationSymbol.DISTINCT)) {
                    throw new InterpreterException(iLocation, "Term does not have supported form");
                }
                BigInteger var10_11 = var7_9 ? bigInteger : bigInteger.negate();
                RelationSymbol var11_12 = var7_9 ? polynomialRelation.getRelationSymbol().swapParameters() : polynomialRelation.getRelationSymbol();
                yield new IAtomicCounterGuard.SingleCounterGuard(var11_12, var8_7, var10_11);
            }
            case 2 -> {
                if (!polynomialRelation.getRelationSymbol().equals((Object)RelationSymbol.EQ)) {
                    throw new InterpreterException(iLocation, "Term does not have supported form");
                }
                String var7_10 = CountingAutomataUtils.getPositiveCounter(iLocation, affineTerm.getVariable2Coefficient());
                String var8_8 = CountingAutomataUtils.getNegativeCounter(iLocation, affineTerm.getVariable2Coefficient());
                yield new IAtomicCounterGuard.TermEqualityTest(var7_10, var8_8, bigInteger);
            }
            default -> throw new InterpreterException(iLocation, "too many variables");
        };
    }

    private static String extractCounter(ILocation iLocation, Term term) throws InterpreterException {
        if (!(term instanceof ApplicationTerm)) {
            throw new InterpreterException(iLocation, "Term does not have supported form");
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        if (applicationTerm.getParameters().length > 0) {
            throw new InterpreterException(iLocation, "Term does not have supported form");
        }
        return applicationTerm.getFunction().getName();
    }

    private static BigInteger extractLiteral(ILocation iLocation, AffineTerm affineTerm) throws InterpreterException {
        if (affineTerm.getConstant().isIntegral()) {
            return affineTerm.getConstant().numerator();
        }
        throw new InterpreterException(iLocation, "Term does not have supported form");
    }

    private static String getPositiveCounter(ILocation iLocation, Map<Term, Rational> map) throws InterpreterException {
        for (Map.Entry<Term, Rational> entry : map.entrySet()) {
            if (!entry.getValue().equals((Object)Rational.ONE)) continue;
            return CountingAutomataUtils.extractCounter(iLocation, entry.getKey());
        }
        throw new InterpreterException(iLocation, "Term does not have supported form");
    }

    private static String getNegativeCounter(ILocation iLocation, Map<Term, Rational> map) throws InterpreterException {
        for (Map.Entry<Term, Rational> entry : map.entrySet()) {
            if (!entry.getValue().equals((Object)Rational.MONE)) continue;
            return CountingAutomataUtils.extractCounter(iLocation, entry.getKey());
        }
        throw new InterpreterException(iLocation, "Term does not have supported form");
    }

    /*
     * WARNING - void declaration
     */
    public static CountingAutomaton<String, String> translateDataStructureToAutomaton(IUltimateServiceProvider iUltimateServiceProvider, CountingAutomatonDataStructure<String, String> countingAutomatonDataStructure) {
        Counter counter6;
        IAtomicCounterGuard iAtomicCounterGuard32;
        Counter counter22;
        IAtomicCounterGuard.SingleCounterGuard singleCounterGuard22;
        Object object2;
        IAtomicCounterGuard iAtomicCounterGuard222;
        ConjunctiveTransition conjunctiveTransition22;
        Guard guard22;
        Object object322;
        Object object422;
        Object object522;
        Object object622;
        Object object722;
        AutomataLibraryServices automataLibraryServices = new AutomataLibraryServices(iUltimateServiceProvider);
        HashSet hashSet = new HashSet(countingAutomatonDataStructure.getStates());
        HashSet hashSet2 = new HashSet(countingAutomatonDataStructure.getAlphabet());
        ArrayList<Counter> arrayList = new ArrayList<Counter>();
        for (Object object722 : countingAutomatonDataStructure.getCounters()) {
            object622 = new Counter((String)object722);
            arrayList.add((Counter)object622);
        }
        object722 = new HashMap();
        for (Object object522 : hashSet) {
            object422 = new ArrayList();
            if (((Set)countingAutomatonDataStructure.getInitialConditions().get(object522)).size() == 0) {
                object322 = new Guard();
                object322.changeTermType(TermType.FALSE);
                guard22 = new ArrayList();
                guard22.add(object322);
                ((ArrayList)object422).add(guard22);
            } else {
                for (Object object322 : (Set)countingAutomatonDataStructure.getInitialConditions().get(object522)) {
                    if (object322.getConjuncts().size() == 0) {
                        conjunctiveTransition22 = new Guard();
                        conjunctiveTransition22.changeTermType(TermType.TRUE);
                        iAtomicCounterGuard222 = new ArrayList();
                        iAtomicCounterGuard222.add(conjunctiveTransition22);
                        ((ArrayList)object422).add(iAtomicCounterGuard222);
                        continue;
                    }
                    conjunctiveTransition22 = new ArrayList();
                    for (IAtomicCounterGuard iAtomicCounterGuard222 : object322.getConjuncts()) {
                        void var17_22;
                        if (iAtomicCounterGuard222 instanceof IAtomicCounterGuard.SingleCounterGuard) {
                            object2 = (IAtomicCounterGuard.SingleCounterGuard)iAtomicCounterGuard222;
                            singleCounterGuard22 = null;
                            for (Counter counter3 : arrayList) {
                                if (!counter3.getCounterName().equals(object2.getLhsCounter())) continue;
                                singleCounterGuard22 = counter3;
                            }
                            Guard guard = new Guard((Counter)singleCounterGuard22, null, Integer.valueOf(object2.getRhsNaturalNumber().intValue()), object2.getRelationSymbol(), TermType.CONSTANT);
                            conjunctiveTransition22.add(guard);
                            continue;
                        }
                        if (!(iAtomicCounterGuard222 instanceof IAtomicCounterGuard.TermEqualityTest)) continue;
                        object2 = (IAtomicCounterGuard.TermEqualityTest)iAtomicCounterGuard222;
                        singleCounterGuard22 = null;
                        Object var17_21 = null;
                        for (Counter counter22 : arrayList) {
                            if (counter22.getCounterName().equals(object2.getLhsCounter())) {
                                singleCounterGuard22 = counter22;
                            }
                            if (!counter22.getCounterName().equals(object2.getRhsCounter())) continue;
                            Counter counter4 = counter22;
                        }
                        if (object2.getRhsNaturalNumber().intValue() == 0) {
                            counter22 = new Guard((Counter)singleCounterGuard22, (Counter)var17_22, null, RelationSymbol.EQ, TermType.COUNTER);
                            conjunctiveTransition22.add(counter22);
                            continue;
                        }
                        counter22 = new Guard((Counter)singleCounterGuard22, (Counter)var17_22, Integer.valueOf(object2.getRhsNaturalNumber().intValue()), RelationSymbol.EQ, TermType.SUM);
                        conjunctiveTransition22.add(counter22);
                    }
                    ((ArrayList)object422).add(conjunctiveTransition22);
                }
            }
            object322 = new InitialCondition((ArrayList)object422);
            object722.put(object522, object322);
        }
        object522 = new HashMap();
        for (Object object622 : hashSet) {
            object322 = new ArrayList();
            if (((Set)countingAutomatonDataStructure.getAcceptingConditions().get(object622)).size() == 0) {
                guard22 = new Guard();
                guard22.changeTermType(TermType.FALSE);
                conjunctiveTransition22 = new ArrayList();
                conjunctiveTransition22.add(guard22);
                ((ArrayList)object322).add(conjunctiveTransition22);
            } else {
                for (Guard guard22 : (Set)countingAutomatonDataStructure.getAcceptingConditions().get(object622)) {
                    if (guard22.getConjuncts().size() == 0) {
                        iAtomicCounterGuard222 = new Guard();
                        iAtomicCounterGuard222.changeTermType(TermType.TRUE);
                        iAtomicCounterGuard32 = new ArrayList();
                        iAtomicCounterGuard32.add(iAtomicCounterGuard222);
                        ((ArrayList)object322).add(iAtomicCounterGuard32);
                        continue;
                    }
                    iAtomicCounterGuard222 = new ArrayList();
                    for (IAtomicCounterGuard iAtomicCounterGuard32 : guard22.getConjuncts()) {
                        void var17_29;
                        if (iAtomicCounterGuard32 instanceof IAtomicCounterGuard.SingleCounterGuard) {
                            void var17_26;
                            singleCounterGuard22 = (IAtomicCounterGuard.SingleCounterGuard)iAtomicCounterGuard32;
                            Object var17_25 = null;
                            for (Counter counter22 : arrayList) {
                                if (!counter22.getCounterName().equals(singleCounterGuard22.getLhsCounter())) continue;
                                Counter counter5 = counter22;
                            }
                            counter22 = new Guard((Counter)var17_26, null, Integer.valueOf(singleCounterGuard22.getRhsNaturalNumber().intValue()), singleCounterGuard22.getRelationSymbol(), TermType.CONSTANT);
                            iAtomicCounterGuard222.add(counter22);
                            continue;
                        }
                        if (!(iAtomicCounterGuard32 instanceof IAtomicCounterGuard.TermEqualityTest)) continue;
                        singleCounterGuard22 = (IAtomicCounterGuard.TermEqualityTest)iAtomicCounterGuard32;
                        Object var17_28 = null;
                        counter22 = null;
                        for (Counter counter6 : arrayList) {
                            if (counter6.getCounterName().equals(singleCounterGuard22.getLhsCounter())) {
                                Counter counter7 = counter6;
                            }
                            if (!counter6.getCounterName().equals(singleCounterGuard22.getRhsCounter())) continue;
                            counter22 = counter6;
                        }
                        if (singleCounterGuard22.getRhsNaturalNumber().intValue() == 0) {
                            counter6 = new Guard((Counter)var17_29, counter22, null, RelationSymbol.EQ, TermType.COUNTER);
                            iAtomicCounterGuard222.add(counter6);
                            continue;
                        }
                        counter6 = new Guard((Counter)var17_29, counter22, Integer.valueOf(singleCounterGuard22.getRhsNaturalNumber().intValue()), RelationSymbol.EQ, TermType.SUM);
                        iAtomicCounterGuard222.add(counter6);
                    }
                    ((ArrayList)object322).add(iAtomicCounterGuard222);
                }
            }
            guard22 = new FinalCondition((ArrayList)object322);
            object522.put(object622, guard22);
        }
        object622 = new HashMap();
        for (Object object422 : hashSet) {
            guard22 = new ArrayList();
            for (ConjunctiveTransition conjunctiveTransition22 : countingAutomatonDataStructure.getOutgoingTransitions(object422)) {
                Counter counter82;
                Counter counter92;
                iAtomicCounterGuard32 = new ArrayList();
                if (conjunctiveTransition22.getGuard().getConjuncts().size() == 0) {
                    object2 = new Guard();
                    object2.changeTermType(TermType.TRUE);
                    singleCounterGuard22 = new ArrayList();
                    singleCounterGuard22.add(object2);
                    iAtomicCounterGuard32.add(singleCounterGuard22);
                } else {
                    object2 = new ArrayList();
                    for (IAtomicCounterGuard.SingleCounterGuard singleCounterGuard22 : conjunctiveTransition22.getGuard().getConjuncts()) {
                        if (singleCounterGuard22 instanceof IAtomicCounterGuard.SingleCounterGuard) {
                            counter22 = singleCounterGuard22;
                            counter6 = null;
                            for (Counter counter92 : arrayList) {
                                if (!counter92.getCounterName().equals(counter22.getLhsCounter())) continue;
                                counter6 = counter92;
                            }
                            counter92 = new Guard(counter6, null, Integer.valueOf(counter22.getRhsNaturalNumber().intValue()), counter22.getRelationSymbol(), TermType.CONSTANT);
                            ((ArrayList)object2).add(counter92);
                            continue;
                        }
                        if (!(singleCounterGuard22 instanceof IAtomicCounterGuard.TermEqualityTest)) continue;
                        counter22 = (IAtomicCounterGuard.TermEqualityTest)singleCounterGuard22;
                        counter6 = null;
                        counter92 = null;
                        for (Counter counter82 : arrayList) {
                            if (counter82.getCounterName().equals(counter22.getLhsCounter())) {
                                counter6 = counter82;
                            }
                            if (!counter82.getCounterName().equals(counter22.getRhsCounter())) continue;
                            counter92 = counter82;
                        }
                        if (counter22.getRhsNaturalNumber().intValue() == 0) {
                            counter82 = new Guard(counter6, counter92, null, RelationSymbol.EQ, TermType.COUNTER);
                            ((ArrayList)object2).add(counter82);
                            continue;
                        }
                        counter82 = new Guard(counter6, counter92, Integer.valueOf(counter22.getRhsNaturalNumber().intValue()), RelationSymbol.EQ, TermType.SUM);
                        ((ArrayList)object2).add(counter82);
                    }
                    iAtomicCounterGuard32.add(object2);
                }
                object2 = new ArrayList();
                for (IAtomicCounterGuard.SingleCounterGuard singleCounterGuard22 : conjunctiveTransition22.getAssignment()) {
                    counter22 = null;
                    counter6 = null;
                    counter82 = arrayList.iterator();
                    while (counter82.hasNext()) {
                        counter92 = (Counter)counter82.next();
                        if (counter92.getCounterName().equals(singleCounterGuard22.getLhsCounter())) {
                            counter22 = counter92;
                        }
                        if (!counter92.getCounterName().equals(singleCounterGuard22.getRhsCounter())) continue;
                        counter6 = counter92;
                    }
                    if (counter6 == null) {
                        counter92 = new Update(counter22, null, Integer.valueOf(singleCounterGuard22.getRhsNaturalNumber().intValue()), TermType.CONSTANT);
                        ((ArrayList)object2).add(counter92);
                        continue;
                    }
                    if (singleCounterGuard22.getRhsNaturalNumber().intValue() == 0) {
                        counter92 = new Update(counter22, counter6, null, TermType.COUNTER);
                        ((ArrayList)object2).add(counter92);
                        continue;
                    }
                    counter92 = new Update(counter22, counter6, Integer.valueOf(singleCounterGuard22.getRhsNaturalNumber().intValue()), TermType.SUM);
                    ((ArrayList)object2).add(counter92);
                }
                singleCounterGuard22 = new Transition((Object)((String)conjunctiveTransition22.getLetter()), (Object)((String)conjunctiveTransition22.getPredecessor()), (Object)((String)conjunctiveTransition22.getSuccessor()), (ArrayList)iAtomicCounterGuard32, (ArrayList)object2);
                guard22.add(singleCounterGuard22);
            }
            object622.put(object422, guard22);
        }
        object422 = new CountingAutomaton(automataLibraryServices, hashSet2, hashSet, arrayList, (Map)object722, (Map)object522, (Map)object622);
        return object422;
    }
}

