/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessprinter.yaml;

import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.FunctionContract;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.LocationInvariant;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.LoopInvariant;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Witness;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.WitnessEntry;
import de.uni_freiburg.informatik.ultimate.witnessprinter.yaml.MetadataProvider;
import de.uni_freiburg.informatik.ultimate.witnessprinter.yaml.YamlWitnessWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class YamlWitnessWriterV0
extends YamlWitnessWriter {
    private final MetadataProvider mMetadataProvider;

    public YamlWitnessWriterV0(MetadataProvider metadataProvider) {
        this.mMetadataProvider = metadataProvider;
    }

    @Override
    public String toString(Witness witness) {
        if (!witness.isCorrectnessWitness()) {
            throw new UnsupportedOperationException("Violation witnesses are not supported in version 0.1");
        }
        return YamlWitnessWriterV0.formatYaml(witness.getEntries().stream().filter(witnessEntry -> !(witnessEntry instanceof FunctionContract)).map(this::toMap).collect(Collectors.toList()));
    }

    private Map<String, Object> toMap(WitnessEntry witnessEntry) {
        if (witnessEntry instanceof LoopInvariant) {
            LoopInvariant loopInvariant = (LoopInvariant)witnessEntry;
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("string", loopInvariant.getInvariant());
            linkedHashMap.put("type", "assertion");
            linkedHashMap.put("format", loopInvariant.getFormat());
            LinkedHashMap<String, Object> linkedHashMap2 = new LinkedHashMap<String, Object>();
            linkedHashMap2.put("entry_type", witnessEntry.getName());
            linkedHashMap2.put("metadata", this.mMetadataProvider.getFreshMetadata());
            linkedHashMap2.put("location", loopInvariant.getLocation().toMap());
            linkedHashMap2.put(witnessEntry.getName(), linkedHashMap);
            return linkedHashMap2;
        }
        if (witnessEntry instanceof LocationInvariant) {
            LocationInvariant locationInvariant = (LocationInvariant)witnessEntry;
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("string", locationInvariant.getInvariant());
            linkedHashMap.put("type", "assertion");
            linkedHashMap.put("format", locationInvariant.getFormat());
            LinkedHashMap<String, Object> linkedHashMap3 = new LinkedHashMap<String, Object>();
            linkedHashMap3.put("entry_type", witnessEntry.getName());
            linkedHashMap3.put("metadata", this.mMetadataProvider.getFreshMetadata());
            linkedHashMap3.put("location", locationInvariant.getLocation().toMap());
            linkedHashMap3.put(witnessEntry.getName(), linkedHashMap);
            return linkedHashMap3;
        }
        throw new UnsupportedOperationException("Entry type " + witnessEntry.getName() + " is not supported in witness version 0.1.");
    }
}

