/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Analyze;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveDeadEnds;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveUnreachable;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaPmaxSat;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaPmaxSatDirectBi;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeSevpa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.ShrinkNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.ASimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.SimulationOrMinimizationType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.delayed.DelayedGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.delayed.DelayedSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.direct.DirectGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.direct.DirectSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair.FairDirectGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair.FairDirectSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair.FairGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair.FairSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.multipebble.ReduceNwaFullMultipebbleSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.ComparisonTables;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.CountingMeasure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.MultipleDataOption;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.SimulationPerformance;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance.TimeMeasure;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class CompareReduceBuchiSimulation<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    public static final String HTML_NO_VALUE = "&ndash;";
    public static final File LOG_PATH = new File(new File(System.getProperty("user.home"), "Desktop"), "simulationPerformance");
    public static final String LOG_SEPARATOR = "\t";
    public static final String PLOT_NO_VALUE = "--";
    public static final String PLOT_SEPARATOR = "\t";
    private static final int FIX_FIELD_AMOUNT = 5;
    private static final String LOG_ENTRY_HEAD_END = "-->";
    private static final String LOG_ENTRY_HEAD_START = "<!--";
    private static final int LOG_FILE_SIZE_THRESHOLD = 1000000;
    private static final String LOG_PATH_DATA = "testData";
    private static final String LOG_PATH_DATA_EXT = ".tsv";
    private static final String LOG_PATH_HTML_PRE = "testResults_";
    private static final String LOG_PATH_HTML_SUFF = ".html";
    private static final String LOG_PATH_PLOT_PRE = "plot_";
    private static final String LOG_PATH_PLOT_SUFF = ".csv";
    private static final int SIMULATION_TIMEOUT = 10;
    private long mExternalOverallTime;
    private final FileFilter mLogFileFilter;
    private final List<String> mLoggedLines;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    private final LinkedHashMap<TimeMeasure, Float> mTimeMeasures;
    protected final LinkedHashMap<CountingMeasure, Integer> mCountingMeasures;

    public static void main(String[] stringArray) {
        System.out.println("Parsing log file...");
        LinkedList<LinkedList<SimulationPerformance>> linkedList = CompareReduceBuchiSimulation.parseLogFile();
        System.out.println("Processing data...");
        LinkedList<Pair> linkedList2 = new LinkedList<Pair>();
        linkedList2.add(new Pair((Object)"instanceFullComparison", ComparisonTables.createInstanceFullComparisonTable(linkedList, "\t", null, false, false, true)));
        linkedList2.add(new Pair((Object)"averagedSimulationPerDirectoryTable", ComparisonTables.createAveragedSimulationPerDirectoryTable(linkedList, "\t", SimulationOrMinimizationType.EXT_RABIT_LIGHT_1, false, false, true)));
        System.out.println("Creating html files...");
        for (Pair pair : linkedList2) {
            CompareReduceBuchiSimulation.tableToHtmlFile((String)pair.getFirst(), (List)pair.getSecond());
        }
        System.out.println("Creating plot files...");
        for (Pair pair : linkedList2) {
            CompareReduceBuchiSimulation.tableToPlotFile((String)pair.getFirst(), (List)pair.getSecond());
        }
        System.out.println("Terminated.");
    }

    public static void tableToHtmlFile(String string, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<!DOCTYPE html><html><head>");
        stringBuilder.append("<title>Simulation Performance Test-Results</title>");
        stringBuilder.append("<script type=\"text/javascript\" src=\"https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js\"></script>");
        stringBuilder.append("<script type=\"text/javascript\" src=\"http://zabuza.square7.ch/sorttable.js\"></script>");
        stringBuilder.append("<script type=\"text/javascript\" src=\"http://zabuza.square7.ch/markRows.js\"></script>");
        stringBuilder.append("<script type=\"text/javascript\" src=\"http://zabuza.square7.ch/toggleEmptyColumns.js\"></script>");
        stringBuilder.append("<style>");
        stringBuilder.append("table.wikitable { margin: 1em 0; background-color: #f9f9f9; border: 1px solid #aaa;border-collapse: collapse; color: black }");
        stringBuilder.append("table.wikitable > tr > th, table.wikitable > tr > td, table.wikitable > * > tr > th, table.wikitable > * > tr > td { border: 1px solid #aaa; padding: 0.2em 0.4em }");
        stringBuilder.append("table.wikitable > tr > th, table.wikitable > * > tr > th { background-color: #f2f2f2; text-align: center }");
        stringBuilder.append("table.wikitable > caption { font-weight: bold }");
        stringBuilder.append("tr:nth-child(even) { background-color: #f9f9f9 }");
        stringBuilder.append("tr:nth-child(odd) { background-color: #e9e9e9 }");
        stringBuilder.append(".emptyrow { background-color: #c9c9c9 !important; }");
        stringBuilder.append("table.sortable th:not(.sorttable_sorted):not(.sorttable_sorted_reverse):not(.sorttable_nosort):after { content: \" \\25B4\\25BE\"; }");
        stringBuilder.append("#markRowText { margin-left: 1em; }");
        stringBuilder.append(".markedRow { background-color: #FFB0B0 !important; }");
        stringBuilder.append(".cellOfEmptyColumn { display: none; }");
        stringBuilder.append("#toggleEmptyColumnsButton { margin-left: 1em; }");
        stringBuilder.append("</style>");
        stringBuilder.append("</head><body>");
        stringBuilder.append("<span class=\"markedRow demoText\">Mark rows:</span><input type=\"text\" id=\"markRowText\" name=\"markRowText\" oninput=\"markRows()\" />");
        stringBuilder.append("<button type=\"button\" id=\"toggleEmptyColumnsButton\" onclick=\"toggleEmptyColumns()\">Hide/Show empty columns</button>");
        stringBuilder.append("<br/>");
        stringBuilder.append("<table id=\"contentTable\" class=\"wikitable sortable\">");
        boolean bl = true;
        for (String object2 : list) {
            String string2 = "td";
            if (bl) {
                string2 = "th";
            }
            if (object2.isEmpty()) {
                stringBuilder.append("<tr class=\"emptyrow\"><td colspan=\"100%\">&nbsp;</td></tr>" + System.lineSeparator());
                continue;
            }
            String[] stringArray = object2.split("\t");
            if (stringArray.length > 0) {
                stringBuilder.append("<tr>");
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string3;
                    String string4 = string3 = stringArray2[n2];
                    if (string3.equals("NO_VALUE")) {
                        string4 = HTML_NO_VALUE;
                    }
                    stringBuilder.append("<" + string2 + ">" + string4 + "</" + string2 + ">");
                    ++n2;
                }
                stringBuilder.append("</tr>" + System.lineSeparator());
            }
            bl = false;
        }
        stringBuilder.append("</table></body></html>");
        Path path = Paths.get(LOG_PATH.getAbsolutePath(), new String[0]);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            Path path2 = path.resolve(LOG_PATH_HTML_PRE + string + LOG_PATH_HTML_SUFF);
            Files.write(path2, Collections.singletonList(stringBuilder.toString()), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static LinkedList<LinkedList<SimulationPerformance>> parseLogFile() {
        BufferedReader bufferedReader = null;
        try {
            Object object;
            LinkedList<LinkedList<SimulationPerformance>> linkedList = new LinkedList<LinkedList<SimulationPerformance>>();
            LinkedList<SimulationPerformance> linkedList2 = null;
            ArrayList<TimeMeasure> arrayList = new ArrayList<TimeMeasure>();
            ArrayList<CountingMeasure> arrayList2 = new ArrayList<CountingMeasure>();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            TimeMeasure[] timeMeasureArray = TimeMeasure.values();
            int n = timeMeasureArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = timeMeasureArray[n2];
                hashMap.put(((Enum)object).name(), object);
                ++n2;
            }
            object = new HashMap();
            CountingMeasure[] countingMeasureArray = CountingMeasure.values();
            int n3 = countingMeasureArray.length;
            n = 0;
            while (n < n3) {
                CountingMeasure countingMeasure = countingMeasureArray[n];
                ((HashMap)object).put(countingMeasure.name(), countingMeasure);
                ++n;
            }
            FileFilter fileFilter = file -> {
                String string = file.getName();
                return string.startsWith(LOG_PATH_DATA) && string.endsWith(LOG_PATH_DATA_EXT);
            };
            File[] fileArray = LOG_PATH.listFiles(fileFilter);
            int n4 = fileArray.length;
            n3 = 0;
            while (n3 < n4) {
                File file2 = fileArray[n3];
                bufferedReader = new BufferedReader(new FileReader(file2));
                block14: while (bufferedReader.ready()) {
                    Object object2;
                    String string = bufferedReader.readLine();
                    String[] stringArray = string.split("\t");
                    if (stringArray[0].startsWith(LOG_ENTRY_HEAD_START)) {
                        if (linkedList2 != null && !linkedList2.isEmpty()) {
                            linkedList.add((LinkedList)linkedList2.clone());
                        }
                        linkedList2 = new LinkedList<SimulationPerformance>();
                        arrayList.clear();
                        arrayList2.clear();
                        int n5 = 6;
                        while (n5 < stringArray.length) {
                            object2 = stringArray[n5];
                            if (((String)object2).equals(LOG_ENTRY_HEAD_END)) continue block14;
                            if (hashMap.containsKey(object2)) {
                                arrayList.add((TimeMeasure)((Object)hashMap.get(object2)));
                            } else if (((HashMap)object).containsKey(object2)) {
                                arrayList2.add((CountingMeasure)((Object)((HashMap)object).get(object2)));
                            }
                            ++n5;
                        }
                        continue;
                    }
                    String string2 = stringArray[0];
                    object2 = SimulationOrMinimizationType.valueOf(stringArray[1]);
                    boolean bl = Boolean.parseBoolean(stringArray[2]);
                    boolean bl2 = Boolean.parseBoolean(stringArray[3]);
                    boolean bl3 = Boolean.parseBoolean(stringArray[4]);
                    SimulationPerformance simulationPerformance = new SimulationPerformance((SimulationOrMinimizationType)((Object)object2), bl);
                    if (bl2) {
                        simulationPerformance.timeOut();
                    }
                    if (bl3) {
                        simulationPerformance.outOfMemory();
                    }
                    simulationPerformance.setName(string2);
                    int n6 = 5;
                    while (n6 < stringArray.length) {
                        int n7 = n6 - 5;
                        int n8 = n6 - 5 - arrayList.size();
                        if (n7 >= 0 && n7 < arrayList.size()) {
                            var23_30 = (TimeMeasure)((Object)arrayList.get(n7));
                            float f = Float.parseFloat(stringArray[n6]);
                            if (f == -1.0f) {
                                simulationPerformance.addTimeMeasureValue((TimeMeasure)var23_30, -1L);
                            } else {
                                simulationPerformance.addTimeMeasureValue((TimeMeasure)var23_30, ComparisonTables.secondsToMillis(f));
                            }
                        } else if (n8 >= 0 && n8 < arrayList2.size()) {
                            var23_30 = (CountingMeasure)((Object)arrayList2.get(n8));
                            int n9 = Integer.parseInt(stringArray[n6]);
                            if (n9 == -1) {
                                simulationPerformance.setCountingMeasure((CountingMeasure)var23_30, -1);
                            } else {
                                simulationPerformance.setCountingMeasure((CountingMeasure)var23_30, n9);
                            }
                        }
                        ++n6;
                    }
                    linkedList2.add(simulationPerformance);
                }
                if (linkedList2 != null && !linkedList2.isEmpty()) {
                    linkedList.add(linkedList2);
                }
                ++n3;
            }
            LinkedList<LinkedList<SimulationPerformance>> linkedList3 = linkedList;
            return linkedList3;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return null;
    }

    private static void tableToPlotFile(String string, List<String> list) {
        block14: {
            PrintWriter printWriter;
            StringBuilder stringBuilder = new StringBuilder();
            for (String object2 : list) {
                if (object2.isEmpty()) {
                    stringBuilder.append(System.lineSeparator());
                    continue;
                }
                String[] stringArray = object2.split("\t");
                if (stringArray.length <= 0) continue;
                boolean bl = true;
                String[] stringArray2 = stringArray;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string2 = stringArray2[n2];
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuilder.append("\t");
                    }
                    String string3 = string2;
                    if (string2.equals("NO_VALUE")) {
                        string3 = PLOT_NO_VALUE;
                    }
                    stringBuilder.append(string3);
                    ++n2;
                }
                stringBuilder.append(System.lineSeparator());
            }
            PrintWriter printWriter2 = null;
            File file = new File(LOG_PATH, LOG_PATH_PLOT_PRE + string + LOG_PATH_PLOT_SUFF);
            try {
                try {
                    printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                    printWriter.print(stringBuilder.toString());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    if (printWriter2 != null) {
                        printWriter2.close();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (printWriter2 != null) {
                    printWriter2.close();
                }
                throw throwable;
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public CompareReduceBuchiSimulation(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.verifyAutomatonValidity(iNwaOutgoingLetterAndTransitionProvider);
        this.mLoggedLines = new LinkedList<String>();
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mTimeMeasures = new LinkedHashMap();
        this.mCountingMeasures = new LinkedHashMap();
        this.mExternalOverallTime = 0L;
        this.mLogFileFilter = file -> {
            String string = file.getName();
            return string.startsWith(LOG_PATH_DATA) && string.endsWith(LOG_PATH_DATA_EXT);
        };
        this.mLogger.info((Object)this.startMessage());
        this.createAndResetPerformanceHead();
        this.appendPerformanceHeadToLog();
        IDoubleDeckerAutomaton iDoubleDeckerAutomaton = new RemoveUnreachable(this.mServices, new RemoveDeadEnds<LETTER, STATE>(this.mServices, iNwaOutgoingLetterAndTransitionProvider).getResult()).getResult();
        this.measurePerformances("", 10000L, iMinimizationStateFactory, (NestedWordAutomatonReachableStates<LETTER, STATE>)iDoubleDeckerAutomaton);
        this.flushLogToFile();
        this.mLogger.info((Object)this.exitMessage());
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }

    @Override
    public String getResult() {
        return "no result";
    }

    public void verifyAutomatonValidity(INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) {
        if (!NestedWordAutomataUtils.isFiniteAutomaton(iNwaOutgoingLetterAndTransitionProvider)) {
            throw new IllegalArgumentException("The inputed automaton is no Buechi-automaton. It must have an empty call and return alphabet.");
        }
    }

    private void appendCurrentPerformanceEntryToLog(String string, SimulationOrMinimizationType simulationOrMinimizationType, boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder().append(string).append("\t").append((Object)simulationOrMinimizationType).append("\t").append(bl).append("\t").append(bl2).append("\t").append(bl3);
        for (Float number : this.mTimeMeasures.values()) {
            stringBuilder.append("\t").append(number);
        }
        for (Integer n : this.mCountingMeasures.values()) {
            stringBuilder.append("\t").append(n);
        }
        this.logLine(stringBuilder.toString());
    }

    private void appendPerformanceHeadToLog() {
        StringBuilder stringBuilder = new StringBuilder(LOG_ENTRY_HEAD_START).append("\t");
        stringBuilder.append("NAME").append("\t").append("TYPE").append("\t").append("USED_SCCS").append("\t").append("TIMED_OUT").append("\t").append("OOM").append("\t");
        for (TimeMeasure enum_ : this.mTimeMeasures.keySet()) {
            stringBuilder.append((Object)enum_).append("\t");
        }
        for (CountingMeasure countingMeasure : this.mCountingMeasures.keySet()) {
            stringBuilder.append((Object)countingMeasure).append("\t");
        }
        stringBuilder.append(LOG_ENTRY_HEAD_END);
        this.logLine(stringBuilder.toString());
    }

    private void createAndResetPerformanceHead() {
        Enum enum_;
        Enum[] enumArray = TimeMeasure.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            enum_ = enumArray[n2];
            this.mTimeMeasures.put((TimeMeasure)enum_, Float.valueOf(-1.0f));
            ++n2;
        }
        enumArray = CountingMeasure.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            enum_ = enumArray[n2];
            this.mCountingMeasures.put((CountingMeasure)enum_, -1);
            ++n2;
        }
    }

    private SimulationPerformance createOutOfMemoryPerformance(String string, SimulationOrMinimizationType simulationOrMinimizationType, boolean bl, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) {
        SimulationPerformance simulationPerformance = SimulationPerformance.createOutOfMemoryPerformance(simulationOrMinimizationType, bl);
        simulationPerformance.setName(string);
        simulationPerformance.setCountingMeasure(CountingMeasure.BUCHI_STATES, iNwaOutgoingLetterAndTransitionProvider.size());
        return simulationPerformance;
    }

    private SimulationPerformance createTimedOutPerformance(String string, SimulationOrMinimizationType simulationOrMinimizationType, boolean bl, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) {
        SimulationPerformance simulationPerformance = SimulationPerformance.createTimedOutPerformance(simulationOrMinimizationType, bl);
        simulationPerformance.setName(string);
        simulationPerformance.setCountingMeasure(CountingMeasure.BUCHI_STATES, iNwaOutgoingLetterAndTransitionProvider.size());
        return simulationPerformance;
    }

    private void flushLogToFile() {
        File file;
        block14: {
            if (!LOG_PATH.exists()) {
                LOG_PATH.mkdir();
            }
            PrintWriter printWriter = null;
            file = null;
            boolean bl = false;
            int n = 0;
            File[] fileArray = LOG_PATH.listFiles(this.mLogFileFilter);
            int n2 = fileArray.length;
            int n3 = 0;
            while (n3 < n2) {
                File object = fileArray[n3];
                if (object.length() < 1000000L) {
                    bl = true;
                    file = object;
                    break;
                }
                String string = object.getName();
                int n4 = Integer.parseInt(string.replaceFirst(LOG_PATH_DATA, "").replaceFirst(LOG_PATH_DATA_EXT, ""));
                if (n4 > n) {
                    n = n4;
                }
                ++n3;
            }
            if (!bl) {
                file = new File(LOG_PATH, LOG_PATH_DATA + ++n + LOG_PATH_DATA_EXT);
            }
            try {
                try {
                    printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file, true)));
                    for (String string : this.mLoggedLines) {
                        printWriter.println(string);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    if (printWriter != null) {
                        printWriter.close();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (printWriter != null) {
                    printWriter.close();
                }
                throw throwable;
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
        this.mLogger.info((Object)("Logged data to file (" + file.getAbsolutePath() + ")."));
    }

    private void flushLogToLogger() {
        for (String string : this.mLoggedLines) {
            this.mLogger.info((Object)string);
        }
    }

    private void logLine(String string) {
        this.mLoggedLines.add(string);
    }

    private void saveStateOfPerformance(SimulationPerformance simulationPerformance) {
        for (TimeMeasure enum_ : this.mTimeMeasures.keySet()) {
            long l = simulationPerformance.getTimeMeasureResult(enum_, MultipleDataOption.ADDITIVE);
            if (l == -1L) {
                this.mTimeMeasures.put(enum_, Float.valueOf(-1.0f));
                continue;
            }
            this.mTimeMeasures.put(enum_, Float.valueOf(ComparisonTables.millisToSeconds(l)));
        }
        for (CountingMeasure countingMeasure : this.mCountingMeasures.keySet()) {
            int n = simulationPerformance.getCountingMeasureResult(countingMeasure);
            this.mCountingMeasures.put(countingMeasure, n);
        }
    }

    protected void addGeneralAutomataPerformanceForExternalMethod(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton2) {
        AutomataLibraryServices automataLibraryServices = this.getServices();
        Analyze<LETTER, STATE> analyze = new Analyze<LETTER, STATE>(automataLibraryServices, iNestedWordAutomaton, true);
        int n = analyze.getNumberOfStates();
        int n2 = analyze.getNumberOfTransitions(Analyze.SymbolType.TOTAL);
        this.mCountingMeasures.put(CountingMeasure.BUCHI_STATES, n);
        this.mCountingMeasures.put(CountingMeasure.BUCHI_NONDETERMINISTIC_STATES, analyze.getNumberOfNondeterministicStates());
        this.mCountingMeasures.put(CountingMeasure.BUCHI_ALPHABET_SIZE, analyze.getNumberOfSymbols(Analyze.SymbolType.TOTAL));
        this.mCountingMeasures.put(CountingMeasure.BUCHI_TRANSITIONS, n2);
        this.mCountingMeasures.put(CountingMeasure.BUCHI_TRANSITION_DENSITY_MILLION, (int)Math.round(analyze.getTransitionDensity(Analyze.SymbolType.TOTAL) * 1000000.0));
        if (iNestedWordAutomaton2 != null) {
            Analyze<LETTER, STATE> analyze2 = new Analyze<LETTER, STATE>(automataLibraryServices, iNestedWordAutomaton2, true);
            int n3 = analyze2.getNumberOfStates();
            int n4 = analyze2.getNumberOfTransitions(Analyze.SymbolType.TOTAL);
            this.mCountingMeasures.put(CountingMeasure.RESULT_STATES, n3);
            this.mCountingMeasures.put(CountingMeasure.RESULT_NONDETERMINISTIC_STATES, analyze2.getNumberOfNondeterministicStates());
            this.mCountingMeasures.put(CountingMeasure.RESULT_ALPHABET_SIZE, analyze2.getNumberOfSymbols(Analyze.SymbolType.TOTAL));
            this.mCountingMeasures.put(CountingMeasure.RESULT_TRANSITIONS, n4);
            this.mCountingMeasures.put(CountingMeasure.RESULT_TRANSITION_DENSITY_MILLION, (int)Math.round(analyze2.getTransitionDensity(Analyze.SymbolType.TOTAL) * 1000000.0));
            this.mCountingMeasures.put(CountingMeasure.REMOVED_STATES, n - n3);
            this.mCountingMeasures.put(CountingMeasure.REMOVED_TRANSITIONS, n2 - n4);
        }
    }

    protected void appendMethodPerformanceToLog(Object object, String string, SimulationOrMinimizationType simulationOrMinimizationType, boolean bl, boolean bl2, boolean bl3, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) {
        this.createAndResetPerformanceHead();
        if (object instanceof ASimulation) {
            ASimulation aSimulation = (ASimulation)object;
            SimulationPerformance simulationPerformance = aSimulation.getSimulationPerformance();
            if (bl2) {
                simulationPerformance.timeOut();
            }
            if (bl3) {
                simulationPerformance.outOfMemory();
            }
            simulationPerformance.setName(string);
            this.saveStateOfPerformance(simulationPerformance);
        } else if (object instanceof ReduceNwaFullMultipebbleSimulation) {
            ReduceNwaFullMultipebbleSimulation reduceNwaFullMultipebbleSimulation = (ReduceNwaFullMultipebbleSimulation)object;
            INestedWordAutomaton iNestedWordAutomaton = reduceNwaFullMultipebbleSimulation.getResult();
            this.addGeneralAutomataPerformanceForExternalMethod((INestedWordAutomaton)iNwaOutgoingLetterAndTransitionProvider, iNestedWordAutomaton);
            this.mTimeMeasures.put(TimeMeasure.OVERALL, Float.valueOf(ComparisonTables.millisToSeconds(this.mExternalOverallTime)));
        } else if (object instanceof MinimizeSevpa) {
            MinimizeSevpa minimizeSevpa = (MinimizeSevpa)object;
            Object object2 = minimizeSevpa.getResult();
            this.addGeneralAutomataPerformanceForExternalMethod((INestedWordAutomaton)iNwaOutgoingLetterAndTransitionProvider, (INestedWordAutomaton)object2);
            this.mTimeMeasures.put(TimeMeasure.OVERALL, Float.valueOf(ComparisonTables.millisToSeconds(this.mExternalOverallTime)));
        } else if (object instanceof ShrinkNwa) {
            ShrinkNwa shrinkNwa = (ShrinkNwa)object;
            Object object3 = shrinkNwa.getResult();
            this.addGeneralAutomataPerformanceForExternalMethod((INestedWordAutomaton)iNwaOutgoingLetterAndTransitionProvider, (INestedWordAutomaton)object3);
            this.mTimeMeasures.put(TimeMeasure.OVERALL, Float.valueOf(ComparisonTables.millisToSeconds(this.mExternalOverallTime)));
        } else if (object instanceof MinimizeNwaPmaxSat) {
            MinimizeNwaPmaxSat minimizeNwaPmaxSat = (MinimizeNwaPmaxSat)object;
            INestedWordAutomaton iNestedWordAutomaton = minimizeNwaPmaxSat.getResult();
            this.addGeneralAutomataPerformanceForExternalMethod((INestedWordAutomaton)iNwaOutgoingLetterAndTransitionProvider, iNestedWordAutomaton);
            this.mTimeMeasures.put(TimeMeasure.OVERALL, Float.valueOf(ComparisonTables.millisToSeconds(this.mExternalOverallTime)));
        }
        if (bl2 && object == null) {
            this.saveStateOfPerformance(this.createTimedOutPerformance(string, simulationOrMinimizationType, bl, iNwaOutgoingLetterAndTransitionProvider));
        } else if (bl3 && object == null) {
            this.saveStateOfPerformance(this.createOutOfMemoryPerformance(string, simulationOrMinimizationType, bl, iNwaOutgoingLetterAndTransitionProvider));
        }
        this.appendCurrentPerformanceEntryToLog(string, simulationOrMinimizationType, bl, bl2, bl3);
    }

    protected ILogger getLogger() {
        return this.mLogger;
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    protected AutomataLibraryServices getServices() {
        return this.mServices;
    }

    protected void measureMethodPerformance(String string, SimulationOrMinimizationType simulationOrMinimizationType, boolean bl, AutomataLibraryServices automataLibraryServices, long l, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        IProgressAwareTimer iProgressAwareTimer = automataLibraryServices.getProgressAwareTimer().getChildTimer(l);
        boolean bl2 = false;
        boolean bl3 = false;
        Object object = null;
        try {
            if (simulationOrMinimizationType.equals((Object)SimulationOrMinimizationType.DIRECT)) {
                DirectGameGraph<LETTER, STATE> directGameGraph = new DirectGameGraph<LETTER, STATE>(automataLibraryServices, iMinimizationStateFactory, iProgressAwareTimer, this.mLogger, iNestedWordAutomaton);
                directGameGraph.generateGameGraphFromAutomaton();
                DirectSimulation<LETTER, STATE> directSimulation = new DirectSimulation<LETTER, STATE>(iProgressAwareTimer, this.mLogger, bl, iMinimizationStateFactory, directGameGraph);
                directSimulation.doSimulation();
                object = directSimulation;
            } else if (simulationOrMinimizationType.equals((Object)SimulationOrMinimizationType.DELAYED)) {
                DelayedGameGraph<LETTER, STATE> delayedGameGraph = new DelayedGameGraph<LETTER, STATE>(automataLibraryServices, iMinimizationStateFactory, iProgressAwareTimer, this.mLogger, iNestedWordAutomaton);
                delayedGameGraph.generateGameGraphFromAutomaton();
                DelayedSimulation<LETTER, STATE> delayedSimulation = new DelayedSimulation<LETTER, STATE>(iProgressAwareTimer, this.mLogger, bl, iMinimizationStateFactory, delayedGameGraph);
                delayedSimulation.doSimulation();
                object = delayedSimulation;
            } else if (simulationOrMinimizationType.equals((Object)SimulationOrMinimizationType.FAIR)) {
                FairGameGraph<LETTER, STATE> fairGameGraph = new FairGameGraph<LETTER, STATE>(automataLibraryServices, iMinimizationStateFactory, iProgressAwareTimer, this.mLogger, iNestedWordAutomaton);
                fairGameGraph.generateGameGraphFromAutomaton();
                FairSimulation<LETTER, STATE> fairSimulation = new FairSimulation<LETTER, STATE>(iProgressAwareTimer, this.mLogger, bl, iMinimizationStateFactory, fairGameGraph);
                fairSimulation.doSimulation();
                object = fairSimulation;
            } else if (simulationOrMinimizationType.equals((Object)SimulationOrMinimizationType.FAIRDIRECT)) {
                FairDirectGameGraph<LETTER, STATE> fairDirectGameGraph = new FairDirectGameGraph<LETTER, STATE>(automataLibraryServices, iMinimizationStateFactory, iProgressAwareTimer, this.mLogger, iNestedWordAutomaton);
                fairDirectGameGraph.generateGameGraphFromAutomaton();
                FairDirectSimulation<LETTER, STATE> fairDirectSimulation = new FairDirectSimulation<LETTER, STATE>(iProgressAwareTimer, this.mLogger, bl, iMinimizationStateFactory, fairDirectGameGraph);
                fairDirectSimulation.doSimulation();
                object = fairDirectSimulation;
            } else if (simulationOrMinimizationType.equals((Object)SimulationOrMinimizationType.EXT_MINIMIZESEVPA)) {
                long l2 = System.currentTimeMillis();
                object = new MinimizeSevpa<LETTER, STATE>(this.mServices, iMinimizationStateFactory, iNestedWordAutomaton);
                this.mExternalOverallTime = System.currentTimeMillis() - l2;
            } else if (simulationOrMinimizationType.equals((Object)SimulationOrMinimizationType.EXT_SHRINKNWA)) {
                long l3 = System.currentTimeMillis();
                object = new ShrinkNwa<LETTER, STATE>(this.mServices, iMinimizationStateFactory, iNestedWordAutomaton);
                this.mExternalOverallTime = System.currentTimeMillis() - l3;
            } else if (simulationOrMinimizationType.equals((Object)SimulationOrMinimizationType.EXT_MINIMIZENWAMAXSAT)) {
                IDoubleDeckerAutomaton iDoubleDeckerAutomaton = null;
                iDoubleDeckerAutomaton = iNestedWordAutomaton instanceof IDoubleDeckerAutomaton ? (IDoubleDeckerAutomaton)iNestedWordAutomaton : new RemoveUnreachable<LETTER, STATE>(automataLibraryServices, iNestedWordAutomaton).getResult();
                long l4 = System.currentTimeMillis();
                object = new MinimizeNwaPmaxSatDirectBi(this.mServices, iMinimizationStateFactory, iDoubleDeckerAutomaton);
                this.mExternalOverallTime = System.currentTimeMillis() - l4;
            }
        }
        catch (AutomataOperationCanceledException automataOperationCanceledException) {
            this.mLogger.info((Object)"Method timed out.");
            bl2 = true;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.mLogger.info((Object)"Method has thrown an out of memory error.");
            bl3 = true;
        }
        this.appendMethodPerformanceToLog(object, string, simulationOrMinimizationType, bl, bl2, bl3, iNestedWordAutomaton);
    }

    protected void measurePerformances(String string, long l, IMinimizationStateFactory<STATE> iMinimizationStateFactory, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates) {
        this.measureMethodPerformance(string, SimulationOrMinimizationType.DIRECT, false, this.mServices, l, iMinimizationStateFactory, nestedWordAutomatonReachableStates);
        this.measureMethodPerformance(string, SimulationOrMinimizationType.DIRECT, true, this.mServices, l, iMinimizationStateFactory, nestedWordAutomatonReachableStates);
        this.measureMethodPerformance(string, SimulationOrMinimizationType.DELAYED, false, this.mServices, l, iMinimizationStateFactory, nestedWordAutomatonReachableStates);
        this.measureMethodPerformance(string, SimulationOrMinimizationType.DELAYED, true, this.mServices, l, iMinimizationStateFactory, nestedWordAutomatonReachableStates);
        this.measureMethodPerformance(string, SimulationOrMinimizationType.FAIR, false, this.mServices, l, iMinimizationStateFactory, nestedWordAutomatonReachableStates);
        this.measureMethodPerformance(string, SimulationOrMinimizationType.FAIR, true, this.mServices, l, iMinimizationStateFactory, nestedWordAutomatonReachableStates);
        this.measureMethodPerformance(string, SimulationOrMinimizationType.FAIRDIRECT, false, this.mServices, l, iMinimizationStateFactory, nestedWordAutomatonReachableStates);
        this.measureMethodPerformance(string, SimulationOrMinimizationType.FAIRDIRECT, true, this.mServices, l, iMinimizationStateFactory, nestedWordAutomatonReachableStates);
        this.measureMethodPerformance(string, SimulationOrMinimizationType.EXT_MINIMIZESEVPA, true, this.mServices, l, iMinimizationStateFactory, nestedWordAutomatonReachableStates);
        this.measureMethodPerformance(string, SimulationOrMinimizationType.EXT_SHRINKNWA, true, this.mServices, l, iMinimizationStateFactory, nestedWordAutomatonReachableStates);
        this.measureMethodPerformance(string, SimulationOrMinimizationType.EXT_MINIMIZENWAMAXSAT, true, this.mServices, l, iMinimizationStateFactory, nestedWordAutomatonReachableStates);
    }

    protected void setExternalOverallTime(long l) {
        this.mExternalOverallTime = l;
    }
}

