/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRTermChecker;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctConjunction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonCalculator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonDetector;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctagonTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.ParametricOctMatrix;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FastUPRCore {
    private final Term mRelation;
    private final UnmodifiableTransFormula mFormula;
    private Term mResultTerm;
    private final FastUPRUtils mUtils;
    private final ManagedScript mManagedScript;
    private final IUltimateServiceProvider mServices;
    private final OctagonTransformer mOctagonTransformer;
    private final OctagonDetector mOctagonDetector;
    private final OctagonCalculator mOctagonCalculator;
    private OctConjunction mConjunc;
    private final Map<IProgramVar, TermVariable> mInVars;
    private final Map<IProgramVar, TermVariable> mOutVars;
    private List<TermVariable> mVariables;
    private final FastUPRTermChecker mTermChecker;
    private final FastUPRFormulaBuilder mFormulaBuilder;

    public FastUPRCore(UnmodifiableTransFormula unmodifiableTransFormula, ManagedScript managedScript, ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mManagedScript = managedScript;
        this.mUtils = new FastUPRUtils(iLogger, false);
        this.mUtils.output("==================================================");
        this.mUtils.output("== FAST UPR CORE ==");
        this.mUtils.output("==================================================");
        this.mFormula = unmodifiableTransFormula;
        this.mRelation = unmodifiableTransFormula.getFormula();
        for (IProgramVar iProgramVar : this.mFormula.getInVars().keySet()) {
            this.mUtils.debug(iProgramVar.toString());
            this.mUtils.debug(iProgramVar.getTermVariable().toString());
        }
        this.mOctagonDetector = new OctagonDetector(iLogger, managedScript, iUltimateServiceProvider);
        this.mOctagonTransformer = new OctagonTransformer(this.mUtils, managedScript.getScript(), this.mOctagonDetector);
        this.mOctagonCalculator = new OctagonCalculator(this.mUtils, managedScript);
        this.mFormulaBuilder = new FastUPRFormulaBuilder(this.mUtils, this.mManagedScript, this.mOctagonCalculator, this.mOctagonTransformer, this.mServices);
        this.mTermChecker = new FastUPRTermChecker(this.mUtils, this.mManagedScript, this.mOctagonCalculator, this.mFormulaBuilder, this.mServices);
        this.mUtils.output("Formula:" + this.mFormula.toString());
        this.mInVars = new LinkedHashMap<IProgramVar, TermVariable>(this.mFormula.getInVars());
        this.mOutVars = new LinkedHashMap<IProgramVar, TermVariable>(this.mFormula.getOutVars());
        this.mVariables = new ArrayList<TermVariable>();
        if (this.mOctagonCalculator.isTrivial(this.mInVars, this.mOutVars)) {
            this.mUtils.output("Trivial TransFormula, loop does nothing.");
            this.mResultTerm = unmodifiableTransFormula.getFormula();
        } else if (this.isOctagon(this.mRelation, managedScript.getScript())) {
            this.mConjunc = this.mOctagonTransformer.transform(this.mRelation);
            this.mConjunc = this.mOctagonCalculator.normalizeVarNames(this.mConjunc, this.mInVars, this.mOutVars);
            this.mUtils.debug(this.mConjunc.toString());
            this.mConjunc = this.mOctagonCalculator.removeInOutVars(this.mConjunc, this.mInVars, this.mOutVars);
            this.mUtils.debug(this.mConjunc.toString());
            this.mVariables = this.mOctagonCalculator.getSortedVariables(this.mInVars, this.mOutVars);
            this.mTermChecker.setConjunction(this.mConjunc, this.mInVars, this.mOutVars);
            this.mUtils.output(">> IS OCTAGON: STARTING PREFIX LOOP");
            this.mUtils.output("Conjunction: " + this.mConjunc.toString());
            this.prefixLoop();
        } else {
            this.mResultTerm = null;
        }
    }

    private void prefixLoop() {
        int n = 0;
        while (!this.periodLoop(n)) {
            ++n;
            if (this.mServices.getProgressMonitorService().continueProcessing()) continue;
            throw new ToolchainCanceledException(new RunningTaskInfo(this.getClass(), "the current task"));
        }
    }

    private boolean periodLoop(int n) {
        int n2 = 1;
        while (n2 <= n) {
            this.mUtils.output(">> Checking Consistency for b=" + n + ", c=" + n2);
            int n3 = this.mTermChecker.checkConsistency(n, n2);
            if (n3 >= 0) {
                this.mUtils.output(">> NOT CONSISTENT FOR 2 ITERATIONS: RETURNING COMPOSITION RESULT");
                this.mResultTerm = this.mFormulaBuilder.buildConsistencyResult(this.mConjunc, n3 * n2 + n - 1, this.mInVars, this.mOutVars);
                return true;
            }
            this.mUtils.output(">> CONSISTENT: CHECKING FOR PERIODICITY");
            ParametricOctMatrix parametricOctMatrix = this.periodCheck(n, n2);
            if (parametricOctMatrix == null) {
                this.mUtils.output("PeriodCheck Not Successful.");
            } else {
                boolean bl = this.checkForAll(parametricOctMatrix, n, n2);
                if (bl) {
                    this.mUtils.output("ForAll Successful.");
                    this.mResultTerm = this.mFormulaBuilder.buildParametricResult(this.mConjunc, n, parametricOctMatrix, this.mInVars, this.mOutVars, this.mVariables);
                    return true;
                }
                this.mUtils.output("ForAll Unsuccessful. Periodicity until Inconsistency.");
                boolean bl2 = this.checkPeriodicity(parametricOctMatrix, n, n2);
                if (bl2 && this.periodicityCalculation(parametricOctMatrix, n, n2)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    private boolean periodicityCalculation(ParametricOctMatrix parametricOctMatrix, int n, int n2) {
        boolean bl = true;
        int n3 = 0;
        while (bl) {
            ParametricOctMatrix parametricOctMatrix2 = parametricOctMatrix.multiplyConstant(new BigDecimal(n3));
            ParametricOctMatrix parametricOctMatrix3 = parametricOctMatrix.multiplyConstant(new BigDecimal(n3 + 1));
            OctConjunction octConjunction = this.mOctagonCalculator.sequentialize(this.mConjunc, this.mInVars, this.mOutVars, n);
            ParametricOctMatrix parametricOctMatrix4 = this.mOctagonTransformer.getMatrix(octConjunction, this.mVariables);
            ParametricOctMatrix parametricOctMatrix5 = parametricOctMatrix2.add(parametricOctMatrix4);
            OctConjunction octConjunction2 = parametricOctMatrix5.toOctConjunction();
            OctConjunction octConjunction3 = this.mOctagonCalculator.sequentialize(this.mConjunc, this.mInVars, this.mOutVars, n2);
            OctConjunction octConjunction4 = this.mOctagonCalculator.binarySequentialize(octConjunction2, octConjunction3, this.mInVars, this.mOutVars);
            bl = this.mTermChecker.checkTerm(octConjunction4.toTerm(this.mManagedScript.getScript()));
            OctConjunction octConjunction5 = parametricOctMatrix3.add(parametricOctMatrix4).toOctConjunction();
            this.mUtils.output(octConjunction4.toString());
            this.mUtils.output(octConjunction4.toTerm(this.mManagedScript.getScript()).toStringDirect());
            if (!this.mTermChecker.checkTerm(this.mManagedScript.getScript().term("=", new Term[]{octConjunction4.toTerm(this.mManagedScript.getScript()), octConjunction5.toTerm(this.mManagedScript.getScript())}))) {
                return false;
            }
            ++n3;
            if (this.mServices.getProgressMonitorService().continueProcessing()) continue;
            throw new ToolchainCanceledException(new RunningTaskInfo(this.getClass(), "the current task"));
        }
        this.mResultTerm = this.mFormulaBuilder.buildPeriodicityResult(this.mConjunc, parametricOctMatrix, n, n2, n3, this.mInVars, this.mOutVars, this.mVariables);
        return true;
    }

    private boolean checkPeriodicity(ParametricOctMatrix parametricOctMatrix, int n, int n2) {
        Script script = this.mManagedScript.getScript();
        OctConjunction octConjunction = this.mOctagonCalculator.sequentialize(this.mConjunc, this.mInVars, this.mOutVars, n);
        ParametricOctMatrix parametricOctMatrix2 = this.mOctagonTransformer.getMatrix(octConjunction, this.mVariables);
        ParametricOctMatrix parametricOctMatrix3 = parametricOctMatrix.multiplyVar("n", this.mManagedScript);
        ParametricOctMatrix parametricOctMatrix4 = parametricOctMatrix3.add(parametricOctMatrix2);
        OctConjunction octConjunction2 = this.mOctagonCalculator.sequentialize(this.mConjunc, this.mInVars, this.mOutVars, n2);
        OctConjunction octConjunction3 = this.mOctagonCalculator.binarySequentialize(parametricOctMatrix4.toOctConjunction(), octConjunction2, this.mInVars, this.mOutVars);
        Term term = script.quantifier(0, new TermVariable[]{parametricOctMatrix3.getParametricVar()}, script.term("and", new Term[]{script.term(">=", new Term[]{parametricOctMatrix3.getParametricVar(), script.decimal(BigDecimal.ZERO)}), octConjunction3.toTerm(script)}), (Term[][])new Term[0][]);
        return this.mTermChecker.checkQuantifiedTerm(term);
    }

    private ParametricOctMatrix periodCheck(int n, int n2) {
        this.mUtils.output(">>> PERIOD CHECK");
        OctConjunction octConjunction = this.mOctagonCalculator.sequentialize(this.mConjunc, this.mInVars, this.mOutVars, n);
        OctConjunction octConjunction2 = this.mOctagonCalculator.sequentialize(this.mConjunc, this.mInVars, this.mOutVars, n + n2);
        OctConjunction octConjunction3 = this.mOctagonCalculator.sequentialize(this.mConjunc, this.mInVars, this.mOutVars, n + 2 * n2);
        this.mUtils.debug(octConjunction.toString());
        this.mUtils.debug(octConjunction2.toString());
        this.mUtils.debug(octConjunction3.toString());
        ParametricOctMatrix parametricOctMatrix = this.mOctagonTransformer.getMatrix(octConjunction, this.mVariables);
        ParametricOctMatrix parametricOctMatrix2 = this.mOctagonTransformer.getMatrix(octConjunction2, this.mVariables);
        ParametricOctMatrix parametricOctMatrix3 = this.mOctagonTransformer.getMatrix(octConjunction3, this.mVariables);
        this.mUtils.debug(parametricOctMatrix.getMatrix().toString());
        this.mUtils.debug(parametricOctMatrix2.getMatrix().toString());
        this.mUtils.debug(parametricOctMatrix3.getMatrix().toString());
        ParametricOctMatrix parametricOctMatrix4 = parametricOctMatrix2.subtract(parametricOctMatrix);
        ParametricOctMatrix parametricOctMatrix5 = parametricOctMatrix3.subtract(parametricOctMatrix2);
        this.mUtils.debug(parametricOctMatrix4.getMatrix().toString());
        this.mUtils.debug(parametricOctMatrix5.getMatrix().toString());
        this.mUtils.debug(parametricOctMatrix4.toOctConjunction().toString());
        this.mUtils.debug(parametricOctMatrix5.toOctConjunction().toString());
        if (parametricOctMatrix4.isEqualTo(parametricOctMatrix5)) {
            this.mUtils.output("> Success!");
            return parametricOctMatrix4;
        }
        return null;
    }

    private boolean checkForAll(ParametricOctMatrix parametricOctMatrix, int n, int n2) {
        this.mUtils.output(">>> FOR ALL CHECK, b=" + n + ",c=" + n2);
        Script script = this.mManagedScript.getScript();
        OctConjunction octConjunction = this.mOctagonCalculator.sequentialize(this.mConjunc, this.mInVars, this.mOutVars, n);
        OctConjunction octConjunction2 = this.mOctagonCalculator.sequentialize(this.mConjunc, this.mInVars, this.mOutVars, n2);
        ParametricOctMatrix parametricOctMatrix2 = this.mOctagonTransformer.getMatrix(octConjunction, this.mVariables);
        this.mUtils.debug("Creating Parametric Matrix differenceN.");
        ParametricOctMatrix parametricOctMatrix3 = parametricOctMatrix.multiplyVar("n", this.mManagedScript);
        this.mUtils.debug(parametricOctMatrix3.toOctConjunction().toString());
        this.mUtils.debug(parametricOctMatrix3.getMapping().toString());
        this.mUtils.debug(parametricOctMatrix2.getMapping().toString());
        this.mUtils.debug(parametricOctMatrix3.getMatrix().toString());
        this.mUtils.debug(parametricOctMatrix2.getMatrix().toString());
        this.mUtils.debug(parametricOctMatrix3.getSummands().toString());
        this.mUtils.debug(parametricOctMatrix3.getParametricVar().toString());
        ParametricOctMatrix parametricOctMatrix4 = parametricOctMatrix3.add(parametricOctMatrix2);
        this.mUtils.debug("Creating Intervals.");
        OctConjunction octConjunction3 = parametricOctMatrix4.toOctConjunction();
        OctConjunction octConjunction4 = this.mOctagonCalculator.binarySequentialize(octConjunction3, octConjunction2, this.mInVars, this.mOutVars);
        OctConjunction octConjunction5 = parametricOctMatrix4.toOctConjunction(1);
        this.mUtils.debug("Intervals:");
        this.mUtils.debug(octConjunction4.toString());
        this.mUtils.debug(octConjunction5.toString());
        Term term = script.term("=", new Term[]{octConjunction4.toTerm(script), octConjunction5.toTerm(script)});
        this.mUtils.debug("eqTerm: " + term.toString());
        Term term2 = script.term("and", new Term[]{script.term(">=", new Term[]{parametricOctMatrix3.getParametricVar(), script.decimal(BigDecimal.ZERO)}), term});
        Term term3 = script.term("<", new Term[]{parametricOctMatrix3.getParametricVar(), script.decimal(BigDecimal.ZERO)});
        Term term4 = script.quantifier(1, new TermVariable[]{parametricOctMatrix3.getParametricVar()}, script.term("or", new Term[]{term2, term3}), (Term[][])new Term[0][]);
        this.mUtils.debug("quantTerm: " + term4.toString());
        Set<TermVariable> set = octConjunction4.getVariables();
        boolean bl = this.mTermChecker.checkQuantifiedTerm(term4);
        if (!bl) {
            return false;
        }
        if (!set.isEmpty()) {
            Term term5 = script.quantifier(0, set.toArray(new TermVariable[0]), octConjunction4.toTerm(script), (Term[][])new Term[0][]);
            Term term6 = script.quantifier(1, new TermVariable[]{parametricOctMatrix3.getParametricVar()}, script.term("or", new Term[]{term3, term5}), (Term[][])new Term[0][]);
            return this.mTermChecker.checkQuantifiedTerm(term6);
        }
        throw new UnsupportedOperationException();
    }

    private boolean isOctagon(Term term, Script script) {
        Term term2 = SmtUtils.toCnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (Term)term);
        this.mUtils.output("CNF");
        this.mUtils.output(term2.toString());
        Set<Term> set = this.mOctagonDetector.getConjunctSubTerms(term2);
        this.mUtils.debug("Term count:" + set.size());
        this.mOctagonDetector.clearChecked();
        for (Term term3 : set) {
            PolynomialRelation polynomialRelation = PolynomialRelation.of((Script)script, (Term)term3);
            if (polynomialRelation == null) {
                return false;
            }
            term3 = polynomialRelation.toTerm(script);
            this.mUtils.debug("Term as Positive Normal Form:");
            this.mUtils.debug(term3.toString());
            if (this.mOctagonDetector.isOctTerm(term3)) continue;
            return false;
        }
        return true;
    }

    public UnmodifiableTransFormula getResult() {
        if (this.mResultTerm == null) {
            throw new UnsupportedOperationException("No Result found.");
        }
        return this.mFormulaBuilder.buildTransFormula(this.mResultTerm, this.mInVars, this.mOutVars);
    }

    public UnmodifiableTransFormula getExitEdgeResult(UnmodifiableTransFormula unmodifiableTransFormula) {
        this.mResultTerm = this.mFormulaBuilder.getExitEdgeResult(unmodifiableTransFormula, this.mResultTerm, this.mInVars, this.mOutVars);
        return this.getResult();
    }
}

