/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.senwa;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.DoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Senwa<LETTER, STATE>
extends DoubleDeckerAutomaton<LETTER, STATE>
implements INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> {
    private final Map<STATE, STATE> mState2Entry = new HashMap<STATE, STATE>();
    private final Map<STATE, Set<STATE>> mEntry2Module = new HashMap<STATE, Set<STATE>>();
    @Deprecated
    private final Map<STATE, Set<STATE>> mEntry2CallPredecessors = new HashMap<STATE, Set<STATE>>();

    public Senwa(AutomataLibraryServices automataLibraryServices, VpAlphabet<LETTER> vpAlphabet, IEmptyStackStateFactory<STATE> iEmptyStackStateFactory) {
        super(automataLibraryServices, vpAlphabet, iEmptyStackStateFactory);
        assert (this.isModuleInformationConsistent());
    }

    public boolean isEntry(STATE STATE) {
        return this.getEntry(STATE) == STATE;
    }

    public STATE getEntry(STATE STATE) {
        return this.mState2Entry.get(STATE);
    }

    public Set<STATE> getCallPredecessors(STATE STATE) {
        assert (this.mEntry2Module.containsKey(STATE));
        assert (this.mEntry2CallPredecessors.containsKey(STATE));
        return this.mEntry2CallPredecessors.get(STATE);
    }

    @Override
    @Deprecated
    public Set<STATE> getDownStates(STATE STATE) {
        STATE STATE2 = this.getEntry(STATE);
        return this.getCallPredecessors(STATE2);
    }

    @Override
    public boolean isDoubleDecker(STATE STATE, STATE STATE2) {
        STATE STATE3 = this.getEntry(STATE);
        if (STATE3 == null) {
            return false;
        }
        Set<STATE> set = this.getCallPredecessors(STATE3);
        return set.contains(STATE2);
    }

    public Set<STATE> getModuleStates(STATE STATE) {
        assert (this.mEntry2Module.containsKey(STATE));
        return this.mEntry2Module.get(STATE);
    }

    @Override
    public void addState(boolean bl, boolean bl2, STATE STATE) {
        throw new IllegalArgumentException("Specify entry");
    }

    public void addState(STATE STATE, boolean bl, boolean bl2, STATE STATE2) {
        this.mState2Entry.put(STATE, STATE2);
        Set<STATE> set = this.mEntry2Module.get(STATE2);
        if (set == null) {
            assert (STATE == STATE2);
            set = new HashSet<STATE>();
            this.mEntry2Module.put(STATE2, set);
        }
        set.add(STATE);
        super.addState(bl, bl2, STATE);
        if (STATE == STATE2) {
            Set<STATE> set2 = this.mEntry2CallPredecessors.get(STATE);
            if (set2 == null) {
                set2 = new HashSet<STATE>();
                this.mEntry2CallPredecessors.put(STATE, set2);
            }
            if (bl) {
                set2.add(super.getEmptyStackState());
            }
        }
        assert (this.isModuleInformationConsistent());
    }

    @Override
    public void removeState(STATE STATE) {
        STATE STATE2 = this.mState2Entry.get(STATE);
        assert (STATE2 != null);
        Set<STATE> set = this.mEntry2Module.get(STATE2);
        boolean bl = set.remove(STATE);
        assert (bl) : "State was not in module";
        for (OutgoingCallTransition outgoingCallTransition : this.callSuccessors(STATE)) {
            STATE STATE3 = outgoingCallTransition.getSucc();
            assert (this.isEntry(STATE3));
            Set<STATE> set2 = this.mEntry2CallPredecessors.get(STATE3);
            set2.remove(STATE);
        }
        if (this.isEntry(STATE)) {
            assert (set.isEmpty()) : "Can only delete entry if it was the last state in module";
            this.mEntry2Module.remove(STATE);
            this.mEntry2CallPredecessors.remove(STATE);
        }
        super.removeState(STATE);
        assert (this.isModuleInformationConsistent());
    }

    @Override
    public void addInternalTransition(STATE STATE, LETTER LETTER, STATE STATE2) {
        STATE STATE3 = this.mState2Entry.get(STATE);
        assert (STATE3 != null);
        STATE STATE4 = this.mState2Entry.get(STATE2);
        assert (STATE4 != null);
        if (STATE3 != STATE4) {
            throw new IllegalArgumentException("Result is no Senwa.");
        }
        super.addInternalTransition(STATE, LETTER, STATE2);
        assert (this.isModuleInformationConsistent());
    }

    @Override
    public void addCallTransition(STATE STATE, LETTER LETTER, STATE STATE2) {
        assert (STATE2 == this.mState2Entry.get(STATE2));
        Set<STATE> set = this.mEntry2CallPredecessors.get(STATE2);
        if (set == null) {
            set = new HashSet<STATE>();
            this.mEntry2CallPredecessors.put(STATE2, set);
        }
        set.add(STATE);
        super.addCallTransition(STATE, LETTER, STATE2);
        assert (this.isModuleInformationConsistent());
    }

    @Override
    public void addReturnTransition(STATE STATE, STATE STATE2, LETTER LETTER, STATE STATE3) {
        assert (this.mState2Entry.get(STATE) != null);
        STATE STATE4 = this.mState2Entry.get(STATE2);
        assert (STATE4 != null);
        STATE STATE5 = this.mState2Entry.get(STATE3);
        assert (STATE5 != null);
        assert (STATE4 == STATE5);
        super.addReturnTransition(STATE, STATE2, LETTER, STATE3);
        assert (this.isModuleInformationConsistent());
    }

    public boolean isModuleInformationConsistent() {
        boolean bl = true;
        for (Object STATE : this.getStates()) {
            Set set2;
            Object STATE2 = this.getEntry(STATE);
            if (STATE2 == STATE) {
                boolean bl2 = bl = bl && this.isEntry(STATE);
                assert (bl);
                for (Set set2 : this.getCallPredecessors(STATE)) {
                    boolean bl3 = bl = bl && (this.getStates().contains(set2) || set2 == this.getEmptyStackState());
                    assert (bl);
                }
            }
            set2 = this.getModuleStates(STATE2);
            boolean bl4 = bl = bl && set2.contains(STATE);
            assert (bl);
        }
        return bl;
    }
}

