/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.srparse;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;

public final class LiteralUtils {
    private LiteralUtils() {
    }

    public static Optional<Term> toTerm(Expression expression, Script script) {
        UnaryExpression unaryExpression;
        if (expression instanceof RealLiteral) {
            return Optional.of(SmtUtils.toRational((String)((RealLiteral)expression).getValue()).toTerm(SmtSortUtils.getRealSort((Script)script)));
        }
        if (expression instanceof IntegerLiteral) {
            return Optional.of(SmtUtils.toRational((String)((IntegerLiteral)expression).getValue()).toTerm(SmtSortUtils.getIntSort((Script)script)));
        }
        if (expression instanceof BooleanLiteral) {
            if (((BooleanLiteral)expression).getValue()) {
                return Optional.of(script.term("true", new Term[0]));
            }
            return Optional.of(script.term("false", new Term[0]));
        }
        if (expression instanceof UnaryExpression && (unaryExpression = (UnaryExpression)expression).getOperator() == UnaryExpression.Operator.ARITHNEGATIVE) {
            return LiteralUtils.toTerm(unaryExpression.getExpr(), script).map(term -> SmtUtils.neg((Script)script, (Term)term));
        }
        return Optional.empty();
    }

    public static Optional<Rational> toRational(Expression expression) {
        if (expression instanceof UnaryExpression) {
            UnaryExpression unaryExpression = (UnaryExpression)expression;
            if (unaryExpression.getOperator() == UnaryExpression.Operator.ARITHNEGATIVE) {
                return LiteralUtils.toRational(unaryExpression.getExpr()).map(rational -> rational.negate());
            }
        } else {
            if (expression instanceof RealLiteral) {
                return Optional.of(SmtUtils.toRational((String)((RealLiteral)expression).getValue()));
            }
            if (expression instanceof IntegerLiteral) {
                return Optional.of(SmtUtils.toRational((String)((IntegerLiteral)expression).getValue()));
            }
        }
        return Optional.empty();
    }

    public static Expression toExpression(ILocation iLocation, Rational rational, boolean bl) {
        if (!rational.isRational()) {
            IntegerLiteral integerLiteral = new IntegerLiteral(iLocation, (IBoogieType)BoogieType.TYPE_INT, rational.numerator().toString());
            IntegerLiteral integerLiteral2 = new IntegerLiteral(iLocation, (IBoogieType)BoogieType.TYPE_INT, rational.denominator().toString());
            return new BinaryExpression(iLocation, (IBoogieType)BoogieType.TYPE_REAL, BinaryExpression.Operator.ARITHDIV, (Expression)integerLiteral, (Expression)integerLiteral2);
        }
        if (rational.isIntegral() && rational.denominator().equals(BigInteger.ONE)) {
            if (bl) {
                return new RealLiteral(iLocation, (IBoogieType)BoogieType.TYPE_REAL, rational.numerator().toString());
            }
            return new IntegerLiteral(iLocation, (IBoogieType)BoogieType.TYPE_INT, rational.numerator().toString());
        }
        String string = new BigDecimal(rational.numerator()).divide(new BigDecimal(rational.denominator())).toPlainString();
        return new RealLiteral(iLocation, (IBoogieType)BoogieType.TYPE_REAL, string);
    }
}

