/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbolFactory;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.CongRewriteFunctionFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.IProofTracker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.MatchRewriteFunctionFactory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofConstants;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import java.util.LinkedHashSet;

public class ProofTracker
implements IProofTracker {
    ProofRules mProofRules;

    public ProofTracker(Theory theory) {
        this.mProofRules = new ProofRules(theory);
        this.setupTheory(theory);
    }

    private void setupTheory(Theory theory) {
        if (theory.getDeclaredSorts().containsKey(".EqProof")) {
            return;
        }
        theory.declareInternalSort(".EqProof", 1, 0);
        Sort[] sortArray = theory.createSortVariables(new String[]{"X"});
        Sort sort = theory.getSort(".EqProof", new Sort[]{sortArray[0]});
        Sort sort2 = theory.getSort(".EqProof", new Sort[]{theory.getBooleanSort()});
        Sort[] sortArray2 = new Sort[]{sortArray[0], sortArray[0]};
        Sort[] sortArray3 = new Sort[]{sort, sort};
        theory.declareInternalPolymorphicFunction(".refl", sortArray, sortArray, sort, 0);
        theory.declareInternalPolymorphicFunction(".rewrite", sortArray, sortArray2, sort, 0);
        theory.declareInternalPolymorphicFunction(".trans", sortArray, sortArray3, sort, 2);
        theory.declareInternalFunctionFactory((FunctionSymbolFactory)new CongRewriteFunctionFactory());
        theory.declareInternalFunctionFactory((FunctionSymbolFactory)new MatchRewriteFunctionFactory());
        theory.declareInternalFunction(".quant", new Sort[]{sort2}, sort2, 0);
    }

    public Term getProof(Term term) {
        Annotation[] annotationArray = ((AnnotatedTerm)term).getAnnotations();
        assert (annotationArray.length == 1 && annotationArray[0].getKey().equals(":proof"));
        return (Term)annotationArray[0].getValue();
    }

    private Term buildProof(Term term, Term term2) {
        assert (term != null);
        Theory theory = term2.getTheory();
        Annotation[] annotationArray = new Annotation[]{new Annotation(":proof", (Object)term)};
        return theory.annotatedTerm(annotationArray, term2);
    }

    @Override
    public Term intern(Term term, Term term2) {
        return this.buildRewrite(term, term2, ProofConstants.RW_INTERN);
    }

    @Override
    public Term orSimpClause(Term term) {
        Term term2;
        Theory theory = term.getTheory();
        Term term3 = this.getProvedTerm(term);
        assert (term3 instanceof ApplicationTerm && ((ApplicationTerm)term3).getFunction() == theory.mOr);
        Term[] termArray = ((ApplicationTerm)term3).getParameters();
        LinkedHashSet<Term> linkedHashSet = new LinkedHashSet<Term>();
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            term2 = termArray2[n2];
            if (term2 != theory.mFalse) {
                linkedHashSet.add(term2);
            }
            ++n2;
        }
        if (linkedHashSet.size() == 0) {
            term2 = theory.mFalse;
        } else if (linkedHashSet.size() == 1) {
            term2 = (Term)linkedHashSet.iterator().next();
        } else {
            Term[] termArray3 = linkedHashSet.toArray(new Term[linkedHashSet.size()]);
            term2 = theory.term("or", termArray3);
        }
        return this.transitivity(term, this.buildRewrite(term3, term2, ProofConstants.RW_OR_SIMP));
    }

    @Override
    public Term reflexivity(Term term) {
        Theory theory = term.getTheory();
        Term term2 = theory.term(".refl", new Term[]{term});
        return this.buildProof(term2, term);
    }

    private boolean isReflexivity(Term term) {
        return this.isApplication(".refl", term);
    }

    @Override
    public Term transitivity(Term term, Term term2) {
        Term term3 = this.getProof(term);
        Term term4 = this.getProof(term2);
        if (this.isReflexivity(term3)) {
            return term2;
        }
        if (this.isReflexivity(term4)) {
            return this.buildProof(term3, this.getProvedTerm(term2));
        }
        Theory theory = term.getTheory();
        Term term5 = theory.term(".trans", new Term[]{term3, term4});
        return this.buildProof(term5, this.getProvedTerm(term2));
    }

    @Override
    public Term congruence(Term term, Term[] termArray) {
        Term term2;
        Term term3;
        Term[] termArray2 = new Term[termArray.length];
        Term[] termArray3 = new Term[termArray.length];
        boolean bl = true;
        int n = 0;
        while (n < termArray.length) {
            termArray2[n] = this.getProof(termArray[n]);
            termArray3[n] = this.getProvedTerm(termArray[n]);
            if (!this.isReflexivity(termArray2[n])) {
                bl = false;
            }
            ++n;
        }
        Theory theory = term.getTheory();
        ApplicationTerm applicationTerm = (ApplicationTerm)this.getProvedTerm(term);
        FunctionSymbol functionSymbol = applicationTerm.getFunction();
        Term term4 = theory.term(functionSymbol, termArray3);
        if (bl) {
            term3 = this.reflexivity(term4);
        } else {
            term2 = functionSymbol.getIndices();
            String[] stringArray = new String[term2 == null ? 1 : 1 + ((String[])term2).length];
            stringArray[0] = functionSymbol.getName();
            if (term2 != null) {
                System.arraycopy(term2, 0, stringArray, 1, ((Term)term2).length);
            }
            Sort sort = functionSymbol.isReturnOverload() ? theory.getSort(".EqProof", new Sort[]{functionSymbol.getReturnSort()}) : null;
            term3 = this.buildProof(theory.term(".cong", stringArray, sort, termArray2), term4);
        }
        term2 = this.transitivity(term, term3);
        return term2;
    }

    @Override
    public Term rewriteToClause(Term term, Term term2) {
        if (this.isReflexivity(this.getProof(term2))) {
            return null;
        }
        ProofLiteral[] proofLiteralArray = new ProofLiteral[]{this.termToProofLiteral(term).negate(), this.termToProofLiteral(this.getProvedTerm(term2))};
        Annotation[] annotationArray = new Annotation[]{new Annotation(":rewrite", (Object)this.getProof(term2))};
        return this.buildProof(this.mProofRules.oracle(proofLiteralArray, annotationArray), this.getProvedTerm(term2));
    }

    public Term resolve(Term term, Term term2, Term term3) {
        boolean bl = true;
        while (this.isApplication("not", term)) {
            term = ((ApplicationTerm)term).getParameters()[0];
            boolean bl2 = bl = !bl;
        }
        return this.mProofRules.resolutionRule(term, bl ? term2 : term3, bl ? term3 : term2);
    }

    @Override
    public Term resolveBinaryTautology(Term term, Term term2, Annotation annotation) {
        Term term3;
        Theory theory = term.getTheory();
        boolean bl = true;
        Term term4 = term3 = this.getProvedTerm(term);
        while (this.isApplication("not", term4)) {
            term4 = ((ApplicationTerm)term4).getParameters()[0];
            boolean bl2 = bl = !bl;
        }
        Term term5 = bl ? theory.term("not", new Term[]{term4}) : term4;
        Term term6 = this.tautology(theory.term("or", new Term[]{term5, term2}), annotation);
        Term term7 = this.resolve(term3, this.getProof(term), this.getProof(term6));
        return this.buildProof(term7, term2);
    }

    @Override
    public Term modusPonens(Term term, Term term2) {
        if (this.isReflexivity(this.getProof(term2))) {
            return this.buildProof(this.getProof(term), this.getProvedTerm(term2));
        }
        Term term3 = this.getProvedTerm(term);
        Term term4 = this.resolve(term3, this.getProof(term), this.getProof(this.rewriteToClause(term3, term2)));
        return this.buildProof(term4, this.getProvedTerm(term2));
    }

    @Override
    public Term getClauseProof(Term term) {
        return this.getProof(term);
    }

    @Override
    public Term tautology(Term term, Annotation annotation) {
        Term term2 = this.mProofRules.oracle(this.termToProofLiterals(term), new Annotation[]{annotation});
        return this.buildProof(term2, term);
    }

    @Override
    public Term getProvedTerm(Term term) {
        return ((AnnotatedTerm)term).getSubterm();
    }

    @Override
    public Term buildRewrite(Term term, Term term2, Annotation annotation) {
        Theory theory = term.getTheory();
        if (term == term2) {
            return this.reflexivity(term2);
        }
        Annotation[] annotationArray = new Annotation[]{annotation};
        Term term3 = theory.term(".rewrite", new Term[]{theory.annotatedTerm(annotationArray, term), term2});
        return this.buildProof(term3, term2);
    }

    @Override
    public Term asserted(Term term) {
        Term term2 = this.mProofRules.asserted(term);
        boolean bl = true;
        while (this.isApplication("not", term)) {
            term2 = this.mProofRules.resolutionRule(term, bl ? term2 : this.mProofRules.notIntro(term), bl ? this.mProofRules.notElim(term) : term2);
            bl = !bl;
            term = ((ApplicationTerm)term).getParameters()[0];
        }
        return this.buildProof(term2, bl ? term : term.getTheory().term("not", new Term[]{term}));
    }

    @Override
    public Term quantCong(QuantifiedFormula quantifiedFormula, Term term) {
        Term term2;
        Theory theory = quantifiedFormula.getTheory();
        Term term3 = this.getProof(term);
        boolean bl = quantifiedFormula.getQuantifier() == 1;
        Term term4 = term2 = bl ? theory.forall(quantifiedFormula.getVariables(), this.getProvedTerm(term)) : theory.exists(quantifiedFormula.getVariables(), this.getProvedTerm(term));
        if (this.isReflexivity(term3)) {
            return this.reflexivity(term2);
        }
        String string = bl ? ":forall" : ":exists";
        Annotation[] annotationArray = new Annotation[]{new Annotation(string, (Object)quantifiedFormula.getVariables())};
        Term term5 = theory.term(".quant", new Term[]{theory.annotatedTerm(annotationArray, term3)});
        return this.buildProof(term5, term2);
    }

    @Override
    public Term match(MatchTerm matchTerm, Term term, Term[] termArray) {
        String string;
        Theory theory = matchTerm.getTheory();
        Term[] termArray2 = new Term[termArray.length + 1];
        Term[] termArray3 = new Term[termArray.length];
        DataType.Constructor[] constructorArray = matchTerm.getConstructors();
        termArray2[0] = this.getProof(term);
        boolean bl = this.isReflexivity(termArray2[0]);
        int n = 0;
        while (n < termArray.length) {
            string = constructorArray[n] == null ? null : constructorArray[n].getName();
            Annotation[] annotationArray = new Annotation[]{new Annotation(":vars", (Object)matchTerm.getVariables()[n]), new Annotation(":constructor", (Object)string)};
            Term term2 = this.getProof(termArray[n]);
            termArray2[n + 1] = theory.annotatedTerm(annotationArray, term2);
            bl &= this.isReflexivity(term2);
            termArray3[n] = this.getProvedTerm(termArray[n]);
            ++n;
        }
        Term term3 = theory.match(this.getProvedTerm(term), matchTerm.getVariables(), termArray3, matchTerm.getConstructors());
        if (bl) {
            return this.reflexivity(term3);
        }
        string = theory.term(".match", termArray2);
        return this.buildProof((Term)string, term3);
    }

    @Override
    public Term allIntro(Term term, TermVariable[] termVariableArray) {
        Term[] termArray;
        Theory theory = term.getTheory();
        Term term2 = this.getProvedTerm(term);
        Term term3 = this.getProof(term);
        if (this.isApplication("not", term2)) {
            termArray = ((ApplicationTerm)term2).getParameters()[0];
            term3 = this.mProofRules.resolutionRule((Term)termArray, this.mProofRules.notIntro(term2), term3);
        }
        termArray = this.mProofRules.getSkolemVars(termVariableArray, term2, true);
        term3 = theory.let(termVariableArray, termArray, term3);
        Term term4 = theory.let(termVariableArray, termArray, term2);
        FormulaUnLet formulaUnLet = new FormulaUnLet();
        term3 = formulaUnLet.unlet(term3);
        Term term5 = theory.forall(termVariableArray, term2);
        term3 = this.mProofRules.resolutionRule(formulaUnLet.unlet(term4), term3, this.mProofRules.forallIntro((QuantifiedFormula)term5));
        return this.buildProof(term3, term5);
    }

    private boolean isApplication(String string, Term term) {
        ApplicationTerm applicationTerm;
        FunctionSymbol functionSymbol;
        return term instanceof ApplicationTerm && (functionSymbol = (applicationTerm = (ApplicationTerm)term).getFunction()).isIntern() && functionSymbol.getName().equals(string);
    }

    private ProofLiteral termToProofLiteral(Term term) {
        boolean bl = true;
        while (this.isApplication("not", term)) {
            term = ((ApplicationTerm)term).getParameters()[0];
            boolean bl2 = bl = !bl;
        }
        return new ProofLiteral(term, bl);
    }

    private Term[] termToClause(Term term) {
        assert (term != null && term.getSort().getName() == "Bool");
        if (this.isApplication("or", term)) {
            return ((ApplicationTerm)term).getParameters();
        }
        if (this.isApplication("false", term)) {
            return new Term[0];
        }
        return new Term[]{term};
    }

    private ProofLiteral[] termArrayToProofLiterals(Term[] termArray) {
        ProofLiteral[] proofLiteralArray = new ProofLiteral[termArray.length];
        int n = 0;
        while (n < proofLiteralArray.length) {
            proofLiteralArray[n] = this.termToProofLiteral(termArray[n]);
            ++n;
        }
        return proofLiteralArray;
    }

    private ProofLiteral[] termToProofLiterals(Term term) {
        return this.termArrayToProofLiterals(this.termToClause(term));
    }
}

