/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransitionPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CommuHashPreprocessor
extends TransitionPreprocessor {
    private final IUltimateServiceProvider mServices;
    public static final String DESCRIPTION = "Simplify formula using CommuhashNormalForm";

    public CommuHashPreprocessor(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public boolean checkSoundness(Script script, ModifiableTransFormula modifiableTransFormula, ModifiableTransFormula modifiableTransFormula2) {
        return true;
    }

    @Override
    public ModifiableTransFormula process(ManagedScript managedScript, ModifiableTransFormula modifiableTransFormula) throws TermException {
        Term term = new ConstantTermNormalizer2().transform(modifiableTransFormula.getFormula());
        Term term2 = new CommuhashNormalForm(this.mServices, managedScript.getScript()).transform(term);
        modifiableTransFormula.setFormula(term2);
        return modifiableTransFormula;
    }

    public static class ConstantTermNormalizer2
    extends TermTransformer {
        protected void convert(Term term) {
            if (term instanceof ConstantTerm) {
                ConstantTerm constantTerm = (ConstantTerm)term;
                if (constantTerm.getValue() instanceof BigInteger) {
                    Rational rational = Rational.valueOf((BigInteger)((BigInteger)constantTerm.getValue()), (BigInteger)BigInteger.ONE);
                    this.setResult(rational.toTerm(term.getSort()));
                } else if (constantTerm.getValue() instanceof BigDecimal) {
                    Rational rational;
                    BigDecimal bigDecimal = (BigDecimal)constantTerm.getValue();
                    if (bigDecimal.scale() <= 0) {
                        BigInteger bigInteger = bigDecimal.toBigInteger();
                        rational = Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE);
                    } else {
                        BigInteger bigInteger = bigDecimal.unscaledValue();
                        BigInteger bigInteger2 = BigInteger.TEN.pow(bigDecimal.scale());
                        rational = Rational.valueOf((BigInteger)bigInteger, (BigInteger)bigInteger2);
                    }
                    this.setResult(rational.toTerm(term.getSort()));
                } else if (constantTerm.getValue() instanceof Rational) {
                    this.setResult((Term)constantTerm);
                } else {
                    this.setResult(term);
                }
            } else {
                super.convert(term);
            }
        }
    }
}

