/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.dataflowdag;

import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.core.lib.observers.BaseObserver;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.util.RCFGEdgeVisitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class AssumeFinder
extends BaseObserver {
    private final ILogger mLogger;
    private final LinkedHashMap<IcfgEdge, List<AssumeStatement>> mEdgesWithAssumes;

    public AssumeFinder(ILogger iLogger) {
        this.mLogger = iLogger;
        this.mEdgesWithAssumes = new LinkedHashMap();
    }

    public boolean process(IElement iElement) throws Throwable {
        if (iElement instanceof BoogieIcfgContainer) {
            BoogieIcfgContainer boogieIcfgContainer = (BoogieIcfgContainer)iElement;
            this.process((IElement)boogieIcfgContainer);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)"AssumeFinder result (edge.hashCode(), pretty-printed assume statement):");
                for (IcfgEdge icfgEdge : this.mEdgesWithAssumes.keySet()) {
                    for (AssumeStatement assumeStatement : this.mEdgesWithAssumes.get(icfgEdge)) {
                        this.mLogger.debug((Object)(icfgEdge.hashCode() + " " + BoogiePrettyPrinter.print((Statement)assumeStatement)));
                    }
                }
            }
        }
        return false;
    }

    public LinkedHashMap<IcfgEdge, List<AssumeStatement>> getEdgesWithAssumes() {
        return this.mEdgesWithAssumes;
    }

    private void process(IcfgLocation icfgLocation) {
        LinkedList<IcfgEdge> linkedList = new LinkedList<IcfgEdge>();
        HashSet<IcfgEdge> hashSet = new HashSet<IcfgEdge>();
        AssumeFinderVisitor assumeFinderVisitor = new AssumeFinderVisitor();
        linkedList.addAll(icfgLocation.getOutgoingEdges());
        while (!linkedList.isEmpty()) {
            IcfgEdge icfgEdge = (IcfgEdge)linkedList.poll();
            assumeFinderVisitor.start(icfgEdge);
            hashSet.add(icfgEdge);
            IcfgLocation icfgLocation2 = (IcfgLocation)icfgEdge.getTarget();
            if (icfgLocation2 == null) {
                this.mLogger.warn((Object)("Empty target for edge " + icfgEdge.hashCode()));
                continue;
            }
            for (IcfgEdge icfgEdge2 : icfgLocation2.getOutgoingEdges()) {
                if (hashSet.contains(icfgEdge2)) continue;
                linkedList.add(icfgEdge2);
            }
        }
    }

    private List<AssumeStatement> getAssumeList(IcfgEdge icfgEdge) {
        List<AssumeStatement> list = this.mEdgesWithAssumes.get(icfgEdge);
        if (list == null) {
            list = new ArrayList<AssumeStatement>();
            this.mEdgesWithAssumes.put(icfgEdge, list);
        }
        return list;
    }

    private class AssumeFinderVisitor
    extends RCFGEdgeVisitor {
        private IcfgEdge mMotherEdge;

        private AssumeFinderVisitor() {
        }

        public void start(IcfgEdge icfgEdge) {
            this.mMotherEdge = icfgEdge;
            this.visit(icfgEdge);
        }

        protected void visit(StatementSequence statementSequence) {
            super.visit(statementSequence);
            for (Statement statement : statementSequence.getStatements()) {
                if (!(statement instanceof AssumeStatement)) continue;
                AssumeFinder.this.getAssumeList(this.mMotherEdge).add((AssumeStatement)statement);
            }
        }
    }
}

