/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.smtinterpol.option.BooleanOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.ChannelOption;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.Option;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.StringOptionWithWarning;
import java.io.PrintWriter;

public class FrontEndOptions {
    private final BooleanOption mPrintSuccess;
    private final ChannelOption mOut;
    private final BooleanOption mPrintTermsCSE;
    private final BooleanOption mContinueOnError;
    private static final String REG_OUT_CHANNEL_DEF = "stdout";
    private static final String REG_OUT_CHANNEL_DESC = "Where to print command responses to.  Use \"stdout\" for standard output and \"stderr\" for standard error.";

    FrontEndOptions(OptionMap optionMap) {
        this.mPrintSuccess = (BooleanOption)optionMap.getOption(":print-success");
        Option option = optionMap.getOption(":regular-output-channel");
        this.mOut = option instanceof ChannelOption ? (ChannelOption)option : null;
        this.mPrintTermsCSE = (BooleanOption)optionMap.getOption(":print-terms-cse");
        this.mContinueOnError = (BooleanOption)optionMap.getOption(":continue-on-error");
    }

    FrontEndOptions(OptionMap optionMap, boolean bl) {
        this.mPrintSuccess = new BooleanOption(true, true, "Print \"success\" after successful command executions that would otherwise not produce feedback.");
        this.mPrintTermsCSE = new BooleanOption(true, true, "Eliminate common subexpressions before printing terms.");
        this.mContinueOnError = new BooleanOption(true, true, "Continue on errors.  Corresponds to (set-info :error-behavior continued-execution).");
        optionMap.addOption(":print-success", this.mPrintSuccess);
        if (bl) {
            this.mOut = new ChannelOption(REG_OUT_CHANNEL_DEF, true, REG_OUT_CHANNEL_DESC);
            optionMap.addOption(":regular-output-channel", this.mOut);
        } else {
            optionMap.addOption(":regular-output-channel", new StringOptionWithWarning(REG_OUT_CHANNEL_DEF, true, REG_OUT_CHANNEL_DESC, "Front End not active.  Option change will not have an effect!", optionMap.getLogProxy()));
            this.mOut = null;
        }
        optionMap.addOption(":print-terms-cse", this.mPrintTermsCSE);
        optionMap.addOption(":continue-on-error", this.mContinueOnError);
    }

    public final boolean isFrontEndActive() {
        return this.mOut != null;
    }

    public final boolean isPrintSuccess() {
        return this.mPrintSuccess.getValue();
    }

    public PrintWriter getOutChannel() {
        return this.mOut.getChannel();
    }

    public final boolean isPrintTermsCSE() {
        return this.mPrintTermsCSE.getValue();
    }

    public final boolean continueOnError() {
        return this.mContinueOnError.getValue();
    }
}

