/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.IRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Difference;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IStateDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmptyParallel;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.PowersetDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.IOpWithDelayedDeadEndRemoval;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.senwa.DifferenceSenwa;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IDeterminizeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISenwaStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISinkStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IMLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.SmtFreePredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.NwaHoareProofProducer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.AbstractCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarNwaWorkerThread;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.ICegarNwaWorkerThread;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.NwaCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PathProgramCache;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryForInterpolantAutomata;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryRefinement;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryResultChecking;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.TransferBetweenMainAndWorker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.WorkerThreadResult;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.automataminimization.AutomataMinimization;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TraceAbstractionPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.TaCheckAndRefinementPreferences;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ParallelNwaCegarLoop<L extends IIcfgTransition<?>, A extends IAutomaton<L, IPredicate>>
extends NwaCegarLoop<L> {
    boolean mComputeHoareAnnotation;
    final String mDestroyEverything = "destroyEverything";
    private final ExecutorService mExec;
    private int mThreadLimit;
    private int mRunningThreads = 0;
    BlockingQueue<IRun<L, ?>> mWorkerTaskQueue = new LinkedBlockingQueue();
    BlockingQueue<WorkerThreadResult<L, A>> mWorkerResultQueue = new LinkedBlockingQueue<WorkerThreadResult<L, A>>();
    private final PathProgramCache<L> mProgramCache = new PathProgramCache(this.mLogger);
    public final HashMap<Integer, NestedRun<L, ?>> mActiveCounterexamples = new HashMap();
    private final Set<Integer> mCounterexamplesToBeRemovedFromActiveCexMap = new HashSet<Integer>();
    protected InterpolationTechnique mInterpolationTechnique;
    protected Class<L> mTransitionClazz;
    private Integer mCounterexamplesChecked = 0;
    private Integer mRefinementsDone = 0;
    private final Integer mCountTimeoutsInSearch = 0;
    private final Integer mCountFailedRunConstructions = 0;
    private Integer mCountFailedToFindCex = 0;
    private Integer mCountBfsFoundCex = 1;
    private final Integer mCountIsEmptyParallel = 0;
    private Integer maxActiveThreads = 0;
    private final Integer mActiveExecutors = 0;
    private long mSearchTime = 0L;
    private long mWorkerSetUpTime = 0L;
    private int mIterationsWithMaxThreads = 0;
    private int mIterationsWithOneThread = 0;
    private final int mExceptionInWorker = 0;
    private long mRefinementTime = 0L;

    public ParallelNwaCegarLoop(DebugIdentifier debugIdentifier, INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, IIcfg<?> iIcfg, CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, TAPreferences tAPreferences, Set<? extends IcfgLocation> set, NwaHoareProofProducer<L> nwaHoareProofProducer, IUltimateServiceProvider iUltimateServiceProvider, Class<L> clazz, PredicateFactoryRefinement predicateFactoryRefinement) {
        super(debugIdentifier, iNestedWordAutomaton, iIcfg, cfgSmtToolkit, predicateFactory, tAPreferences, set, nwaHoareProofProducer, iUltimateServiceProvider, clazz, predicateFactoryRefinement);
        this.mThreadLimit = this.mPref.getThreadLimit();
        if (this.mThreadLimit == 0) {
            this.mThreadLimit = Runtime.getRuntime().availableProcessors();
            --this.mThreadLimit;
        }
        this.mExec = Executors.newFixedThreadPool(this.mThreadLimit);
        Thread.currentThread().setName("Main Cegar Thread");
        this.getServices().getStorage().pushMarker((Object)"destroyEverything");
    }

    private ICegarNwaWorkerThread<L, A> setUpContinuesWorker(IUltimateServiceProvider iUltimateServiceProvider, int n) throws InterruptedException {
        TransferBetweenMainAndWorker transferBetweenMainAndWorker = new TransferBetweenMainAndWorker(new AutomataLibraryServices(this.mServices), this.mLogger, this.mCsToolkit.getManagedScript(), iUltimateServiceProvider, this.getSolverSettings(iUltimateServiceProvider, this.getIteration() + this.mRunningThreads + this.mCounterexample.getWord().asList().hashCode() + "parallel"), this.mCsToolkit);
        CfgSmtToolkit cfgSmtToolkit = transferBetweenMainAndWorker.constructWorkerCfgSmtToolkit();
        PredicateFactory predicateFactory = new PredicateFactory(this.mServices, cfgSmtToolkit.getManagedScript(), cfgSmtToolkit.getSymbolTable());
        PredicateFactoryForInterpolantAutomata predicateFactoryForInterpolantAutomata = new PredicateFactoryForInterpolantAutomata(cfgSmtToolkit.getManagedScript(), predicateFactory, this.mComputeHoareAnnotation);
        Set set = Collections.emptySet();
        if (this.mComputeHoareAnnotation) {
            throw new AssertionError((Object)"Hoare Annotations not yet supported in Parallel cegar loop");
        }
        PredicateFactoryRefinement predicateFactoryRefinement = new PredicateFactoryRefinement(this.mServices, cfgSmtToolkit.getManagedScript(), predicateFactory, this.mComputeHoareAnnotation, set);
        TaCheckAndRefinementPreferences taCheckAndRefinementPreferences = new TaCheckAndRefinementPreferences(this.getServices(), this.mPref, this.mInterpolationTechnique, this.mSimplificationTechnique, cfgSmtToolkit, predicateFactory, this.mIcfg);
        return new CegarNwaWorkerThread(this.mLogger, this.mPref, n, this.mResultBuilder, iUltimateServiceProvider, cfgSmtToolkit, predicateFactory, taCheckAndRefinementPreferences, predicateFactoryForInterpolantAutomata, predicateFactoryRefinement, this.mComputeHoareAnnotation, this, this.mWorkerResultQueue, this.mWorkerTaskQueue, transferBetweenMainAndWorker);
    }

    @Override
    protected void iterate() throws AutomataLibraryException {
        boolean bl = false;
        IcfgLocation icfgLocation = this.getErrorLocFromCounterexample();
        IUltimateServiceProvider iUltimateServiceProvider = this.createIterationTimer(icfgLocation);
        int n = 0;
        while (n < this.mThreadLimit) {
            try {
                this.mExec.submit(this.setUpContinuesWorker(iUltimateServiceProvider, n));
            }
            catch (InterruptedException interruptedException) {
                throw new AssertionError((Object)("Interrupted during worker setup " + String.valueOf(interruptedException)));
            }
            ++n;
        }
        this.startWorker();
        this.mIteration = 1;
        while (this.mIteration <= this.mPref.maxIterations()) {
            this.abortIfTimeout();
            n = 0;
            this.mLogger.info((Object)String.format("=== Iteration %s ===", this.getIteration()));
            try {
                WorkerThreadResult workerThreadResult = this.getWorkerResult(bl);
                while (workerThreadResult != null) {
                    long l = System.nanoTime() / 1000000000L;
                    try {
                        this.mLogger.info((Object)"Main: A Thread is Done");
                        if (workerThreadResult.workerCrashed()) {
                            this.mLogger.error((Object)"Main: Worker Crashed! exiting CEGAR loop.");
                            this.shutDownAndDestroy("destroyEverything");
                            throw new AssertionError((Object)"Worker Crashed!, Exiting CEGAR loop!");
                        }
                        if (this.mPref.stopAfterFirstViolation() && workerThreadResult.getAutomatonType().equals((Object)NwaCegarLoop.AutomatonType.ERROR)) {
                            this.shutDownAndDestroy("destroyEverything");
                            this.updateAndPrintStatistics(true);
                            return;
                        }
                        this.mLogger.info((Object)("Worker Automaton Type: " + String.valueOf((Object)workerThreadResult.getAutomatonType())));
                        this.mLogger.info((Object)"Refining Abstraction");
                        this.refinement(workerThreadResult);
                        this.mRefinementsDone = this.mRefinementsDone + 1;
                        n = 1;
                        workerThreadResult.garbageCollect();
                        if (this.isSafeThenTerminate()) {
                            this.updateAndPrintStatistics(true);
                            return;
                        }
                    }
                    catch (CancellationException cancellationException) {
                        this.mLogger.warn((Object)("Worker was cancelled! " + String.valueOf(cancellationException)));
                    }
                    catch (Exception exception) {
                        this.mLogger.warn((Object)("Worker Failed! " + String.valueOf(exception)));
                        throw exception;
                    }
                    workerThreadResult = (WorkerThreadResult)this.mWorkerResultQueue.poll();
                    this.mRefinementTime += System.nanoTime() / 1000000000L - l;
                }
                this.mLogger.info((Object)"No more worker results to process");
                assert (workerThreadResult == null);
            }
            catch (ToolchainCanceledException toolchainCanceledException) {
                this.mLogger.warn((Object)("Worker Failed! " + String.valueOf((Object)toolchainCanceledException)));
                throw toolchainCanceledException;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                this.mLogger.warn((Object)("Worker was interrupted! " + String.valueOf(interruptedException)));
            }
            if (n != 0 && !this.mPref.minimizeAbstractionPerWorker()) {
                this.minimizeAbstractionIfEnabled();
            }
            if (n != 0) {
                bl = false;
            }
            boolean bl2 = true;
            while (this.mRunningThreads < this.mThreadLimit && !bl) {
                assert (this.mRunningThreads >= 0);
                this.mCounterexample = this.searchForErrorTrace(!bl2);
                if (this.mCounterexample == null) {
                    bl = true;
                    break;
                }
                if (this.mCounterexample != null) {
                    this.startWorker();
                }
                bl2 = false;
            }
            this.updateAndPrintStatistics(false);
            ++this.mIteration;
        }
        this.mExec.shutdownNow();
        this.mResultBuilder.addResultForAllRemaining(AbstractCegarLoop.Result.USER_LIMIT_ITERATIONS);
    }

    private void updateAndPrintStatistics(boolean bl) {
        if (this.mRunningThreads > this.maxActiveThreads) {
            this.maxActiveThreads = this.mRunningThreads;
        }
        if (this.mRunningThreads == this.mThreadLimit) {
            ++this.mIterationsWithMaxThreads;
        }
        if (this.mRunningThreads == 1) {
            ++this.mIterationsWithOneThread;
        }
        if (bl) {
            this.mLogger.info((Object)("Iteration " + this.getIteration()));
            this.mLogger.info((Object)("Refinements: " + String.valueOf(this.mRefinementsDone)));
            this.mLogger.info((Object)("Counterexamples: " + String.valueOf(this.mCounterexamplesChecked)));
            this.mLogger.info((Object)("SearchTimeout: " + String.valueOf(this.mCountTimeoutsInSearch)));
            this.mLogger.info((Object)("RunConstructionFailed: " + String.valueOf(this.mCountFailedRunConstructions)));
            this.mLogger.info((Object)("SearchFailed: " + String.valueOf(this.mCountFailedToFindCex)));
            this.mLogger.info((Object)("BFS: " + String.valueOf(this.mCountBfsFoundCex)));
            this.mLogger.info((Object)("IsEmptyParallel: " + String.valueOf(this.mCountIsEmptyParallel)));
            this.mLogger.info((Object)("ActiveThreads: " + String.valueOf(this.maxActiveThreads)));
            this.mLogger.info((Object)("ActiveExecutorsForPathPrograms: " + String.valueOf(this.mActiveExecutors)));
            this.mLogger.info((Object)("IterationsWithMaxThreads: " + this.mIterationsWithMaxThreads));
            this.mLogger.info((Object)("IterationsWithONEThread: " + this.mIterationsWithOneThread));
            this.mLogger.info((Object)("SearchTime: " + this.mSearchTime + " s"));
            this.mLogger.info((Object)("WorkerSetUpTime: " + this.mWorkerSetUpTime + " s"));
            this.mLogger.info((Object)"ExceptionInWorker: 0");
            this.mLogger.info((Object)("mRefinementTime: " + this.mRefinementTime));
        }
    }

    private boolean isSafeThenTerminate() throws AutomataOperationCanceledException {
        this.mLogger.info((Object)"Checking if program is safe");
        if (super.isAbstractionEmpty() || ((INestedWordAutomaton)this.mAbstraction).size() == 0) {
            this.mResultBuilder.addResultForAllRemaining(AbstractCegarLoop.Result.SAFE);
            this.shutDownAndDestroy("destroyEverything");
            return true;
        }
        this.mCounterexample = null;
        return false;
    }

    private void startWorker() {
        IUltimateServiceProvider iUltimateServiceProvider;
        this.mWorkerTaskQueue.add(this.mCounterexample);
        long l = System.nanoTime() / 1000000000L;
        this.mLogger.info((Object)"Main: Starting Thread");
        IcfgLocation icfgLocation = this.getErrorLocFromCounterexample();
        this.mServices = iUltimateServiceProvider = this.createIterationTimer(icfgLocation);
        ++this.mRunningThreads;
        this.mCounterexamplesChecked = this.mCounterexamplesChecked + 1;
        this.addCounterexampleToSet((NestedRun)this.mCounterexample);
        this.mWorkerSetUpTime += System.nanoTime() / 1000000000L - l;
    }

    private WorkerThreadResult<L, A> getWorkerResult(boolean bl) throws InterruptedException {
        WorkerThreadResult<L, A> workerThreadResult = null;
        if (this.mRunningThreads >= this.mThreadLimit || bl) {
            assert (this.mRunningThreads > 0);
            this.mLogger.info((Object)"All threads busy, going to sleep.");
            workerThreadResult = this.mWorkerResultQueue.take();
            this.mLogger.info((Object)"Waking up, a worker is done.");
        } else {
            workerThreadResult = (WorkerThreadResult<L, A>)this.mWorkerResultQueue.poll();
        }
        return workerThreadResult;
    }

    private void shutDownAndDestroy(Object object) {
        this.mExec.shutdownNow();
        Set set = this.getServices().getStorage().destroyMarker(object);
        if (!set.isEmpty()) {
            this.mLogger.warn((Object)("Destroyed unattended storables created during the last iteration: " + set.stream().collect(Collectors.joining(","))));
        }
    }

    private void refinement(WorkerThreadResult<L, A> workerThreadResult) throws AutomataOperationCanceledException, AutomataLibraryException {
        this.mCegarLoopBenchmark.announceNextIteration();
        this.removeCounterexampleFromSet(workerThreadResult.getCounterexample());
        Set set = Collections.emptySet();
        PredicateFactoryRefinement predicateFactoryRefinement = new PredicateFactoryRefinement(this.getServices(), workerThreadResult.getWorkerMgdScript(), workerThreadResult.getPredicateFactory(), this.mComputeHoareAnnotation, set);
        this.mLogger.info((Object)"Difference in Main");
        IOpWithDelayedDeadEndRemoval<L, IPredicate> iOpWithDelayedDeadEndRemoval = this.computeAutomataDifference((INestedWordAutomaton)this.mAbstraction, workerThreadResult, predicateFactoryRefinement);
        this.mAbstraction = iOpWithDelayedDeadEndRemoval.getResult();
        if (this.mPref.minimizeAbstractionPerWorker()) {
            this.minimizeAbstractionIfEnabled(predicateFactoryRefinement, new PredicateFactoryResultChecking((SmtFreePredicateFactory)this.mPredicateFactory));
        }
        --this.mRunningThreads;
        this.mLogger.info((Object)"Main: Refinement done.");
    }

    private void addCounterexampleToSet(NestedRun<L, ?> nestedRun) {
        List list = nestedRun.getWord().asList();
        int n = list.hashCode();
        if (this.mActiveCounterexamples.containsKey(n)) {
            throw new AssertionError((Object)"IsEmpty(Parallel) Found the same counterexample twice!");
        }
        this.mActiveCounterexamples.put(n, nestedRun);
    }

    private void removeCounterexampleFromSet(IRun<L, ?> iRun) {
        List list = iRun.getWord().asList();
        int n = list.hashCode();
        this.mLogger.info((Object)("Subtrahend traceHash: " + n));
        if (this.mPref.considerOnlyActiveCounterexamplesInIsEmptyParallel()) {
            this.mActiveCounterexamples.remove(n);
        } else {
            if (this.mCounterexamplesToBeRemovedFromActiveCexMap == null) {
                return;
            }
            this.mCounterexamplesToBeRemovedFromActiveCexMap.add(n);
        }
    }

    public INestedWordAutomaton<L, IPredicate> getAbstraction() {
        return (INestedWordAutomaton)this.mAbstraction;
    }

    private IsEmpty<L, IPredicate> getSearch(IsEmpty.SearchStrategy searchStrategy, Set<IPredicate> set) throws AutomataOperationCanceledException {
        switch (searchStrategy) {
            case PARALLEL: {
                return new IsEmptyParallel(new AutomataLibraryServices(this.mServices), (INwaOutgoingLetterAndTransitionProvider)this.mAbstraction, ((INestedWordAutomaton)this.mAbstraction).getInitialStates(), Collections.emptySet(), set, set == null, IsEmpty.SearchStrategy.BFS, this.mActiveCounterexamples, this.mPref.getSearchLoopBound());
            }
        }
        return new IsEmpty(new AutomataLibraryServices(this.getServices()), (INwaOutgoingLetterAndTransitionProvider)this.mAbstraction, searchStrategy);
    }

    private boolean isSearchCorrectAndTraceFresh(IsEmpty<L, IPredicate> isEmpty) {
        boolean bl;
        boolean bl2;
        block4: {
            bl2 = false;
            bl = true;
            try {
                bl2 = isEmpty.checkResult((IStateFactory)this.mStateFactoryForRefinement);
            }
            catch (AutomataLibraryException automataLibraryException) {
                automataLibraryException.printStackTrace();
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        NestedRun nestedRun = isEmpty.getNestedRun();
        if (nestedRun != null) {
            List list = nestedRun.getWord().asList();
            int n = list.hashCode();
            if (this.mActiveCounterexamples.containsKey(n)) {
                bl = false;
            }
            return bl2 && bl;
        }
        return false;
    }

    private NestedRun<L, IPredicate> searchForErrorTrace(boolean bl) throws AutomataOperationCanceledException {
        IsEmpty<L, IPredicate> isEmpty;
        long l = System.nanoTime() / 1000000000L;
        Set<IPredicate> set = null;
        if (!bl && this.isSearchCorrectAndTraceFresh(isEmpty = this.getSearch(IsEmpty.SearchStrategy.BFS, set))) {
            this.mCountBfsFoundCex = this.mCountBfsFoundCex + 1;
            this.mLogger.info((Object)"Found new Counterexample via BFS!");
            return isEmpty.getNestedRun();
        }
        isEmpty = this.getSearch(IsEmpty.SearchStrategy.PARALLEL, set);
        if (this.isSearchCorrectAndTraceFresh(isEmpty)) {
            this.mLogger.info((Object)"Found new Counterexample via IsEmptyParallel!");
            return isEmpty.getNestedRun();
        }
        this.mLogger.info((Object)"Did not Find a Counterexample!");
        this.mCountFailedToFindCex = this.mCountFailedToFindCex + 1;
        assert (this.mRunningThreads > 0);
        this.mSearchTime += System.nanoTime() / 1000000000L - l;
        return null;
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<L, IPredicate> enhanceInterpolantAutomaton(TAPreferences.InterpolantAutomatonEnhancement interpolantAutomatonEnhancement, IPredicateUnifier iPredicateUnifier, IHoareTripleChecker iHoareTripleChecker, NestedWordAutomaton<L, IPredicate> nestedWordAutomaton) {
        NestedWordAutomaton<L, IPredicate> nestedWordAutomaton2 = nestedWordAutomaton;
        return nestedWordAutomaton2;
    }

    private IOpWithDelayedDeadEndRemoval<L, IPredicate> computeAutomataDifference(INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, WorkerThreadResult<L, A> workerThreadResult, PredicateFactoryRefinement predicateFactoryRefinement) throws AutomataLibraryException, AssertionError {
        this.mLogger.debug((Object)"Start constructing difference");
        PowersetDeterminizer powersetDeterminizer = new PowersetDeterminizer(workerThreadResult.getSubtrahend(), true, (IDeterminizeStateFactory)this.mPredicateFactoryInterpolantAutomata);
        Object object = this.mPref.differenceSenwa() ? new DifferenceSenwa(new AutomataLibraryServices(this.getServices()), (ISenwaStateFactory)predicateFactoryRefinement, iNestedWordAutomaton, workerThreadResult.getSubtrahend(), (IStateDeterminizer)powersetDeterminizer, false) : new Difference(new AutomataLibraryServices(this.getServices()), (ISinkStateFactory)predicateFactoryRefinement, iNestedWordAutomaton, workerThreadResult.getSubtrahend(), (IStateDeterminizer)powersetDeterminizer, workerThreadResult.exploitSigmaStarConcatOfIa());
        this.mCegarLoopBenchmark.reportInterpolantAutomatonStates(workerThreadResult.getSubtrahend().size());
        workerThreadResult.useErrorAutomaton();
        assert (!this.mPref.dumpOnlyReuseAutomata());
        assert (this.mFaultLocalizationMode == TraceAbstractionPreferenceInitializer.RelevanceAnalysisMode.NONE);
        object.removeDeadEnds();
        return object;
    }

    private SolverBuilder.SolverSettings getSolverSettings(IUltimateServiceProvider iUltimateServiceProvider, String string) {
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        SolverBuilder.SolverMode solverMode = (SolverBuilder.SolverMode)iPreferenceProvider.getEnum("SMT solver", SolverBuilder.SolverMode.class);
        boolean bl = iPreferenceProvider.getBoolean("Fake non-incremental script");
        boolean bl2 = iPreferenceProvider.getBoolean("Dump SMT script to file");
        boolean bl3 = iPreferenceProvider.getBoolean("Compress dumped SMT script");
        String string2 = iPreferenceProvider.getString("To the following directory");
        String string3 = iPreferenceProvider.getString("Command for external solver");
        boolean bl4 = iPreferenceProvider.getBoolean("Dump unsat core track benchmark to file");
        boolean bl5 = iPreferenceProvider.getBoolean("Dump main track benchmark to file");
        Map map = iPreferenceProvider.getKeyValueMap("Additional SMT options");
        Logics logics = Logics.valueOf((String)iPreferenceProvider.getString("Logic for external solver"));
        SolverBuilder.SolverSettings solverSettings = SolverBuilder.constructSolverSettings().setUseFakeIncrementalScript(bl).setDumpSmtScriptToFile(bl2, string2, string, bl3).setDumpUnsatCoreTrackBenchmark(bl4).setDumpMainTrackBenchmark(bl5).setUseExternalSolver(true, string3, logics).setSolverMode(solverMode).setAdditionalOptions(map);
        return solverSettings;
    }

    private void minimizeAbstractionIfEnabled(PredicateFactoryRefinement predicateFactoryRefinement, PredicateFactoryResultChecking predicateFactoryResultChecking) throws AutomataOperationCanceledException, AutomataLibraryException, AssertionError {
        TraceAbstractionPreferenceInitializer.Minimization minimization = this.mPref.getMinimization();
        switch (minimization) {
            case NONE: {
                break;
            }
            case MINIMIZE_SEVPA: 
            case SHRINK_NWA: 
            case DFA_HOPCROFT_ARRAYS: 
            case DFA_HOPCROFT_LISTS: 
            case NWA_MAX_SAT: 
            case NWA_MAX_SAT2: 
            case NWA_COMBINATOR_PATTERN: 
            case NWA_COMBINATOR_EVERY_KTH: 
            case RAQ_DIRECT_SIMULATION: 
            case RAQ_DIRECT_SIMULATION_B: 
            case NWA_OVERAPPROXIMATION: 
            case NWA_COMBINATOR_MULTI_DEFAULT: 
            case NWA_COMBINATOR_MULTI_SIMULATION: {
                this.minimizeAbstraction(predicateFactoryRefinement, predicateFactoryResultChecking, minimization);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    protected void minimizeAbstraction(PredicateFactoryRefinement predicateFactoryRefinement, PredicateFactoryResultChecking predicateFactoryResultChecking, TraceAbstractionPreferenceInitializer.Minimization minimization) throws AutomataOperationCanceledException, AutomataLibraryException, AssertionError {
        AutomataMinimization automataMinimization;
        Function<IPredicate, Set> function = iPredicate -> iPredicate instanceof ISLPredicate ? Collections.singleton(((ISLPredicate)iPredicate).getProgramPoint()) : new HashSet<IcfgLocation>(Arrays.asList(((IMLPredicate)iPredicate).getProgramPoints()));
        try {
            automataMinimization = new AutomataMinimization(this.getServices(), (INestedWordAutomaton)this.mAbstraction, minimization, this.mComputeHoareAnnotation, this.getIteration(), predicateFactoryRefinement, 10, this.mStoredRawInterpolantAutomata, this.mInterpolAutomaton, 1000, predicateFactoryResultChecking, function, true);
        }
        catch (AutomataMinimization.AutomataMinimizationTimeout automataMinimizationTimeout) {
            this.mCegarLoopBenchmark.addAutomataMinimizationData(automataMinimizationTimeout.getStatistics());
            throw automataMinimizationTimeout.getAutomataOperationCanceledException();
        }
        this.mCegarLoopBenchmark.addAutomataMinimizationData(automataMinimization.getStatistics());
        boolean bl = automataMinimization.newAutomatonWasBuilt();
        if (bl) {
            Map<IPredicate, IPredicate> map;
            IDoubleDeckerAutomaton iDoubleDeckerAutomaton = automataMinimization.getMinimizedAutomaton();
            if (this.mComputeHoareAnnotation && (map = automataMinimization.getOldState2newStateMapping()) == null) {
                throw new AssertionError((Object)("Hoare annotation and " + String.valueOf((Object)minimization) + " incompatible"));
            }
            int n = ((INestedWordAutomaton)this.mAbstraction).size();
            int n2 = iDoubleDeckerAutomaton.size();
            assert (n == 0 || n >= n2) : "Minimization increased state space";
            this.mAbstraction = iDoubleDeckerAutomaton;
        }
    }

    public PathProgramCache<L> getCurrentProgramCache() {
        return this.mProgramCache;
    }

    public void reportFailedContinuesWorkerThread() {
        IcfgLocation icfgLocation = this.getErrorLocFromCounterexample();
        IUltimateServiceProvider iUltimateServiceProvider = this.createIterationTimer(icfgLocation);
        try {
            this.setUpContinuesWorker(iUltimateServiceProvider, 0);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

