/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.preferences;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.PreferenceException;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.KeyValueUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UnknownFormatConversionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class RcpPreferenceProvider
implements IPreferenceProvider {
    private final String mPluginID;
    private static final Map<String, Set<IEclipsePreferences.IPreferenceChangeListener>> ACTIVE_LISTENER = new HashMap<String, Set<IEclipsePreferences.IPreferenceChangeListener>>();

    public RcpPreferenceProvider(String string) {
        this.mPluginID = string;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public boolean getBoolean(String string, boolean bl) {
        return this.getInstance().getBoolean(string, this.getDefault().getBoolean(string, bl));
    }

    public String getString(String string) {
        return this.getString(string, "");
    }

    public String getString(String string, String string2) {
        return this.getInstance().get(string, this.getDefault().get(string, string2));
    }

    public <T extends Enum<T>> T getEnum(String string, Class<T> clazz) {
        String string2 = this.getString(string);
        if (string2.isEmpty()) {
            throw new UnknownFormatConversionException("An empty string cannot be converted to type " + String.valueOf(clazz));
        }
        return Enum.valueOf(clazz, string2);
    }

    public <T extends Enum<T>> T getEnum(String string, T t, Class<T> clazz) {
        String string2 = this.getString(string);
        if (string2.isEmpty()) {
            return t;
        }
        return Enum.valueOf(clazz, string2);
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, new byte[0]);
    }

    public byte[] getByteArray(String string, byte[] byArray) {
        return this.getInstance().getByteArray(string, this.getDefault().getByteArray(string, byArray));
    }

    public double getDouble(String string) {
        return this.getDouble(string, 0.0);
    }

    public double getDouble(String string, double d) {
        return this.getInstance().getDouble(string, this.getDefault().getDouble(string, d));
    }

    public float getFloat(String string) {
        return this.getFloat(string, 0.0f);
    }

    public float getFloat(String string, float f) {
        return this.getInstance().getFloat(string, this.getDefault().getFloat(string, f));
    }

    public int getInt(String string) {
        return this.getInt(string, 0);
    }

    public int getInt(String string, int n) {
        return this.getInstance().getInt(string, this.getDefault().getInt(string, n));
    }

    public long getLong(String string) {
        return this.getLong(string, 0L);
    }

    public long getLong(String string, long l) {
        return this.getInstance().getLong(string, this.getDefault().getLong(string, l));
    }

    public Map<String, String> getKeyValueMap(String string) {
        return KeyValueUtil.toMap((String)this.getString(string, ""));
    }

    public void put(String string, String string2) {
        this.getInstance().put(string, string2);
        try {
            this.getInstance().flush();
        }
        catch (BackingStoreException backingStoreException) {
            throw new PreferenceException(this.mPluginID, (Throwable)backingStoreException);
        }
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener iPreferenceChangeListener) {
        RcpPreferenceProvider.addPreferenceChangeListener(this.mPluginID, iPreferenceChangeListener);
    }

    private static void addPreferenceChangeListener(String string, IEclipsePreferences.IPreferenceChangeListener iPreferenceChangeListener) {
        InstanceScope.INSTANCE.getNode(string).addPreferenceChangeListener(iPreferenceChangeListener);
        Set<IEclipsePreferences.IPreferenceChangeListener> set = ACTIVE_LISTENER.get(string);
        if (set == null) {
            set = new HashSet<IEclipsePreferences.IPreferenceChangeListener>();
            ACTIVE_LISTENER.put(string, set);
        }
        set.add(iPreferenceChangeListener);
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener iPreferenceChangeListener) {
        this.getInstance().removePreferenceChangeListener(iPreferenceChangeListener);
        if (ACTIVE_LISTENER.containsKey(this.mPluginID)) {
            ACTIVE_LISTENER.get(this.mPluginID).remove(iPreferenceChangeListener);
        }
    }

    public IEclipsePreferences getDefaultEclipsePreferences() {
        return this.getDefault();
    }

    public IEclipsePreferences getEclipsePreferences() {
        return this.getInstance();
    }

    public IScopeContext getScopeContext() {
        return InstanceScope.INSTANCE;
    }

    public void exportPreferences(OutputStream outputStream) throws CoreException {
        Platform.getPreferencesService().exportPreferences(this.getInstance(), outputStream, null);
    }

    public static IStatus importPreferences(InputStream inputStream) throws CoreException {
        IPreferencesService iPreferencesService = Platform.getPreferencesService();
        IStatus iStatus = iPreferencesService.importPreferences(inputStream);
        if (iStatus.isOK()) {
            for (Map.Entry<String, Set<IEclipsePreferences.IPreferenceChangeListener>> entry : ACTIVE_LISTENER.entrySet()) {
                for (IEclipsePreferences.IPreferenceChangeListener iPreferenceChangeListener : entry.getValue()) {
                    InstanceScope.INSTANCE.getNode(entry.getKey()).removePreferenceChangeListener(iPreferenceChangeListener);
                    RcpPreferenceProvider.addPreferenceChangeListener(entry.getKey(), iPreferenceChangeListener);
                }
            }
        }
        return iStatus;
    }

    public static Set<String> validatePreferences(ICore<?> iCore, InputStream inputStream) throws CoreException, BackingStoreException {
        Object object;
        HashSet hashSet = new HashSet();
        IPreferenceNodeVisitor iPreferenceNodeVisitor = iEclipsePreferences -> {
            String[] stringArray = iEclipsePreferences.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                hashSet.add(iEclipsePreferences.name() + "." + string);
                ++n2;
            }
            return true;
        };
        IExportedPreferences iExportedPreferences = iCore.getRegisteredUltimatePluginIDs();
        int n = ((String[])iExportedPreferences).length;
        int n2 = 0;
        while (n2 < n) {
            object = iExportedPreferences[n2];
            new RcpPreferenceProvider((String)object).getDefault().accept(iPreferenceNodeVisitor);
            ++n2;
        }
        object = new LinkedHashSet();
        IPreferenceNodeVisitor iPreferenceNodeVisitor2 = arg_0 -> RcpPreferenceProvider.lambda$1(hashSet, (Set)object, arg_0);
        IPreferencesService iPreferencesService = Platform.getPreferencesService();
        iExportedPreferences = iPreferencesService.readPreferences(inputStream);
        iExportedPreferences.accept(iPreferenceNodeVisitor2);
        return object;
    }

    public String[] getDeltaPreferencesStrings() {
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        try {
            IEclipsePreferences iEclipsePreferences = this.getDefault();
            IEclipsePreferences iEclipsePreferences2 = this.getInstance();
            String[] stringArray = iEclipsePreferences.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String string2 = iEclipsePreferences.get(string, "NO DEFAULT SET");
                String string3 = iEclipsePreferences2.get(string, string2);
                if (!string3.equals(string2)) {
                    arrayList.add((CallSite)((Object)(string + "=" + string3)));
                }
                ++n2;
            }
        }
        catch (BackingStoreException backingStoreException) {
            throw new PreferenceException(this.mPluginID, (Throwable)backingStoreException);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Map<String, Object> getDefaultPreferences() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            IEclipsePreferences iEclipsePreferences = this.getDefault();
            String[] stringArray = iEclipsePreferences.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String string2 = iEclipsePreferences.get(string, null);
                hashMap.put(string, string2);
                ++n2;
            }
        }
        catch (BackingStoreException backingStoreException) {
            throw new PreferenceException(this.mPluginID, (Throwable)backingStoreException);
        }
        return hashMap;
    }

    public Map<String, Object> getPreferences() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            IEclipsePreferences iEclipsePreferences = this.getInstance();
            IEclipsePreferences iEclipsePreferences2 = this.getDefault();
            String[] stringArray = iEclipsePreferences.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String string2 = iEclipsePreferences.get(string, iEclipsePreferences2.get(string, null));
                hashMap.put(string, string2);
                ++n2;
            }
        }
        catch (BackingStoreException backingStoreException) {
            throw new PreferenceException(this.mPluginID, (Throwable)backingStoreException);
        }
        return hashMap;
    }

    public String getSingleLinePreferenceString() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            IEclipsePreferences iEclipsePreferences = this.getInstance();
            IEclipsePreferences iEclipsePreferences2 = this.getDefault();
            String[] stringArray = iEclipsePreferences2.keys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String string2 = iEclipsePreferences.get(string, iEclipsePreferences2.get(string, null));
                stringBuilder.append(string).append('=').append((Object)string2).append(" \u2666 ");
                ++n2;
            }
            stringBuilder.setLength(Math.max(0, stringBuilder.length() - " \u2666 ".length()));
        }
        catch (BackingStoreException backingStoreException) {
            throw new PreferenceException(this.mPluginID, (Throwable)backingStoreException);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.mPluginID + " UltimatePreferenceStore";
    }

    private IEclipsePreferences getInstance() {
        return InstanceScope.INSTANCE.getNode(this.mPluginID);
    }

    private IEclipsePreferences getDefault() {
        return DefaultScope.INSTANCE.getNode(this.mPluginID);
    }

    public void put(String string, Object object) {
        if (object == null) {
            this.put(string, null);
        } else {
            this.put(string, object.toString());
        }
    }

    private static /* synthetic */ boolean lambda$1(Set set, Set set2, IEclipsePreferences iEclipsePreferences) throws BackingStoreException {
        String[] stringArray = iEclipsePreferences.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            String string2 = iEclipsePreferences.name() + "." + string;
            if (!set.contains(string2)) {
                set2.add(string2);
            }
            ++n2;
        }
        return true;
    }
}

