/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.visualization;

import de.uni_freiburg.informatik.ultimate.automata.GeneralAutomatonPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.visualization.CommonExternalFormatWriter;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public interface INwaAtsFormatter<LETTER, STATE> {
    public Map<LETTER, String> getAlphabetMapping(Collection<LETTER> var1, char var2);

    public Map<STATE, String> getStateMapping(Collection<STATE> var1);

    public static class ToString<LETTER, STATE>
    implements INwaAtsFormatter<LETTER, STATE> {
        @Override
        public Map<LETTER, String> getAlphabetMapping(Collection<LETTER> collection, char c) {
            HashMap<LETTER, String> hashMap = new HashMap<LETTER, String>();
            for (LETTER LETTER : collection) {
                hashMap.put(LETTER, GeneralAutomatonPrinter.quoteAndReplaceBackslashes(LETTER));
            }
            return hashMap;
        }

        @Override
        public Map<STATE, String> getStateMapping(Collection<STATE> collection) {
            HashMap<STATE, String> hashMap = new HashMap<STATE, String>();
            for (STATE STATE : collection) {
                hashMap.put(STATE, GeneralAutomatonPrinter.quoteAndReplaceBackslashes(STATE));
            }
            return hashMap;
        }
    }

    public static class ToStringWithHash<LETTER, STATE>
    implements INwaAtsFormatter<LETTER, STATE> {
        private static int sHashDivisor = 1;

        @Override
        public Map<LETTER, String> getAlphabetMapping(Collection<LETTER> collection, char c) {
            HashMap<LETTER, String> hashMap = new HashMap<LETTER, String>();
            for (LETTER LETTER : collection) {
                hashMap.put(LETTER, GeneralAutomatonPrinter.quoteAndReplaceBackslashes(LETTER, Integer.toString(LETTER.hashCode() / sHashDivisor)));
            }
            return hashMap;
        }

        @Override
        public Map<STATE, String> getStateMapping(Collection<STATE> collection) {
            HashMap<STATE, String> hashMap = new HashMap<STATE, String>();
            for (STATE STATE : collection) {
                hashMap.put(STATE, GeneralAutomatonPrinter.quoteAndReplaceBackslashes(STATE, Integer.toString(STATE.hashCode() / sHashDivisor)));
            }
            return hashMap;
        }
    }

    public static class UniqueId<LETTER, STATE>
    implements INwaAtsFormatter<LETTER, STATE> {
        @Override
        public Map<LETTER, String> getAlphabetMapping(Collection<LETTER> collection, char c) {
            return CommonExternalFormatWriter.constructAlphabetMapping(collection, c);
        }

        @Override
        public Map<STATE, String> getStateMapping(Collection<STATE> collection) {
            int n = 0;
            LinkedHashMap<STATE, CallSite> linkedHashMap = new LinkedHashMap<STATE, CallSite>();
            for (STATE STATE : collection) {
                linkedHashMap.put(STATE, (CallSite)((Object)("s" + Integer.toString(n))));
                ++n;
            }
            return linkedHashMap;
        }
    }
}

