/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.model.services;

import de.uni_freiburg.informatik.ultimate.core.model.models.ProcedureContract;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslatedCFG;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.core.model.translation.ITranslator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public interface IBacktranslationService {
    public <STE, TTE, SE, TE, SVL, TVL, LOC> void addTranslator(ITranslator<STE, TTE, SE, TE, SVL, TVL, LOC> var1);

    public <SE, TE> TE translateExpression(SE var1, Class<SE> var2);

    public <SE, TE, CTX> TE translateExpressionWithContext(SE var1, CTX var2, Class<SE> var3);

    @Deprecated
    default public <SE> String translateExpressionToString(SE SE, Class<SE> clazz) {
        return this.targetExpressionToString(this.translateExpression(SE, clazz));
    }

    @Deprecated
    default public <SE, CTX> String translateExpressionWithContextToString(SE SE, CTX CTX, Class<SE> clazz) {
        return this.targetExpressionToString(this.translateExpressionWithContext(SE, CTX, clazz));
    }

    public <STE> List<?> translateTrace(List<STE> var1, Class<STE> var2);

    public <STE> List<String> translateTraceToHumanReadableString(List<STE> var1, Class<STE> var2);

    public <STE, SE> IProgramExecution<?, ?> translateProgramExecution(IProgramExecution<STE, SE> var1);

    public <STE, SE> Lasso<IProgramExecution<?, ?>> translateLassoProgramExecution(Lasso<IProgramExecution<STE, SE>> var1);

    public <SE> IProgramExecution.ProgramState<?> translateProgramState(IProgramExecution.ProgramState<SE> var1);

    public <SE> String translateProgramStateToString(IProgramExecution.ProgramState<SE> var1);

    public <STE, SE> IBacktranslatedCFG<?, ?> translateCFG(IBacktranslatedCFG<?, STE> var1);

    public <TE, SE, CTX> ProcedureContract<TE, ? extends TE> translateProcedureContract(ProcedureContract<SE, ? extends SE> var1, CTX var2, Class<SE> var3);

    default public <TE> String targetExpressionToString(TE TE) {
        return TE == null ? null : TE.toString();
    }

    default public <TE> ProcedureContract<String, String> targetProcedureContractToString(ProcedureContract<TE, ? extends TE> procedureContract) {
        String string;
        String string2 = procedureContract.getRequires() == null ? null : this.targetExpressionToString(procedureContract.getRequires());
        String string3 = string = procedureContract.getEnsures() == null ? null : this.targetExpressionToString(procedureContract.getEnsures());
        if (procedureContract.hasModifies()) {
            Set set = procedureContract.getModifies().stream().map(this::targetExpressionToString).collect(Collectors.toSet());
            return new ProcedureContract<String, String>(procedureContract.getProcedure(), string2, string, set);
        }
        return new ProcedureContract<String, String>(procedureContract.getProcedure(), string2, string);
    }

    public IBacktranslationService getTranslationServiceCopy();

    public record Lasso<X extends IProgramExecution<?, ?>>(X stem, X loop) {
    }
}

