/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PureSubstitution
extends TermTransformer {
    private final Script mScript;
    protected final ManagedScript mMgdScript;
    private final ScopedHashMap<Term, Term> mScopedSubstitutionMapping;

    private PureSubstitution(Script script, Map<? extends Term, ? extends Term> map) {
        this.mMgdScript = null;
        this.mScript = script;
        this.mScopedSubstitutionMapping = new ScopedHashMap();
        this.mScopedSubstitutionMapping.putAll(map);
    }

    protected PureSubstitution(ManagedScript managedScript, Map<? extends Term, ? extends Term> map) {
        this.mMgdScript = managedScript;
        this.mScript = managedScript.getScript();
        this.mScopedSubstitutionMapping = new ScopedHashMap();
        this.mScopedSubstitutionMapping.putAll(map);
    }

    public static Term apply(Script script, Map<? extends Term, ? extends Term> map, Term term) {
        return new PureSubstitution(script, map).transform(term);
    }

    public static Term apply(ManagedScript managedScript, Map<? extends Term, ? extends Term> map, Term term) {
        return new PureSubstitution(managedScript, map).transform(term);
    }

    protected void convert(Term term) {
        Term term2 = (Term)this.mScopedSubstitutionMapping.get((Object)term);
        if (term2 != null) {
            this.setResult(term2);
        } else {
            if (term instanceof QuantifiedFormula) {
                this.mScopedSubstitutionMapping.beginScope();
                QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
                this.removeQuantifiedVarContainingKeys(quantifiedFormula);
                term = this.renameQuantifiedVarsThatOccurInValues(quantifiedFormula);
            } else if (term instanceof LetTerm) {
                throw new UnsupportedOperationException("LetTerm not supported");
            }
            super.convert(term);
        }
    }

    private Term renameQuantifiedVarsThatOccurInValues(QuantifiedFormula quantifiedFormula) {
        Set<TermVariable> set = PureSubstitution.varsOccuringInValues(quantifiedFormula.getVariables(), this.mScopedSubstitutionMapping);
        if (set.isEmpty()) {
            return quantifiedFormula;
        }
        if (this.mMgdScript == null) {
            throw new UnsupportedOperationException("Substitution in quantified formula such that substitute containes quantified variable. This (rare) case is only supported if you call substitution with fresh variable construction.");
        }
        return this.renameQuantifiedVariables(this.mMgdScript, quantifiedFormula, set, "subst");
    }

    private void removeQuantifiedVarContainingKeys(QuantifiedFormula quantifiedFormula) {
        Iterator iterator = this.mScopedSubstitutionMapping.entrySet().iterator();
        while (iterator.hasNext()) {
            List<TermVariable> list;
            Map.Entry entry = (Map.Entry)iterator.next();
            List<TermVariable> list2 = Arrays.asList(quantifiedFormula.getVariables());
            if (Collections.disjoint(list2, list = Arrays.asList(((Term)entry.getKey()).getFreeVars()))) continue;
            iterator.remove();
        }
    }

    private static Set<TermVariable> varsOccuringInValues(TermVariable[] termVariableArray, Map<?, Term> map) {
        Set<TermVariable> set = null;
        for (Term term : map.values()) {
            TermVariable[] termVariableArray2 = term.getFreeVars();
            int n = termVariableArray2.length;
            int n2 = 0;
            while (n2 < n) {
                TermVariable termVariable = termVariableArray2[n2];
                if (Arrays.asList(termVariableArray).contains(termVariable)) {
                    set = PureSubstitution.addToSet(termVariable, set);
                }
                ++n2;
            }
        }
        if (set == null) {
            set = Collections.emptySet();
        }
        return set;
    }

    private static Set<TermVariable> addToSet(TermVariable termVariable, Set<TermVariable> set) {
        if (set == null) {
            set = new HashSet<TermVariable>();
        }
        set.add(termVariable);
        return set;
    }

    public void postConvertQuantifier(QuantifiedFormula quantifiedFormula, Term term) {
        QuantifiedFormula quantifiedFormula2;
        TermVariable[] termVariableArray = new TermVariable[quantifiedFormula.getVariables().length];
        boolean bl = false;
        int n = 0;
        while (n < quantifiedFormula.getVariables().length) {
            if (this.mScopedSubstitutionMapping.containsKey((Object)quantifiedFormula.getVariables()[n])) {
                termVariableArray[n] = quantifiedFormula.getVariables()[n];
                bl = true;
            } else {
                termVariableArray[n] = quantifiedFormula.getVariables()[n];
            }
            ++n;
        }
        if (quantifiedFormula.getSubformula() == term) {
            assert (!bl);
            quantifiedFormula2 = quantifiedFormula;
        } else {
            if (!bl) {
                termVariableArray = quantifiedFormula.getVariables();
            }
            quantifiedFormula2 = this.mScript.quantifier(quantifiedFormula.getQuantifier(), termVariableArray, term, (Term[][])new Term[0][]);
        }
        this.mScopedSubstitutionMapping.endScope();
        this.setResult((Term)quantifiedFormula2);
    }

    public String toString() {
        return "Substitution " + this.mScopedSubstitutionMapping.toString();
    }

    private Term renameQuantifiedVariables(ManagedScript managedScript, QuantifiedFormula quantifiedFormula, Set<TermVariable> set, String string) {
        TermVariable termVariable2;
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (TermVariable termVariable2 : set) {
            TermVariable termVariable3 = managedScript.constructFreshTermVariable(string, termVariable2.getSort());
            hashMap.put((Term)termVariable2, (Term)termVariable3);
        }
        termVariable2 = this.applySubsititution(hashMap, quantifiedFormula.getSubformula());
        TermVariable[] termVariableArray = new TermVariable[quantifiedFormula.getVariables().length];
        int n = 0;
        while (n < termVariableArray.length) {
            TermVariable termVariable4 = (TermVariable)hashMap.get(quantifiedFormula.getVariables()[n]);
            termVariableArray[n] = termVariable4 != null ? termVariable4 : quantifiedFormula.getVariables()[n];
            ++n;
        }
        return managedScript.getScript().quantifier(quantifiedFormula.getQuantifier(), termVariableArray, (Term)termVariable2, (Term[][])new Term[0][]);
    }

    protected Term applySubsititution(Map<Term, Term> map, Term term) {
        if (this.mMgdScript == null) {
            return PureSubstitution.apply(this.mScript, map, term);
        }
        return PureSubstitution.apply(this.mMgdScript, map, term);
    }
}

