/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.Interpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAtomInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.LAInterpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.SymbolChecker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.SymbolCollector;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InterpolantChecker {
    Interpolator mInterpolator;
    Script mCheckingSolver;
    Set<FunctionSymbol> mGlobals;

    public InterpolantChecker(Interpolator interpolator, Script script) {
        this.mInterpolator = interpolator;
        this.mCheckingSolver = script;
    }

    private Term fixupAndLet(Term term, final HashMap<TermVariable, Term> hashMap, final HashMap<TermVariable, Term> hashMap2) {
        TermTransformer termTransformer = new TermTransformer(){

            public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
                TermVariable termVariable;
                Term term;
                FunctionSymbol functionSymbol = applicationTerm.getFunction();
                if (hashMap != null && functionSymbol.isIntern() && functionSymbol.getName().equals("@EQ") && (term = (Term)hashMap.get(termVariable = (TermVariable)applicationTerm.getParameters()[0])) != null) {
                    Term term2 = termArray[1];
                    this.setResult(InterpolantChecker.this.mInterpolator.substitute(term, termVariable, term2));
                    return;
                }
                super.convertApplicationTerm(applicationTerm, termArray);
            }

            public void convert(Term term) {
                Term term2;
                if (LAInterpolator.isLATerm(term)) {
                    term = ((AnnotatedTerm)term).getSubterm();
                }
                if (hashMap2 != null && term instanceof TermVariable && (term2 = (Term)hashMap2.get(term)) != null) {
                    this.setResult(term2);
                    return;
                }
                super.convert(term);
            }
        };
        return termTransformer.transform(term);
    }

    private Term fixVars(Term term, HashMap<TermVariable, Term> hashMap) {
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            Interpolator interpolator = this.mInterpolator;
            ((Object)((Object)interpolator)).getClass();
            Interpolator.TermSubstitutor termSubstitutor = new Interpolator.TermSubstitutor(interpolator, (Term)termVariable, hashMap.get(termVariable));
            term = termSubstitutor.transform(term);
            ++n2;
        }
        return term;
    }

    private Term purifyAndFix(Term term, HashMap<TermVariable, Term> hashMap, HashMap<TermVariable, Term> hashMap2) {
        for (Map.Entry<TermVariable, Term> entry : hashMap2.entrySet()) {
            Term term2 = hashMap.get(entry.getKey());
            assert (term2 != null);
            Interpolator interpolator = this.mInterpolator;
            ((Object)((Object)interpolator)).getClass();
            Interpolator.TermSubstitutor termSubstitutor = new Interpolator.TermSubstitutor(interpolator, term2, entry.getValue());
            term = termSubstitutor.transform(term);
        }
        return term;
    }

    public void checkInductivity(Term[] termArray, Term[] termArray2) {
        Object object;
        InterpolatorAtomInfo interpolatorAtomInfo;
        Interpolator.LitInfo litInfo;
        Object object2;
        Term applicationTerm;
        Object term14;
        LogProxy logProxy = this.mInterpolator.getLogger();
        Theory theory = this.mInterpolator.mTheory;
        int n = logProxy.getLoglevel();
        logProxy.setLoglevel(2);
        this.mCheckingSolver.push(1);
        HashMap[] hashMapArray = new HashMap[termArray2.length];
        HashMap<TermVariable, Term> hashMap = this.mInterpolator.mPurifyDefinitions;
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        HashMap<TermVariable, Term> hashMap2 = new HashMap<TermVariable, Term>();
        for (Map.Entry<TermVariable, Term> entry : hashMap.entrySet()) {
            TermVariable termVariable = entry.getKey();
            if (hashMap2.containsKey(termVariable)) continue;
            term14 = ".check" + termVariable.getName();
            this.mCheckingSolver.declareFun((String)term14, new Sort[0], termVariable.getSort());
            applicationTerm = this.mCheckingSolver.term((String)term14, new Term[0]);
            hashMap2.put(termVariable, applicationTerm);
        }
        assert (hashMap.size() == hashMap2.size());
        int n2 = 0;
        while (n2 < termArray2.length) {
            hashSet.addAll(Arrays.asList(termArray2[n2].getFreeVars()));
            ++n2;
        }
        term14 = termArray;
        int n3 = termArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Term term2 = term14[n4];
            applicationTerm = this.mInterpolator.getAtom(term2);
            object2 = this.mInterpolator.getAtomTermInfo(applicationTerm);
            litInfo = this.mInterpolator.getAtomOccurenceInfo(applicationTerm);
            TermVariable termVariable = litInfo.mMixedVar;
            if (termVariable != null) {
                interpolatorAtomInfo = null;
                int litInfo2 = 0;
                while (litInfo2 < termArray2.length) {
                    if (litInfo.isMixed(litInfo2)) {
                        if (((InterpolatorAtomInfo)object2).isCCEquality()) {
                            if (interpolatorAtomInfo == null) {
                                n9 = ".check." + termVariable.getName();
                                this.mCheckingSolver.declareFun(n9, new Sort[0], termVariable.getSort());
                                interpolatorAtomInfo = this.mCheckingSolver.term(n9, new Term[0]);
                            }
                            object = interpolatorAtomInfo;
                        } else {
                            n9 = ".check" + litInfo2 + "." + termVariable.getName();
                            this.mCheckingSolver.declareFun(n9, new Sort[0], termVariable.getSort());
                            object = this.mCheckingSolver.term(n9, new Term[0]);
                        }
                        if (hashMapArray[litInfo2] == null) {
                            hashMapArray[litInfo2] = new HashMap();
                        }
                        hashMapArray[litInfo2].put(termVariable, object);
                    }
                    ++litInfo2;
                }
            }
            ++n4;
        }
        int n6 = 0;
        while (n6 < termArray2.length + 1) {
            int term15;
            HashMap[] hashMapArray2 = new HashMap[termArray2.length];
            this.mCheckingSolver.push(1);
            for (Map.Entry entry : this.mInterpolator.mPartitions.entrySet()) {
                if ((Integer)entry.getValue() != n6) continue;
                this.mCheckingSolver.assertTerm(theory.term((String)entry.getKey(), new Term[0]));
            }
            object2 = termArray;
            int n5 = termArray.length;
            int n7 = 0;
            while (n7 < n5) {
                Term term3 = object2[n7];
                litInfo = this.mInterpolator.getAtom(term3);
                boolean bl = litInfo == term3;
                interpolatorAtomInfo = this.mInterpolator.getAtomTermInfo((Term)litInfo);
                Interpolator.LitInfo litInfo2 = this.mInterpolator.mAtomOccurenceInfos.get(litInfo);
                if (litInfo2.contains(n6)) {
                    object = this.purifyAndFix(term3, hashMap, hashMap2);
                    this.mCheckingSolver.assertTerm(theory.not((Term)object));
                } else if (!litInfo2.isBLocal(n6) && !litInfo2.isALocalInSomeChild(n6)) {
                    if (interpolatorAtomInfo.isCCEquality()) {
                        object = interpolatorAtomInfo.getEquality();
                        int n17 = -1;
                        int term6 = -1;
                        int term4 = n6 - 1;
                        while (term4 >= this.mInterpolator.mStartOfSubtrees[n6]) {
                            if (litInfo2.isMixed(term4)) {
                                if (n17 < 0) {
                                    n17 = term4;
                                } else {
                                    assert (term6 < 0);
                                    term6 = term4;
                                }
                            }
                            term4 = this.mInterpolator.mStartOfSubtrees[term4] - 1;
                        }
                        if (n17 < 0) {
                            assert (litInfo2.isMixed(n6));
                            String term5 = bl ? "@EQ" : "=";
                            int term13 = litInfo2.getLhsOccur().isALocal(n6) ? 0 : 1;
                            var25_65 = (Term)hashMapArray[n6].get(litInfo2.mMixedVar);
                            this.mCheckingSolver.assertTerm(theory.term(term5, new Term[]{var25_65, object.getParameters()[term13]}));
                        } else if (!litInfo2.isMixed(n6)) {
                            Term term7 = (Term)hashMapArray[n17].get(litInfo2.mMixedVar);
                            if (term6 < 0) {
                                int n8;
                                int n9 = n8 = litInfo2.getLhsOccur().isALocal(n17) ? 1 : 0;
                                if (bl) {
                                    this.mCheckingSolver.assertTerm(theory.not(theory.term("@EQ", new Term[]{term7, object.getParameters()[n8]})));
                                } else {
                                    this.mCheckingSolver.assertTerm(theory.term("=", new Term[]{term7, object.getParameters()[n8]}));
                                }
                            } else {
                                if (hashMapArray2[term6] == null) {
                                    hashMapArray2[term6] = new HashMap();
                                }
                                hashMapArray2[term6].put(litInfo2.mMixedVar, theory.not(theory.term("@EQ", new Term[]{term7, litInfo2.mMixedVar})));
                            }
                        } else assert (n17 >= 0 && term6 < 0 && litInfo2.isMixed(n6));
                    } else if (interpolatorAtomInfo.isLAEquality() && bl) {
                        object = new InterpolatorAffineTerm();
                        int interpolatorAffineTerm = -1;
                        int term8 = n6 - 1;
                        while (term8 >= this.mInterpolator.mStartOfSubtrees[n6]) {
                            if (litInfo2.isMixed(term8)) {
                                ((InterpolatorAffineTerm)object).add(Rational.MONE, litInfo2.getAPart(term8));
                                if (interpolatorAffineTerm < 0) {
                                    interpolatorAffineTerm = term8;
                                } else {
                                    Term term9 = (Term)hashMapArray[term8].get(litInfo2.mMixedVar);
                                    ((InterpolatorAffineTerm)object).add(Rational.ONE, term9);
                                    if (hashMapArray2[term8] == null) {
                                        hashMapArray2[term8] = new HashMap();
                                    }
                                    hashMapArray2[term8].put(litInfo2.mMixedVar, theory.term("=", new Term[]{term9, litInfo2.mMixedVar}));
                                }
                            }
                            term8 = this.mInterpolator.mStartOfSubtrees[term8] - 1;
                        }
                        if (litInfo2.isMixed(n6)) {
                            assert (litInfo2.isMixed(n6));
                            ((InterpolatorAffineTerm)object).add(Rational.ONE, litInfo2.getAPart(n6));
                            if (interpolatorAffineTerm < 0) {
                                Term term10 = (Term)hashMapArray[n6].get(litInfo2.mMixedVar);
                                Term term11 = ((InterpolatorAffineTerm)object).toSMTLib(theory, interpolatorAtomInfo.isInt());
                                this.mCheckingSolver.assertTerm(theory.term("@EQ", new Term[]{term10, term11}));
                            } else {
                                Term sort = (Term)hashMapArray[interpolatorAffineTerm].get(litInfo2.mMixedVar);
                                ((InterpolatorAffineTerm)object).negate();
                                ((InterpolatorAffineTerm)object).add(Rational.ONE, (Term)litInfo2.mMixedVar);
                                if (hashMapArray2[n6] == null) {
                                    hashMapArray2[n6] = new HashMap();
                                }
                                Term term12 = theory.term("@EQ", new Term[]{sort, ((InterpolatorAffineTerm)object).toSMTLib(theory, interpolatorAtomInfo.isInt())});
                                hashMapArray2[n6].put(litInfo2.mMixedVar, term12);
                            }
                        } else {
                            assert (interpolatorAffineTerm >= 0);
                            Term term = (Term)hashMapArray[interpolatorAffineTerm].get(litInfo2.mMixedVar);
                            ((InterpolatorAffineTerm)object).add(Rational.ONE, interpolatorAtomInfo.getAffineTerm());
                            ((InterpolatorAffineTerm)object).negate();
                            Term term2 = ((InterpolatorAffineTerm)object).toSMTLib(theory, interpolatorAtomInfo.isInt());
                            this.mCheckingSolver.assertTerm(theory.not(theory.term("@EQ", new Term[]{term, term2})));
                        }
                    } else {
                        object = new InterpolatorAffineTerm();
                        int bl2 = n6 - 1;
                        while (bl2 >= this.mInterpolator.mStartOfSubtrees[n6]) {
                            if (litInfo2.isMixed(bl2)) {
                                ((InterpolatorAffineTerm)object).add(Rational.MONE, litInfo2.getAPart(bl2));
                                ((InterpolatorAffineTerm)object).add(Rational.ONE, (Term)hashMapArray[bl2].get(litInfo2.mMixedVar));
                            }
                            bl2 = this.mInterpolator.mStartOfSubtrees[bl2] - 1;
                        }
                        if (litInfo2.isMixed(n6)) {
                            assert (litInfo2.mMixedVar != null);
                            ((InterpolatorAffineTerm)object).add(Rational.ONE, litInfo2.getAPart(n6));
                            ((InterpolatorAffineTerm)object).add(Rational.MONE, (Term)hashMapArray[n6].get(litInfo2.mMixedVar));
                        } else {
                            InterpolatorAffineTerm interpolatorAffineTerm = new InterpolatorAffineTerm(interpolatorAtomInfo.getAffineTerm());
                            if (bl) {
                                interpolatorAffineTerm.add(interpolatorAtomInfo.getEpsilon().negate());
                            }
                            ((InterpolatorAffineTerm)object).add(Rational.ONE, interpolatorAffineTerm);
                        }
                        if (interpolatorAtomInfo.isBoundConstraint()) {
                            if (bl) {
                                ((InterpolatorAffineTerm)object).negate();
                            }
                            this.mCheckingSolver.assertTerm(((InterpolatorAffineTerm)object).toLeq0(theory));
                        } else {
                            boolean bl3 = ((InterpolatorAffineTerm)object).isInt();
                            Sort sort = theory.getSort(bl3 ? "Int" : "Real", new Sort[0]);
                            Term term = ((InterpolatorAffineTerm)object).toSMTLib(theory, bl3);
                            Term term4 = Rational.ZERO.toTerm(sort);
                            var25_65 = theory.term("=", new Term[]{term, term4});
                            if (!litInfo2.isMixed(n6) && bl) {
                                var25_65 = theory.term("not", new Term[]{var25_65});
                            }
                            this.mCheckingSolver.assertTerm(var25_65);
                        }
                    }
                }
                ++n7;
            }
            int n18 = n6 - 1;
            while (term15 >= this.mInterpolator.mStartOfSubtrees[n6]) {
                Term term = this.fixupAndLet(termArray2[term15], hashMapArray2[term15], hashMapArray[term15]);
                term = this.fixVars(term, hashMap2);
                this.mCheckingSolver.assertTerm(term);
                term15 = this.mInterpolator.mStartOfSubtrees[term15] - 1;
            }
            if (n6 < termArray2.length) {
                Term term = this.fixupAndLet(termArray2[n6], hashMapArray2[n6], hashMapArray[n6]);
                term = this.fixVars(term, hashMap2);
                this.mCheckingSolver.assertTerm(theory.not(term));
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                ApplicationTerm applicationTerm2 = (ApplicationTerm)entry.getValue();
                object2 = this.mInterpolator.mFunctionSymbolOccurrenceInfos.get(applicationTerm2.getFunction());
                if (!((Interpolator.Occurrence)object2).contains(n6)) {
                    hashSet.contains(entry.getKey());
                }
                litInfo = this.fixVars((Term)applicationTerm2, hashMap2);
                this.mCheckingSolver.assertTerm(theory.term("=", new Term[]{litInfo, hashMap2.get(entry.getKey())}));
            }
            if (this.mCheckingSolver.checkSat() == Script.LBool.SAT) {
                throw new AssertionError();
            }
            this.mCheckingSolver.pop(1);
            ++n6;
        }
        this.mCheckingSolver.pop(1);
        logProxy.setLoglevel(n);
    }

    public void assertUnpartitionedFormulas(Collection<Term> collection, Set<String> set) {
        LogProxy logProxy = this.mInterpolator.getLogger();
        int n = logProxy.getLoglevel();
        try {
            logProxy.setLoglevel(2);
            SymbolCollector symbolCollector = new SymbolCollector();
            block3: for (Term term : collection) {
                if (term instanceof AnnotatedTerm) {
                    AnnotatedTerm annotatedTerm = (AnnotatedTerm)term;
                    Annotation[] annotationArray = annotatedTerm.getAnnotations();
                    int n2 = annotationArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        Annotation annotation = annotationArray[n3];
                        if (":named".equals(annotation.getKey()) && set.contains(annotation.getValue())) continue block3;
                        ++n3;
                    }
                }
                this.mCheckingSolver.assertTerm(term);
                symbolCollector.collect(term);
            }
            this.mGlobals = symbolCollector.getSymbols();
        }
        finally {
            logProxy.setLoglevel(n);
        }
    }

    public boolean checkFinalInterpolants(Map<String, Integer> map, Term[] termArray) {
        Integer n;
        boolean bl = false;
        int n2 = termArray.length + 1;
        SymbolCollector symbolCollector = new SymbolCollector();
        Set[] setArray = new Set[n2];
        int n3 = 0;
        while (n3 < n2) {
            for (Map.Entry<String, Integer> entry : this.mInterpolator.mPartitions.entrySet()) {
                if (entry.getValue() != n3) continue;
                symbolCollector.collect(this.mCheckingSolver.term(entry.getKey(), new Term[0]));
            }
            setArray[n3] = symbolCollector.getSymbols();
            ++n3;
        }
        Map[] mapArray = new Map[n2];
        int n4 = 0;
        while (n4 < n2) {
            mapArray[n4] = new HashMap();
            for (FunctionSymbol functionSymbol : setArray[n4]) {
                mapArray[n4].put(functionSymbol, 1);
            }
            int n5 = n4 - 1;
            while (n5 >= this.mInterpolator.mStartOfSubtrees[n4]) {
                for (Map.Entry entry : mapArray[n5].entrySet()) {
                    n = (Integer)mapArray[n4].get(entry.getKey());
                    if (n == null) {
                        n = 0;
                    }
                    mapArray[n4].put((FunctionSymbol)entry.getKey(), n + (Integer)entry.getValue());
                }
                n5 = this.mInterpolator.mStartOfSubtrees[n5] - 1;
            }
            ++n4;
        }
        LogProxy logProxy = this.mInterpolator.getLogger();
        int n6 = logProxy.getLoglevel();
        try {
            Map.Entry entry;
            logProxy.setLoglevel(2);
            entry = new SymbolChecker(this.mGlobals, mapArray[termArray.length]);
            int n7 = 0;
            while (n7 < n2) {
                this.mCheckingSolver.push(1);
                int n8 = n7 - 1;
                while (n8 >= this.mInterpolator.mStartOfSubtrees[n7]) {
                    this.mCheckingSolver.assertTerm(termArray[n8]);
                    n8 = this.mInterpolator.mStartOfSubtrees[n8] - 1;
                }
                for (Map.Entry<String, Integer> entry2 : this.mInterpolator.mPartitions.entrySet()) {
                    if (entry2.getValue() != n7) continue;
                    this.mCheckingSolver.assertTerm(this.mCheckingSolver.term(entry2.getKey(), new Term[0]));
                }
                if (n7 != termArray.length) {
                    if (((SymbolChecker)((Object)entry)).check(termArray[n7], mapArray[n7])) {
                        logProxy.error("Symbol error in Interpolant %d: A-local: %s, B-local: %s.", n7, ((SymbolChecker)((Object)entry)).getALocals(), ((SymbolChecker)((Object)entry)).getBLocals());
                        bl = true;
                    }
                    this.mCheckingSolver.assertTerm(this.mCheckingSolver.term("not", new Term[]{termArray[n7]}));
                }
                if ((n = this.mCheckingSolver.checkSat()) == Script.LBool.SAT) {
                    logProxy.error("Interpolant %d not inductive", n7);
                    bl = true;
                } else if (n == Script.LBool.UNKNOWN) {
                    logProxy.warn("Unable to check validity of interpolant: %s", this.mCheckingSolver.getInfo(":reason-unknown"));
                }
                this.mCheckingSolver.pop(1);
                ++n7;
            }
        }
        finally {
            logProxy.setLoglevel(n6);
        }
        return !bl;
    }
}

