/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcPredicateSymbol;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph.HCPredicate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class HCPredicateFactory
extends BasicPredicateFactory {
    private final ManagedScript mMgdScript;
    private final HCPredicate mDontCareLocationPredicate;
    private final HCPredicate mTrueLocationPredicate;
    private final HCPredicate mFalseLocationPredicate;
    private final HcSymbolTable mHCSymbolTable;
    private final Map<HcPredicateSymbol, HCPredicate> mLocToTruePred;

    public HCPredicateFactory(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, HcSymbolTable hcSymbolTable, SmtUtils.SimplificationTechnique simplificationTechnique) {
        super(iUltimateServiceProvider, managedScript, (IIcfgSymbolTable)hcSymbolTable);
        this.mMgdScript = managedScript;
        this.mHCSymbolTable = hcSymbolTable;
        this.mLocToTruePred = new HashMap<HcPredicateSymbol, HCPredicate>();
        this.mDontCareLocationPredicate = this.newPredicate(hcSymbolTable.getDontCareHornClausePredicateSymbol(), super.getDontCareTerm(), Collections.emptyList(), Collections.emptyList());
        this.mFalseLocationPredicate = this.getTruePredicateWithLocation(hcSymbolTable.getFalseHornClausePredicateSymbol());
        this.mTrueLocationPredicate = this.getTruePredicateWithLocation(hcSymbolTable.getTrueHornClausePredicateSymbol());
    }

    public HCPredicate getTruePredicateWithLocation(HcPredicateSymbol hcPredicateSymbol) {
        HCPredicate hCPredicate = this.mLocToTruePred.get(hcPredicateSymbol);
        if (hCPredicate == null) {
            this.mMgdScript.lock((Object)this);
            hCPredicate = this.newPredicate(hcPredicateSymbol, this.mMgdScript.term((Object)this, "true", new Term[0]), Collections.emptyList(), Collections.emptyList());
            this.mMgdScript.unlock((Object)this);
            this.mLocToTruePred.put(hcPredicateSymbol, hCPredicate);
        }
        return hCPredicate;
    }

    public HCPredicate getTrueLocationPredicate() {
        return this.mTrueLocationPredicate;
    }

    public HCPredicate getFalseLocationPredicate() {
        return this.mFalseLocationPredicate;
    }

    public HCPredicate getDontCareLocationPredicate() {
        return this.mDontCareLocationPredicate;
    }

    public HCPredicate newPredicate(HcPredicateSymbol hcPredicateSymbol, Term term, List<TermVariable> list, List<FunctionSymbol> list2) {
        return this.newPredicate(Collections.singleton(hcPredicateSymbol), term, list, list2);
    }

    public HCPredicate newPredicate(Set<HcPredicateSymbol> set, Term term, List<TermVariable> list, List<FunctionSymbol> list2) {
        ComputeHcOutVarsAndNormalizeTerm computeHcOutVarsAndNormalizeTerm = new ComputeHcOutVarsAndNormalizeTerm(term, list, list2);
        int n = this.constructFreshSerialNumber();
        return new HCPredicate(set, n, computeHcOutVarsAndNormalizeTerm.getNormalizedTerm(), computeHcOutVarsAndNormalizeTerm.getProgramVars(), computeHcOutVarsAndNormalizeTerm.getProgramFuns(), this.computeClosedFormula(computeHcOutVarsAndNormalizeTerm.getNormalizedTerm()), list);
    }

    private Term computeClosedFormula(Term term) {
        if (this.isDontCare(term)) {
            return term;
        }
        HashMap<TermVariable, ApplicationTerm> hashMap = new HashMap<TermVariable, ApplicationTerm>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            ApplicationTerm applicationTerm = this.mSymbolTable.getProgramVar(termVariable).getDefaultConstant();
            hashMap.put(termVariable, applicationTerm);
            ++n2;
        }
        return PureSubstitution.apply((ManagedScript)this.mMgdScript, hashMap, (Term)term);
    }

    static /* synthetic */ HcSymbolTable access$0(HCPredicateFactory hCPredicateFactory) {
        return hCPredicateFactory.mHCSymbolTable;
    }

    class ComputeHcOutVarsAndNormalizeTerm {
        private final Term mNormalizedTerm;
        private final Set<IProgramVar> mProgramVars;
        private final Set<IProgramFunction> mProgramFuns;

        public ComputeHcOutVarsAndNormalizeTerm(Term term, List<TermVariable> list, List<FunctionSymbol> list2) {
            if (HCPredicateFactory.this.isDontCare(term)) {
                this.mNormalizedTerm = term;
                this.mProgramVars = Collections.emptySet();
                this.mProgramFuns = Collections.emptySet();
            } else {
                this.mNormalizedTerm = term;
                this.mProgramVars = list.stream().map(termVariable -> HCPredicateFactory.this.mHCSymbolTable.getProgramVar(termVariable)).collect(Collectors.toSet());
                this.mProgramFuns = list2.stream().map(functionSymbol -> HCPredicateFactory.this.mHCSymbolTable.getProgramFun(functionSymbol)).collect(Collectors.toSet());
            }
        }

        public Term getNormalizedTerm() {
            return this.mNormalizedTerm;
        }

        public Set<IProgramVar> getProgramVars() {
            return this.mProgramVars;
        }

        public Set<IProgramFunction> getProgramFuns() {
            return this.mProgramFuns;
        }
    }
}

