/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.IInterpolantGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TracePredicates {
    private final IPredicate mPrecondition;
    private final IPredicate mPostcondition;
    private final List<IPredicate> mPredicates;

    public TracePredicates(IInterpolantGenerator<? extends IAction> iInterpolantGenerator) {
        if (iInterpolantGenerator.getInterpolants() == null) {
            throw new AssertionError((Object)"We can only build an interpolant automaton for which interpolants were computed.");
        }
        this.mPrecondition = iInterpolantGenerator.getPrecondition();
        this.mPostcondition = iInterpolantGenerator.getPostcondition();
        this.mPredicates = Arrays.asList(iInterpolantGenerator.getInterpolants());
    }

    public TracePredicates(IPredicate iPredicate, IPredicate iPredicate2, List<IPredicate> list) {
        this.mPrecondition = iPredicate;
        this.mPostcondition = iPredicate2;
        this.mPredicates = list;
    }

    public IPredicate getPredicate(int n) {
        if (n < 0) {
            throw new AssertionError((Object)"index beyond precondition");
        }
        if (n == 0) {
            return this.mPrecondition;
        }
        if (n <= this.mPredicates.size()) {
            return this.mPredicates.get(n - 1);
        }
        if (n == this.mPredicates.size() + 1) {
            return this.mPostcondition;
        }
        throw new AssertionError((Object)"index beyond postcondition");
    }

    public List<IPredicate> getPredicates() {
        return Collections.unmodifiableList(this.mPredicates);
    }

    public IPredicate getPrecondition() {
        return this.mPrecondition;
    }

    public IPredicate getPostcondition() {
        return this.mPostcondition;
    }

    public String toString() {
        return String.format("{%s} %s {%s}", this.mPrecondition, this.mPredicates, this.mPostcondition);
    }
}

