/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieStructType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LRValue;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;

public class RValue
extends LRValue {
    private final Expression mValue;

    public RValue(Expression expression, ICType iCType) {
        this(expression, iCType, false);
    }

    public RValue(Expression expression, ICType iCType, boolean bl) {
        this(expression, iCType, bl, false);
    }

    public RValue(RValue rValue) {
        this(rValue.mValue, rValue.getCType(), rValue.isBoogieBool(), rValue.isIntFromPointer());
    }

    public RValue(Expression expression, ICType iCType, boolean bl, boolean bl2) {
        super(iCType, bl, bl2);
        this.mValue = expression;
        this.checkType(iCType);
    }

    @Override
    public Expression getValue() {
        return this.mValue;
    }

    public void checkType(ICType iCType) {
        if (iCType instanceof CFunction) {
            throw new IllegalArgumentException("RValues cannot have function type");
        }
        if (!RValue.areBoogieAndCTypeCompatible(iCType, this.mValue.getType())) {
            throw new IllegalArgumentException(String.format("The value of the constructed RValue has a BoogieType (%s) that is incompatible with its CType (%s).", this.mValue.getType(), iCType));
        }
    }

    private static boolean areBoogieAndCTypeCompatible(ICType iCType, IBoogieType iBoogieType) {
        if (iCType instanceof CPointer) {
            if (iBoogieType instanceof BoogieArrayType) {
                return true;
            }
            if (!(iBoogieType instanceof BoogieStructType)) {
                return false;
            }
            BoogieStructType boogieStructType = (BoogieStructType)iBoogieType;
            if (boogieStructType.getFieldCount() != 2 && boogieStructType.getFieldCount() != 1) {
                return false;
            }
        }
        return true;
    }
}

