/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.abstraction;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.ISymbolicIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IndependenceStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.abstraction.IAbstraction;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.ILattice;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;

public class IndependenceRelationWithAbstraction<H, L, S>
implements IIndependenceRelation<S, L> {
    private final IIndependenceRelation<S, L> mUnderlying;
    private final IAbstraction<H, L> mAbstraction;
    private final H mLevel;
    private final IndependenceStatisticsDataProvider mStatistics;

    public IndependenceRelationWithAbstraction(IIndependenceRelation<S, L> iIndependenceRelation, IAbstraction<H, L> iAbstraction, H h) {
        this.mUnderlying = iIndependenceRelation;
        this.mAbstraction = iAbstraction;
        this.mLevel = h;
        this.mStatistics = new AbstractingStatistics();
    }

    @Override
    public boolean isSymmetric() {
        return this.mUnderlying.isSymmetric();
    }

    @Override
    public boolean isConditional() {
        return this.mUnderlying.isConditional();
    }

    @Override
    public IIndependenceRelation.Dependence isIndependent(S s, L l, L l2) {
        L l3 = this.mAbstraction.abstractLetter(l, this.mLevel);
        L l4 = this.mAbstraction.abstractLetter(l2, this.mLevel);
        IIndependenceRelation.Dependence dependence = this.mUnderlying.isIndependent(s, l3, l4);
        this.mStatistics.reportQuery(dependence, s != null);
        return dependence;
    }

    public SymbolicIndependenceWithAbstraction<S> getSymbolicRelation() {
        ISymbolicIndependenceRelation<L, S> iSymbolicIndependenceRelation = this.mUnderlying.getSymbolicRelation();
        if (iSymbolicIndependenceRelation == null) {
            return null;
        }
        return new SymbolicIndependenceWithAbstraction<S>(iSymbolicIndependenceRelation);
    }

    @Override
    public IStatisticsDataProvider getStatistics() {
        return this.mStatistics;
    }

    public ILattice<H> getHierarchy() {
        return this.mAbstraction.getHierarchy();
    }

    public H getLevel() {
        return this.mLevel;
    }

    private class AbstractingStatistics
    extends IndependenceStatisticsDataProvider {
        public static final String ABSTRACTION_STATISTICS = "Statistics for Abstraction";

        public AbstractingStatistics() {
            super(IndependenceRelationWithAbstraction.class, IndependenceRelationWithAbstraction.this.mUnderlying);
            this.forward(ABSTRACTION_STATISTICS, IndependenceRelationWithAbstraction.this.mAbstraction::getStatistics);
        }
    }

    private class SymbolicIndependenceWithAbstraction<C>
    implements ISymbolicIndependenceRelation<L, C> {
        private final ISymbolicIndependenceRelation<L, C> mUnderlyingSymbolic;

        public SymbolicIndependenceWithAbstraction(ISymbolicIndependenceRelation<L, C> iSymbolicIndependenceRelation) {
            this.mUnderlyingSymbolic = iSymbolicIndependenceRelation;
        }

        @Override
        public C getCommutativityCondition(C c, L l, L l2) {
            Object l3 = IndependenceRelationWithAbstraction.this.mAbstraction.abstractLetter(l, IndependenceRelationWithAbstraction.this.mLevel);
            Object l4 = IndependenceRelationWithAbstraction.this.mAbstraction.abstractLetter(l2, IndependenceRelationWithAbstraction.this.mLevel);
            return this.mUnderlyingSymbolic.getCommutativityCondition(c, l3, l4);
        }

        @Override
        public boolean isSymmetric() {
            return this.mUnderlyingSymbolic.isSymmetric();
        }

        @Override
        public boolean isConditional() {
            return this.mUnderlyingSymbolic.isConditional();
        }
    }
}

