/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class VpAlphabet<LETTER> {
    private final Set<LETTER> mInternalAlphabet;
    private final Set<LETTER> mCallAlphabet;
    private final Set<LETTER> mReturnAlphabet;

    public VpAlphabet(Set<LETTER> set, Set<LETTER> set2, Set<LETTER> set3) {
        this.mInternalAlphabet = set;
        this.mCallAlphabet = set2;
        this.mReturnAlphabet = set3;
    }

    public VpAlphabet(Set<LETTER> set) {
        this.mInternalAlphabet = set;
        this.mCallAlphabet = Collections.emptySet();
        this.mReturnAlphabet = Collections.emptySet();
    }

    public VpAlphabet(VpAlphabet<LETTER> vpAlphabet, Map<LETTER, LETTER> map) {
        this.mInternalAlphabet = vpAlphabet.getInternalAlphabet().stream().map(map::get).collect(Collectors.toSet());
        this.mCallAlphabet = vpAlphabet.getCallAlphabet().stream().map(map::get).collect(Collectors.toSet());
        this.mReturnAlphabet = vpAlphabet.getReturnAlphabet().stream().map(map::get).collect(Collectors.toSet());
    }

    public Set<LETTER> getInternalAlphabet() {
        return this.mInternalAlphabet;
    }

    public Set<LETTER> getCallAlphabet() {
        return this.mCallAlphabet;
    }

    public Set<LETTER> getReturnAlphabet() {
        return this.mReturnAlphabet;
    }

    public boolean containsAny(LETTER LETTER) {
        return this.mInternalAlphabet.contains(LETTER) || this.mCallAlphabet.contains(LETTER) || this.mReturnAlphabet.contains(LETTER);
    }

    public int hashCode() {
        return Objects.hash(this.mCallAlphabet, this.mInternalAlphabet, this.mReturnAlphabet);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        VpAlphabet vpAlphabet = (VpAlphabet)object;
        if (this.mCallAlphabet == null ? vpAlphabet.mCallAlphabet != null : !this.mCallAlphabet.equals(vpAlphabet.mCallAlphabet)) {
            return false;
        }
        if (this.mInternalAlphabet == null ? vpAlphabet.mInternalAlphabet != null : !this.mInternalAlphabet.equals(vpAlphabet.mInternalAlphabet)) {
            return false;
        }
        return !(this.mReturnAlphabet == null ? vpAlphabet.mReturnAlphabet != null : !this.mReturnAlphabet.equals(vpAlphabet.mReturnAlphabet));
    }
}

