/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationStatistics;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.StatisticsType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NwaOutgoingLetterAndTransitionAdapter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.UnaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiAccepts;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiComplementFKVNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiIsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.LassoExtractor;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.MultiOptimizationLevelRankingGenerator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IStateDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.NumberOfTransitions;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.PowersetDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiComplementFkvStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IDeterminizeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.ArrayList;
import java.util.Collection;

public final class BuchiComplementFKV<LETTER, STATE>
extends UnaryNwaOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    private final NestedWordAutomatonReachableStates<LETTER, STATE> mResult;
    private final BuchiComplementFKVNwa<LETTER, STATE> mOnDemandComplement;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mComplemented;
    private final MultiOptimizationLevelRankingGenerator.FkvOptimization mOptimization;

    public <SF extends IDeterminizeStateFactory<STATE> & IBuchiComplementFkvStateFactory<STATE>> BuchiComplementFKV(AutomataLibraryServices automataLibraryServices, SF SF, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException {
        this(automataLibraryServices, SF, iNwaOutgoingLetterAndTransitionProvider, MultiOptimizationLevelRankingGenerator.FkvOptimization.HEIMAT2.toString(), Integer.MAX_VALUE);
    }

    public <SF extends IDeterminizeStateFactory<STATE> & IBuchiComplementFkvStateFactory<STATE>> BuchiComplementFKV(AutomataLibraryServices automataLibraryServices, SF SF, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, String string, int n) throws AutomataOperationCanceledException {
        this(automataLibraryServices, SF, iNwaOutgoingLetterAndTransitionProvider, new PowersetDeterminizer<LETTER, STATE>(iNwaOutgoingLetterAndTransitionProvider, true, SF), MultiOptimizationLevelRankingGenerator.FkvOptimization.valueOf(string), n);
    }

    public BuchiComplementFKV(AutomataLibraryServices automataLibraryServices, IBuchiComplementFkvStateFactory<STATE> iBuchiComplementFkvStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, IStateDeterminizer<LETTER, STATE> iStateDeterminizer) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iBuchiComplementFkvStateFactory, iNwaOutgoingLetterAndTransitionProvider, iStateDeterminizer, MultiOptimizationLevelRankingGenerator.FkvOptimization.HEIMAT2, Integer.MAX_VALUE);
    }

    private BuchiComplementFKV(AutomataLibraryServices automataLibraryServices, IBuchiComplementFkvStateFactory<STATE> iBuchiComplementFkvStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, IStateDeterminizer<LETTER, STATE> iStateDeterminizer, MultiOptimizationLevelRankingGenerator.FkvOptimization fkvOptimization, int n) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mOptimization = fkvOptimization;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mOnDemandComplement = new BuchiComplementFKVNwa<LETTER, STATE>(this.mServices, iNwaOutgoingLetterAndTransitionProvider, iStateDeterminizer, iBuchiComplementFkvStateFactory, this.mOptimization, n);
        this.mComplemented = new NwaOutgoingLetterAndTransitionAdapter<LETTER, STATE>(this.mOnDemandComplement);
        this.mResult = new NestedWordAutomatonReachableStates<LETTER, STATE>(this.mServices, this.mComplemented);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        void nestedLassoWord;
        BuchiIsEmpty<LETTER, STATE> buchiIsEmpty;
        boolean bl;
        this.mLogger.info((Object)("Start testing correctness of " + this.getOperationName()));
        ArrayList<NestedLassoWord<LETTER>> arrayList = new ArrayList<NestedLassoWord<LETTER>>();
        BuchiIsEmpty<LETTER, STATE> buchiIsEmpty2 = new BuchiIsEmpty<LETTER, STATE>(this.mServices, this.mOperand);
        boolean bl2 = buchiIsEmpty2.getResult();
        if (!bl2) {
            arrayList.add(buchiIsEmpty2.getAcceptingNestedLassoRun().getNestedLassoWord());
        }
        if (!(bl = (buchiIsEmpty = new BuchiIsEmpty<LETTER, STATE>(this.mServices, this.mResult)).getResult().booleanValue())) {
            arrayList.add(buchiIsEmpty.getAcceptingNestedLassoRun().getNestedLassoWord());
        }
        boolean bl3 = true;
        assert (bl3 &= !bl2 || !bl);
        boolean n = false;
        while (nestedLassoWord < 11) {
            arrayList.add(NestedWordAutomataUtils.getRandomNestedLassoWord(this.mResult, 1, (long)nestedLassoWord));
            arrayList.add(NestedWordAutomataUtils.getRandomNestedLassoWord(this.mResult, 2, (long)nestedLassoWord));
            ++nestedLassoWord;
        }
        arrayList.addAll((Collection<NestedLassoWord<LETTER>>)new LassoExtractor<LETTER, STATE>(this.mServices, this.mOperand).getResult());
        arrayList.addAll((Collection<NestedLassoWord<LETTER>>)new LassoExtractor<LETTER, STATE>(this.mServices, this.mResult).getResult());
        for (NestedLassoWord nestedLassoWord2 : arrayList) {
            boolean bl4 = this.checkAcceptance(nestedLassoWord2, this.mOperand, false);
            if (!bl4) {
                bl4 = this.checkAcceptance(nestedLassoWord2, this.mOperand, false);
            }
            assert (bl3 &= bl4);
        }
        if (!bl3) {
            AutomatonDefinitionPrinter.writeToFileIfPreferred(this.mServices, this.getOperationName() + "Failed", "language is different", this.mOperand, this.mResult);
        }
        this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
        return bl3;
    }

    @Override
    public String startMessage() {
        return "Start " + this.getOperationName() + " with optimization " + String.valueOf((Object)this.mOptimization) + ". Operand " + this.mOperand.sizeInformation();
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + " with optimization " + String.valueOf((Object)this.mOptimization) + ". Operand " + this.mOperand.sizeInformation() + " Result " + this.mResult.sizeInformation() + this.mOnDemandComplement.getPowersetStates() + " powerset states" + this.mOnDemandComplement.getRankStates() + " rank states. The highest rank that occured is " + this.mOnDemandComplement.getHighesRank();
    }

    public int getHighestRank() {
        return this.mOnDemandComplement.getHighesRank();
    }

    @Override
    public NestedWordAutomatonReachableStates<LETTER, STATE> getResult() {
        return this.mResult;
    }

    @Override
    protected INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    private boolean checkAcceptance(NestedLassoWord<LETTER> nestedLassoWord, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, boolean bl) throws AutomataLibraryException {
        boolean bl2 = new BuchiAccepts<LETTER, STATE>(this.mServices, iNwaOutgoingLetterAndTransitionProvider, nestedLassoWord).getResult();
        boolean bl3 = new BuchiAccepts<LETTER, STATE>(this.mServices, this.mResult, nestedLassoWord).getResult();
        boolean bl4 = bl ? !bl3 || bl2 : bl2 ^ bl3;
        return bl4;
    }

    @Override
    public AutomataOperationStatistics getAutomataOperationStatistics() {
        AutomataOperationStatistics automataOperationStatistics = new AutomataOperationStatistics();
        int n = this.getOperand().size();
        int n2 = ((NestedWordAutomatonReachableStates)this.getResult()).size();
        automataOperationStatistics.addKeyValuePair(StatisticsType.STATES_INPUT, n);
        automataOperationStatistics.addKeyValuePair(StatisticsType.STATES_OUTPUT, n2);
        int n3 = new NumberOfTransitions(this.mServices, this.getResult()).getResult();
        automataOperationStatistics.addKeyValuePair(StatisticsType.TRANSITIONS_OUTPUT, n3);
        return automataOperationStatistics;
    }
}

