/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.statistics;

import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.ILabeledGraph;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.PathExpressionComputer;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.IRegex;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.RegexDag;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.RegexDagCompressor;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.RegexDagNode;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.RegexToDag;
import de.uni_freiburg.informatik.ultimate.lib.sifa.statistics.SifaStats;

public final class RegexStatUtils {
    private RegexStatUtils() {
    }

    public static <N, L> PathExpressionComputer<N, L> createPEComputer(SifaStats sifaStats, ILabeledGraph<N, L> iLabeledGraph) {
        sifaStats.start(SifaStats.Key.PATH_EXPR_TIME);
        PathExpressionComputer pathExpressionComputer = new PathExpressionComputer(iLabeledGraph);
        sifaStats.stop(SifaStats.Key.PATH_EXPR_TIME);
        return pathExpressionComputer;
    }

    public static <N, L> IRegex<L> exprBetween(SifaStats sifaStats, PathExpressionComputer<N, L> pathExpressionComputer, N n, N n2) {
        sifaStats.start(SifaStats.Key.PATH_EXPR_TIME);
        IRegex iRegex = pathExpressionComputer.exprBetween(n, n2);
        sifaStats.stop(SifaStats.Key.PATH_EXPR_TIME);
        return iRegex;
    }

    public static <L> RegexToDag<L> createRegexToDag(SifaStats sifaStats) {
        sifaStats.start(SifaStats.Key.REGEX_TO_DAG_TIME);
        RegexToDag regexToDag = new RegexToDag();
        sifaStats.stop(SifaStats.Key.REGEX_TO_DAG_TIME);
        return regexToDag;
    }

    public static <L> RegexDagNode<L> addToDag(SifaStats sifaStats, RegexToDag<L> regexToDag, IRegex<L> iRegex) {
        sifaStats.start(SifaStats.Key.REGEX_TO_DAG_TIME);
        RegexDagNode<L> regexDagNode = regexToDag.add(iRegex);
        sifaStats.stop(SifaStats.Key.REGEX_TO_DAG_TIME);
        return regexDagNode;
    }

    public static <L> RegexDag<L> getDagAndReset(SifaStats sifaStats, RegexToDag<L> regexToDag) {
        sifaStats.start(SifaStats.Key.REGEX_TO_DAG_TIME);
        RegexDag<L> regexDag = regexToDag.getDagAndReset();
        sifaStats.stop(SifaStats.Key.REGEX_TO_DAG_TIME);
        return regexDag;
    }

    public static <L> RegexDag<L> regexToDag(SifaStats sifaStats, IRegex<L> iRegex) {
        sifaStats.start(SifaStats.Key.REGEX_TO_DAG_TIME);
        RegexToDag<L> regexToDag = new RegexToDag<L>();
        regexToDag.add(iRegex);
        RegexDag regexDag = regexToDag.getDagAndReset();
        sifaStats.stop(SifaStats.Key.REGEX_TO_DAG_TIME);
        return regexDag;
    }

    public static <L> RegexDag<L> compress(SifaStats sifaStats, RegexDag<L> regexDag) {
        sifaStats.add(SifaStats.Key.DAG_COMPRESSION_PROCESSED_NODES, regexDag.collectNodes().size());
        sifaStats.start(SifaStats.Key.DAG_COMPRESSION_TIME);
        RegexDag regexDag2 = new RegexDagCompressor<L>().compress(regexDag);
        sifaStats.stop(SifaStats.Key.DAG_COMPRESSION_TIME);
        sifaStats.add(SifaStats.Key.DAG_COMPRESSION_RETAINED_NODES, regexDag2.collectNodes().size());
        return regexDag2;
    }
}

