/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import de.uni_freiburg.informatik.ultimate.util.datastructures.CrossProducts;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class ThreeValuedEquivalenceRelation<E> {
    private final UnionFind<E> mUnionFind;
    private final HashRelation<E, E> mDisequalities;
    private boolean mIsInconsistent;

    public ThreeValuedEquivalenceRelation() {
        this.mUnionFind = new UnionFind();
        this.mDisequalities = new HashRelation();
        this.mIsInconsistent = false;
    }

    public ThreeValuedEquivalenceRelation(Comparator<E> comparator) {
        assert (comparator != null) : "use other constructor in this case!";
        this.mUnionFind = new UnionFind<E>(comparator);
        this.mDisequalities = new HashRelation();
        this.mIsInconsistent = false;
    }

    public ThreeValuedEquivalenceRelation(ThreeValuedEquivalenceRelation<E> threeValuedEquivalenceRelation) {
        this.mUnionFind = threeValuedEquivalenceRelation.mUnionFind.clone();
        this.mDisequalities = new HashRelation(threeValuedEquivalenceRelation.mDisequalities);
        this.mIsInconsistent = threeValuedEquivalenceRelation.mIsInconsistent;
        assert (this.sanityCheck());
    }

    public ThreeValuedEquivalenceRelation(UnionFind<E> unionFind, HashRelation<E, E> hashRelation) {
        this.mUnionFind = unionFind.clone();
        this.mDisequalities = new HashRelation(hashRelation);
        this.mIsInconsistent = false;
        assert (this.sanityCheck());
    }

    public boolean addElement(E e) {
        if (this.mUnionFind.find(e) == null) {
            this.mUnionFind.findAndConstructEquivalenceClassIfNeeded(e);
            return true;
        }
        return false;
    }

    public E removeElement(E e, E e2) {
        assert (e2 == null || this.getRepresentative(e) == this.getRepresentative(e2));
        E e3 = this.mUnionFind.find(e);
        HashSet<E> hashSet = new HashSet<E>(this.mUnionFind.getEquivalenceClassMembers(e));
        this.mUnionFind.remove(e, e2);
        if (e3 != e) {
            assert (this.getRepresentative(e3) == e3);
            return e3;
        }
        hashSet.remove(e);
        if (hashSet.isEmpty()) {
            this.mDisequalities.removeDomainElement(e);
            this.mDisequalities.removeRangeElement(e);
            assert (this.sanityCheck());
            return null;
        }
        assert (e3 == e);
        E e4 = e2 == null ? this.mUnionFind.find(hashSet.iterator().next()) : e2;
        assert (e4 != null);
        this.mDisequalities.replaceDomainElement(e, e4);
        this.mDisequalities.replaceRangeElement(e, e4);
        assert (this.sanityCheck());
        assert (this.getRepresentative(e4) == e4) : "the returned element must be a representative, " + String.valueOf(e4) + " is its own rep, but " + String.valueOf(this.getRepresentative(e4)) + " is.";
        return e4;
    }

    public boolean reportEquality(E e, E e2) {
        if (this.mIsInconsistent) {
            throw new IllegalStateException();
        }
        E e3 = this.mUnionFind.find(e);
        if (e3 == null) {
            throw new IllegalArgumentException("unknown element " + String.valueOf(e));
        }
        E e4 = this.mUnionFind.find(e2);
        if (e4 == null) {
            throw new IllegalArgumentException("unknown element " + String.valueOf(e2));
        }
        if (e3 == e4) {
            return false;
        }
        if (this.getEqualityStatus(e, e2) == EqualityStatus.NOT_EQUAL) {
            this.reportInconsistency();
            return true;
        }
        this.mUnionFind.union(e, e2);
        if (this.isRepresentative(e3)) {
            assert (this.mUnionFind.find(e2) == e3);
            this.mDisequalities.replaceDomainElement(e4, e3);
            this.mDisequalities.replaceRangeElement(e4, e3);
        } else {
            assert (this.mUnionFind.find(e) == e4);
            this.mDisequalities.replaceDomainElement(e3, e4);
            this.mDisequalities.replaceRangeElement(e3, e4);
        }
        assert (this.sanityCheck());
        return true;
    }

    private void reportInconsistency() {
        this.mIsInconsistent = true;
    }

    public boolean reportDisequality(E e, E e2) {
        if (this.mIsInconsistent) {
            throw new IllegalStateException();
        }
        E e3 = this.mUnionFind.find(e);
        if (e3 == null) {
            throw new IllegalArgumentException("unknown element " + String.valueOf(e));
        }
        E e4 = this.mUnionFind.find(e2);
        if (e4 == null) {
            throw new IllegalArgumentException("unknown element " + String.valueOf(e2));
        }
        if (this.getEqualityStatus(e3, e4) == EqualityStatus.NOT_EQUAL) {
            return false;
        }
        if (e3 == e4) {
            this.reportInconsistency();
            return true;
        }
        this.mDisequalities.addPair(e3, e4);
        assert (this.sanityCheck());
        return true;
    }

    public E getRepresentativeAndAddElementIfNeeded(E e) {
        return this.mUnionFind.findAndConstructEquivalenceClassIfNeeded(e);
    }

    public E getRepresentative(E e) {
        return this.mUnionFind.find(e);
    }

    public boolean isRepresentative(E e) {
        if (!this.getAllElements().contains(e)) {
            throw new IllegalArgumentException("only call this for elements that are present!");
        }
        return this.getRepresentative(e) == e;
    }

    public boolean isInconsistent() {
        return this.mIsInconsistent;
    }

    public EqualityStatus getEqualityStatus(E e, E e2) {
        if (this.mIsInconsistent) {
            throw new IllegalStateException("Cannot get equality status from inconsistent " + this.getClass().getSimpleName());
        }
        E e3 = this.mUnionFind.find(e);
        if (e3 == null) {
            throw new IllegalArgumentException("Unknown element: " + String.valueOf(e));
        }
        E e4 = this.mUnionFind.find(e2);
        if (e4 == null) {
            throw new IllegalArgumentException("Unknown element: " + String.valueOf(e2));
        }
        if (e3.equals(e4)) {
            return EqualityStatus.EQUAL;
        }
        if (this.mDisequalities.containsPair(e3, e4) || this.mDisequalities.containsPair(e4, e3)) {
            return EqualityStatus.NOT_EQUAL;
        }
        return EqualityStatus.UNKNOWN;
    }

    public boolean sanityCheck() {
        if (!this.mUnionFind.sanityCheck()) {
            return false;
        }
        for (Map.Entry entry : this.mDisequalities.getSetOfPairs()) {
            if (entry.getKey() == null) {
                return false;
            }
            if (entry.getValue() != null) continue;
            return false;
        }
        for (Map.Entry entry : this.mDisequalities.getSetOfPairs()) {
            if (!this.isRepresentative(entry.getKey())) {
                return false;
            }
            if (this.isRepresentative(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public Collection<E> getAllRepresentatives() {
        return this.mUnionFind.getAllRepresentatives();
    }

    public Collection<Set<E>> getAllEquivalenceClasses() {
        return this.mUnionFind.getAllEquivalenceClasses();
    }

    public String toString() {
        if (this.isTautological()) {
            return "True";
        }
        if (this.isInconsistent()) {
            return "False";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Equivalences: ");
        stringBuilder.append(this.mUnionFind);
        stringBuilder.append("\n");
        stringBuilder.append("Non-Equivalences: ");
        stringBuilder.append(this.mDisequalities);
        return stringBuilder.toString();
    }

    public Set<E> getAllElements() {
        return this.mUnionFind.getAllElements();
    }

    public Set<E> getRepresentativesUnequalTo(E e) {
        assert (this.isRepresentative(e));
        HashSet hashSet = new HashSet(this.mDisequalities.getImage(e));
        for (Object d : this.mDisequalities.getDomain()) {
            if (!this.mDisequalities.getImage(d).contains(e)) continue;
            hashSet.add(d);
        }
        return hashSet;
    }

    public Set<E> getEquivalenceClass(E e) {
        return this.mUnionFind.getEquivalenceClassMembers(e);
    }

    public ThreeValuedEquivalenceRelation<E> join(ThreeValuedEquivalenceRelation<E> threeValuedEquivalenceRelation) {
        UnionFind<E> unionFind = UnionFind.intersectPartitionBlocks(this.mUnionFind, threeValuedEquivalenceRelation.mUnionFind).getFirst();
        return new ThreeValuedEquivalenceRelation<E>(unionFind, ThreeValuedEquivalenceRelation.xJoinDisequalities(this, threeValuedEquivalenceRelation, unionFind, true));
    }

    public ThreeValuedEquivalenceRelation<E> meet(ThreeValuedEquivalenceRelation<E> threeValuedEquivalenceRelation) {
        UnionFind<E> unionFind = UnionFind.unionPartitionBlocks(this.mUnionFind, threeValuedEquivalenceRelation.mUnionFind);
        return new ThreeValuedEquivalenceRelation<E>(unionFind, ThreeValuedEquivalenceRelation.xJoinDisequalities(this, threeValuedEquivalenceRelation, unionFind, false));
    }

    public Triple<UnionFind<E>, HashRelation<E, E>, HashRelation<E, E>> joinPartitions(ThreeValuedEquivalenceRelation<E> threeValuedEquivalenceRelation) {
        return UnionFind.intersectPartitionBlocks(this.mUnionFind, threeValuedEquivalenceRelation.mUnionFind);
    }

    private static <E> HashRelation<E, E> xJoinDisequalities(ThreeValuedEquivalenceRelation<E> threeValuedEquivalenceRelation, ThreeValuedEquivalenceRelation<E> threeValuedEquivalenceRelation2, UnionFind<E> unionFind, boolean bl) {
        HashRelation hashRelation = new HashRelation();
        for (Map.Entry entry : CrossProducts.binarySelectiveCrossProduct(unionFind.getAllRepresentatives(), false, false)) {
            boolean bl2;
            if (bl) {
                bl2 = threeValuedEquivalenceRelation.getEqualityStatus(entry.getKey(), entry.getValue()) == EqualityStatus.NOT_EQUAL && threeValuedEquivalenceRelation2.getEqualityStatus(entry.getKey(), entry.getValue()) == EqualityStatus.NOT_EQUAL;
            } else {
                boolean bl3 = bl2 = threeValuedEquivalenceRelation.getEqualityStatus(entry.getKey(), entry.getValue()) == EqualityStatus.NOT_EQUAL || threeValuedEquivalenceRelation2.getEqualityStatus(entry.getKey(), entry.getValue()) == EqualityStatus.NOT_EQUAL;
            }
            if (!bl2) continue;
            hashRelation.addPair(entry.getKey(), entry.getValue());
        }
        return hashRelation;
    }

    public Map<E, E> getSupportingEqualities() {
        HashMap<E, Object> hashMap = new HashMap<E, Object>();
        for (Set<E> set : this.mUnionFind.getAllEquivalenceClasses()) {
            Object v = null;
            for (E e : set) {
                if (v != null) {
                    hashMap.put(e, v);
                }
                v = e;
            }
        }
        return hashMap;
    }

    public HashRelation<E, E> getDisequalities() {
        assert (!this.mDisequalities.getSetOfPairs().stream().anyMatch(entry -> entry.getValue() == null));
        return new HashRelation(this.mDisequalities);
    }

    public boolean isTautological() {
        return this.getSupportingEqualities().isEmpty() && this.mDisequalities.isEmpty();
    }

    public void transformElements(Function<E, E> function) {
        this.mUnionFind.transformElements(function);
        HashRelation hashRelation = new HashRelation(this.mDisequalities);
        for (Map.Entry entry : hashRelation) {
            this.mDisequalities.removePair(entry.getKey(), entry.getValue());
            this.mDisequalities.addPair(function.apply(entry.getKey()), function.apply(entry.getValue()));
        }
        assert (this.sanityCheck());
    }

    public ThreeValuedEquivalenceRelation<E> filterAndKeepOnlyConstraintsThatIntersectWith(Set<E> set) {
        HashRelation hashRelation2;
        UnionFind unionFind = this.mUnionFind.getElementComparator() != null ? new UnionFind(this.mUnionFind.getElementComparator()) : new UnionFind();
        for (HashRelation hashRelation2 : set) {
            if (unionFind.find(hashRelation2) != null || this.mUnionFind.find(hashRelation2) == null) continue;
            ImmutableSet immutableSet = this.mUnionFind.getEquivalenceClassMembers(hashRelation2);
            unionFind.addEquivalenceClass(immutableSet, this.mUnionFind.find(hashRelation2));
        }
        hashRelation2 = new HashRelation();
        for (Map.Entry entry : this.mDisequalities.getSetOfPairs()) {
            if (!DataStructureUtils.getSomeCommonElement(this.getEquivalenceClass(entry.getKey()), set).isPresent() && !DataStructureUtils.getSomeCommonElement(this.getEquivalenceClass(entry.getValue()), set).isPresent()) continue;
            hashRelation2.addPair(unionFind.findAndConstructEquivalenceClassIfNeeded(entry.getKey()), unionFind.findAndConstructEquivalenceClassIfNeeded(entry.getValue()));
        }
        return new ThreeValuedEquivalenceRelation<E>(unionFind, hashRelation2);
    }

    public ThreeValuedEquivalenceRelation<E> projectTo(Set<E> set) {
        HashRelation hashRelation2;
        UnionFind unionFind = this.mUnionFind.getElementComparator() != null ? new UnionFind(this.mUnionFind.getElementComparator()) : new UnionFind();
        for (HashRelation hashRelation2 : set) {
            if (unionFind.find(hashRelation2) != null || this.mUnionFind.find(hashRelation2) == null) continue;
            ImmutableSet immutableSet = this.mUnionFind.getEquivalenceClassMembers(hashRelation2);
            unionFind.addEquivalenceClass(ImmutableSet.of(DataStructureUtils.intersection(immutableSet, set)));
        }
        hashRelation2 = new HashRelation();
        for (Map.Entry entry : this.mDisequalities.getSetOfPairs()) {
            Optional<E> optional;
            Optional<E> optional2 = DataStructureUtils.getSomeCommonElement(set, this.getEquivalenceClass(entry.getKey()));
            if (!optional2.isPresent() || !(optional = DataStructureUtils.getSomeCommonElement(set, this.getEquivalenceClass(entry.getValue()))).isPresent()) continue;
            hashRelation2.addPair(unionFind.find(optional2.get()), unionFind.find(optional.get()));
        }
        return new ThreeValuedEquivalenceRelation<E>(unionFind, hashRelation2);
    }

    public boolean isConstrained(E e) {
        if (this.mUnionFind.find(e) == null) {
            throw new IllegalArgumentException();
        }
        if (this.getEquivalenceClass(e).size() > 1) {
            return true;
        }
        if (this.mDisequalities.getImage(e).size() > 0) {
            return true;
        }
        for (Map.Entry entry : this.mDisequalities.getSetOfPairs()) {
            if (!entry.getValue().equals(e)) continue;
            return true;
        }
        return false;
    }

    public void removeDisequality(E e, E e2) {
        this.mDisequalities.removePair(e, e2);
        this.mDisequalities.removePair(e2, e);
    }
}

