/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.delayed.nwa;

import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.delayed.DelayedSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.delayed.nwa.DelayedNwaGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.Vertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.NwaSimulationUtil;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.SpoilerNwaVertex;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;

public final class DelayedNwaSimulation<LETTER, STATE>
extends DelayedSimulation<LETTER, STATE> {
    public DelayedNwaSimulation(IProgressAwareTimer iProgressAwareTimer, ILogger iLogger, boolean bl, IStateFactory<STATE> iStateFactory, DelayedNwaGameGraph<LETTER, STATE> delayedNwaGameGraph) throws AutomataOperationCanceledException {
        super(iProgressAwareTimer, iLogger, bl, iStateFactory, delayedNwaGameGraph);
    }

    @Override
    public void doSimulation() throws AutomataOperationCanceledException {
        super.doSimulation();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Simulation results (filtered):");
            for (Vertex vertex : this.getGameGraph().getSpoilerVertices()) {
                int n = vertex.getPM(null, this.getGameGraph().getGlobalInfinity());
                if (!(vertex instanceof SpoilerNwaVertex) || n >= this.getGameGraph().getGlobalInfinity() && vertex.getQ0() != vertex.getQ1() || n < this.getGameGraph().getGlobalInfinity() && vertex.getQ0() == vertex.getQ1()) continue;
                String string = Integer.toString(n);
                if (n >= this.getGameGraph().getGlobalInfinity()) {
                    string = "inf";
                }
                this.getLogger().debug((Object)("\t(" + vertex.isB() + "," + String.valueOf(vertex.getQ0()) + "," + String.valueOf(vertex.getQ1()) + ") = " + string));
            }
        }
    }

    @Override
    protected void retrieveGeneralAutomataPerformance() {
        super.retrieveGeneralAutomataPerformance();
        NwaSimulationUtil.retrieveGeneralNwaAutomataPerformance(this.getSimulationPerformance(), this.getGameGraph().getAutomaton(), this.getResult(), this.getGameGraph().getServices());
    }
}

