/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.source.smtparser;

import de.uni_freiburg.informatik.ultimate.core.lib.results.MSODResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import de.uni_freiburg.informatik.ultimate.source.smtparser.Activator;

public class ResultReportingWrapperScript
extends WrapperScript {
    private final IUltimateServiceProvider mServices;

    public ResultReportingWrapperScript(Script script, IUltimateServiceProvider iUltimateServiceProvider) {
        super(script);
        this.mServices = iUltimateServiceProvider;
    }

    public Script.LBool checkSat() throws SMTLIBException {
        Script.LBool lBool = super.checkSat();
        switch (lBool) {
            case SAT: {
                break;
            }
            case UNKNOWN: {
                break;
            }
            case UNSAT: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown case: " + String.valueOf(lBool));
            }
        }
        MSODResult mSODResult = new MSODResult(Activator.PLUGIN_ID, "MSODResult", "MSOD resulted in: " + lBool.toString(), lBool, IResultWithSeverity.Severity.INFO);
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)mSODResult);
        return lBool;
    }
}

