/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtsolver.external;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import java.io.IOException;
import java.util.Formatter;
import java.util.Objects;

public class SmtInterpolLogProxyWrapper
implements LogProxy {
    private final ILogger mLogger;

    public SmtInterpolLogProxyWrapper(ILogger iLogger) {
        this.mLogger = iLogger;
    }

    public void setLoglevel(int n) {
    }

    public int getLoglevel() {
        if (this.mLogger.isDebugEnabled()) {
            return 5;
        }
        if (this.mLogger.isInfoEnabled()) {
            return 4;
        }
        if (this.mLogger.isWarnEnabled()) {
            return 3;
        }
        if (this.mLogger.isErrorEnabled()) {
            return 2;
        }
        if (this.mLogger.isFatalEnabled()) {
            return 1;
        }
        return 0;
    }

    public boolean isFatalEnabled() {
        return this.mLogger.isFatalEnabled();
    }

    public boolean isErrorEnabled() {
        return this.mLogger.isErrorEnabled();
    }

    public boolean isWarnEnabled() {
        return this.mLogger.isWarnEnabled();
    }

    public boolean isInfoEnabled() {
        return this.mLogger.isInfoEnabled();
    }

    public boolean isDebugEnabled() {
        return this.mLogger.isDebugEnabled();
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public void outOfMemory(String string) {
        this.fatal(string);
    }

    public void fatal(Object object) {
        if (this.mLogger.isFatalEnabled()) {
            this.log(1, String.valueOf(object));
        }
    }

    public void error(Object object) {
        if (this.mLogger.isErrorEnabled()) {
            this.log(2, String.valueOf(object));
        }
    }

    public void warn(Object object) {
        if (this.mLogger.isWarnEnabled()) {
            this.log(3, String.valueOf(object));
        }
    }

    public void info(Object object) {
        if (this.mLogger.isInfoEnabled()) {
            this.log(4, String.valueOf(object));
        }
    }

    public void debug(Object object) {
        if (this.mLogger.isDebugEnabled()) {
            this.log(5, String.valueOf(object));
        }
    }

    public void trace(Object object) {
        if (this.mLogger.isDebugEnabled()) {
            this.log(6, String.valueOf(object));
        }
    }

    public void fatal(String string, Object ... objectArray) {
        if (this.mLogger.isFatalEnabled()) {
            this.log(1, string, objectArray);
        }
    }

    public void error(String string, Object ... objectArray) {
        if (this.mLogger.isErrorEnabled()) {
            this.log(2, string, objectArray);
        }
    }

    public void warn(String string, Object ... objectArray) {
        if (this.mLogger.isWarnEnabled()) {
            this.log(3, string, objectArray);
        }
    }

    public void info(String string, Object ... objectArray) {
        if (this.mLogger.isInfoEnabled()) {
            this.log(4, string, objectArray);
        }
    }

    public void debug(String string, Object ... objectArray) {
        if (this.mLogger.isDebugEnabled()) {
            this.log(5, string, objectArray);
        }
    }

    public void trace(String string, Object ... objectArray) {
        if (this.mLogger.isDebugEnabled()) {
            this.log(6, string, objectArray);
        }
    }

    public boolean canChangeDestination() {
        return false;
    }

    public void changeDestination(String string) throws IOException {
    }

    public String getDestination() {
        return "stdout";
    }

    public int hashCode() {
        return Objects.hash(this.mLogger);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SmtInterpolLogProxyWrapper smtInterpolLogProxyWrapper = (SmtInterpolLogProxyWrapper)object;
        return !(this.mLogger == null ? smtInterpolLogProxyWrapper.mLogger != null : !this.mLogger.equals(smtInterpolLogProxyWrapper.mLogger));
    }

    private void log(int n, String string) {
        switch (n) {
            case 0: {
                return;
            }
            case 5: 
            case 6: {
                this.mLogger.debug((Object)string);
                return;
            }
            case 4: {
                this.mLogger.info((Object)string);
                return;
            }
            case 3: {
                this.mLogger.warn((Object)string);
                return;
            }
            case 2: {
                this.mLogger.error((Object)string);
                return;
            }
            case 1: {
                this.mLogger.fatal((Object)string);
                return;
            }
        }
        this.mLogger.fatal((Object)("Unsupported log level: " + string));
    }

    private void log(int n, String string, Object[] objectArray) {
        if (objectArray.length == 0) {
            this.log(n, string);
        } else {
            this.log(n, SmtInterpolLogProxyWrapper.convert(string, objectArray));
        }
    }

    private static String convert(String string, Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder);
        formatter.format(string, objectArray);
        formatter.close();
        return stringBuilder.toString();
    }
}

