/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.util.statistics.Benchmark;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsElement;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsType;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class PredicateUnifierStatisticsGenerator
implements IStatisticsDataProvider {
    private int mDeclaredPredicates = 0;
    private int mGetRequests = 0;
    private int mSyntacticMatches = 0;
    private int mSemanticMatches = 0;
    private int mConstructedPredicates = 0;
    private int mIntricatePredicates = 0;
    private int mDeprecatedPredicatesCount = 0;
    private int mImplicationChecksByTransitivity = 0;
    protected final Benchmark mBenchmark = new Benchmark();
    protected boolean mRunning = false;

    public PredicateUnifierStatisticsGenerator() {
        this.mBenchmark.register(String.valueOf((Object)PredicateUniferStatisticsDefinitions.Time));
    }

    public void incrementDeclaredPredicates() {
        ++this.mDeclaredPredicates;
    }

    public void incrementGetRequests() {
        ++this.mGetRequests;
    }

    public void incrementSyntacticMatches() {
        ++this.mSyntacticMatches;
    }

    public void incrementSemanticMatches() {
        ++this.mSemanticMatches;
    }

    public void incrementConstructedPredicates() {
        ++this.mConstructedPredicates;
    }

    public void incrementIntricatePredicates() {
        ++this.mIntricatePredicates;
    }

    public void incrementDeprecatedPredicates() {
        ++this.mDeprecatedPredicatesCount;
    }

    public void incrementImplicationChecksByTransitivity() {
        ++this.mImplicationChecksByTransitivity;
    }

    public long getTime() {
        return (long)this.mBenchmark.getElapsedTime(String.valueOf((Object)PredicateUniferStatisticsDefinitions.Time), TimeUnit.NANOSECONDS);
    }

    public void continueTime() {
        assert (!this.mRunning) : "Timing already running";
        this.mRunning = true;
        this.mBenchmark.unpause(String.valueOf((Object)PredicateUniferStatisticsDefinitions.Time));
    }

    public void stopTime() {
        assert (this.mRunning) : "Timing not running";
        this.mRunning = false;
        this.mBenchmark.pause(String.valueOf((Object)PredicateUniferStatisticsDefinitions.Time));
    }

    public Collection<String> getKeys() {
        return PredicateUnifierStatisticsType.getInstance().getKeys();
    }

    public Object getValue(String string) {
        PredicateUniferStatisticsDefinitions predicateUniferStatisticsDefinitions = PredicateUniferStatisticsDefinitions.valueOf(string);
        switch (predicateUniferStatisticsDefinitions) {
            case DeclaredPredicates: {
                return this.mDeclaredPredicates;
            }
            case GetRequests: {
                return this.mGetRequests;
            }
            case SyntacticMatches: {
                return this.mSyntacticMatches;
            }
            case SemanticMatches: {
                return this.mSemanticMatches;
            }
            case ConstructedPredicates: {
                return this.mConstructedPredicates;
            }
            case IntricatePredicates: {
                return this.mIntricatePredicates;
            }
            case DeprecatedPredicates: {
                return this.mDeprecatedPredicatesCount;
            }
            case ImplicationChecksByTransitivity: {
                return this.mImplicationChecksByTransitivity;
            }
            case Time: {
                return this.getTime();
            }
        }
        throw new AssertionError((Object)"unknown key");
    }

    public IStatisticsType getBenchmarkType() {
        return PredicateUnifierStatisticsType.getInstance();
    }

    public static enum PredicateUniferStatisticsDefinitions implements IStatisticsElement
    {
        DeclaredPredicates(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.DATA_BEFORE_KEY),
        GetRequests(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.DATA_BEFORE_KEY),
        SyntacticMatches(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.DATA_BEFORE_KEY),
        SemanticMatches(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.DATA_BEFORE_KEY),
        ConstructedPredicates(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.DATA_BEFORE_KEY),
        IntricatePredicates(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.DATA_BEFORE_KEY),
        DeprecatedPredicates(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.DATA_BEFORE_KEY),
        ImplicationChecksByTransitivity(Integer.class, StatisticsType.INTEGER_ADDITION, StatisticsType.DATA_BEFORE_KEY),
        Time(Integer.class, StatisticsType.LONG_ADDITION, StatisticsType.NANOS_BEFORE_KEY);

        private final Class<?> mClazz;
        private final Function<Object, Function<Object, Object>> mAggr;
        private final Function<String, Function<Object, String>> mPrettyprinter;

        private PredicateUniferStatisticsDefinitions(Class<?> clazz, Function<Object, Function<Object, Object>> function, Function<String, Function<Object, String>> function2) {
            this.mClazz = clazz;
            this.mAggr = function;
            this.mPrettyprinter = function2;
        }

        public Object aggregate(Object object, Object object2) {
            return this.mAggr.apply(object).apply(object2);
        }

        public String prettyprint(Object object) {
            return this.mPrettyprinter.apply(this.name()).apply(object);
        }
    }

    public static class PredicateUnifierStatisticsType
    extends StatisticsType<PredicateUniferStatisticsDefinitions> {
        private static final PredicateUnifierStatisticsType INSTANCE = new PredicateUnifierStatisticsType();

        public PredicateUnifierStatisticsType() {
            super(PredicateUniferStatisticsDefinitions.class);
        }

        public static PredicateUnifierStatisticsType getInstance() {
            return INSTANCE;
        }
    }
}

