/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashSet;

public class CheckClosedTerm
extends NonRecursive {
    private final ScopedHashSet<Term> mCheckedTerms = new ScopedHashSet();
    private boolean mIsClosed;

    public boolean isClosed(Term term) {
        this.mIsClosed = true;
        this.run(new TermWalker(term));
        return this.mIsClosed;
    }

    void check(Term term) {
        if (this.mCheckedTerms.contains((Object)term) || !this.mIsClosed) {
            return;
        }
        this.mCheckedTerms.add((Object)term);
        if (term instanceof ApplicationTerm) {
            Term[] termArray = ((ApplicationTerm)term).getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term2 = termArray[n2];
                this.enqueueWalker(new TermWalker(term2));
                ++n2;
            }
        } else if (term instanceof AnnotatedTerm) {
            this.enqueueWalker(new TermWalker(((AnnotatedTerm)term).getSubterm()));
        } else if (term instanceof LetTerm) {
            Term term3;
            LetTerm letTerm = (LetTerm)term;
            Term[] termArray = letTerm.getValues();
            int n = termArray.length;
            int n3 = 0;
            while (n3 < n) {
                term3 = termArray[n3];
                this.enqueueWalker(new TermWalker(term3));
                ++n3;
            }
            this.mCheckedTerms.beginScope();
            this.enqueueWalker(new EndScopeWalker());
            termArray = letTerm.getVariables();
            n = termArray.length;
            n3 = 0;
            while (n3 < n) {
                term3 = termArray[n3];
                this.mCheckedTerms.add((Object)term3);
                ++n3;
            }
            this.enqueueWalker(new TermWalker(letTerm.getSubTerm()));
        } else if (term instanceof TermVariable) {
            this.mIsClosed = false;
        } else if (term instanceof QuantifiedFormula) {
            QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term;
            this.mCheckedTerms.beginScope();
            this.enqueueWalker(new EndScopeWalker());
            TermVariable[] termVariableArray = quantifiedFormula.getVariables();
            int n = termVariableArray.length;
            int n4 = 0;
            while (n4 < n) {
                TermVariable termVariable = termVariableArray[n4];
                this.mCheckedTerms.add((Object)termVariable);
                ++n4;
            }
            this.enqueueWalker(new TermWalker(quantifiedFormula.getSubformula()));
        } else if (term instanceof MatchTerm) {
            MatchTerm matchTerm = (MatchTerm)term;
            int n = 0;
            while (n < matchTerm.getCases().length) {
                this.enqueueWalker(new MatchCaseWalker(matchTerm, n));
                ++n;
            }
            this.enqueueWalker(new TermWalker(matchTerm.getDataTerm()));
        } else if (!(term instanceof ConstantTerm)) {
            throw new AssertionError((Object)("Unknown term: " + String.valueOf(term.getClass())));
        }
    }

    void checkMatchCase(MatchTerm matchTerm, int n) {
        this.mCheckedTerms.beginScope();
        TermVariable[] termVariableArray = matchTerm.getVariables()[n];
        int n2 = termVariableArray.length;
        int n3 = 0;
        while (n3 < n2) {
            TermVariable termVariable = termVariableArray[n3];
            this.mCheckedTerms.add((Object)termVariable);
            ++n3;
        }
        this.enqueueWalker(new EndScopeWalker());
        this.enqueueWalker(new TermWalker(matchTerm.getCases()[n]));
    }

    static class EndScopeWalker
    implements NonRecursive.Walker {
        EndScopeWalker() {
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            ((CheckClosedTerm)nonRecursive).mCheckedTerms.endScope();
        }
    }

    static class MatchCaseWalker
    implements NonRecursive.Walker {
        final MatchTerm mMatch;
        final int mCaseNr;

        public MatchCaseWalker(MatchTerm matchTerm, int n) {
            this.mMatch = matchTerm;
            this.mCaseNr = n;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            ((CheckClosedTerm)nonRecursive).checkMatchCase(this.mMatch, this.mCaseNr);
        }
    }

    static class TermWalker
    implements NonRecursive.Walker {
        final Term mTerm;

        public TermWalker(Term term) {
            this.mTerm = term;
        }

        @Override
        public void walk(NonRecursive nonRecursive) {
            ((CheckClosedTerm)nonRecursive).check(this.mTerm);
        }
    }
}

