/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.poset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class TopologicalSorter<V> {
    private Set<V> mUnmarkedNodes;
    private Set<V> mTemporarilyMarkedNodes;
    private List<V> mTopolicalSorting;
    private final Function<V, Collection<V>> mSuccesorsOf;

    public TopologicalSorter(Function<V, Collection<V>> function) {
        this.mSuccesorsOf = function;
    }

    public Optional<List<V>> topologicalOrdering(Collection<V> collection) {
        Optional<List<V>> optional = this.reversedTopologicalOrdering(collection);
        optional.ifPresent(Collections::reverse);
        return optional;
    }

    public Optional<List<V>> reversedTopologicalOrdering(Collection<V> collection) {
        try {
            return Optional.of(this.tryRevTopSort(collection));
        }
        catch (GraphCycleException graphCycleException) {
            return Optional.empty();
        }
    }

    private List<V> tryRevTopSort(Collection<V> collection) throws GraphCycleException {
        this.mUnmarkedNodes = new LinkedHashSet<V>(collection);
        this.mTemporarilyMarkedNodes = new HashSet<V>();
        this.mTopolicalSorting = new ArrayList<V>(collection.size());
        while (!this.mUnmarkedNodes.isEmpty()) {
            this.visit(this.mUnmarkedNodes.iterator().next());
        }
        return this.mTopolicalSorting;
    }

    private void visit(V v) throws GraphCycleException {
        if (this.mTemporarilyMarkedNodes.contains(v)) {
            throw new GraphCycleException();
        }
        if (this.mUnmarkedNodes.contains(v)) {
            this.markTemporarily(v);
            for (V v2 : this.mSuccesorsOf.apply(v)) {
                this.visit(v2);
            }
            this.markPermanently(v);
            this.mTopolicalSorting.add(v);
        }
    }

    private void markTemporarily(V v) {
        this.mTemporarilyMarkedNodes.add(v);
    }

    private void markPermanently(V v) {
        this.mTemporarilyMarkedNodes.remove(v);
        this.mUnmarkedNodes.remove(v);
    }

    private static class GraphCycleException
    extends Exception {
        private static final long serialVersionUID = -7189895863479876025L;

        private GraphCycleException() {
        }
    }
}

