/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaMaxSat2;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaPmaxSat;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.AbstractMaxSatSolver;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.InteractiveMaxSatSolver;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.ScopedTransitivityGeneratorDoubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;

public class MinimizeNwaPmaxSatDimacs<LETTER, STATE>
extends MinimizeNwaPmaxSat<LETTER, STATE> {
    private final Iterable<Set<STATE>> mInitialPartition;
    private final int mLargestBlockInitialPartition;
    private final int mInitialPartitionSize;
    private final long mNumberOfInitialPairs;
    private final Map<STATE, Set<STATE>> mState2EquivalenceClass;

    public MinimizeNwaPmaxSatDimacs(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, IDoubleDeckerAutomaton<LETTER, STATE> iDoubleDeckerAutomaton, String string) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMinimizationStateFactory, iDoubleDeckerAutomaton, new MinimizeNwaMaxSat2.Settings().setSolverModeExternal(), string);
        this.printStartMessage();
        this.mInitialPartition = Collections.singleton(iDoubleDeckerAutomaton.getStates());
        this.mState2EquivalenceClass = new HashMap<STATE, Set<STATE>>();
        int n = 0;
        int n2 = 0;
        long l = 0L;
        for (Set<STATE> set : this.mInitialPartition) {
            for (STATE STATE : set) {
                this.mState2EquivalenceClass.put(STATE, set);
            }
            n = Math.max(n, set.size());
            l += (long)set.size() * (long)set.size() - (long)set.size();
            ++n2;
        }
        this.mLargestBlockInitialPartition = n;
        this.mInitialPartitionSize = n2;
        this.mNumberOfInitialPairs = l;
        this.mLogger.info((Object)("Initial partition has " + n2 + " blocks, largest block has " + n + " states"));
        this.run();
        this.printExitMessage();
    }

    @Override
    protected String createTaskDescription() {
        return NestedWordAutomataUtils.generateGenericMinimizationRunningTaskDescription(this.getOperationName(), this.mOperand, this.mInitialPartitionSize, this.mLargestBlockInitialPartition);
    }

    @Override
    protected void generateVariablesAndAcceptingConstraints() throws AutomataOperationCanceledException {
        for (Set<STATE> set : this.mInitialPartition) {
            STATE[] STATEArray = this.constructStateArray(set);
            this.generateVariablesHelper(STATEArray);
            this.checkTimeout("generating variables");
        }
    }

    @Override
    protected void generateTransitionAndTransitivityConstraints(boolean bl) throws AutomataOperationCanceledException {
        for (Set<STATE> set : this.mInitialPartition) {
            STATE[] STATEArray = this.constructStateArray(set);
            int n = 0;
            while (n < STATEArray.length) {
                this.generateTransitionConstraints(STATEArray, n);
                this.checkTimeout("adding transition constraints");
                ++n;
            }
            if (!bl) continue;
            this.generateTransitivityConstraints(STATEArray);
        }
    }

    @Override
    protected boolean isInitialPair(STATE STATE, STATE STATE2) {
        return this.mState2EquivalenceClass.get(STATE) == this.mState2EquivalenceClass.get(STATE2);
    }

    @Override
    protected void generateVariablesHelper(STATE[] STATEArray) {
        if (STATEArray.length <= 1) {
            return;
        }
        BiPredicate biPredicate = this.mSettings.getFinalNonfinalConstraintPredicate();
        int n = 0;
        while (n < STATEArray.length) {
            STATE STATE = STATEArray[n];
            if (this.mTransitivityGenerator != null) {
                this.mTransitivityGenerator.addContent(STATE);
            }
            int n2 = 0;
            while (n2 < n) {
                STATE STATE2 = STATEArray[n2];
                Doubleton doubleton = new Doubleton(STATE, STATE2);
                this.mStatePair2Var.put(STATE, STATE2, (Object)doubleton);
                this.mStatePair2Var.put(STATE2, STATE, (Object)doubleton);
                this.mSolver.addVariable(doubleton);
                if (this.mOperand.isFinal(STATE) ^ this.mOperand.isFinal(STATE2) && biPredicate.test(STATE, STATE2)) {
                    this.setStatesDifferent(doubleton);
                }
                ++n2;
            }
            ++n;
        }
    }

    @Override
    protected AbstractMaxSatSolver<Doubleton<STATE>> createTransitivitySolver() {
        this.mTransitivityGenerator = new ScopedTransitivityGeneratorDoubleton(this.mSettings.isUsePathCompression());
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.mTransitivityGenerator);
        return new InteractiveMaxSatSolver<Doubleton<STATE>>(this.mServices, arrayList);
    }
}

