/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.visualization;

import de.uni_freiburg.informatik.ultimate.automata.GeneralAutomatonPrinter;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.visualization.IPetriAtsFormatter;
import java.io.PrintWriter;
import java.util.Map;

public class NetWriter<LETTER, PLACE>
extends GeneralAutomatonPrinter {
    private final Map<LETTER, String> mAlphabet;
    private final Map<PLACE, String> mPlacesMapping;

    public NetWriter(PrintWriter printWriter, String string, BoundedPetriNet<LETTER, PLACE> boundedPetriNet, IPetriAtsFormatter<LETTER, PLACE> iPetriAtsFormatter) {
        super(printWriter);
        this.mAlphabet = iPetriAtsFormatter.getAlphabetMapping(boundedPetriNet.getAlphabet());
        this.mPlacesMapping = iPetriAtsFormatter.getPlacesMapping(boundedPetriNet.getPlaces());
        this.print("PetriNet ");
        this.print(string);
        this.printAutomatonPrefix();
        this.printAlphabet();
        this.printPlaces();
        this.printTransitions(boundedPetriNet);
        this.printInitialMarking(boundedPetriNet.getInitialPlaces());
        this.printAcceptingPlaces(boundedPetriNet.getAcceptingPlaces());
        this.printAutomatonSuffix();
        this.finish();
    }

    protected final void printElementPrefix(String string) {
        this.print(String.format("\t%s = ", string));
    }

    private void printAlphabet() {
        this.printCollectionPrefix("alphabet");
        this.printValues(this.mAlphabet);
        this.printCollectionSuffix();
    }

    private void printPlaces() {
        this.printCollectionPrefix("places");
        this.printValues(this.mPlacesMapping);
        this.printCollectionSuffix();
    }

    private void printTransitions(BoundedPetriNet<LETTER, PLACE> boundedPetriNet) {
        this.printlnCollectionPrefix("transitions");
        boundedPetriNet.getTransitions().forEach(this::printTransition);
        this.printTransitionsSuffix();
        this.print(',');
        this.print(NEW_LINE);
    }

    private void printTransition(Transition<LETTER, PLACE> transition) {
        this.printOneTransitionPrefix();
        this.printMarking((Iterable<PLACE>)transition.getPredecessors());
        this.print(' ');
        this.print(this.mAlphabet.get(transition.getSymbol()));
        this.print(' ');
        this.printMarking((Iterable<PLACE>)transition.getSuccessors());
        this.printOneTransitionSuffix();
    }

    private void printMarking(Iterable<PLACE> iterable) {
        this.print('{');
        for (PLACE PLACE : iterable) {
            this.printElement(this.mPlacesMapping.get(PLACE));
        }
        this.print('}');
    }

    private void printInitialMarking(Iterable<PLACE> iterable) {
        this.printElementPrefix("initialMarking");
        this.printMarking(iterable);
        this.println(',');
    }

    private void printAcceptingPlaces(Iterable<PLACE> iterable) {
        this.printElementPrefix("acceptingPlaces");
        this.printMarking(iterable);
        this.print(NEW_LINE);
    }
}

