/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.ltl2aut;

import com.github.jhoenicke.javacup.runtime.Scanner;
import com.github.jhoenicke.javacup.runtime.SymbolFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.annotation.LTLPropertyCheck;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayStoreExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitVectorAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitvecLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StringLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StructAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.parser.BoogieSymbolFactory;
import de.uni_freiburg.informatik.ultimate.boogie.parser.Lexer;
import de.uni_freiburg.informatik.ultimate.boogie.parser.Parser;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.PreprocessorAnnotation;
import de.uni_freiburg.informatik.ultimate.boogie.symboltable.BoogieSymbolTable;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.boogie.typechecker.TypeCheckException;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.ltl2aut.Activator;
import de.uni_freiburg.informatik.ultimate.ltl2aut.LTLXBAExecutor;
import de.uni_freiburg.informatik.ultimate.ltl2aut.ast.AstNode;
import de.uni_freiburg.informatik.ultimate.ltl2aut.never2nwa.NWAContainer;
import de.uni_freiburg.informatik.ultimate.ltl2aut.never2nwa.Never2Automaton;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlockFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class LTL2autObserver
implements IUnmanagedObserver {
    private static final String LTL_MARKER = "#LTLProperty:";
    private static final String ALPHABET = "ABCDEHIJKLMNOPQRSTVWYZ";
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private String mInputFile;
    private NWAContainer mNWAContainer;
    private LTLPropertyCheck mCheck;
    private BoogieSymbolTable mSymbolTable;

    public LTL2autObserver(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
    }

    public void init(ModelType modelType, int n, int n2) {
        this.mNWAContainer = null;
        this.mInputFile = null;
        this.mSymbolTable = null;
        this.mCheck = null;
    }

    public void finish() throws Throwable {
        Object object;
        if (this.mCheck == null) {
            object = this.getLTLPropertyString();
            if (((String[])object).length > 1) {
                throw new UnsupportedOperationException("We currently support only one LTL property at a time, but found " + ((String[])object).length);
            }
            this.mCheck = this.createCheckFromPropertyString(object[0], this.mSymbolTable);
        }
        object = this.mCheck.getCheckableAtomicPropositions();
        String string = this.mCheck.getLTL2BALTLProperty();
        AstNode astNode = this.getNeverClaim(string);
        CodeBlockFactory codeBlockFactory = CodeBlockFactory.getFactory((IToolchainStorage)this.mServices.getStorage());
        INestedWordAutomaton<CodeBlock, String> iNestedWordAutomaton = this.createNWAFromNeverClaim(astNode, (Map<String, LTLPropertyCheck.CheckableExpression>)object, this.mSymbolTable, codeBlockFactory);
        this.mLogger.info((Object)("LTL Property is: " + this.mCheck.getUltimateLTLProperty()));
        this.mNWAContainer = new NWAContainer(iNestedWordAutomaton);
        this.mCheck.annotate((IElement)this.mNWAContainer);
    }

    private LTLPropertyCheck createCheckFromPropertyString(String string, BoogieSymbolTable boogieSymbolTable) throws Throwable {
        Map<String, LTLPropertyCheck.CheckableExpression> map = this.parseAtomicPropositions(string, boogieSymbolTable);
        if (map.isEmpty()) {
            throw new IllegalArgumentException("No atomic propositions in " + string);
        }
        LinkedHashMap<String, LTLPropertyCheck.CheckableExpression> linkedHashMap = new LinkedHashMap<String, LTLPropertyCheck.CheckableExpression>();
        String string2 = string;
        int n = 0;
        for (Map.Entry<String, LTLPropertyCheck.CheckableExpression> entry : map.entrySet()) {
            String string3 = LTL2autObserver.getAPSymbol(n);
            ++n;
            string2 = string2.replaceAll(Pattern.quote(entry.getKey()), string3);
            linkedHashMap.put(string3, entry.getValue());
        }
        return new LTLPropertyCheck(string2, linkedHashMap, null);
    }

    private Map<String, LTLPropertyCheck.CheckableExpression> parseAtomicPropositions(String string, BoogieSymbolTable boogieSymbolTable) {
        LinkedHashMap<String, LTLPropertyCheck.CheckableExpression> linkedHashMap = new LinkedHashMap<String, LTLPropertyCheck.CheckableExpression>();
        int n = string.indexOf("AP(");
        while (n >= 0) {
            int n2;
            int n3 = n += "AP(".length();
            int n4 = 1;
            while (n4 > 0) {
                n2 = string.indexOf("(", n);
                int n5 = string.indexOf(")", n);
                assert (n2 >= 0 || n5 >= 0) : "Unmatched opening parenthesis";
                if (n2 >= 0 && n2 < n5) {
                    ++n4;
                    n = n2 + 1;
                    continue;
                }
                --n4;
                n = n5 + 1;
            }
            n2 = n - 1;
            String string2 = string.substring(n3, n2);
            LTLPropertyCheck.CheckableExpression checkableExpression = this.createCheckableExpression(string2, boogieSymbolTable);
            linkedHashMap.put("AP(" + string2 + ")", checkableExpression);
            n = string.indexOf("AP(", n);
        }
        return linkedHashMap;
    }

    private LTLPropertyCheck.CheckableExpression createCheckableExpression(String string, BoogieSymbolTable boogieSymbolTable) {
        String string2 = String.format("procedure main() { #thevar := %s ;}", string.trim());
        BoogieSymbolFactory boogieSymbolFactory = new BoogieSymbolFactory();
        Lexer lexer = new Lexer(IOUtils.toInputStream((String)string2));
        lexer.setSymbolFactory(boogieSymbolFactory);
        Parser parser = new Parser((Scanner)lexer, (SymbolFactory)boogieSymbolFactory);
        try {
            Unit unit = (Unit)parser.parse().value;
            Procedure procedure = (Procedure)unit.getDeclarations()[0];
            AssignmentStatement assignmentStatement = (AssignmentStatement)procedure.getBody().getBlock()[0];
            Expression expression = assignmentStatement.getRhs()[0];
            Expression expression2 = expression.accept((GeneratedBoogieAstTransformer)new TypeAdder(boogieSymbolTable));
            return new LTLPropertyCheck.CheckableExpression(expression2, Collections.emptyList());
        }
        catch (Exception exception) {
            this.mLogger.error((Object)String.format("Exception while parsing the atomic proposition \"%s\": %s", string, exception));
            throw new RuntimeException(exception);
        }
    }

    public static String getAPSymbol(int n) {
        if (n < ALPHABET.length()) {
            return String.valueOf(ALPHABET.charAt(n));
        }
        StringBuilder stringBuilder = new StringBuilder("A");
        int n2 = n;
        while (n2 > ALPHABET.length()) {
            stringBuilder.append(ALPHABET.charAt((n2 -= ALPHABET.length()) % ALPHABET.length()));
        }
        return stringBuilder.toString();
    }

    private String[] getLTLPropertyString() throws IOException {
        if (this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Read property from file") && this.mInputFile != null) {
            String[] stringArray = this.extractPropertyFromInputFile();
            if (stringArray.length > 0) {
                return stringArray;
            }
            throw new IllegalArgumentException("File " + this.mInputFile + " did not contain an LTL property");
        }
        this.mLogger.info((Object)"Using LTL properties from settings");
        String[] stringArray = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getString("Property to check").split("\n");
        if (stringArray.length > 0 && !stringArray[0].isEmpty()) {
            return stringArray;
        }
        throw new IllegalArgumentException("Settings did not contain an LTL property");
    }

    private String[] extractPropertyFromInputFile() throws IOException {
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.mInputFile));){
                while ((string = bufferedReader.readLine()) != null) {
                    if (!string.contains(LTL_MARKER)) continue;
                    arrayList.add(string.replaceFirst("//", "").replace(LTL_MARKER, "").trim());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            this.mLogger.error((Object)("Error while reading " + this.mInputFile + ": " + String.valueOf(iOException)));
            throw iOException;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private AstNode getNeverClaim(String string) throws Throwable {
        try {
            this.mLogger.debug((Object)"Parsing LTL property...");
            return new LTLXBAExecutor(this.mServices).ltl2Ast(string);
        }
        catch (Throwable throwable) {
            this.mLogger.fatal((Object)String.format("Exception during LTL->BA execution: %s", throwable));
            throw throwable;
        }
    }

    private INestedWordAutomaton<CodeBlock, String> createNWAFromNeverClaim(AstNode astNode, Map<String, LTLPropertyCheck.CheckableExpression> map, BoogieSymbolTable boogieSymbolTable, CodeBlockFactory codeBlockFactory) throws Exception {
        INestedWordAutomaton<CodeBlock, String> iNestedWordAutomaton;
        if (astNode == null) {
            throw new IllegalArgumentException("There is no never claim");
        }
        if (map == null) {
            throw new IllegalArgumentException("There are no CheckableExpressions");
        }
        if (boogieSymbolTable == null) {
            throw new IllegalArgumentException("The BoogieSymbolTable is missing");
        }
        if (codeBlockFactory == null) {
            throw new IllegalArgumentException("The CodeBlockFactory is missing. Did you run the RCFGBuilder before this plugin?");
        }
        this.mLogger.debug((Object)"Transforming NeverClaim to NestedWordAutomaton...");
        try {
            iNestedWordAutomaton = new Never2Automaton(astNode, boogieSymbolTable, map, this.mLogger, this.mServices, codeBlockFactory).getAutomaton();
            if (iNestedWordAutomaton == null) {
                throw new IllegalArgumentException("nwa is null");
            }
        }
        catch (Exception exception) {
            this.mLogger.fatal((Object)"LTL2Aut encountered an error while transforming the NeverClaim to a NestedWordAutomaton");
            throw exception;
        }
        return iNestedWordAutomaton;
    }

    public boolean performedChanges() {
        return false;
    }

    public boolean process(IElement iElement) throws Throwable {
        if (iElement instanceof Unit) {
            this.mInputFile = ((Unit)iElement).getLocation().getFileName();
            this.mCheck = LTLPropertyCheck.getAnnotation((IElement)iElement);
            this.mSymbolTable = PreprocessorAnnotation.getAnnotation((IElement)iElement).getSymbolTable();
            return false;
        }
        return true;
    }

    public NWAContainer getNWAContainer() {
        return this.mNWAContainer;
    }

    private static final class TypeAdder
    extends GeneratedBoogieAstTransformer {
        private Pair<String, Expression> mTypeError;
        private final BoogieSymbolTable mSymbolTable;

        public String toString() {
            return "Transformer that adds type information to atomic propositions";
        }

        public Pair<String, Expression> getTypeError() {
            return this.mTypeError;
        }

        public TypeAdder(BoogieSymbolTable boogieSymbolTable) {
            this.mSymbolTable = boogieSymbolTable;
        }

        public Expression transform(IntegerLiteral integerLiteral) {
            return ExpressionFactory.createIntegerLiteral((ILocation)integerLiteral.getLoc(), (String)integerLiteral.getValue());
        }

        public Expression transform(StringLiteral stringLiteral) {
            return ExpressionFactory.createStringLiteral((ILocation)stringLiteral.getLoc(), (String)stringLiteral.getValue());
        }

        public Expression transform(BooleanLiteral booleanLiteral) {
            return ExpressionFactory.createBooleanLiteral((ILocation)booleanLiteral.getLoc(), (boolean)booleanLiteral.getValue());
        }

        public Expression transform(RealLiteral realLiteral) {
            return ExpressionFactory.createRealLiteral((ILocation)realLiteral.getLoc(), (String)realLiteral.getValue());
        }

        public Expression transform(BitvecLiteral bitvecLiteral) {
            return ExpressionFactory.createBitvecLiteral((ILocation)bitvecLiteral.getLoc(), (String)bitvecLiteral.getValue(), (int)bitvecLiteral.getLength());
        }

        public Expression transform(IdentifierExpression identifierExpression) {
            IBoogieType iBoogieType = this.mSymbolTable.getTypeForVariableSymbol(identifierExpression.getIdentifier(), DeclarationInformation.StorageClass.GLOBAL, "GLOBAL");
            return new IdentifierExpression(identifierExpression.getLoc(), iBoogieType, identifierExpression.getIdentifier(), DeclarationInformation.DECLARATIONINFO_GLOBAL);
        }

        public Expression transform(BinaryExpression binaryExpression) {
            Expression expression = binaryExpression.getLeft().accept((GeneratedBoogieAstTransformer)this);
            Expression expression2 = binaryExpression.getRight().accept((GeneratedBoogieAstTransformer)this);
            try {
                return ExpressionFactory.newBinaryExpression((ILocation)binaryExpression.getLoc(), (BinaryExpression.Operator)binaryExpression.getOperator(), (Expression)expression, (Expression)expression2);
            }
            catch (TypeCheckException typeCheckException) {
                this.setTypeError(typeCheckException.getMessage(), (Expression)binaryExpression);
                return new IdentifierExpression(binaryExpression.getLoc(), (IBoogieType)BoogieType.TYPE_ERROR, "Error", DeclarationInformation.DECLARATIONINFO_GLOBAL);
            }
        }

        public Expression transform(IfThenElseExpression ifThenElseExpression) {
            Expression expression = ifThenElseExpression.getCondition().accept((GeneratedBoogieAstTransformer)this);
            Expression expression2 = ifThenElseExpression.getThenPart().accept((GeneratedBoogieAstTransformer)this);
            Expression expression3 = ifThenElseExpression.getElsePart().accept((GeneratedBoogieAstTransformer)this);
            try {
                return ExpressionFactory.constructIfThenElseExpression((ILocation)ifThenElseExpression.getLoc(), (Expression)expression, (Expression)expression2, (Expression)expression3);
            }
            catch (TypeCheckException typeCheckException) {
                this.setTypeError(typeCheckException.getMessage(), (Expression)ifThenElseExpression);
                return new IdentifierExpression(ifThenElseExpression.getLoc(), (IBoogieType)BoogieType.TYPE_ERROR, "Error", DeclarationInformation.DECLARATIONINFO_GLOBAL);
            }
        }

        public Expression transform(UnaryExpression unaryExpression) {
            Expression expression = unaryExpression.getExpr().accept((GeneratedBoogieAstTransformer)this);
            try {
                return ExpressionFactory.constructUnaryExpression((ILocation)unaryExpression.getLoc(), (UnaryExpression.Operator)unaryExpression.getOperator(), (Expression)expression);
            }
            catch (TypeCheckException typeCheckException) {
                this.setTypeError(typeCheckException.getMessage(), (Expression)unaryExpression);
                return new IdentifierExpression(unaryExpression.getLoc(), (IBoogieType)BoogieType.TYPE_ERROR, "Error", DeclarationInformation.DECLARATIONINFO_GLOBAL);
            }
        }

        public Expression transform(BitVectorAccessExpression bitVectorAccessExpression) {
            Expression expression = bitVectorAccessExpression.getBitvec().accept((GeneratedBoogieAstTransformer)this);
            try {
                return ExpressionFactory.constructBitvectorAccessExpression((ILocation)bitVectorAccessExpression.getLoc(), (Expression)expression, (int)bitVectorAccessExpression.getEnd(), (int)bitVectorAccessExpression.getStart());
            }
            catch (TypeCheckException typeCheckException) {
                this.setTypeError(typeCheckException.getMessage(), (Expression)bitVectorAccessExpression);
                return new IdentifierExpression(bitVectorAccessExpression.getLoc(), (IBoogieType)BoogieType.TYPE_ERROR, "Error", DeclarationInformation.DECLARATIONINFO_GLOBAL);
            }
        }

        public Expression transform(ArrayAccessExpression arrayAccessExpression) {
            Expression expression = arrayAccessExpression.getArray().accept((GeneratedBoogieAstTransformer)this);
            Expression[] expressionArray = arrayAccessExpression.getIndices();
            Expression[] expressionArray2 = new Expression[expressionArray.length];
            int n = 0;
            while (n < expressionArray.length) {
                expressionArray2[n] = expressionArray[n].accept((GeneratedBoogieAstTransformer)this);
                ++n;
            }
            try {
                return ExpressionFactory.constructNestedArrayAccessExpression((ILocation)arrayAccessExpression.getLoc(), (Expression)expression, (Expression[])expressionArray2);
            }
            catch (TypeCheckException typeCheckException) {
                this.setTypeError(typeCheckException.getMessage(), (Expression)arrayAccessExpression);
                return new IdentifierExpression(arrayAccessExpression.getLoc(), (IBoogieType)BoogieType.TYPE_ERROR, "Error", DeclarationInformation.DECLARATIONINFO_GLOBAL);
            }
        }

        public Expression transform(ArrayStoreExpression arrayStoreExpression) {
            Expression expression = arrayStoreExpression.getArray().accept((GeneratedBoogieAstTransformer)this);
            Expression[] expressionArray = arrayStoreExpression.getIndices();
            Expression expression2 = arrayStoreExpression.getValue().accept((GeneratedBoogieAstTransformer)this);
            Expression[] expressionArray2 = new Expression[expressionArray.length];
            int n = 0;
            while (n < expressionArray.length) {
                expressionArray2[n] = expressionArray[n].accept((GeneratedBoogieAstTransformer)this);
                ++n;
            }
            try {
                return ExpressionFactory.constructArrayStoreExpression((ILocation)arrayStoreExpression.getLoc(), (Expression)expression, (Expression[])expressionArray2, (Expression)expression2);
            }
            catch (TypeCheckException typeCheckException) {
                this.setTypeError(typeCheckException.getMessage(), (Expression)arrayStoreExpression);
                return new IdentifierExpression(arrayStoreExpression.getLoc(), (IBoogieType)BoogieType.TYPE_ERROR, "Error", DeclarationInformation.DECLARATIONINFO_GLOBAL);
            }
        }

        public Expression transform(StructAccessExpression structAccessExpression) {
            Expression expression = structAccessExpression.getStruct().accept((GeneratedBoogieAstTransformer)this);
            try {
                return ExpressionFactory.constructStructAccessExpression((ILocation)structAccessExpression.getLoc(), (Expression)expression, (String)structAccessExpression.getField());
            }
            catch (TypeCheckException typeCheckException) {
                this.setTypeError(typeCheckException.getMessage(), (Expression)structAccessExpression);
                return new IdentifierExpression(structAccessExpression.getLoc(), (IBoogieType)BoogieType.TYPE_ERROR, "Error", DeclarationInformation.DECLARATIONINFO_GLOBAL);
            }
        }

        private void setTypeError(String string, Expression expression) {
            if (this.mTypeError != null) {
                return;
            }
            this.mTypeError = new Pair((Object)string, (Object)expression);
        }
    }
}

