/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.core.lib.models.WrapperNode;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.boogie.SymbolTable;

public class SymbolTableTransformer
extends BoogieTransformer {
    protected final ILogger mLogger;
    protected SymbolTable mSymbolTable;
    protected String mCurrentScopeIdentifier;

    public SymbolTableTransformer(ILogger iLogger) {
        this.mLogger = iLogger;
        this.mSymbolTable = new SymbolTable();
        this.mCurrentScopeIdentifier = "";
    }

    public SymbolTable getSymbolTable() {
        return this.mSymbolTable;
    }

    public boolean process(IElement iElement) {
        if (iElement instanceof WrapperNode) {
            Declaration[] declarationArray;
            Unit unit = (Unit)((WrapperNode)iElement).getBacking();
            Declaration[] declarationArray2 = declarationArray = unit.getDeclarations();
            int n = declarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Declaration declaration = declarationArray2[n2];
                this.processDeclaration(declaration);
                ++n2;
            }
            return false;
        }
        return true;
    }

    protected Declaration processDeclaration(Declaration declaration) {
        if (declaration instanceof Procedure) {
            Procedure procedure = (Procedure)declaration;
            this.mCurrentScopeIdentifier = procedure.getIdentifier();
            this.addVariables(procedure.getInParams());
            this.addVariables(procedure.getOutParams());
        } else if (declaration instanceof VariableDeclaration) {
            this.mCurrentScopeIdentifier = "global";
            VariableDeclaration variableDeclaration = (VariableDeclaration)declaration;
            VarList[] varListArray = variableDeclaration.getVariables();
            int n = varListArray.length;
            int n2 = 0;
            while (n2 < n) {
                VarList varList = varListArray[n2];
                String[] stringArray = varList.getIdentifiers();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String string = stringArray[n4];
                    this.mSymbolTable.addGlobalVariable(string, varList.getType().getBoogieType());
                    ++n4;
                }
                ++n2;
            }
        }
        return super.processDeclaration(declaration);
    }

    protected Body processBody(Body body) {
        this.addVariables(body.getLocalVars());
        return super.processBody(body);
    }

    private void addVariables(VariableDeclaration[] variableDeclarationArray) {
        VariableDeclaration[] variableDeclarationArray2 = variableDeclarationArray;
        int n = variableDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableDeclaration variableDeclaration = variableDeclarationArray2[n2];
            this.addVariables(variableDeclaration.getVariables());
            ++n2;
        }
    }

    private void addVariables(VarList[] varListArray) {
        VarList[] varListArray2 = varListArray;
        int n = varListArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarList varList = varListArray2[n2];
            String[] stringArray = varList.getIdentifiers();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string = stringArray[n4];
                this.mSymbolTable.addLocalVariable(string, this.mCurrentScopeIdentifier, varList.getType().getBoogieType());
                ++n4;
            }
            ++n2;
        }
    }
}

