/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.localize;

import de.uni_freiburg.informatik.ultimate.lib.pea.BooleanDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Decision;
import de.uni_freiburg.informatik.ultimate.lib.pea.EventDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.Phase;
import de.uni_freiburg.informatik.ultimate.lib.pea.RangeDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.ZDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.PEA2TCSConverter;
import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.TCSWriter;
import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.localize.CollectFunctionsVisitor;
import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.localize.LocalizeException;
import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.localize.LocalizeZVisitor;
import de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking.localize.ProcessDeclarationsVisitor;
import de.uni_freiburg.informatik.ultimate.lib.pea.util.z.TermToZCDDVisitor;
import de.uni_freiburg.informatik.ultimate.lib.pea.util.z.ZTerm;
import de.uni_freiburg.informatik.ultimate.lib.pea.util.z.ZWrapper;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.czt.parser.util.ParseException;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.util.ZString;

public class LocalizeWriter
extends TCSWriter {
    private static final String FILENAME_TASK_SUFFIX = "_TASK";
    public static final String Z_DIV = "div";
    private static final String Z_INT_TYPE = ZString.NUM;
    public static final String Z_REAL_TYPE = "\u211d";
    private PC pcFlag = PC.NONE;
    private static final boolean CHECK_QUERY_AS_INVARIANT = true;
    private final Set<String> unprimedGlobalConstants = new HashSet<String>();
    private int fileCounter;
    private String fileNameSuffix = ".loc";
    private Map<String, Integer> freeTypes;
    private String localizeQuery;
    private String unicodeQuery;
    private Map<String, String> functionSymbols;
    private Map<String, Integer> arity;
    private Map<String, String> unchangedVarMap;
    FileWriter writer;
    private CollectFunctionsVisitor queryFunctions;
    private String queryClauses;
    private String currentIndent = "           ";
    private Map<String, String> zVariables;
    private boolean usePointerType;
    private Map<String, Integer> extensionLevels;
    private List<Integer> stableExts;
    private List<String> nullPointers;
    private final Map<String, String> nullPointerMap;
    private final String andDelimiter = ";\n";
    private Set<String> pcVars;
    private ArrayList<String> pcQuery;

    public LocalizeWriter(String string) {
        super(string);
        int n = string.lastIndexOf(46);
        this.mFileName = string.substring(0, n);
        this.fileNameSuffix = string.substring(n);
        this.functionSymbols = new HashMap<String, String>();
        this.arity = new HashMap<String, Integer>();
        this.unchangedVarMap = new HashMap<String, String>();
        this.fileCounter = 0;
        this.usePointerType = false;
        this.extensionLevels = new HashMap<String, Integer>();
        this.nullPointerMap = new HashMap<String, String>();
    }

    public LocalizeWriter(String string, Map<String, Integer> map, List<Integer> list, List<String> list2, String string2, PC pC, boolean bl) {
        this(string);
        this.unicodeQuery = string2.replace("\n", "\n           ");
        this.pcFlag = pC;
        this.usePointerType = bl;
        this.extensionLevels = map;
        this.stableExts = list;
        this.nullPointers = list2;
    }

    @Override
    public void write() {
        try {
            this.localizeQuery = null;
            this.fileCounter = 0;
            this.zVariables = this.mConverter.getVariables();
            PEA2TCSConverter.TransitionConstraint transitionConstraint = this.mConverter.getNextTransitionConstraint();
            this.transformTypes();
            this.buildNullPointerMap();
            this.addProgramCounter(transitionConstraint);
            this.processQuery();
            this.buildUnchangedVarMap();
            this.writeTransitions(transitionConstraint);
        }
        catch (IOException | InstantiationException | ParseException throwable) {
            throwable.printStackTrace();
        }
    }

    private void buildNullPointerMap() {
        if (this.usePointerType) {
            for (String string : this.nullPointers) {
                String string2 = this.zVariables.get(string).trim();
                if (string2 == null || this.freeTypes.get(string2) == null) {
                    throw new LocalizeException("Null pointer has no or wrong pointer type: " + string);
                }
                this.nullPointerMap.put(string, "null_" + String.valueOf(this.freeTypes.get(string2)));
            }
        }
    }

    public static String operatorFor(String string) {
        if (string.equals(ZString.EQUALS)) {
            return "=";
        }
        if (string.equals(ZString.LESS)) {
            return "<";
        }
        if (string.equals(ZString.GREATER)) {
            return ">";
        }
        if (string.equals(ZString.LEQ)) {
            return "<=";
        }
        if (string.equals(ZString.GEQ)) {
            return ">=";
        }
        return null;
    }

    @Override
    protected void writeAndDelimiter(Writer writer) throws IOException {
        writer.write(";\n");
    }

    @Override
    protected void writeDecision(Decision<?> decision, int n, Writer writer) throws IOException {
        this.writeDecision(decision, n, writer, true);
    }

    private void writeDecision(Decision<?> decision, int n, Writer writer, boolean bl) throws IOException {
        writer.append(this.currentIndent);
        if (decision instanceof RangeDecision) {
            String string = ((RangeDecision)decision).getVar();
            writer.append(string);
            int[] nArray = ((RangeDecision)decision).getLimits();
            if (n == 0) {
                if ((nArray[0] & 1) == 0) {
                    writer.append("<");
                } else {
                    writer.append("<=");
                }
                writer.append("_" + nArray[0] / 2);
                return;
            }
            if (n == nArray.length) {
                if ((nArray[nArray.length - 1] & 1) == 1) {
                    writer.append(">");
                } else {
                    writer.append(">=");
                }
                writer.append("_" + nArray[nArray.length - 1] / 2);
                return;
            }
            if (nArray[n - 1] / 2 == nArray[n] / 2) {
                writer.append(">");
                writer.append("_" + nArray[n] / 2);
                return;
            }
            if ((nArray[n - 1] & 1) == 1) {
                writer.append(">");
            } else {
                writer.append(">=");
            }
            writer.append("_" + nArray[n - 1] / 2);
            writer.append(",").append(string);
            if ((nArray[n] & 1) == 0) {
                writer.append("<");
            } else {
                writer.append("<=");
            }
            writer.append("_" + nArray[n] / 2);
            return;
        }
        if (n == 0) {
            if (decision instanceof BooleanDecision) {
                String string = ((BooleanDecision)decision).getVar();
                writer.append(string);
            } else if (decision instanceof EventDecision) {
                String string = ((EventDecision)decision).getEvent();
                writer.append(string + ">" + string + "'");
            } else if (decision instanceof ZDecision) {
                this.writeZDecision((ZDecision)decision, writer, bl);
            }
        } else if (decision instanceof BooleanDecision) {
            String string = ((BooleanDecision)decision).getVar();
            if (string.matches("(.+)<=(.+)")) {
                writer.append(string.replace("<=", ">"));
            } else if (string.matches("(.+)>=(.+)")) {
                writer.append(string.replace(">=", "<"));
            } else if (string.matches("(.+)<(.+)")) {
                writer.append(string.replace("<", ">="));
            } else if (string.matches("(.+)>(.+)")) {
                writer.append(string.replace(">", "=<"));
            } else {
                writer.append("NOT(" + string + ")");
            }
        } else if (decision instanceof EventDecision) {
            String string = ((EventDecision)decision).getEvent();
            writer.append(string + " = " + string + "'");
        } else if (decision instanceof ZDecision) {
            this.writeZDecision(((ZDecision)decision).negate(), writer, bl);
        }
    }

    protected void writeDeclarations(PEA2TCSConverter.TransitionConstraint transitionConstraint) throws IOException, ParseException, InstantiationException {
        Object object;
        Object object2;
        Object object4;
        this.writer.write("\n% " + this.mConverter.getName() + "\n\n");
        CollectFunctionsVisitor collectFunctionsVisitor = new CollectFunctionsVisitor(this.functionSymbols);
        HashSet<String> hashSet = new HashSet<String>();
        this.collectFunctionsFromCDDCached(transitionConstraint.getConstraint(), collectFunctionsVisitor, hashSet);
        this.writer.write("Base_functions:={");
        Set<String> set = collectFunctionsVisitor.getBaseFunctions();
        set.addAll(this.queryFunctions.getBaseFunctions());
        Object object5 = set.iterator();
        while (object5.hasNext()) {
            this.writer.write("(" + this.replaceZSymbols(object5.next()) + ", 2)");
            if (!object5.hasNext()) continue;
            this.writer.write(", ");
        }
        this.writer.write("}\n");
        object5 = collectFunctionsVisitor.getExtFunctions();
        this.writer.write("Extension_functions:={");
        object5.putAll(this.queryFunctions.getExtFunctions());
        HashSet<String> hashSet2 = new HashSet<String>();
        Object object6 = object5.keySet().iterator();
        while (object6.hasNext()) {
            object4 = (String)object6.next();
            String object32 = ((String)object4).replaceAll(ZString.PRIME, "");
            if (this.arity.get(object32) == 0) {
                hashSet2.add((String)object4);
                continue;
            }
            if (((String)object4).contains(ZString.PRIME) && this.unprimedGlobalConstants.contains(object32)) {
                if (object5.containsKey(object32)) continue;
                object2 = this.extensionLevels.get(object32);
                object = this.replaceZSymbols(object32);
            } else {
                object2 = this.extensionLevels.get(object4);
                object = this.replaceZSymbols((String)object4);
            }
            if (object2 == null) {
                throw new LocalizeException("Extension level not defined: " + (String)object4);
            }
            if (((String)object).startsWith("_")) {
                object = ((String)object).substring(1);
            }
            this.writer.write("(" + (String)object + "," + String.valueOf(this.arity.get(object32)) + "," + String.valueOf(object2) + "," + (String)object5.get(object4) + ")");
            if (!object6.hasNext()) continue;
            this.writer.write(", ");
        }
        this.writer.write("}\n");
        this.writer.write("Relations:={");
        object6 = collectFunctionsVisitor.getRelations();
        object6.addAll(this.queryFunctions.getRelations());
        object4 = object6.iterator();
        while (object4.hasNext()) {
            this.writer.write("(" + this.replaceZSymbols((String)object4.next()) + ", 2)");
            if (!object4.hasNext()) continue;
            this.writer.write(", ");
        }
        this.writer.write("}\n");
        this.writer.write("Constants:={");
        boolean bl = true;
        for (String string : hashSet2) {
            String string2 = string.replace(ZString.PRIME, "");
            if (this.nullPointerMap.containsKey(string)) {
                object2 = this.nullPointerMap.get(string);
            } else if (this.nullPointerMap.containsKey(string2)) {
                if (hashSet2.contains(string2)) continue;
                object2 = this.nullPointerMap.get(string2);
            } else {
                if (string.contains(ZString.PRIME) && this.unprimedGlobalConstants.contains(string2)) {
                    if (hashSet2.contains(string2)) continue;
                    object2 = this.replaceZSymbols(string2);
                } else {
                    object2 = this.replaceZSymbols(string);
                }
                if (((String)object2).startsWith("_")) {
                    object2 = ((String)object2).substring(1);
                }
            }
            if (!bl) {
                this.writer.write(", ");
            } else {
                bl = false;
            }
            this.writer.write("(" + (String)object2 + "," + (String)object5.get(string) + ")");
        }
        if (PC.SINGLE.equals((Object)this.pcFlag)) {
            String string = transitionConstraint.getSource().replace("_X_", "XXX");
            object = transitionConstraint.getDest().replace("_X_", "XXX");
            this.writer.write("(" + string + ", int), (" + (String)object + ", int)");
        }
        this.writer.write("}\n");
        if (this.stableExts != null && !this.stableExts.isEmpty()) {
            this.writer.write("Stable:=");
            Iterator<Integer> iterator = this.stableExts.iterator();
            while (iterator.hasNext()) {
                this.writer.write(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                this.writer.write(",");
            }
            this.writer.write(";\n\n");
        }
    }

    protected void writeClauseToWriter(CDD cDD, Writer writer) {
        ArrayList arrayList = new ArrayList();
        ArrayList<CDD> arrayList2 = new ArrayList<CDD>();
        CDD[] cDDArray = cDD.toDNF();
        try {
            this.currentIndent = "";
            if (cDDArray.length <= 1) {
                if (cDD.getChilds()[0] == CDD.TRUE) {
                    this.writeDecision(cDD.getDecision(), 0, writer);
                } else {
                    this.writeDecision(cDD.getDecision(), 1, writer);
                }
                return;
            }
            try {
                Object object;
                CDD[] cDDArray2 = cDDArray;
                int n = cDDArray.length;
                int n2 = 0;
                while (n2 < n) {
                    object = cDDArray2[n2];
                    if (((CDD)object).getChilds().length <= 0 || !(((CDD)object).getDecision() instanceof ZDecision)) {
                        throw new LocalizeException("Unexpected term in Localize export: " + String.valueOf(object));
                    }
                    if (((CDD)object).getChilds()[0] == CDD.TRUE) {
                        arrayList.add(object);
                    } else {
                        arrayList2.add(((CDD)object).negate());
                    }
                    ++n2;
                }
                object = arrayList2.iterator();
                while (object.hasNext()) {
                    CDD cDD2 = (CDD)object.next();
                    this.writeDecision(cDD2.getDecision(), 0, writer);
                    if (!object.hasNext()) continue;
                    writer.write(", ");
                }
                writer.append(" --> ");
                object = arrayList.iterator();
                while (object.hasNext()) {
                    CDD cDD3 = (CDD)object.next();
                    this.writeDecision(cDD3.getDecision(), 0, writer);
                    if (!object.hasNext()) continue;
                    writer.write(", ");
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        finally {
            this.currentIndent = "           ";
        }
    }

    protected void writeClauseAsDisjunction(CDD cDD, Writer writer) {
        CDD[] cDDArray = cDD.toDNF();
        try {
            this.currentIndent = "";
            if (cDDArray.length == 1) {
                if (cDD.getChilds()[0] == CDD.TRUE) {
                    this.writeDecision(cDD.getDecision(), 0, writer, false);
                } else {
                    this.writeDecision(cDD.getDecision(), 1, writer, false);
                }
                return;
            }
            try {
                writer.append("OR(");
                int n = 0;
                while (n < cDDArray.length) {
                    if (cDDArray[n].getChilds().length <= 0 || !(cDDArray[n].getDecision() instanceof ZDecision)) {
                        throw new LocalizeException("Unexpected term in Localize export: " + String.valueOf(cDDArray[n]));
                    }
                    if (cDDArray[n].getChilds()[0] == CDD.TRUE) {
                        this.writeDecision(cDDArray[n].getDecision(), 0, writer, false);
                    } else {
                        writer.append("NOT(");
                        this.writeDecision(cDDArray[n].getDecision(), 0, writer, false);
                        writer.append(")");
                    }
                    if (n + 1 < cDDArray.length) {
                        writer.append(", ");
                    }
                    ++n;
                }
                writer.append(")");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        finally {
            this.currentIndent = "           ";
        }
    }

    @Override
    protected CDD processDeclarations(List<String> list, Map<String, String> map) {
        if (list != null) {
            Object object = "";
            for (String object2 : list) {
                object = (String)object + object2 + "\n";
            }
            try {
                ZTerm zTerm = ZWrapper.INSTANCE.declToTerm((String)object);
                ProcessDeclarationsVisitor processDeclarationsVisitor = new ProcessDeclarationsVisitor(zTerm);
                Map map2 = (Map)zTerm.getTerm().accept((Visitor)processDeclarationsVisitor);
                this.freeTypes = processDeclarationsVisitor.getFreeTypes();
                if (map2 != null && map2.keySet() != null) {
                    map.putAll(map2);
                    this.unprimedGlobalConstants.addAll(map2.keySet());
                }
                return processDeclarationsVisitor.getInvariant();
            }
            catch (InstantiationException | ParseException throwable) {
                throwable.printStackTrace();
                throw new LocalizeException("Error while parsing declaration: " + (String)object);
            }
        }
        return CDD.TRUE;
    }

    private void collectFunctionsFromCDD(CDD cDD, CollectFunctionsVisitor collectFunctionsVisitor) throws ParseException, InstantiationException {
        this.collectFunctionsFromCDDCached(cDD, collectFunctionsVisitor, null);
    }

    private void collectFunctionsFromCDDCached(CDD cDD, CollectFunctionsVisitor collectFunctionsVisitor, Set<String> set) throws ParseException, InstantiationException {
        Object object;
        Object object2;
        if (cDD == CDD.TRUE || cDD == CDD.FALSE) {
            return;
        }
        if (cDD.getDecision() instanceof ZDecision) {
            object2 = (ZDecision)cDD.getDecision();
            if (set == null || !set.contains(((ZDecision)object2).getPredicate())) {
                object = ZWrapper.INSTANCE.predicateToTerm(((ZDecision)object2).getPredicate());
                ((ZTerm)object).getTerm().accept((Visitor)collectFunctionsVisitor);
                if (set != null) {
                    set.add(((ZDecision)object2).getPredicate());
                }
            }
        }
        if (cDD.getDecision() instanceof RangeDecision && !(object2 = collectFunctionsVisitor.getExtFunctions()).containsKey(object = ((RangeDecision)cDD.getDecision()).getVar())) {
            object2.put(object, "real");
        }
        int n = 0;
        while (n < cDD.getChilds().length) {
            if (cDD.getChilds()[n] != CDD.FALSE && cDD.getChilds()[n] != CDD.TRUE) {
                this.collectFunctionsFromCDDCached(cDD.getChilds()[n], collectFunctionsVisitor, set);
            }
            ++n;
        }
    }

    private String replaceZSymbols(String string) {
        string = string.replaceAll(ZString.PRIME, "'");
        string = string.replace(ZString.MINUS, "-");
        string = string.replace(Z_DIV, "/");
        return string.replace(ZString.AND, ", ");
    }

    private void transformTypes() throws ParseException, InstantiationException {
        this.functionSymbols = new HashMap<String, String>();
        this.arity = new HashMap<String, Integer>();
        for (String string : this.zVariables.keySet()) {
            Object object;
            String[] stringArray = this.zVariables.get(string).split(ZString.FUN);
            if (stringArray.length == 0) {
                throw new LocalizeException("Type not supported by Localize export: " + this.zVariables.get(string));
            }
            String[] stringArray2 = stringArray[0].split(ZString.CROSS);
            if (stringArray2.length == 0) {
                throw new LocalizeException("Type not supported by Localize export: " + this.zVariables.get(string));
            }
            String string2 = stringArray2[0].trim();
            if (!Pattern.matches("[a-zA-Z_0-9\u2124\u211d]*", string2)) {
                throw new LocalizeException("Type not supported by Localize export: " + this.zVariables.get(string));
            }
            int n = 1;
            while (n < stringArray2.length) {
                if (!stringArray2[n].equals(string2)) {
                    throw new LocalizeException("Type not supported by Localize export: " + this.zVariables.get(string));
                }
                ++n;
            }
            String string3 = "";
            if (stringArray.length > 1 && !Pattern.matches("[a-zA-Z_0-9\u2124\u211d]*", string3 = stringArray[1].trim())) {
                throw new LocalizeException("Type not supported by Localize export: " + this.zVariables.get(string));
            }
            if (!(Z_REAL_TYPE.equals(string2) || string2.equals(Z_INT_TYPE) || this.freeTypes.containsKey(string2))) {
                throw new LocalizeException("Type not declared as basic type (in Z type definitions): " + string2);
            }
            if (!("".equals(string3) || Z_REAL_TYPE.equals(string3) || string3.equals(Z_INT_TYPE) || this.freeTypes.containsKey(string3))) {
                throw new LocalizeException("Type not declared as basic type (in Z type definitions): " + string3);
            }
            if (Z_REAL_TYPE.equals(string2)) {
                object = "real";
            } else if (string2.equals(Z_INT_TYPE)) {
                object = "int";
            } else if (this.freeTypes.containsKey(string2)) {
                object = this.usePointerType ? "pointer#" + String.valueOf(this.freeTypes.get(string2)) : "free#" + String.valueOf(this.freeTypes.get(string2));
            } else {
                throw new LocalizeException("Type not supported by Localize export: " + string2);
            }
            if (!"".equals(string3)) {
                Object object2;
                if (Z_REAL_TYPE.equals(string3)) {
                    object2 = "real";
                } else if (string3.equals(Z_INT_TYPE)) {
                    object2 = "int";
                } else if (this.freeTypes.containsKey(string3)) {
                    object2 = this.usePointerType ? "pointer#" + String.valueOf(this.freeTypes.get(string3)) : "free#" + String.valueOf(this.freeTypes.get(string3));
                } else {
                    throw new LocalizeException("Type not supported by Localize export: " + string3);
                }
                this.functionSymbols.put(string, (String)object + "," + (String)object2);
                this.arity.put(string, n);
                continue;
            }
            this.functionSymbols.put(string, (String)object);
            this.arity.put(string, 0);
        }
    }

    private void addProgramCounter(PEA2TCSConverter.TransitionConstraint transitionConstraint) {
        if (PC.SINGLE.equals((Object)this.pcFlag)) {
            this.functionSymbols.put("pc", "int");
            this.arity.put("pc", 0);
            this.functionSymbols.put("pc" + ZString.PRIME, "int");
            this.arity.put("pc" + ZString.PRIME, 0);
        } else if (PC.MULTIPLE.equals((Object)this.pcFlag)) {
            this.pcVars = new HashSet<String>();
            int n = 0;
            List<Phase> list = this.mConverter.getPEA().getPhases();
            for (Phase phase : list) {
                String[] stringArray = phase.getName().split("_X_");
                if (n == 0) {
                    n = stringArray.length;
                } else if (stringArray.length != n) {
                    throw new LocalizeException("Error found in location names: " + phase.getName());
                }
                String[] stringArray2 = stringArray;
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string = stringArray2[n3];
                    if (!this.pcVars.contains(string)) {
                        this.pcVars.add(string);
                        this.functionSymbols.put(string, "int");
                        this.unprimedGlobalConstants.add(string);
                        this.arity.put(string, 0);
                    }
                    ++n3;
                }
            }
            int n4 = 0;
            while (n4 < n) {
                this.functionSymbols.put("pc" + n4, "int");
                this.arity.put("pc" + n4, 0);
                this.functionSymbols.put("pc" + n4 + ZString.PRIME, "int");
                this.arity.put("pc" + n4 + ZString.PRIME, 0);
                ++n4;
            }
        }
    }

    private void writeClausesToFile(PEA2TCSConverter.TransitionConstraint transitionConstraint) throws IOException {
        this.writer.write("Clauses :=\n");
        this.writeConjunction(transitionConstraint.getConstraint(), this.writer);
        this.writer.write(this.queryClauses);
        this.writer.write("\n");
    }

    private void writeQuery() throws IOException {
        try {
            if (this.localizeQuery == null) {
                this.processQuery();
            }
            this.writer.write("Formulas :=\n");
            this.writer.write(this.localizeQuery);
            this.writer.write("\n");
            this.writer.write("\n");
        }
        catch (InstantiationException | ParseException throwable) {
            throwable.printStackTrace();
        }
    }

    private void processGeneralQuery() throws ParseException, InstantiationException, IOException {
        Object object;
        CDD[] cDDArray;
        ZTerm zTerm = ZWrapper.INSTANCE.predicateToTerm(this.unicodeQuery);
        TermToZCDDVisitor termToZCDDVisitor = new TermToZCDDVisitor(zTerm);
        CDD cDD = (CDD)zTerm.getTerm().accept((Visitor)termToZCDDVisitor);
        StringWriter stringWriter = new StringWriter();
        StringWriter stringWriter2 = new StringWriter();
        CDD[] cDDArray2 = cDDArray = cDD.toCNF();
        int n = cDDArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            object = cDDArray2[n2];
            if (((CDD)object).getDecision() instanceof ZDecision && (string = ((ZDecision)((CDD)object).getDecision()).getPredicate()).trim().startsWith(ZString.ALL)) {
                stringWriter2.write("           ");
                this.writeZDecision((ZDecision)((CDD)object).getDecision(), stringWriter2, true);
                stringWriter2.write(";\n");
            } else {
                stringWriter.write("           ");
                this.writeClauseToWriter((CDD)object, stringWriter);
                stringWriter.write(";\n");
            }
            ++n2;
        }
        this.localizeQuery = stringWriter.toString();
        this.queryClauses = stringWriter2.toString();
        this.queryFunctions = new CollectFunctionsVisitor(this.functionSymbols);
        object = new HashSet();
        this.collectFunctionsFromCDDCached(cDD, this.queryFunctions, (Set<String>)object);
    }

    private void processQuery() throws ParseException, InstantiationException, IOException {
        this.processInvariantQuery();
    }

    private void processInvariantQuery() throws ParseException, InstantiationException, IOException {
        Object object;
        CDD[] cDDArray;
        ZTerm zTerm = ZWrapper.INSTANCE.predicateToTerm(this.unicodeQuery);
        TermToZCDDVisitor termToZCDDVisitor = new TermToZCDDVisitor(zTerm);
        CDD cDD = (CDD)zTerm.getTerm().accept((Visitor)termToZCDDVisitor);
        StringWriter stringWriter = new StringWriter();
        StringWriter stringWriter2 = new StringWriter();
        this.writeConjunction(cDD, stringWriter);
        CDD cDD2 = cDD.prime(Collections.emptySet()).negate();
        CDD[] cDDArray2 = cDDArray = cDD2.toCNF();
        int n = cDDArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = cDDArray2[n2];
            stringWriter2.append("           ");
            this.writeClauseAsDisjunction((CDD)object, stringWriter2);
            stringWriter2.append(";\n\n");
            ++n2;
        }
        this.queryClauses = "\n           % Invariant\n" + stringWriter.toString();
        this.localizeQuery = stringWriter2.toString();
        this.queryFunctions = new CollectFunctionsVisitor(this.functionSymbols);
        object = new HashSet();
        this.collectFunctionsFromCDDCached(cDD2, this.queryFunctions, (Set<String>)object);
        this.collectFunctionsFromCDDCached(cDD, this.queryFunctions, (Set<String>)object);
        if (PC.MULTIPLE.equals((Object)this.pcFlag)) {
            this.pcQuery = new ArrayList();
            for (String string : this.queryFunctions.getExtFunctions().keySet()) {
                if (!this.pcVars.contains(string)) continue;
                this.pcQuery.add(string);
            }
        }
    }

    private void writeTransitions(PEA2TCSConverter.TransitionConstraint transitionConstraint) throws IOException, ParseException, InstantiationException {
        while (transitionConstraint != null) {
            this.writer = new FileWriter(this.mFileName + FILENAME_TASK_SUFFIX + this.fileCounter++ + this.fileNameSuffix);
            PEA2TCSConverter.TransitionConstraint transitionConstraint2 = this.addPC2Constraint(transitionConstraint);
            this.writeDeclarations(transitionConstraint2);
            this.writeClausesToFile(transitionConstraint2);
            this.writeQuery();
            this.writer.flush();
            this.writer.close();
            transitionConstraint = this.mConverter.getNextTransitionConstraint();
        }
    }

    private PEA2TCSConverter.TransitionConstraint addPC2Constraint(PEA2TCSConverter.TransitionConstraint transitionConstraint) {
        if (transitionConstraint.getSource().contains("XXX")) {
            throw new LocalizeException("Usage of reserved Localize strings; do not use 'XXX' and '_' in names: " + transitionConstraint.getSource());
        }
        if (transitionConstraint.getDest().contains("XXX")) {
            throw new LocalizeException("Usage of reserved Localize strings; do not use 'XXX' and '_' in names: " + transitionConstraint.getDest());
        }
        CDD cDD = transitionConstraint.getConstraint();
        if (PC.SINGLE.equals((Object)this.pcFlag)) {
            String string = transitionConstraint.getSource().replace("_X_", "XXX");
            String string2 = transitionConstraint.getDest().replace("_X_", "XXX");
            if (string.contains("_")) {
                throw new LocalizeException("Usage of reserved Localize strings; do not use 'XXX' and '_' in names: " + transitionConstraint.getSource());
            }
            if (string2.contains("_")) {
                throw new LocalizeException("Usage of reserved Localize strings; do not use 'XXX' and '_' in names: " + transitionConstraint.getDest());
            }
            cDD = cDD.and(ZDecision.create("pc" + ZString.EQUALS + string));
            cDD = cDD.and(ZDecision.create("pc" + ZString.PRIME + ZString.EQUALS + string2));
        } else if (PC.MULTIPLE.equals((Object)this.pcFlag)) {
            String[] stringArray;
            String[] stringArray2 = transitionConstraint.getSource().split("_X_");
            if (stringArray2.length != (stringArray = transitionConstraint.getDest().split("_X_")).length) {
                throw new LocalizeException("Error found in location names: " + transitionConstraint.getSource() + " or " + transitionConstraint.getDest());
            }
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray2[n].contains("_")) {
                    throw new LocalizeException("Usage of reserved Localize strings; do not use 'XXX' and '_' in names: " + transitionConstraint.getSource());
                }
                if (stringArray[n].contains("_")) {
                    throw new LocalizeException("Usage of reserved Localize strings; do not use 'XXX' and '_' in names: " + transitionConstraint.getDest());
                }
                String string = "pc" + n;
                String string3 = "pc" + n + ZString.PRIME;
                if (this.queryFunctions.getExtFunctions().containsKey(string)) {
                    cDD = cDD.and(ZDecision.create(string + ZString.EQUALS + stringArray2[n]));
                    for (String string4 : this.pcQuery) {
                        if (string4.equals(stringArray2[n])) continue;
                        cDD = cDD.and(ZDecision.create(string4 + ZString.EQUALS + stringArray2[n]).negate());
                    }
                }
                if (this.queryFunctions.getExtFunctions().containsKey(string3)) {
                    cDD = cDD.and(ZDecision.create(string3 + ZString.EQUALS + stringArray[n]));
                    for (String string4 : this.pcQuery) {
                        if (string4.equals(stringArray[n])) continue;
                        cDD = cDD.and(ZDecision.create(string4 + ZString.EQUALS + stringArray[n]).negate());
                    }
                }
                ++n;
            }
        } else if (PC.NONE.equals((Object)this.pcFlag)) {
            return transitionConstraint;
        }
        return new PEA2TCSConverter.TransitionConstraint(cDD, transitionConstraint.getSource(), transitionConstraint.getDest());
    }

    private void writeZDecision(ZDecision zDecision, Writer writer, boolean bl) {
        try {
            ZTerm zTerm = ZWrapper.INSTANCE.predicateToTerm(zDecision.getPredicate());
            LocalizeZVisitor localizeZVisitor = new LocalizeZVisitor(zTerm, this.unprimedGlobalConstants, this.functionSymbols, this.freeTypes, this.nullPointerMap, this, bl);
            String string = this.replaceZSymbols(((StringBuffer)zTerm.getTerm().accept((Visitor)localizeZVisitor)).toString());
            if (this.unchangedVarMap.containsKey(string)) {
                writer.write(this.unchangedVarMap.get(string));
            } else {
                writer.write(string);
            }
        }
        catch (IOException | InstantiationException | ParseException throwable) {
            throwable.printStackTrace();
        }
    }

    private void buildUnchangedVarMap() {
        this.unchangedVarMap = new HashMap<String, String>();
        for (String string : this.functionSymbols.keySet()) {
            if (!this.arity.containsKey(string)) {
                throw new LocalizeException("Type not declared as basic type (in Z type definitions): " + string);
            }
            int n = this.arity.get(string);
            if (n <= 0) continue;
            String string2 = string + "'=" + string;
            StringBuilder stringBuilder = new StringBuilder("(").append("FORALL");
            Object object = "(";
            int n2 = 0;
            while (n2 < n) {
                stringBuilder.append(" x").append(n2);
                object = (String)object + "x" + n2;
                if (++n2 < n) {
                    stringBuilder.append(",");
                    object = (String)object + ",";
                    continue;
                }
                stringBuilder.append(")").append(". ");
                object = (String)object + ")";
            }
            stringBuilder.append(string).append("'").append((String)object).append("=").append(string).append((String)object);
            this.unchangedVarMap.put(string2, stringBuilder.toString());
        }
    }

    public static class LocalizeString {
        public static final String DIV = "/";
        public static final String EQUALS = "=";
        public static final String FREETYPE = "free#";
        public static final String POINTERTYPE = "pointer#";
        public static final String GEQ = ">=";
        public static final String GREATER = ">";
        public static final String INT = "int";
        public static final String LEQ = "<=";
        public static final String LESS = "<";
        public static final String INDENT = "           ";
        public static final String LPAREN = "(";
        public static final String MINUS = "-";
        public static final String NOT = "NOT";
        public static final String AND = "AND";
        public static final String OR = "OR";
        public static final String NUMPREFIX = "_";
        public static final String PRIME = "'";
        public static final String REAL = "real";
        public static final String RPAREN = ")";
        public static final String SEPARATOR = "XXX";
        public static final String SEQUENT = " --> ";
        public static final String FORALL = "FORALL";
        public static final String NULLPOINTER = "null_";
    }

    public static enum PC {
        NONE,
        SINGLE,
        MULTIPLE;

    }
}

