/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.automataminimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.RemoveUnreachable;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwaDd;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeDfaHopcroftArrays;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeDfaHopcroftLists;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaCombinator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaMaxSat2;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaMulti;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaOverapproximation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaPattern;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeNwaPmaxSatDirectBi;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeSevpa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.ShrinkNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.arrays.MinimizeNwaMaxSAT;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.delayed.BuchiReduce;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.delayed.nwa.ReduceNwaDelayedSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.direct.nwa.ReduceNwaDirectSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair.ReduceBuchiFairDirectSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.fair.ReduceBuchiFairSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.multipebble.ReduceNwaDelayedFullMultipebbleSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.multipebble.ReduceNwaDirectFullMultipebbleSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.summarycomputationgraph.ReduceNwaDelayedSimulationB;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.summarycomputationgraph.ReduceNwaDirectSimulationB;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryResultChecking;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.TraceAbstractionUtils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.automataminimization.AutomataMinimizationStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TraceAbstractionPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

public class AutomataMinimization<LCS, LCSP extends IPredicate, LETTER> {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final MinimizationResult mMinimizationResult;
    private final IDoubleDeckerAutomaton<LETTER, IPredicate> mMinimizedAutomaton;
    private final Map<IPredicate, IPredicate> mOldState2newState;
    private final AutomataMinimizationStatisticsGenerator mStatistics;
    private static final long DEFAULT_TIMEOUT_FOR_EXPENSIVE_NWA_MINIMIZATIONS = 5000L;

    public <SF extends IMinimizationStateFactory<IPredicate> & INwaInclusionStateFactory<IPredicate>> AutomataMinimization(IUltimateServiceProvider iUltimateServiceProvider, INestedWordAutomaton<LETTER, IPredicate> iNestedWordAutomaton, TraceAbstractionPreferenceInitializer.Minimization minimization, boolean bl, int n, SF SF, int n2, Collection<INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate>> collection, INestedWordAutomaton<LETTER, IPredicate> iNestedWordAutomaton2, int n3, PredicateFactoryResultChecking predicateFactoryResultChecking, Function<LCSP, LCS> function, boolean bl2) throws AutomataMinimizationTimeout {
        long l;
        block10: {
            this.mServices = iUltimateServiceProvider;
            this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
            l = System.nanoTime();
            PartitionBackedSetOfPairs<IPredicate> partitionBackedSetOfPairs = TraceAbstractionUtils.computePartition(iNestedWordAutomaton, this.mLogger, function);
            AutomataLibraryServices automataLibraryServices = new AutomataLibraryServices(iUltimateServiceProvider);
            try {
                this.mMinimizationResult = this.doMinimizationOperation(iNestedWordAutomaton, minimization, bl, n, SF, n2, collection, iNestedWordAutomaton2, n3, partitionBackedSetOfPairs, automataLibraryServices, bl2);
                if (this.mMinimizationResult.wasNewAutomatonBuilt()) {
                    try {
                        assert (this.mMinimizationResult.getRawMinimizationOutput().checkResult((IMinimizationCheckResultStateFactory)predicateFactoryResultChecking)) : "incorrect minimization result for " + String.valueOf((Object)minimization);
                    }
                    catch (AutomataOperationCanceledException automataOperationCanceledException) {
                        throw automataOperationCanceledException;
                    }
                    catch (AutomataLibraryException automataLibraryException) {
                        throw new AssertionError((Object)automataLibraryException);
                    }
                    Object object = this.mMinimizationResult.getRawMinimizationOutput() instanceof AbstractMinimizeNwaDd ? (IDoubleDeckerAutomaton)this.mMinimizationResult.getRawMinimizationOutput().getResult() : new RemoveUnreachable(new AutomataLibraryServices(iUltimateServiceProvider), (INwaOutgoingLetterAndTransitionProvider)this.mMinimizationResult.getRawMinimizationOutput().getResult()).getResult();
                    if (bl) {
                        if (!this.mMinimizationResult.getRawMinimizationOutput().hasOldState2newState()) {
                            throw new AssertionError((Object)("Hoare annotation and " + String.valueOf((Object)minimization) + " incompatible"));
                        }
                        AbstractMinimizeNwa abstractMinimizeNwa = this.mMinimizationResult.getRawMinimizationOutput();
                        this.mOldState2newState = abstractMinimizeNwa.getOldState2newState();
                    } else {
                        this.mOldState2newState = null;
                    }
                    this.mMinimizedAutomaton = object;
                    break block10;
                }
                this.mMinimizedAutomaton = null;
                this.mOldState2newState = null;
            }
            catch (AutomataOperationCanceledException automataOperationCanceledException) {
                long l2 = System.nanoTime() - l;
                this.mStatistics = new AutomataMinimizationStatisticsGenerator(l2, true, false, 0L);
                throw new AutomataMinimizationTimeout(automataOperationCanceledException, this.mStatistics);
            }
        }
        long l3 = this.mMinimizationResult.wasNewAutomatonBuilt() ? (long)(iNestedWordAutomaton.size() - this.mMinimizedAutomaton.size()) : 0L;
        long l4 = System.nanoTime() - l;
        this.mStatistics = new AutomataMinimizationStatisticsGenerator(l4, this.mMinimizationResult.wasMinimizationAttempted(), l3 > 0L, l3);
    }

    private <SF extends IMinimizationStateFactory<IPredicate> & INwaInclusionStateFactory<IPredicate>> MinimizationResult doMinimizationOperation(INestedWordAutomaton<LETTER, IPredicate> iNestedWordAutomaton, TraceAbstractionPreferenceInitializer.Minimization minimization, boolean bl, int n, SF SF, int n2, Collection<INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate>> collection, INestedWordAutomaton<LETTER, IPredicate> iNestedWordAutomaton2, int n3, PartitionBackedSetOfPairs<IPredicate> partitionBackedSetOfPairs, AutomataLibraryServices automataLibraryServices, boolean bl2) throws AutomataOperationCanceledException, AssertionError {
        return switch (minimization) {
            case TraceAbstractionPreferenceInitializer.Minimization.MINIMIZE_SEVPA -> new MinimizationResult(true, true, new MinimizeSevpa(automataLibraryServices, SF, iNestedWordAutomaton, partitionBackedSetOfPairs, bl, bl2));
            case TraceAbstractionPreferenceInitializer.Minimization.SHRINK_NWA -> new MinimizationResult(true, true, new ShrinkNwa(automataLibraryServices, SF, iNestedWordAutomaton, partitionBackedSetOfPairs, bl, false, false, 200, false, 0, false, false, true, bl2));
            case TraceAbstractionPreferenceInitializer.Minimization.NWA_COMBINATOR_PATTERN -> {
                MinimizeNwaPattern var14_16 = new MinimizeNwaPattern(automataLibraryServices, SF, (IDoubleDeckerAutomaton)iNestedWordAutomaton, partitionBackedSetOfPairs, bl, n);
                boolean var15_25 = var14_16 != iNestedWordAutomaton;
                yield new MinimizationResult(true, var15_25, var14_16);
            }
            case TraceAbstractionPreferenceInitializer.Minimization.NWA_COMBINATOR_EVERY_KTH -> {
                MinimizeNwaPattern var14_17 = new MinimizeNwaPattern(automataLibraryServices, SF, (IDoubleDeckerAutomaton)iNestedWordAutomaton, partitionBackedSetOfPairs, bl, n2, n);
                boolean var15_26 = var14_17 != iNestedWordAutomaton;
                MinimizationResult var13_14 = new MinimizationResult(true, var15_26, var14_17);
                throw new UnsupportedOperationException("currently unsupported - check minimizaton attempt");
            }
            case TraceAbstractionPreferenceInitializer.Minimization.NWA_OVERAPPROXIMATION -> {
                if (!$assertionsDisabled && collection == null) {
                    throw new AssertionError();
                }
                collection.add((INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate>)iNestedWordAutomaton2);
                MinimizeNwaOverapproximation var14_18 = new MinimizeNwaOverapproximation(automataLibraryServices, SF, iNestedWordAutomaton, partitionBackedSetOfPairs, bl, n3, collection);
                boolean var15_27 = var14_18 != iNestedWordAutomaton;
                MinimizationResult var13_15 = new MinimizationResult(true, var15_27, var14_18);
                throw new UnsupportedOperationException("currently unsupported - check minimizaton attempt");
            }
            case TraceAbstractionPreferenceInitializer.Minimization.NWA_SIZE_BASED_PICKER -> {
                Object var14_19 = iNestedWordAutomaton.size() <= 617 ? new MinimizeNwaPmaxSatDirectBi(automataLibraryServices, SF, (IDoubleDeckerAutomaton)iNestedWordAutomaton, partitionBackedSetOfPairs, new MinimizeNwaMaxSat2.Settings().setAddMapOldState2NewState(bl).setLibraryMode(false)) : (iNestedWordAutomaton.size() <= 13377 ? new ShrinkNwa(automataLibraryServices, SF, iNestedWordAutomaton, partitionBackedSetOfPairs, bl, false, false, 200, false, 0, false, false, true, bl2) : new MinimizeSevpa(automataLibraryServices, SF, iNestedWordAutomaton, partitionBackedSetOfPairs, bl, bl2));
                yield new MinimizationResult(true, true, var14_19);
            }
            case TraceAbstractionPreferenceInitializer.Minimization.DFA_HOPCROFT_ARRAYS -> new MinimizationResult(true, true, new MinimizeDfaHopcroftArrays(automataLibraryServices, SF, iNestedWordAutomaton, partitionBackedSetOfPairs, bl));
            case TraceAbstractionPreferenceInitializer.Minimization.DFA_HOPCROFT_LISTS -> new MinimizationResult(true, true, new MinimizeDfaHopcroftLists(automataLibraryServices, SF, iNestedWordAutomaton, partitionBackedSetOfPairs, bl));
            case TraceAbstractionPreferenceInitializer.Minimization.NWA_MAX_SAT -> new MinimizationResult(true, true, new MinimizeNwaMaxSAT(automataLibraryServices, SF, iNestedWordAutomaton));
            case TraceAbstractionPreferenceInitializer.Minimization.NWA_MAX_SAT2 -> {
                AutomataLibraryServices var14_20 = new AutomataLibraryServices(this.mServices, 5000L);
                MinimizationResult var15_28 = null;
                try {
                    var15_28 = new MinimizationResult(true, true, new MinimizeNwaPmaxSatDirectBi(var14_20, SF, (IDoubleDeckerAutomaton)iNestedWordAutomaton, partitionBackedSetOfPairs, new MinimizeNwaMaxSat2.Settings().setAddMapOldState2NewState(bl).setLibraryMode(false)));
                }
                catch (AutomataOperationCanceledException v0) {
                    var15_28 = this.constructNoopMinimizationResult(true, iNestedWordAutomaton);
                }
                yield var15_28;
            }
            case TraceAbstractionPreferenceInitializer.Minimization.RAQ_DIRECT_SIMULATION -> new MinimizationResult(true, true, new ReduceNwaDirectSimulation(automataLibraryServices, SF, (IDoubleDeckerAutomaton)iNestedWordAutomaton, false, partitionBackedSetOfPairs));
            case TraceAbstractionPreferenceInitializer.Minimization.RAQ_DIRECT_SIMULATION_B -> new MinimizationResult(true, true, new ReduceNwaDirectSimulationB(automataLibraryServices, SF, (IDoubleDeckerAutomaton)iNestedWordAutomaton));
            case TraceAbstractionPreferenceInitializer.Minimization.FULLMULTIPEBBLE_DIRECT_SIMULATION -> {
                AutomataLibraryServices var14_21 = new AutomataLibraryServices(this.mServices, 5000L);
                MinimizationResult var15_29 = null;
                try {
                    var15_29 = new MinimizationResult(true, true, new ReduceNwaDirectFullMultipebbleSimulation(var14_21, SF, (IDoubleDeckerAutomaton)iNestedWordAutomaton));
                }
                catch (AutomataOperationCanceledException v1) {
                    var15_29 = this.constructNoopMinimizationResult(true, iNestedWordAutomaton);
                }
                yield var15_29;
            }
            case TraceAbstractionPreferenceInitializer.Minimization.NWA_COMBINATOR_MULTI_DEFAULT -> {
                MinimizeNwaMulti var14_22 = new MinimizeNwaMulti(automataLibraryServices, SF, (IDoubleDeckerAutomaton)iNestedWordAutomaton, partitionBackedSetOfPairs, bl);
                boolean var15_30 = var14_22.getMode() != MinimizeNwaCombinator.MinimizationMethods.NONE;
                yield new MinimizationResult(var15_30, true, var14_22);
            }
            case TraceAbstractionPreferenceInitializer.Minimization.NWA_COMBINATOR_MULTI_SIMULATION -> {
                MinimizeNwaMulti var14_23 = new MinimizeNwaMulti(automataLibraryServices, SF, (IDoubleDeckerAutomaton)iNestedWordAutomaton, partitionBackedSetOfPairs, bl, MinimizeNwaMulti.Strategy.SIMULATION_BASED);
                boolean var15_31 = var14_23.getMode() != MinimizeNwaCombinator.MinimizationMethods.NONE;
                yield new MinimizationResult(var15_31, true, var14_23);
            }
            case TraceAbstractionPreferenceInitializer.Minimization.DELAYED_SIMULATION -> new MinimizationResult(true, true, new BuchiReduce(automataLibraryServices, SF, iNestedWordAutomaton));
            case TraceAbstractionPreferenceInitializer.Minimization.FAIR_SIMULATION_WITH_SCC -> new MinimizationResult(true, true, new ReduceBuchiFairSimulation(automataLibraryServices, SF, iNestedWordAutomaton, true));
            case TraceAbstractionPreferenceInitializer.Minimization.FAIR_SIMULATION_WITHOUT_SCC -> new MinimizationResult(true, true, new ReduceBuchiFairSimulation(automataLibraryServices, SF, iNestedWordAutomaton, false));
            case TraceAbstractionPreferenceInitializer.Minimization.FAIR_DIRECT_SIMULATION -> new MinimizationResult(true, true, new ReduceBuchiFairDirectSimulation(automataLibraryServices, SF, iNestedWordAutomaton, true));
            case TraceAbstractionPreferenceInitializer.Minimization.RAQ_DELAYED_SIMULATION -> new MinimizationResult(true, true, new ReduceNwaDelayedSimulation(automataLibraryServices, SF, (IDoubleDeckerAutomaton)iNestedWordAutomaton, false, partitionBackedSetOfPairs));
            case TraceAbstractionPreferenceInitializer.Minimization.RAQ_DELAYED_SIMULATION_B -> new MinimizationResult(true, true, new ReduceNwaDelayedSimulationB(automataLibraryServices, SF, (IDoubleDeckerAutomaton)iNestedWordAutomaton));
            case TraceAbstractionPreferenceInitializer.Minimization.FULLMULTIPEBBLE_DELAYED_SIMULATION -> {
                AutomataLibraryServices var14_24 = new AutomataLibraryServices(this.mServices, 5000L);
                MinimizationResult var15_32 = null;
                try {
                    var15_32 = new MinimizationResult(true, true, new ReduceNwaDelayedFullMultipebbleSimulation(var14_24, SF, (IDoubleDeckerAutomaton)iNestedWordAutomaton));
                }
                catch (AutomataOperationCanceledException v2) {
                    var15_32 = this.constructNoopMinimizationResult(true, iNestedWordAutomaton);
                }
                yield var15_32;
            }
            case TraceAbstractionPreferenceInitializer.Minimization.NONE -> this.constructNoopMinimizationResult(false, iNestedWordAutomaton);
            default -> throw new AssertionError((Object)"Unknown minimization method.");
        };
    }

    private MinimizationResult constructNoopMinimizationResult(boolean bl, final INestedWordAutomaton<LETTER, IPredicate> iNestedWordAutomaton) {
        MinimizationResult minimizationResult = new MinimizationResult(bl, false, new AbstractMinimizeNwa<LETTER, IPredicate>(new AutomataLibraryServices(this.mServices), null){

            public INestedWordAutomaton<LETTER, IPredicate> getResult() {
                return iNestedWordAutomaton;
            }

            protected INestedWordAutomaton<LETTER, IPredicate> getOperand() {
                return null;
            }

            protected Pair<Boolean, String> checkResultHelper(IMinimizationCheckResultStateFactory<IPredicate> iMinimizationCheckResultStateFactory) throws AutomataLibraryException {
                return null;
            }
        });
        return minimizationResult;
    }

    public IDoubleDeckerAutomaton<LETTER, IPredicate> getMinimizedAutomaton() {
        return this.mMinimizedAutomaton;
    }

    public Map<IPredicate, IPredicate> getOldState2newStateMapping() {
        return this.mOldState2newState;
    }

    public boolean newAutomatonWasBuilt() {
        return this.mMinimizationResult.wasNewAutomatonBuilt();
    }

    public boolean wasMinimizationAttempted() {
        return this.mMinimizationResult.wasMinimizationAttempted();
    }

    public AutomataMinimizationStatisticsGenerator getStatistics() {
        return this.mStatistics;
    }

    public static class AutomataMinimizationTimeout
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final AutomataMinimizationStatisticsGenerator mStatistics;
        private final AutomataOperationCanceledException mAutomataOperationCanceledException;

        public AutomataMinimizationTimeout(AutomataOperationCanceledException automataOperationCanceledException, AutomataMinimizationStatisticsGenerator automataMinimizationStatisticsGenerator) {
            this.mAutomataOperationCanceledException = automataOperationCanceledException;
            this.mStatistics = automataMinimizationStatisticsGenerator;
        }

        public AutomataMinimizationStatisticsGenerator getStatistics() {
            return this.mStatistics;
        }

        public AutomataOperationCanceledException getAutomataOperationCanceledException() {
            return this.mAutomataOperationCanceledException;
        }
    }

    private class MinimizationResult {
        private final boolean mNewAutomatonWasBuilt;
        private final boolean mMinimizationAttempt;
        private final AbstractMinimizeNwa<LETTER, IPredicate> mRawMinimizationOutput;

        public MinimizationResult(boolean bl, boolean bl2, AbstractMinimizeNwa<LETTER, IPredicate> abstractMinimizeNwa) {
            this.mNewAutomatonWasBuilt = bl2;
            this.mMinimizationAttempt = bl;
            this.mRawMinimizationOutput = abstractMinimizeNwa;
        }

        public boolean wasNewAutomatonBuilt() {
            return this.mNewAutomatonWasBuilt;
        }

        public boolean wasMinimizationAttempted() {
            return this.mMinimizationAttempt;
        }

        public AbstractMinimizeNwa<LETTER, IPredicate> getRawMinimizationOutput() {
            return this.mRawMinimizationOutput;
        }
    }
}

