/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.FakeBoogieVar;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class AbsIntUtil {
    public static final BigDecimal MINUS_ONE = BigDecimal.ONE.negate();
    public static final BigDecimal TWO = new BigDecimal(2);

    private AbsIntUtil() {
    }

    public static void dumpToFile(Map<CodeBlock, Map<BoogieIcfgLocation, Term>> map, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<CodeBlock, Map<BoogieIcfgLocation, Term>> entry : map.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            stringBuilder.append(entry.getKey().toString()).append("\n");
            for (Map.Entry object : ((Map)entry.getValue()).entrySet()) {
                stringBuilder.append(" * ").append(object.getValue()).append("\n");
            }
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("No preds :(\n");
        }
        stringBuilder.append("\n\n");
        try {
            Map.Entry<CodeBlock, Map<BoogieIcfgLocation, Term>> entry;
            entry = null;
            Iterator<Map.Entry<CodeBlock, Map<BoogieIcfgLocation, Term>>> iterator = null;
            try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string, true));){
                bufferedWriter.append(stringBuilder);
                bufferedWriter.close();
            }
            catch (Throwable throwable) {
                if (entry == null) {
                    entry = throwable;
                } else if (entry != throwable) {
                    ((Throwable)((Object)entry)).addSuppressed(throwable);
                }
                throw entry;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static <LOC> void logPredicates(Map<?, Map<LOC, Term>> map, Script script, Consumer<String> consumer) {
        HashMap<LOC, Term> hashMap = new HashMap<LOC, Term>();
        for (Map.Entry<?, Map<LOC, Term>> entry : map.entrySet()) {
            for (Map.Entry<LOC, Term> entry2 : entry.getValue().entrySet()) {
                Term term = (Term)hashMap.get(entry2.getKey());
                if (term == null) {
                    hashMap.put(entry2.getKey(), entry2.getValue());
                    continue;
                }
                hashMap.put(entry2.getKey(), SmtUtils.or((Script)script, (Term[])new Term[]{entry2.getValue(), term}));
            }
        }
        AbsIntUtil.logPredicates(hashMap, consumer);
    }

    public static void logPredicates(Map<?, Term> map, Consumer<String> consumer) {
        for (Map.Entry<?, Term> entry : map.entrySet()) {
            consumer.accept(String.valueOf(entry.getKey()) + ": " + String.valueOf(entry.getValue()));
        }
    }

    public static <K, V> Map<K, V> getFreshMap(Map<K, V> map, int n) {
        HashMap<K, V> hashMap = new HashMap<K, V>(n);
        hashMap.putAll(map);
        return hashMap;
    }

    public static <K, V> Map<K, V> getFreshMap(Map<K, V> map) {
        return AbsIntUtil.getFreshMap(map, map.size());
    }

    public static <T> ArrayList<T> singletonArrayList(T t) {
        ArrayList<T> arrayList = new ArrayList<T>();
        arrayList.add(t);
        return arrayList;
    }

    public static BigDecimal euclideanDivision(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        BigDecimal[] bigDecimalArray = bigDecimal.divideAndRemainder(bigDecimal2);
        BigDecimal bigDecimal3 = bigDecimalArray[0];
        BigDecimal bigDecimal4 = bigDecimalArray[1];
        if (bigDecimal4.signum() != 0 && bigDecimal.signum() < 0) {
            bigDecimal3 = bigDecimal2.signum() < 0 ? bigDecimal3.add(BigDecimal.ONE) : bigDecimal3.subtract(BigDecimal.ONE);
        }
        return bigDecimal3;
    }

    public static Rational euclideanDivision(Rational rational, Rational rational2) {
        Rational rational3 = rational.div(rational2);
        rational3 = rational3.signum() == -1 ? rational3.ceil() : rational3.floor();
        Rational rational4 = rational.sub(rational3.mul(rational2));
        if (rational4.signum() != 0 && rational.signum() < 0) {
            rational3 = rational2.signum() < 0 ? rational3.add(Rational.ONE) : rational3.sub(Rational.ONE);
        }
        return rational3;
    }

    public static BigDecimal exactDivison(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        BigDecimal[] bigDecimalArray = bigDecimal.divideAndRemainder(bigDecimal2);
        if (bigDecimalArray[1].signum() == 0) {
            return bigDecimalArray[0];
        }
        throw new ArithmeticException("Divison not exact for " + String.valueOf(bigDecimal) + " / " + String.valueOf(bigDecimal2));
    }

    public static Rational exactDivision(Rational rational, Rational rational2) {
        Rational rational3 = rational.div(rational2);
        if (rational3.isIntegral()) {
            return rational3;
        }
        throw new ArithmeticException("Divison not exact for " + String.valueOf(rational) + " / " + String.valueOf(rational2));
    }

    public static boolean isIntegral(BigDecimal bigDecimal) {
        return bigDecimal.remainder(BigDecimal.ONE).signum() == 0;
    }

    public static BigDecimal euclideanModulo(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        BigDecimal bigDecimal3 = bigDecimal.remainder(bigDecimal2);
        if (bigDecimal3.signum() < 0) {
            bigDecimal3 = bigDecimal3.add(bigDecimal2.abs());
        }
        return bigDecimal3;
    }

    public static BigInteger euclideanModulo(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger.remainder(bigInteger2);
        if (bigInteger3.signum() < 0) {
            bigInteger3 = bigInteger3.add(bigInteger2.abs());
        }
        return bigInteger3;
    }

    public static Rational euclideanModulo(Rational rational, Rational rational2) {
        Rational rational3 = rational.div(rational2);
        Rational rational4 = rational3.floor();
        Rational rational5 = rational.sub(rational4.mul(rational2));
        if (rational5.isNegative()) {
            return rational5.add(rational2.abs());
        }
        return rational5;
    }

    public static Pair<BigInteger, BigInteger> decimalFraction(BigDecimal bigDecimal) {
        BigInteger bigInteger = bigDecimal.unscaledValue();
        BigInteger bigInteger2 = BigInteger.TEN.pow(Math.abs(bigDecimal.scale()));
        if (bigDecimal.scale() < 0) {
            bigInteger = bigInteger.multiply(bigInteger2);
            bigInteger2 = BigInteger.ONE;
        }
        return new Pair((Object)bigInteger, (Object)bigInteger2);
    }

    public static IProgramVar createTemporaryIBoogieVar(String string, IBoogieType iBoogieType) {
        return new FakeBoogieVar(iBoogieType, string);
    }

    public static boolean isVariable(IdentifierExpression identifierExpression) {
        DeclarationInformation declarationInformation = identifierExpression.getDeclarationInformation();
        switch (declarationInformation.getStorageClass()) {
            case IMPLEMENTATION: 
            case PROC_FUNC: {
                return false;
            }
            case GLOBAL: 
            case PROC_FUNC_INPARAM: 
            case PROC_FUNC_OUTPARAM: 
            case IMPLEMENTATION_INPARAM: 
            case IMPLEMENTATION_OUTPARAM: 
            case LOCAL: 
            case QUANTIFIED: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown storage class: " + String.valueOf(declarationInformation.getStorageClass()));
    }

    public static boolean isOldVar(IProgramVarOrConst iProgramVarOrConst) {
        return iProgramVarOrConst instanceof IProgramOldVar;
    }

    public static boolean isGlobal(IProgramVarOrConst iProgramVarOrConst) {
        if (iProgramVarOrConst instanceof IProgramVar) {
            return iProgramVarOrConst.isGlobal();
        }
        if (iProgramVarOrConst instanceof ProgramConst) {
            return true;
        }
        throw new AssertionError((Object)("Unknown IProgramVar type: " + iProgramVarOrConst.getClass().getName()));
    }

    public static BinaryExpression.Operator negateRelOp(BinaryExpression.Operator operator) {
        switch (operator) {
            case COMPEQ: {
                return BinaryExpression.Operator.COMPNEQ;
            }
            case COMPNEQ: {
                return BinaryExpression.Operator.COMPEQ;
            }
            case COMPLEQ: {
                return BinaryExpression.Operator.COMPGT;
            }
            case COMPGT: {
                return BinaryExpression.Operator.COMPLEQ;
            }
            case COMPLT: {
                return BinaryExpression.Operator.COMPGEQ;
            }
            case COMPGEQ: {
                return BinaryExpression.Operator.COMPLT;
            }
        }
        throw new IllegalArgumentException("Not a negatable relational operator: " + String.valueOf(operator));
    }

    public static BoogieIcfgContainer getBoogieIcfgContainer(IIcfg<?> iIcfg) {
        if (iIcfg instanceof BoogieIcfgContainer) {
            return (BoogieIcfgContainer)iIcfg;
        }
        BoogieIcfgContainer boogieIcfgContainer = BoogieIcfgContainer.getAnnotation(iIcfg);
        if (boogieIcfgContainer != null) {
            return boogieIcfgContainer;
        }
        throw new IllegalArgumentException("Cannot extract BoogieIcfgContainer from IICFG");
    }

    public static <STATE extends IAbstractState<STATE>> STATE synchronizeVariables(STATE STATE, STATE STATE2) {
        if (STATE2 == null) {
            return null;
        }
        if (STATE == null) {
            return STATE2;
        }
        STATE STATE3 = AbsIntUtil.synchronizeVariables(STATE2, (Set<IProgramVarOrConst>)STATE.getVariables());
        assert (!STATE2.isBottom() || STATE3.isBottom()) : "Bottom is lost";
        return STATE3;
    }

    public static <STATE extends IAbstractState<STATE>> Set<STATE> synchronizeVariables(Set<STATE> set) {
        if (set == null) {
            return null;
        }
        if (set.size() < 2) {
            return set;
        }
        Set set2 = set.stream().flatMap(iAbstractState -> iAbstractState.getVariables().stream()).collect(Collectors.toSet());
        return set.stream().map(iAbstractState -> AbsIntUtil.synchronizeVariables(iAbstractState, set2)).collect(Collectors.toSet());
    }

    public static <STATE extends IAbstractState<STATE>> STATE synchronizeVariables(STATE STATE, Set<IProgramVarOrConst> set) {
        ImmutableSet immutableSet = STATE.getVariables();
        Set set2 = DataStructureUtils.difference((Set)immutableSet, set);
        Set set3 = DataStructureUtils.difference(set, (Set)immutableSet);
        if (set2.isEmpty() && set3.isEmpty()) {
            return STATE;
        }
        IAbstractState iAbstractState = set2.isEmpty() ? STATE.addVariables((Collection)set3) : (set3.isEmpty() ? STATE.removeVariables((Collection)set2) : STATE.removeVariables((Collection)set2).addVariables((Collection)set3));
        assert (!STATE.isBottom() || iAbstractState.isBottom()) : "Bottom lost during synchronization";
        return (STATE)iAbstractState;
    }

    public static BigDecimal sanitizeBigDecimalValue(String string) {
        if (string.contains("/")) {
            String[] stringArray = string.split("/");
            if (stringArray.length != 2) {
                throw new NumberFormatException("Not a valid division value: " + string);
            }
            BigDecimal bigDecimal = new BigDecimal(stringArray[0]);
            BigDecimal bigDecimal2 = new BigDecimal(stringArray[1]);
            return bigDecimal.divide(bigDecimal2);
        }
        return new BigDecimal(string);
    }
}

