/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IOutgoingTransitionlet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.StateBasedTransitionFilterPredicateProvider;
import de.uni_freiburg.informatik.ultimate.util.datastructures.FilteredIterable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.IteratorConcatenation;
import de.uni_freiburg.informatik.ultimate.util.scc.DefaultSccComputation;
import de.uni_freiburg.informatik.ultimate.util.scc.SccComputation;
import de.uni_freiburg.informatik.ultimate.util.scc.StronglyConnectedComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class AutomatonSccComputation<LETTER, STATE> {
    private final DefaultSccComputation<STATE> mSccComputation;

    public AutomatonSccComputation(AutomataLibraryServices automataLibraryServices, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates, Set<STATE> set, Set<STATE> set2) {
        this.mSccComputation = new DefaultSccComputation(automataLibraryServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID), (SccComputation.ISuccessorProvider)new InSumCaSuccessorProvider(nestedWordAutomatonReachableStates, set), set.size(), set2);
    }

    public Collection<StronglyConnectedComponent<STATE>> getBalls() {
        return this.mSccComputation.getBalls();
    }

    private class InSumCaSuccessorProvider
    implements SccComputation.ISuccessorProvider<STATE> {
        private final INestedWordAutomaton<LETTER, STATE> mOperand;
        private final StateBasedTransitionFilterPredicateProvider<LETTER, STATE> mTransitionFilter;

        public InSumCaSuccessorProvider(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, Set<STATE> set) {
            this.mOperand = iNestedWordAutomaton;
            this.mTransitionFilter = new StateBasedTransitionFilterPredicateProvider(set);
        }

        private <E extends IOutgoingTransitionlet<LETTER, STATE>> Iterator<STATE> getStateContainerIterator(final Iterator<E> iterator) {
            return new Iterator<STATE>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public STATE next() {
                    return ((IOutgoingTransitionlet)iterator.next()).getSucc();
                }
            };
        }

        public IteratorConcatenation<STATE> getSuccessors(STATE STATE) {
            Iterator iterator = this.getStateContainerIterator(new FilteredIterable(this.mOperand.internalSuccessors(STATE), this.mTransitionFilter.getInternalSuccessorPredicate()).iterator());
            Iterator iterator2 = this.getStateContainerIterator(new FilteredIterable(this.mOperand.summarySuccessors(STATE), this.mTransitionFilter.getReturnSummaryPredicate()).iterator());
            Iterator iterator3 = this.getStateContainerIterator(new FilteredIterable(this.mOperand.callSuccessors(STATE), this.mTransitionFilter.getCallSuccessorPredicate()).iterator());
            ArrayList arrayList = new ArrayList();
            arrayList.add(iterator);
            arrayList.add(iterator2);
            arrayList.add(iterator3);
            return new IteratorConcatenation(arrayList);
        }
    }
}

