/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiAccepts;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.RunConstructor;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.StateContainer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.Summary;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.scc.StronglyConnectedComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class LassoExtractor<LETTER, STATE> {
    private final AutomataLibraryServices mServices;
    private final ILogger mLogger;
    private final NestedWordAutomatonReachableStates<LETTER, STATE> mNwars;
    private final NestedLassoRun<LETTER, STATE> mNlr;

    public LassoExtractor(AutomataLibraryServices automataLibraryServices, NestedWordAutomatonReachableStates<LETTER, STATE> nestedWordAutomatonReachableStates, StateContainer<LETTER, STATE> stateContainer, StronglyConnectedComponent<StateContainer<LETTER, STATE>> stronglyConnectedComponent, HashRelation<StateContainer<LETTER, STATE>, Summary<LETTER, STATE>> hashRelation) throws AutomataOperationCanceledException {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
        this.mNwars = nestedWordAutomatonReachableStates;
        Set<SuccInfo> set = Collections.emptySet();
        LoopFinder loopFinder = new LoopFinder(stateContainer, stronglyConnectedComponent, true, hashRelation, set);
        NestedRun nestedRun = loopFinder.getNestedRun();
        assert (nestedRun.getLength() > 1) : "looping epsilon transition";
        NestedRun<LETTER, STATE> nestedRun2 = new RunConstructor<LETTER, STATE>(this.mServices, this.mNwars, stateContainer).constructRun();
        this.mLogger.debug((Object)("Stem length: " + nestedRun2.getLength()));
        this.mLogger.debug((Object)("Loop length: " + nestedRun.getLength()));
        this.mNlr = new NestedLassoRun<LETTER, STATE>(nestedRun2, nestedRun);
        this.mLogger.debug((Object)("Stem " + String.valueOf(nestedRun2)));
        this.mLogger.debug((Object)("Loop " + String.valueOf(nestedRun)));
        try {
            assert (new BuchiAccepts<LETTER, STATE>(this.mServices, this.mNwars, this.mNlr.getNestedLassoWord()).getResult().booleanValue());
        }
        catch (AutomataLibraryException automataLibraryException) {
            throw new AssertionError((Object)automataLibraryException);
        }
    }

    NestedLassoRun<LETTER, STATE> getNestedLassoRun() {
        return this.mNlr;
    }

    NestedWordAutomatonReachableStates<LETTER, STATE> getNwars() {
        return this.mNwars;
    }

    class LoopFinder
    extends RunFinder {
        private final StronglyConnectedComponent<StateContainer<LETTER, STATE>> mScc;

        public LoopFinder(StateContainer<LETTER, STATE> stateContainer, StronglyConnectedComponent<StateContainer<LETTER, STATE>> stronglyConnectedComponent, boolean bl, HashRelation<StateContainer<LETTER, STATE>, Summary<LETTER, STATE>> hashRelation, Set<SuccInfo> set) {
            super(stateContainer, stateContainer, bl, hashRelation, set);
            this.mScc = stronglyConnectedComponent;
        }

        @Override
        protected int getMaximalIterationNumber() {
            return this.mScc.getNodes().size();
        }

        @Override
        protected SuccInfo possiblePredecessor(StateContainer<LETTER, STATE> stateContainer, IncomingReturnTransition<LETTER, STATE> incomingReturnTransition, boolean bl, boolean bl2) {
            StateContainer stateContainer2 = LassoExtractor.this.getNwars().obtainStateContainer(incomingReturnTransition.getHierPred());
            StateContainer stateContainer3 = LassoExtractor.this.getNwars().obtainStateContainer(incomingReturnTransition.getLinPred());
            return this.possiblePredecessor(stateContainer2, incomingReturnTransition.getLetter(), stateContainer, NestedWordAutomatonReachableStates.InCaRe.SUMMARY, stateContainer3, true, bl2);
        }

        @Override
        protected SuccInfo possiblePredecessor(StateContainer<LETTER, STATE> stateContainer, IncomingCallTransition<LETTER, STATE> incomingCallTransition, boolean bl, boolean bl2) {
            StateContainer stateContainer2 = LassoExtractor.this.getNwars().obtainStateContainer(incomingCallTransition.getPred());
            return this.possiblePredecessor(stateContainer2, incomingCallTransition.getLetter(), stateContainer, NestedWordAutomatonReachableStates.InCaRe.CALL, null, bl, bl2);
        }

        @Override
        protected SuccInfo possiblePredecessor(StateContainer<LETTER, STATE> stateContainer, IncomingInternalTransition<LETTER, STATE> incomingInternalTransition, boolean bl, boolean bl2) {
            StateContainer stateContainer2 = LassoExtractor.this.getNwars().obtainStateContainer(incomingInternalTransition.getPred());
            return this.possiblePredecessor(stateContainer2, incomingInternalTransition.getLetter(), stateContainer, NestedWordAutomatonReachableStates.InCaRe.INTERNAL, null, bl, bl2);
        }

        private SuccInfo possiblePredecessor(StateContainer<LETTER, STATE> stateContainer, LETTER LETTER, StateContainer<LETTER, STATE> stateContainer2, NestedWordAutomatonReachableStates.InCaRe inCaRe, StateContainer<LETTER, STATE> stateContainer3, boolean bl, boolean bl2) {
            if (!this.mScc.getNodes().contains(stateContainer)) {
                return null;
            }
            boolean bl3 = bl2;
            boolean bl4 = bl3 = bl3 || LassoExtractor.this.getNwars().isFinal(stateContainer.getState());
            if (inCaRe == NestedWordAutomatonReachableStates.InCaRe.SUMMARY) {
                boolean bl5 = bl3 = bl3 || this.isAcceptingSummary(stateContainer, stateContainer2);
            }
            if (this.alreadyVisited(stateContainer, bl, bl3)) {
                return null;
            }
            boolean bl6 = this.mGoal.equals(stateContainer) && bl3;
            boolean bl7 = bl2 ^ bl3;
            SuccInfo succInfo = new SuccInfo(stateContainer2, LETTER, inCaRe, stateContainer3, bl3, bl6, bl7);
            super.markVisited(stateContainer, bl, bl3);
            return succInfo;
        }
    }

    abstract class RunFinder {
        protected final Set<SuccInfo> mForbiddenSummaries;
        protected final StateContainer<LETTER, STATE> mStart;
        protected final StateContainer<LETTER, STATE> mGoal;
        protected final boolean mVisitAccepting;
        protected final List<Map<StateContainer<LETTER, STATE>, SuccInfo>> mSuccessorsWithSummary;
        protected final List<Map<StateContainer<LETTER, STATE>, SuccInfo>> mSuccessorsWithoutSummary;
        protected boolean mFoundWithSummary;
        protected boolean mFoundWithoutSummary;
        protected int mIteration;
        private final HashRelation<StateContainer<LETTER, STATE>, Summary<LETTER, STATE>> mAcceptingSummaries;
        private final Set<StateContainer<LETTER, STATE>> mVisited_WithoutSummary_WithoutGuarantee = new HashSet();
        private final Set<StateContainer<LETTER, STATE>> mVisited_WithSummary_WithoutGuarantee = new HashSet();
        private final Set<StateContainer<LETTER, STATE>> mVisited_WithoutSummary_WithGuarantee = new HashSet();
        private final Set<StateContainer<LETTER, STATE>> mVisited_WithSummary_WithGuarantee = new HashSet();
        private int mIterationFoundWithSummary;

        public RunFinder(StateContainer<LETTER, STATE> stateContainer, StateContainer<LETTER, STATE> stateContainer2, boolean bl, HashRelation<StateContainer<LETTER, STATE>, Summary<LETTER, STATE>> hashRelation, Set<SuccInfo> set) {
            assert (stateContainer != null);
            assert (stateContainer2 != null);
            this.mStart = stateContainer;
            this.mGoal = stateContainer2;
            this.mVisitAccepting = bl;
            this.mAcceptingSummaries = hashRelation;
            this.mForbiddenSummaries = set;
            this.mSuccessorsWithSummary = new ArrayList();
            this.mSuccessorsWithoutSummary = new ArrayList();
            this.mIterationFoundWithSummary = -1;
            this.mIteration = 0;
        }

        public NestedRun<LETTER, STATE> getNestedRun() {
            this.find(this.mStart);
            if (this.mFoundWithoutSummary) {
                return this.constructRun(this.mIteration, false);
            }
            return this.constructRun(this.mIterationFoundWithSummary, true);
        }

        protected boolean isAcceptingSummary(StateContainer<LETTER, STATE> stateContainer, StateContainer<LETTER, STATE> stateContainer2) {
            Set set = this.mAcceptingSummaries.getImage(stateContainer);
            if (set == null) {
                return false;
            }
            for (Summary summary : set) {
                if (!summary.getSucc().equals(stateContainer2)) continue;
                return true;
            }
            return false;
        }

        private boolean continueSearch() {
            if (this.mFoundWithoutSummary) {
                return false;
            }
            return !this.mSuccessorsWithSummary.get(this.mIteration).isEmpty() || !this.mSuccessorsWithoutSummary.get(this.mIteration).isEmpty();
        }

        private void find(StateContainer<LETTER, STATE> stateContainer) {
            this.mSuccessorsWithoutSummary.add(new HashMap());
            this.mSuccessorsWithSummary.add(new HashMap());
            this.findPredecessors(stateContainer, !this.mVisitAccepting || LassoExtractor.this.getNwars().isFinal(stateContainer.getState()), false);
            while (this.continueSearch()) {
                boolean bl;
                assert (this.mIteration <= this.getMaximalIterationNumber()) : "too many iterations";
                ++this.mIteration;
                this.mSuccessorsWithoutSummary.add(new HashMap());
                this.mSuccessorsWithSummary.add(new HashMap());
                if (!this.mFoundWithSummary) {
                    for (StateContainer stateContainer2 : this.mSuccessorsWithSummary.get(this.mIteration - 1).keySet()) {
                        bl = this.mSuccessorsWithSummary.get(this.mIteration - 1).get(stateContainer2).isGuarantee();
                        this.findPredecessors(stateContainer2, bl, true);
                    }
                }
                for (StateContainer stateContainer2 : this.mSuccessorsWithoutSummary.get(this.mIteration - 1).keySet()) {
                    bl = this.mSuccessorsWithoutSummary.get(this.mIteration - 1).get(stateContainer2).isGuarantee();
                    this.findPredecessors(stateContainer2, bl, false);
                }
            }
            assert (this.mFoundWithSummary || this.mFoundWithoutSummary) : "Bug in run reconstruction of new emptiness test.";
        }

        protected abstract int getMaximalIterationNumber();

        protected abstract SuccInfo possiblePredecessor(StateContainer<LETTER, STATE> var1, IncomingReturnTransition<LETTER, STATE> var2, boolean var3, boolean var4);

        protected abstract SuccInfo possiblePredecessor(StateContainer<LETTER, STATE> var1, IncomingCallTransition<LETTER, STATE> var2, boolean var3, boolean var4);

        protected abstract SuccInfo possiblePredecessor(StateContainer<LETTER, STATE> var1, IncomingInternalTransition<LETTER, STATE> var2, boolean var3, boolean var4);

        private void addSuccessorInformation(StateContainer<LETTER, STATE> stateContainer, boolean bl, SuccInfo succInfo) {
            Map map;
            if (bl) {
                this.mFoundWithSummary |= succInfo.goalFound();
                map = this.mSuccessorsWithSummary.get(this.mIteration);
            } else {
                this.mFoundWithoutSummary |= succInfo.goalFound();
                map = this.mSuccessorsWithoutSummary.get(this.mIteration);
            }
            SuccInfo succInfo2 = map.get(stateContainer);
            if (succInfo2 == null) {
                map.put(stateContainer, succInfo);
                return;
            }
            if (!succInfo2.isGuarantee() && succInfo.isGuarantee()) {
                map.put(stateContainer, succInfo);
                return;
            }
            if (!succInfo2.goalFound() && succInfo.goalFound()) {
                map.put(stateContainer, succInfo);
            }
        }

        void markVisited(StateContainer<LETTER, STATE> stateContainer, boolean bl, boolean bl2) {
            if (bl) {
                if (bl2) {
                    this.mVisited_WithSummary_WithGuarantee.add(stateContainer);
                } else {
                    this.mVisited_WithSummary_WithoutGuarantee.add(stateContainer);
                }
            } else if (bl2) {
                this.mVisited_WithoutSummary_WithGuarantee.add(stateContainer);
            } else {
                this.mVisited_WithoutSummary_WithoutGuarantee.add(stateContainer);
            }
        }

        protected boolean alreadyVisited(StateContainer<LETTER, STATE> stateContainer, boolean bl, boolean bl2) {
            if (bl) {
                if (bl2) {
                    return this.mVisited_WithSummary_WithGuarantee.contains(stateContainer);
                }
                return this.mVisited_WithSummary_WithoutGuarantee.contains(stateContainer);
            }
            if (bl2) {
                return this.mVisited_WithoutSummary_WithGuarantee.contains(stateContainer);
            }
            return this.mVisited_WithoutSummary_WithoutGuarantee.contains(stateContainer);
        }

        protected void findPredecessors(StateContainer<LETTER, STATE> stateContainer, boolean bl, boolean bl2) {
            StateContainer stateContainer2;
            SuccInfo succInfo;
            for (IncomingInternalTransition iTransitionlet : LassoExtractor.this.getNwars().internalPredecessors(stateContainer.getState())) {
                succInfo = this.possiblePredecessor(stateContainer, iTransitionlet, bl2, bl);
                if (succInfo == null) continue;
                stateContainer2 = LassoExtractor.this.getNwars().obtainStateContainer(iTransitionlet.getPred());
                this.addSuccessorInformation(stateContainer2, bl2, succInfo);
            }
            for (IncomingCallTransition incomingCallTransition : LassoExtractor.this.getNwars().callPredecessors(stateContainer.getState())) {
                succInfo = this.possiblePredecessor(stateContainer, incomingCallTransition, bl2, bl);
                if (succInfo == null) continue;
                stateContainer2 = LassoExtractor.this.getNwars().obtainStateContainer(incomingCallTransition.getPred());
                this.addSuccessorInformation(stateContainer2, bl2, succInfo);
            }
            for (IncomingReturnTransition incomingReturnTransition : LassoExtractor.this.getNwars().returnPredecessors(stateContainer.getState())) {
                succInfo = this.possiblePredecessor(stateContainer, incomingReturnTransition, bl2, bl);
                if (succInfo == null) continue;
                stateContainer2 = LassoExtractor.this.getNwars().obtainStateContainer(incomingReturnTransition.getHierPred());
                this.addSuccessorInformation(stateContainer2, true, succInfo);
            }
            if (this.mFoundWithSummary && this.mIterationFoundWithSummary == -1) {
                this.mIterationFoundWithSummary = this.mIteration;
            }
        }

        private NestedRun<LETTER, STATE> constructRun(int n, boolean bl) {
            boolean bl2 = this.mVisitAccepting;
            NestedRun nestedRun = new NestedRun(this.mGoal.getState());
            int n2 = n;
            while (n2 >= 0) {
                NestedRun nestedRun2;
                StateContainer stateContainer = LassoExtractor.this.getNwars().obtainStateContainer(nestedRun.getStateAtPosition(nestedRun.getLength() - 1));
                if (LassoExtractor.this.getNwars().isFinal(stateContainer.getState())) {
                    bl2 = false;
                }
                SuccInfo succInfo = null;
                if (bl) {
                    succInfo = this.mSuccessorsWithSummary.get(n2).get(stateContainer);
                }
                if (succInfo == null) {
                    succInfo = this.mSuccessorsWithoutSummary.get(n2).get(stateContainer);
                }
                assert (succInfo != null) : "No successor found!";
                if (succInfo.getType() == NestedWordAutomatonReachableStates.InCaRe.INTERNAL) {
                    nestedRun2 = new NestedRun(stateContainer.getState(), succInfo.getLetter(), -2, succInfo.getSuccessor().getState());
                } else if (succInfo.getType() == NestedWordAutomatonReachableStates.InCaRe.CALL) {
                    nestedRun2 = new NestedRun(stateContainer.getState(), succInfo.getLetter(), Integer.MAX_VALUE, succInfo.getSuccessor().getState());
                } else if (succInfo.getType() == NestedWordAutomatonReachableStates.InCaRe.SUMMARY) {
                    boolean bl3;
                    if (bl2 && succInfo.isGuaranteeChanger() && !LassoExtractor.this.getNwars().isFinal(stateContainer.getState())) {
                        assert (this.isAcceptingSummary(stateContainer, succInfo.getSuccessor()));
                        bl3 = true;
                    } else {
                        bl3 = false;
                    }
                    HashSet<SuccInfo> hashSet = new HashSet<SuccInfo>(this.mForbiddenSummaries);
                    assert (!hashSet.contains(succInfo));
                    hashSet.add(succInfo);
                    SummaryFinder summaryFinder = new SummaryFinder(succInfo.getLinPred(), stateContainer, bl3, this.mAcceptingSummaries, hashSet);
                    nestedRun2 = summaryFinder.getNestedRun();
                    NestedRun nestedRun3 = new NestedRun(succInfo.getLinPred().getState(), succInfo.getLetter(), Integer.MIN_VALUE, succInfo.getSuccessor().getState());
                    nestedRun2 = nestedRun2.concatenate(nestedRun3);
                    if (bl3) {
                        bl2 = false;
                    }
                } else {
                    throw new AssertionError((Object)"unknown transition");
                }
                nestedRun = nestedRun.concatenate(nestedRun2);
                --n2;
            }
            return nestedRun;
        }
    }

    class SuccInfo {
        private final StateContainer<LETTER, STATE> mSuccessor;
        private final LETTER mLetter;
        private final NestedWordAutomatonReachableStates.InCaRe mType;
        private final StateContainer<LETTER, STATE> mLinPred;
        private final boolean mGuarantee;
        private final boolean mGoalFound;
        private final boolean mGuaranteeChanger;

        public SuccInfo(StateContainer<LETTER, STATE> stateContainer, LETTER LETTER, NestedWordAutomatonReachableStates.InCaRe inCaRe, StateContainer<LETTER, STATE> stateContainer2, boolean bl, boolean bl2, boolean bl3) {
            if (inCaRe == NestedWordAutomatonReachableStates.InCaRe.SUMMARY && stateContainer2 == null) {
                throw new IllegalArgumentException("for summary we need linPred");
            }
            if ((inCaRe == NestedWordAutomatonReachableStates.InCaRe.INTERNAL || inCaRe == NestedWordAutomatonReachableStates.InCaRe.CALL) && stateContainer2 != null) {
                throw new IllegalArgumentException("linPred not allowed for internal and call");
            }
            if (inCaRe == NestedWordAutomatonReachableStates.InCaRe.RETURN) {
                throw new IllegalArgumentException("we do not use return here");
            }
            this.mSuccessor = stateContainer;
            this.mLetter = LETTER;
            this.mType = inCaRe;
            this.mLinPred = stateContainer2;
            this.mGuarantee = bl;
            this.mGoalFound = bl2;
            this.mGuaranteeChanger = bl3;
        }

        public StateContainer<LETTER, STATE> getSuccessor() {
            return this.mSuccessor;
        }

        public LETTER getLetter() {
            return this.mLetter;
        }

        public NestedWordAutomatonReachableStates.InCaRe getType() {
            return this.mType;
        }

        public StateContainer<LETTER, STATE> getLinPred() {
            return this.mLinPred;
        }

        public boolean isGuarantee() {
            return this.mGuarantee;
        }

        public boolean goalFound() {
            return this.mGoalFound;
        }

        public boolean isGuaranteeChanger() {
            return this.mGuaranteeChanger;
        }

        public String toString() {
            return "SuccInfo [mSuccessor=" + String.valueOf(this.mSuccessor) + ", mLetter=" + String.valueOf(this.mLetter) + ", mType=" + String.valueOf((Object)this.mType) + ", mLinPred=" + String.valueOf(this.mLinPred) + ", mGuarantee=" + this.mGuarantee + ", mGoalFound=" + this.mGoalFound + ", mGuaranteeChanger=" + this.mGuaranteeChanger + "]";
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + (this.mGoalFound ? 1231 : 1237);
            n = 31 * n + (this.mGuarantee ? 1231 : 1237);
            n = 31 * n + (this.mGuaranteeChanger ? 1231 : 1237);
            n = 31 * n + (this.mLetter == null ? 0 : this.mLetter.hashCode());
            n = 31 * n + (this.mLinPred == null ? 0 : this.mLinPred.hashCode());
            n = 31 * n + (this.mSuccessor == null ? 0 : this.mSuccessor.hashCode());
            n = 31 * n + (this.mType == null ? 0 : this.mType.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            SuccInfo succInfo = (SuccInfo)object;
            if (!this.getOuterType().equals(succInfo.getOuterType())) {
                return false;
            }
            if (this.mGoalFound != succInfo.mGoalFound) {
                return false;
            }
            if (this.mGuarantee != succInfo.mGuarantee) {
                return false;
            }
            if (this.mGuaranteeChanger != succInfo.mGuaranteeChanger) {
                return false;
            }
            if (this.mLetter == null ? succInfo.mLetter != null : !this.mLetter.equals(succInfo.mLetter)) {
                return false;
            }
            if (this.mLinPred == null ? succInfo.mLinPred != null : !this.mLinPred.equals(succInfo.mLinPred)) {
                return false;
            }
            if (this.mSuccessor == null ? succInfo.mSuccessor != null : !this.mSuccessor.equals(succInfo.mSuccessor)) {
                return false;
            }
            return this.mType == succInfo.mType;
        }

        private LassoExtractor<LETTER, STATE> getOuterType() {
            return LassoExtractor.this;
        }
    }

    class SummaryFinder
    extends RunFinder {
        public SummaryFinder(StateContainer<LETTER, STATE> stateContainer, StateContainer<LETTER, STATE> stateContainer2, boolean bl, HashRelation<StateContainer<LETTER, STATE>, Summary<LETTER, STATE>> hashRelation, Set<SuccInfo> set) {
            super(stateContainer, stateContainer2, bl, hashRelation, set);
        }

        @Override
        protected int getMaximalIterationNumber() {
            return LassoExtractor.this.getNwars().size();
        }

        @Override
        protected SuccInfo possiblePredecessor(StateContainer<LETTER, STATE> stateContainer, IncomingInternalTransition<LETTER, STATE> incomingInternalTransition, boolean bl, boolean bl2) {
            StateContainer stateContainer2 = LassoExtractor.this.getNwars().obtainStateContainer(incomingInternalTransition.getPred());
            if (!this.goalIsDownState(stateContainer2, bl2)) {
                return null;
            }
            boolean bl3 = bl2;
            boolean bl4 = bl3 = bl3 || LassoExtractor.this.getNwars().isFinal(stateContainer2.getState());
            if (this.alreadyVisited(stateContainer2, bl, bl3)) {
                return null;
            }
            boolean bl5 = bl3 ^ bl2;
            SuccInfo succInfo = new SuccInfo(stateContainer, incomingInternalTransition.getLetter(), NestedWordAutomatonReachableStates.InCaRe.INTERNAL, null, bl3, false, bl5);
            super.markVisited(stateContainer2, bl, bl3);
            return succInfo;
        }

        @Override
        protected SuccInfo possiblePredecessor(StateContainer<LETTER, STATE> stateContainer, IncomingCallTransition<LETTER, STATE> incomingCallTransition, boolean bl, boolean bl2) {
            StateContainer stateContainer2 = LassoExtractor.this.getNwars().obtainStateContainer(incomingCallTransition.getPred());
            if (!bl2 || !this.mGoal.equals(stateContainer2)) {
                return null;
            }
            SuccInfo succInfo = new SuccInfo(stateContainer, incomingCallTransition.getLetter(), NestedWordAutomatonReachableStates.InCaRe.CALL, null, bl2, true, false);
            super.markVisited(stateContainer2, bl, bl2);
            return succInfo;
        }

        @Override
        protected SuccInfo possiblePredecessor(StateContainer<LETTER, STATE> stateContainer, IncomingReturnTransition<LETTER, STATE> incomingReturnTransition, boolean bl, boolean bl2) {
            StateContainer stateContainer2 = LassoExtractor.this.getNwars().obtainStateContainer(incomingReturnTransition.getHierPred());
            if (!this.goalIsDownState(stateContainer2, bl2)) {
                return null;
            }
            boolean bl3 = bl2;
            bl3 = bl3 || LassoExtractor.this.getNwars().isFinal(stateContainer2.getState());
            boolean bl4 = bl3 = bl3 || this.isAcceptingSummary(stateContainer2, stateContainer);
            if (this.alreadyVisited(stateContainer2, true, bl3)) {
                return null;
            }
            boolean bl5 = bl3 ^ bl2;
            StateContainer stateContainer3 = LassoExtractor.this.getNwars().obtainStateContainer(incomingReturnTransition.getLinPred());
            SuccInfo succInfo = new SuccInfo(stateContainer, incomingReturnTransition.getLetter(), NestedWordAutomatonReachableStates.InCaRe.SUMMARY, stateContainer3, bl3, false, bl5);
            if (this.mForbiddenSummaries.contains(succInfo)) {
                return null;
            }
            super.markVisited(stateContainer2, true, bl3);
            return succInfo;
        }

        private boolean goalIsDownState(StateContainer<LETTER, STATE> stateContainer, boolean bl) {
            if (!stateContainer.getDownStates().containsKey(this.mGoal.getState())) {
                return false;
            }
            if (bl) {
                return true;
            }
            return stateContainer.hasDownProp(this.mGoal.getState(), StateContainer.DownStateProp.REACHABLE_FROM_FINAL_WITHOUT_CALL);
        }
    }
}

