/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal;

import de.uni_freiburg.informatik.ultimate.lassoranker.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunction;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.AffineFunctionGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.internal.AbstractLinearInvariantPattern;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LinearPatternWithConstantCoefficients
extends AbstractLinearInvariantPattern {
    private final Map<IProgramVar, AffineTerm> mProgramVars2ConstantCoefficients;
    private Map<IProgramVar, Term> mProgramVars2TermVariables = null;
    private AffineTerm mConstant = null;
    private LinearInequality mLinearInequality = null;
    private String mName = null;
    private final Map<Term, AffineTerm> mAuxVarsToConstantCoefficients;

    public LinearPatternWithConstantCoefficients(Script script, Set<IProgramVar> set, String string, boolean bl, Map<IProgramVar, AffineTerm> map, Map<Term, AffineTerm> map2, AffineTerm affineTerm) {
        assert (set.equals(map.keySet())) : "The given set of variables must be equal to the key-set of the map programVarsToConstantCoefficients";
        this.mFunctionGenerator = new AffineFunctionGenerator(script, set, string, true);
        this.mStrictInequality = bl;
        this.mVariablesOfThisPattern = set;
        this.mProgramVars2ConstantCoefficients = map;
        this.mAuxVarsToConstantCoefficients = map2;
        this.mConstant = affineTerm;
    }

    @Override
    public Collection<Term> getCoefficients() {
        return Collections.emptyList();
    }

    public void setName(String string) {
        this.mName = string;
    }

    @Override
    public LinearInequality getLinearInequality(Map<IProgramVar, Term> map) {
        IProgramVar iProgramVar2;
        assert (map.keySet().containsAll(this.mVariablesOfThisPattern)) : "The given map does not contain an entry for each variable of this pattern";
        HashMap<IProgramVar, Term> hashMap = new HashMap<IProgramVar, Term>(this.mVariablesOfThisPattern.size());
        for (IProgramVar iProgramVar2 : this.mVariablesOfThisPattern) {
            hashMap.put(iProgramVar2, map.get(iProgramVar2));
        }
        iProgramVar2 = this.mFunctionGenerator.generate(hashMap, this.mProgramVars2ConstantCoefficients, this.mAuxVarsToConstantCoefficients);
        iProgramVar2.setStrict(this.mStrictInequality);
        iProgramVar2.add(this.mConstant);
        this.mProgramVars2TermVariables = hashMap;
        this.mLinearInequality = iProgramVar2;
        return iProgramVar2;
    }

    @Override
    public AffineFunction getAffineFunction(Map<Term, Rational> map) {
        AffineFunction affineFunction = new AffineFunction();
        for (IProgramVar iProgramVar : this.mProgramVars2TermVariables.keySet()) {
            if (!this.mProgramVars2ConstantCoefficients.containsKey(iProgramVar)) continue;
            affineFunction.put(iProgramVar, this.mProgramVars2ConstantCoefficients.get(iProgramVar).getConstant().numerator());
        }
        affineFunction.setConstant(this.mConstant.getConstant().numerator());
        return affineFunction;
    }

    public String toString() {
        if (this.mLinearInequality != null) {
            if (this.mName != null) {
                return this.mName + ": " + this.mLinearInequality.toString();
            }
            return this.mLinearInequality.toString();
        }
        return super.toString();
    }
}

