/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.StringFactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class GetRandomNwaTv
extends GeneralOperation<String, String, IStateFactory<String>> {
    private static final double HUNDRED = 100.0;
    private static final String LETTER_CALL_PREFIX = "c";
    private static final String LETTER_INTERNAL_PREFIX = "a";
    private static final String LETTER_RETURN_PREFIX = "r";
    private static final int MODE_CALL = 1;
    private static final int MODE_INTERNAL = 0;
    private static final int MODE_RETURN = 2;
    private static final double ONE = 1.0;
    private static final String STATE_PREFIX = "q";
    private static final double ZERO = 0.0;
    private static final int ZERO_INT = 0;
    private static final long DEFAULT_SEED = 0L;
    private final double mAcceptanceDensity;
    private final double mCallTransitionDensity;
    private final double mHierarchicalPredecessorDensity;
    private final double mInternalTransitionDensity;
    private final int mNumberOfCallLetters;
    private final int mNumberOfInternalLetters;
    private final int mNumberOfReturnLetters;
    private final int mNumberOfStates;
    private final NestedWordAutomaton<String, String> mResult;
    private final double mReturnTransitionDensity;

    public GetRandomNwaTv(AutomataLibraryServices automataLibraryServices, int n, int n2, int n3, int n4) {
        this(automataLibraryServices, n, n2, (double)n3 / 100.0, (double)n4 / 100.0, 0L);
    }

    public GetRandomNwaTv(AutomataLibraryServices automataLibraryServices, int n, int n2, double d, double d2, long l) {
        this(automataLibraryServices, n, n2, 0, 0, d, 0.0, 0.0, 0.0, d2, l);
    }

    public GetRandomNwaTv(AutomataLibraryServices automataLibraryServices, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this(automataLibraryServices, n, n2, n3, n4, (double)n5 / 100.0, (double)n6 / 100.0, (double)n7 / 100.0, (double)n8 / 100.0, (double)n9 / 100.0, 0L);
    }

    public GetRandomNwaTv(AutomataLibraryServices automataLibraryServices, int n, int n2, int n3, int n4, double d, double d2, double d3, double d4, double d5, long l) {
        super(automataLibraryServices);
        this.mNumberOfStates = n;
        this.mNumberOfInternalLetters = n2;
        this.mNumberOfCallLetters = n3;
        this.mNumberOfReturnLetters = n4;
        this.mInternalTransitionDensity = d;
        this.mCallTransitionDensity = d2;
        this.mReturnTransitionDensity = d3;
        this.mHierarchicalPredecessorDensity = d4;
        this.mAcceptanceDensity = d5;
        this.checkInputValidity();
        this.mResult = this.generateAutomaton(l);
    }

    @Override
    public INestedWordAutomaton<String, String> getResult() {
        return this.mResult;
    }

    private static int densityToAbsolute(double d, int n) {
        int n2 = (int)(d * (double)n);
        int n3 = n2 > 0 ? n2 : (d == 0.0 ? 0 : 1);
        return n3;
    }

    private void addStates(NestedWordAutomaton<String, String> nestedWordAutomaton, String[] stringArray, Random random) {
        int n = random.nextInt(this.mNumberOfStates);
        int n2 = GetRandomNwaTv.densityToAbsolute(this.mAcceptanceDensity, this.mNumberOfStates);
        int n3 = 0;
        while (n3 < this.mNumberOfStates) {
            String string = STATE_PREFIX + Integer.toString(n3);
            nestedWordAutomaton.addState(n3 == n, n3 < n2, string);
            stringArray[n3] = string;
            ++n3;
        }
    }

    private void addTransitions(Set<String> set, NestedWordAutomaton<String, String> nestedWordAutomaton, Random random, String[] stringArray, int n) {
        int n2;
        int n3;
        String string = switch (n) {
            case 0 -> {
                n3 = this.mNumberOfInternalLetters;
                n2 = GetRandomNwaTv.densityToAbsolute(this.mInternalTransitionDensity, this.mNumberOfStates);
                yield LETTER_INTERNAL_PREFIX;
            }
            case 1 -> {
                n3 = this.mNumberOfCallLetters;
                n2 = GetRandomNwaTv.densityToAbsolute(this.mCallTransitionDensity, this.mNumberOfStates);
                yield LETTER_CALL_PREFIX;
            }
            case 2 -> {
                n3 = this.mNumberOfReturnLetters;
                n2 = GetRandomNwaTv.densityToAbsolute(this.mReturnTransitionDensity, this.mNumberOfStates);
                yield LETTER_RETURN_PREFIX;
            }
            default -> throw new IllegalArgumentException();
        };
        boolean[][] blArray = new boolean[this.mNumberOfStates][this.mNumberOfStates];
        int n4 = 0;
        while (n4 < n3) {
            String string2 = string + Integer.toString(n4);
            set.add(string2);
            if (n4 == 0) {
                var12_12 = 0;
                while (var12_12 < this.mNumberOfStates) {
                    blArray[var12_12] = new boolean[this.mNumberOfStates];
                    ++var12_12;
                }
            } else {
                var12_12 = 0;
                while (var12_12 < this.mNumberOfStates) {
                    Arrays.fill(blArray[var12_12], false);
                    ++var12_12;
                }
            }
            this.addTransitionsGivenLetter(nestedWordAutomaton, random, stringArray, blArray, string2, n2, n);
            ++n4;
        }
    }

    private void addTransitionsGivenLetter(NestedWordAutomaton<String, String> nestedWordAutomaton, Random random, String[] stringArray, boolean[][] blArray, String string, int n, int n2) {
        int n3 = 0;
        while (n3 < n) {
            int n4;
            int n5;
            while (blArray[n5 = random.nextInt(this.mNumberOfStates)][n4 = random.nextInt(this.mNumberOfStates)]) {
            }
            this.addTransitionToAutomaton(nestedWordAutomaton, stringArray, string, n2, n5, n4, random);
            blArray[n5][n4] = true;
            ++n3;
        }
    }

    private void addTransitionToAutomaton(NestedWordAutomaton<String, String> nestedWordAutomaton, String[] stringArray, String string, int n, int n2, int n3, Random random) {
        switch (n) {
            case 0: {
                nestedWordAutomaton.addInternalTransition(stringArray[n2], string, stringArray[n3]);
                break;
            }
            case 1: {
                nestedWordAutomaton.addCallTransition(stringArray[n2], string, stringArray[n3]);
                break;
            }
            case 2: {
                for (int n4 : this.getRandomHierarchicalPredecessors(random)) {
                    nestedWordAutomaton.addReturnTransition(stringArray[n2], stringArray[n4], string, stringArray[n3]);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void checkInputValidity() {
        if (this.mNumberOfStates < 0) {
            throw new IllegalArgumentException("Negative number of states.");
        }
        if (this.mNumberOfInternalLetters < 0) {
            throw new IllegalArgumentException("Negative number of letters.");
        }
        if (this.mNumberOfInternalLetters == 0 && this.mInternalTransitionDensity > 0.0) {
            throw new IllegalArgumentException("Impossible to have internal transitions without letters.");
        }
        if (this.mNumberOfCallLetters == 0 && this.mCallTransitionDensity > 0.0) {
            throw new IllegalArgumentException("Impossible to have call transitions without letters.");
        }
        if (this.mNumberOfReturnLetters == 0 && this.mReturnTransitionDensity > 0.0) {
            throw new IllegalArgumentException("Impossible to have return transitions without letters.");
        }
        if (this.mInternalTransitionDensity < 0.0 || this.mCallTransitionDensity < 0.0 || this.mReturnTransitionDensity < 0.0) {
            throw new IllegalArgumentException("Negative transition density.");
        }
        if (this.mHierarchicalPredecessorDensity < 0.0) {
            throw new IllegalArgumentException("Negative hierarchical predecessor density.");
        }
        if (this.mReturnTransitionDensity > 0.0 ^ this.mHierarchicalPredecessorDensity > 0.0) {
            throw new IllegalArgumentException("Inconsistent return transition and hierarchical predecessor density.");
        }
        if (this.mAcceptanceDensity < 0.0 || this.mAcceptanceDensity > 1.0) {
            throw new IllegalArgumentException("Illegal acceptance density.");
        }
    }

    private NestedWordAutomaton<String, String> generateAutomaton(long l) {
        HashSet<String> hashSet = new HashSet<String>(this.mNumberOfInternalLetters);
        HashSet<String> hashSet2 = new HashSet<String>(this.mNumberOfInternalLetters);
        HashSet<String> hashSet3 = new HashSet<String>(this.mNumberOfInternalLetters);
        NestedWordAutomaton<String, String> nestedWordAutomaton = new NestedWordAutomaton<String, String>(this.mServices, new VpAlphabet(hashSet, hashSet2, hashSet3), new StringFactory());
        if (this.mNumberOfStates == 0) {
            return nestedWordAutomaton;
        }
        Random random = new Random(l);
        String[] stringArray = new String[this.mNumberOfStates];
        this.addStates(nestedWordAutomaton, stringArray, random);
        this.addTransitions(hashSet, nestedWordAutomaton, random, stringArray, 0);
        this.addTransitions(hashSet2, nestedWordAutomaton, random, stringArray, 1);
        this.addTransitions(hashSet3, nestedWordAutomaton, random, stringArray, 2);
        return nestedWordAutomaton;
    }

    private Iterable<Integer> getRandomHierarchicalPredecessors(Random random) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n = GetRandomNwaTv.densityToAbsolute(this.mHierarchicalPredecessorDensity, this.mNumberOfStates);
        while (hashSet.size() < n) {
            hashSet.add(random.nextInt(this.mNumberOfStates));
        }
        return hashSet;
    }
}

