/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib;

import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.LoggingScript;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashMap;
import java.util.Map;

public class Benchmark {
    private final Script mScript;
    private int mFormulaNum;
    private final Map<String, Sort> mSortTranslator;
    private final Map<String, String> mFunNameTranslator;

    public Benchmark(Script script, boolean bl) {
        this.mScript = script;
        this.mFormulaNum = bl ? -2 : -1;
        this.mSortTranslator = new HashMap<String, Sort>();
        this.mFunNameTranslator = new HashMap<String, String>();
        this.mScript.setOption(":produce-proofs", (Object)true);
    }

    public void setOption(String string, Object object) {
        this.mScript.setOption(string, object);
    }

    public void note(String string) {
        if ("Interpolation Problem starts here".equals(string)) {
            ++this.mFormulaNum;
        }
    }

    private final void mapFuns() {
        this.mFunNameTranslator.put("abs", "abs$");
        this.mFunNameTranslator.put("mod", "mod$");
        this.mFunNameTranslator.put("div", "div$");
    }

    private final void mapArith() {
        this.mFunNameTranslator.put("~", "-");
    }

    private final String translateFunName(String string) {
        String string2 = this.mFunNameTranslator.get(string);
        return string2 == null ? string : string2;
    }

    public void setLogic(String string) {
        Logics logics = Logics.valueOf((String)string);
        this.mScript.setLogic(logics);
        switch (logics) {
            case QF_AX: {
                this.mScript.declareSort("Index", 0);
                this.mScript.declareSort("Element", 0);
                this.mSortTranslator.put("Array", this.mScript.sort("Array", new Sort[]{this.mScript.sort("Index", new Sort[0]), this.mScript.sort("Element", new Sort[0])}));
                break;
            }
            case AUFLIRA: 
            case AUFNIRA: {
                Sort sort = this.mScript.sort("Array", new Sort[]{this.mScript.sort("Int", new Sort[0]), this.mScript.sort("Real", new Sort[0])});
                this.mSortTranslator.put("Array1", sort);
                this.mSortTranslator.put("Array2", this.mScript.sort("Array", new Sort[]{this.mScript.sort("Int", new Sort[0]), sort}));
                this.mapFuns();
                this.mapArith();
                break;
            }
            case QF_AUFLIA: 
            case AUFLIA: {
                this.mSortTranslator.put("Array", this.mScript.sort("Array", new Sort[]{this.mScript.sort("Int", new Sort[0]), this.mScript.sort("Real", new Sort[0])}));
            }
            case QF_UFLIA: 
            case QF_UFLRA: {
                this.mapFuns();
                this.mapArith();
                break;
            }
            case QF_UF: {
                this.mScript.declareSort("U", 0);
                break;
            }
            case QF_IDL: 
            case QF_LIA: 
            case QF_LRA: 
            case QF_RDL: 
            case LRA: {
                this.mapArith();
                break;
            }
        }
    }

    public void setInfo(String string, String string2) {
        this.mScript.setInfo(string, (Object)string2);
    }

    public void declareSort(String string) {
        this.mScript.declareSort(string, 0);
    }

    public void declareFun(String string, Sort[] sortArray, Sort sort) {
        this.mScript.declareFun(this.translateFunName(string), sortArray, sort);
    }

    public Term term(String string, Term ... termArray) {
        return this.mScript.term(this.translateFunName(string), termArray);
    }

    public Term annotateTerm(Term term, Annotation ... annotationArray) {
        if (annotationArray.length > 0) {
            term = this.mScript.annotate(term, annotationArray);
        }
        return term;
    }

    public Term quantifier(int n, TermVariable[] termVariableArray, Term term, Term[] ... termArray) {
        return this.mScript.quantifier(n, termVariableArray, term, termArray);
    }

    public Term let(TermVariable termVariable, Term term, Term term2) {
        return this.mScript.let(new TermVariable[]{termVariable}, new Term[]{term}, term2);
    }

    public Sort sort(String string) {
        Sort sort = this.mSortTranslator.get(string);
        if (sort != null) {
            return sort;
        }
        return this.mScript.sort(string, new Sort[0]);
    }

    public TermVariable variable(String string, Sort sort) {
        return this.mScript.variable(string, sort);
    }

    public Sort getBooleanSort() {
        return this.mScript.sort("Bool", new Sort[0]);
    }

    public void assertTerm(Term term) {
        if (this.mFormulaNum >= 0) {
            term = this.mScript.annotate(term, new Annotation[]{new Annotation(":named", (Object)("IP_" + this.mFormulaNum++))});
        }
        this.mScript.assertTerm(term);
    }

    public Term numeral(String string) {
        return this.mScript.numeral(string);
    }

    public Term decimal(String string) {
        return this.mScript.decimal(string);
    }

    public Term[] check() {
        Script.LBool lBool = this.mScript.checkSat();
        if (!(this.mScript instanceof LoggingScript)) {
            System.out.println(lBool);
        }
        if (this.mFormulaNum > 1) {
            Term[] termArray = new Term[this.mFormulaNum];
            int n = 0;
            while (n < this.mFormulaNum) {
                termArray[n] = this.mScript.term("IP_" + n, new Term[0]);
                ++n;
            }
            return this.mScript.getInterpolants(termArray);
        }
        return null;
    }

    public void close() {
        this.mScript.exit();
    }

    public void getProof() {
        this.mScript.getProof();
    }
}

