/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.EqualityProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.NumericSortInterpretation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SharedTermEvaluator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.BoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.CompositeReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.CutCreator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.EQAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.ExactInfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.Explainer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LASharedTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LiteralReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MatrixEntry;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.SOIPivoter;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.TableauxRow;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedArrayList;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class LinArSolve
implements ITheory {
    final Clausifier mClausifier;
    final ScopedArrayList<LinVar> mLinvars;
    final ArrayList<TableauxRow> mTableaux;
    final ArrayList<BitSet> mDependentRows;
    final Set<LinVar> mIntVars;
    final Queue<Literal> mProplist;
    final ScopedHashMap<Map<LinVar, Rational>, LinVar> mBasics;
    final Set<LinVar> mOob;
    int mNumPivots;
    int mNumPivotsBland;
    long mPivotTime;
    long mFixTime;
    int mCompositeCreateLit;
    int mCountGetUpperBound;
    long mTimeGetUpperBound;
    int mNumCuts;
    int mNumBranches;
    long mCutGenTime;
    final ScopedArrayList<LASharedTerm> mSharedVars = new ScopedArrayList();
    final ArrayDeque<Literal> mSuggestions;
    private long mPropBoundTime;
    private long mPropBoundSetTime;
    private long mBacktrackPropTime;
    private final BitSet mDirty;
    private LinVar mConflictVar;
    private Rational mEps;
    private boolean mInCheck = false;
    private int mHasNonLinearVar = -1;
    private int mPushPopLevel = 0;

    public LinArSolve(Clausifier clausifier) {
        this.mClausifier = clausifier;
        this.mLinvars = new ScopedArrayList();
        this.mTableaux = new ArrayList();
        this.mDependentRows = new ArrayList();
        this.mIntVars = new LinkedHashSet<LinVar>();
        this.mDirty = new BitSet();
        this.mProplist = new ArrayDeque<Literal>();
        this.mSuggestions = new ArrayDeque();
        this.mBasics = new ScopedHashMap();
        this.mOob = new HashSet<LinVar>();
        this.mNumPivots = 0;
        this.mPivotTime = 0L;
        this.mFixTime = 0L;
        this.mCompositeCreateLit = 0;
        this.mNumCuts = 0;
        this.mNumBranches = 0;
        this.mCutGenTime = 0L;
    }

    public DPLLEngine getEngine() {
        return this.mClausifier.getEngine();
    }

    public LogProxy getLogger() {
        return this.mClausifier.getLogger();
    }

    private boolean checkClean() {
        return true;
    }

    private boolean checkoobcontent() {
        for (LinVar linVar : this.mLinvars) {
            assert (!linVar.outOfBounds() || this.mOob.contains(linVar)) : "Variable " + String.valueOf(linVar) + " is out of bounds: " + String.valueOf(linVar.getLowerBound()) + "<=" + String.valueOf(linVar.getValue()) + "<=" + String.valueOf(linVar.getUpperBound());
        }
        return true;
    }

    public LinVar addVar(Term term, boolean bl, int n) {
        if (term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("*")) {
            this.mHasNonLinearVar = this.mPushPopLevel;
        }
        this.mClausifier.getLogger().debug("Creating var %s", term);
        LinVar linVar = new LinVar(term, bl, n, this.mLinvars.size());
        this.mLinvars.add(linVar);
        this.mDependentRows.add(new BitSet());
        this.mTableaux.add(null);
        if (bl) {
            this.mIntVars.add(linVar);
        }
        return linVar;
    }

    private LinVar generateLinVar(TreeMap<LinVar, Rational> treeMap) {
        if (treeMap.size() == 1) {
            Map.Entry<LinVar, Rational> entry = treeMap.entrySet().iterator().next();
            assert (entry.getValue().equals((Object)Rational.ONE));
            LinVar linVar = entry.getKey();
            return linVar;
        }
        LinVar linVar = (LinVar)this.mBasics.get(treeMap);
        if (linVar == null) {
            LinVar[] linVarArray = new LinVar[treeMap.size()];
            BigInteger[] bigIntegerArray = new BigInteger[treeMap.size()];
            int n = 0;
            TreeMap<LinVar, Rational> treeMap2 = new TreeMap<LinVar, Rational>();
            boolean bl = true;
            for (Map.Entry<LinVar, Rational> entry : treeMap.entrySet()) {
                linVarArray[n] = entry.getKey();
                assert (entry.getValue().denominator().equals(BigInteger.ONE));
                bigIntegerArray[n] = entry.getValue().numerator();
                this.unsimplifyAndAdd(entry.getKey(), entry.getValue(), treeMap2);
                bl &= linVarArray[n].mIsInt;
                ++n;
            }
            int n2 = this.mLinvars.size();
            linVar = new LinVar(new LinTerm(linVarArray, bigIntegerArray), bl, this.mClausifier.getStackLevel(), n2);
            this.mBasics.put(treeMap, (Object)linVar);
            this.mLinvars.add(linVar);
            this.mDependentRows.add(null);
            this.mTableaux.add(new TableauxRow(linVar, treeMap2));
            this.mDirty.set(n2);
            this.mClausifier.getLogger().debug("Generated LinVar %1$s", linVar);
            linVar.mBasic = true;
            Object object = ExactInfinitesimalNumber.ZERO;
            for (MatrixEntry matrixEntry : linVar.getTableauxRow(this)) {
                LinVar linVar2 = matrixEntry.getColumn();
                Rational rational = Rational.valueOf((BigInteger)matrixEntry.getCoeff(), (BigInteger)matrixEntry.getHeadCoeff().negate());
                object = ((ExactInfinitesimalNumber)object).add(linVar2.getValue().mul(rational));
                this.mDependentRows.get(linVar2.mMatrixpos).set(linVar.mMatrixpos);
            }
            linVar.setValue((ExactInfinitesimalNumber)object);
            assert (linVar.checkCoeffChain(this));
        }
        return linVar;
    }

    public Literal generateConstraint(MutableAffineTerm mutableAffineTerm, boolean bl) {
        Rational rational = mutableAffineTerm.getGCD().inverse();
        mutableAffineTerm.mul(rational);
        LinVar linVar = this.generateLinVar(this.getSummandMap(mutableAffineTerm));
        return this.generateConstraint(linVar, mutableAffineTerm.mConstant.mReal.negate(), rational.isNegative(), bl);
    }

    private final TreeMap<LinVar, Rational> getSummandMap(MutableAffineTerm mutableAffineTerm) {
        return mutableAffineTerm.getSummands();
    }

    void updateVariableValue(LinVar linVar, ExactInfinitesimalNumber exactInfinitesimalNumber) {
        assert (!linVar.mBasic);
        ExactInfinitesimalNumber exactInfinitesimalNumber2 = exactInfinitesimalNumber.sub(linVar.getValue());
        linVar.addValue(exactInfinitesimalNumber2);
        for (MatrixEntry matrixEntry : linVar.getTableauxColumn(this)) {
            LinVar linVar2 = matrixEntry.getRow();
            assert (linVar2.mBasic);
            Rational rational = Rational.valueOf((BigInteger)matrixEntry.getCoeff(), (BigInteger)matrixEntry.getHeadCoeff().negate());
            linVar2.addValue(exactInfinitesimalNumber2.mul(rational));
            assert (!linVar2.getValue().getRealValue().denominator().equals(BigInteger.ZERO));
            if (!linVar2.outOfBounds()) continue;
            this.mOob.add(linVar2);
        }
    }

    private void updateVariable(LinVar linVar, boolean bl, InfinitesimalNumber infinitesimalNumber, InfinitesimalNumber infinitesimalNumber2) {
        boolean bl2;
        assert (!linVar.mBasic);
        ExactInfinitesimalNumber exactInfinitesimalNumber = linVar.getValue().isub(infinitesimalNumber2);
        boolean bl3 = bl ? exactInfinitesimalNumber.signum() < 0 : (bl2 = exactInfinitesimalNumber.signum() > 0);
        if (bl2) {
            linVar.addValue(exactInfinitesimalNumber);
        }
        assert (!linVar.getValue().getRealValue().denominator().equals(BigInteger.ZERO));
        BitSet bitSet = this.mDependentRows.get(linVar.mMatrixpos);
        this.mDirty.or(bitSet);
        for (MatrixEntry matrixEntry : linVar.getTableauxColumn(this)) {
            LinVar linVar2 = matrixEntry.getRow();
            assert (linVar2.mBasic);
            Rational rational = Rational.valueOf((BigInteger)matrixEntry.getCoeff(), (BigInteger)matrixEntry.getHeadCoeff().negate());
            if (bl2) {
                linVar2.addValue(exactInfinitesimalNumber.mul(rational));
            }
            assert (!linVar2.getValue().getRealValue().denominator().equals(BigInteger.ZERO));
            if (!linVar2.outOfBounds()) continue;
            this.mOob.add(linVar2);
        }
    }

    public void removeReason(LAReason lAReason) {
        LAReason lAReason2;
        LinVar linVar = lAReason.getVar();
        if (lAReason.isUpper()) {
            if (linVar.mUpper == lAReason) {
                linVar.mUpper = lAReason.getOldReason();
                if (linVar.mUpperLiteral == lAReason) {
                    linVar.mUpperLiteral = ((LiteralReason)lAReason).getOldLiteralReason();
                } else assert (lAReason instanceof CompositeReason);
                if (!linVar.mBasic) {
                    if (linVar.getValue().compareTo(linVar.getLowerBound()) < 0) {
                        this.updateVariableValue(linVar, new ExactInfinitesimalNumber(linVar.getLowerBound()));
                    }
                } else if (linVar.outOfBounds()) {
                    this.mOob.add(linVar);
                }
                return;
            }
            lAReason2 = linVar.mUpper;
            if (linVar.mUpperLiteral == lAReason) {
                linVar.mUpperLiteral = ((LiteralReason)lAReason).getOldLiteralReason();
            }
        } else {
            if (linVar.mLower == lAReason) {
                linVar.mLower = lAReason.getOldReason();
                if (linVar.mLowerLiteral == lAReason) {
                    linVar.mLowerLiteral = ((LiteralReason)lAReason).getOldLiteralReason();
                } else assert (lAReason instanceof CompositeReason);
                if (!linVar.mBasic) {
                    if (linVar.getValue().compareTo(linVar.getUpperBound()) > 0) {
                        this.updateVariableValue(linVar, new ExactInfinitesimalNumber(linVar.getUpperBound()));
                    }
                } else if (linVar.outOfBounds()) {
                    this.mOob.add(linVar);
                }
                return;
            }
            lAReason2 = linVar.mLower;
            if (linVar.mLowerLiteral == lAReason) {
                linVar.mLowerLiteral = ((LiteralReason)lAReason).getOldLiteralReason();
            }
        }
        while (true) {
            if (lAReason2 instanceof LiteralReason && ((LiteralReason)lAReason2).getOldLiteralReason() == lAReason) {
                ((LiteralReason)lAReason2).setOldLiteralReason(((LiteralReason)lAReason).getOldLiteralReason());
            }
            if (lAReason2.getOldReason() == lAReason) break;
            lAReason2 = lAReason2.getOldReason();
        }
        lAReason2.setOldReason(lAReason.getOldReason());
    }

    public void removeLiteralReason(LiteralReason literalReason) {
        assert (this.checkClean());
        for (LAReason lAReason : literalReason.getDependents()) {
            this.removeReason(lAReason);
        }
        this.removeReason(literalReason);
        assert (this.checkClean());
    }

    @Override
    public void backtrackLiteral(Literal literal) {
        InfinitesimalNumber infinitesimalNumber;
        LinVar linVar;
        Object object;
        assert (this.checkClean());
        DPLLAtom dPLLAtom = literal.getAtom();
        if (dPLLAtom instanceof LAEquality) {
            object = (LAEquality)dPLLAtom;
            linVar = ((LAEquality)object).getVar();
            infinitesimalNumber = new InfinitesimalNumber(((LAEquality)object).getBound(), 0);
            if (object == literal.negate()) {
                linVar.removeDiseq((LAEquality)object);
            }
        } else if (dPLLAtom instanceof BoundConstraint) {
            object = (BoundConstraint)dPLLAtom;
            linVar = ((BoundConstraint)object).getVar();
            infinitesimalNumber = ((BoundConstraint)object).getBound();
        } else {
            return;
        }
        object = linVar.mUpper;
        while (object != null && ((LAReason)object).getBound().lesseq(infinitesimalNumber)) {
            if (object instanceof LiteralReason && ((LiteralReason)object).getLiteral() == literal && ((LAReason)object).getLastLiteral() == object) {
                this.removeLiteralReason((LiteralReason)object);
                break;
            }
            object = ((LAReason)object).getOldReason();
        }
        object = linVar.mLower;
        while (object != null && infinitesimalNumber.lesseq(((LAReason)object).getBound())) {
            if (object instanceof LiteralReason && ((LiteralReason)object).getLiteral() == literal && ((LAReason)object).getLastLiteral() == object) {
                this.removeLiteralReason((LiteralReason)object);
                break;
            }
            object = ((LAReason)object).getOldReason();
        }
    }

    public Clause checkPendingConflict() {
        LinVar linVar = this.mConflictVar;
        if (linVar != null && linVar.getTightUpperBound().less(linVar.getTightLowerBound())) {
            Explainer explainer = new Explainer(this, this.getEngine().isProofGenerationEnabled(), null);
            InfinitesimalNumber infinitesimalNumber = linVar.getTightLowerBound().sub(linVar.getTightUpperBound());
            infinitesimalNumber = linVar.mUpper.explain(explainer, infinitesimalNumber, Rational.ONE);
            infinitesimalNumber = linVar.mLower.explain(explainer, infinitesimalNumber, Rational.MONE);
            return explainer.createClause(this.getEngine());
        }
        this.mConflictVar = null;
        return null;
    }

    @Override
    public void backtrackAll() {
        this.mProplist.clear();
        this.mSuggestions.clear();
    }

    @Override
    public void backtrackStart() {
        this.mProplist.clear();
        this.mSuggestions.clear();
    }

    @Override
    public Clause backtrackComplete() {
        Clause clause = this.checkPendingConflict();
        if (clause != null) {
            return clause;
        }
        clause = this.checkPendingBoundPropagations();
        if (clause != null) {
            return clause;
        }
        for (LinVar linVar : this.mLinvars) {
            if (linVar.hasTightUpperBound()) {
                for (DPLLAtom dPLLAtom : linVar.mConstraints.tailMap(linVar.getTightUpperBound(), true).values()) {
                    assert (linVar.getTightUpperBound().lesseq(((BoundConstraint)dPLLAtom).getBound()));
                    if (dPLLAtom.getDecideStatus() != null) continue;
                    this.mProplist.add(dPLLAtom);
                }
                for (DPLLAtom dPLLAtom : linVar.mEqualities.tailMap(linVar.getTightUpperBound(), false).values()) {
                    if (dPLLAtom.getDecideStatus() != null) continue;
                    this.mProplist.add(dPLLAtom.negate());
                }
            }
            if (!linVar.hasTightLowerBound()) continue;
            for (DPLLAtom dPLLAtom : linVar.mConstraints.headMap(linVar.getTightLowerBound(), false).values()) {
                if (dPLLAtom.getDecideStatus() != null) continue;
                this.mProplist.add(dPLLAtom.negate());
            }
            for (DPLLAtom dPLLAtom : linVar.mEqualities.headMap(linVar.getTightLowerBound(), false).values()) {
                if (dPLLAtom.getDecideStatus() != null) continue;
                this.mProplist.add(dPLLAtom.negate());
            }
        }
        assert (this.checkClean());
        return this.fixOobs();
    }

    Clause checkPendingBoundPropagations() {
        while (!this.mDirty.isEmpty()) {
            Object object;
            Object object2;
            int n = this.mDirty.nextSetBit(0);
            LinVar linVar = (LinVar)this.mLinvars.get(n);
            this.mDirty.clear(n);
            if (!linVar.mBasic) continue;
            long l = System.nanoTime();
            boolean bl = true;
            boolean bl2 = true;
            TableauxRow tableauxRow = this.mTableaux.get(linVar.mMatrixpos);
            int n2 = -tableauxRow.getRawCoeff(0).signum();
            int n3 = 1;
            while (n3 < tableauxRow.size()) {
                int n4 = tableauxRow.getRawCoeff(n3).signum();
                object2 = (LinVar)this.mLinvars.get(tableauxRow.getRawIndex(n3));
                if (bl) {
                    Object object3 = object = n4 == n2 ? ((LinVar)object2).getUpperBound() : ((LinVar)object2).getLowerBound();
                    if (((InfinitesimalNumber)object).isInfinity()) {
                        bl = false;
                    }
                }
                if (bl2) {
                    Object object4 = object = n4 == n2 ? ((LinVar)object2).getLowerBound() : ((LinVar)object2).getUpperBound();
                    if (((InfinitesimalNumber)object).isInfinity()) {
                        bl2 = false;
                    }
                }
                ++n3;
            }
            this.mBacktrackPropTime += System.nanoTime() - l;
            l = System.nanoTime();
            if (bl || bl2) {
                InfinitesimalNumber infinitesimalNumber = InfinitesimalNumber.ZERO;
                InfinitesimalNumber infinitesimalNumber2 = InfinitesimalNumber.ZERO;
                object = linVar.getTableauxRow(this).iterator();
                while (object.hasNext()) {
                    InfinitesimalNumber infinitesimalNumber3;
                    object2 = (MatrixEntry)object.next();
                    Rational rational = Rational.valueOf((BigInteger)((MatrixEntry)object2).getCoeff(), (BigInteger)((MatrixEntry)object2).getHeadCoeff().negate());
                    LinVar linVar2 = ((MatrixEntry)object2).getColumn();
                    if (bl) {
                        infinitesimalNumber3 = rational.signum() > 0 ? linVar2.getUpperBound() : linVar2.getLowerBound();
                        infinitesimalNumber = infinitesimalNumber.add(infinitesimalNumber3.mul(rational));
                    }
                    if (!bl2) continue;
                    infinitesimalNumber3 = rational.signum() > 0 ? linVar2.getLowerBound() : linVar2.getUpperBound();
                    infinitesimalNumber2 = infinitesimalNumber2.add(infinitesimalNumber3.mul(rational));
                }
                object2 = null;
                if (bl) {
                    object2 = this.propagateBound(linVar, infinitesimalNumber, true);
                }
                if (bl2) {
                    if (object2 == null) {
                        object2 = this.propagateBound(linVar, infinitesimalNumber2, false);
                    } else {
                        this.mDirty.set(linVar.mMatrixpos);
                    }
                }
                if (object2 != null) {
                    this.mPropBoundTime += System.nanoTime() - l;
                    return object2;
                }
            }
            this.mPropBoundTime += System.nanoTime() - l;
        }
        return null;
    }

    @Override
    public Clause computeConflictClause() {
        this.mSuggestions.clear();
        this.mClausifier.getLogger().debug("Final Check LA");
        assert (this.mOob.isEmpty());
        Clause clause = this.ensureIntegrals();
        if (clause != null || !this.mSuggestions.isEmpty() || !this.mProplist.isEmpty()) {
            return clause;
        }
        assert (this.mOob.isEmpty());
        this.mutate();
        assert (this.mOob.isEmpty());
        Map<ExactInfinitesimalNumber, List<LASharedTerm>> map = this.getSharedCongruences();
        assert (this.checkClean());
        this.mClausifier.getLogger().debug("cong: %s", map);
        for (LinVar linVar : this.mLinvars) {
            Literal literal;
            LAEquality lAEquality = linVar.getDiseq(linVar.getValue().getRealValue());
            if (lAEquality == null || (literal = this.ensureDisequality(lAEquality)) == null) continue;
            assert (literal.getAtom().getDecideStatus() == null);
            this.mSuggestions.add(literal);
            this.mClausifier.getLogger().debug("Using %s to ensure disequality %s", literal, lAEquality.negate());
        }
        if (this.mSuggestions.isEmpty() && this.mProplist.isEmpty()) {
            return this.mbtc(map);
        }
        assert (this.compositesSatisfied());
        return null;
    }

    @Override
    public int checkCompleteness() {
        if (this.mHasNonLinearVar >= 0) {
            return 2;
        }
        return 0;
    }

    private boolean compositesSatisfied() {
        for (LinVar linVar : this.mLinvars) {
            assert (linVar.getValue().roundToInfinitesimal().compareTo(linVar.getTightUpperBound()) <= 0);
            assert (linVar.getValue().roundToInfinitesimal().compareTo(linVar.getTightLowerBound()) >= 0);
        }
        return true;
    }

    @Override
    public Literal getPropagatedLiteral() {
        while (!this.mProplist.isEmpty()) {
            Literal literal = this.mProplist.remove();
            if (literal.getAtom().getDecideStatus() != null) continue;
            return literal;
        }
        return null;
    }

    private Clause createUnitClause(Literal literal, boolean bl, InfinitesimalNumber infinitesimalNumber, LinVar linVar) {
        Explainer explainer = new Explainer(this, this.getEngine().isProofGenerationEnabled(), literal);
        if (bl) {
            assert (linVar.getTightUpperBound().less(infinitesimalNumber));
            explainer.addLiteral(literal, Rational.MONE);
            LAReason lAReason = linVar.mUpper;
            while (lAReason.getOldReason() != null && lAReason.getOldReason().getBound().less(infinitesimalNumber)) {
                lAReason = lAReason.getOldReason();
            }
            lAReason.explain(explainer, infinitesimalNumber.sub(lAReason.getBound()), Rational.ONE);
        } else {
            assert (infinitesimalNumber.less(linVar.getTightLowerBound()));
            explainer.addLiteral(literal, Rational.ONE);
            LAReason lAReason = linVar.mLower;
            while (lAReason.getOldReason() != null && infinitesimalNumber.less(lAReason.getOldReason().getBound())) {
                lAReason = lAReason.getOldReason();
            }
            lAReason.explain(explainer, lAReason.getBound().sub(infinitesimalNumber), Rational.MONE);
        }
        return explainer.createClause(this.getEngine());
    }

    @Override
    public Clause getUnitClause(Literal literal) {
        DPLLAtom dPLLAtom = literal.getAtom();
        if (dPLLAtom instanceof LAEquality) {
            LAEquality lAEquality = (LAEquality)dPLLAtom;
            LinVar linVar = lAEquality.getVar();
            if (literal == lAEquality) {
                InfinitesimalNumber infinitesimalNumber = new InfinitesimalNumber(lAEquality.getBound(), 0);
                LAReason lAReason = linVar.mUpper;
                while (lAReason.getBound().less(infinitesimalNumber)) {
                    lAReason = lAReason.getOldReason();
                }
                LAReason lAReason2 = linVar.mLower;
                while (infinitesimalNumber.less(lAReason2.getBound())) {
                    lAReason2 = lAReason2.getOldReason();
                }
                assert (lAReason.getBound().equals(infinitesimalNumber) && lAReason2.getBound().equals(infinitesimalNumber)) : "Bounds on variable do not match propagated equality bound";
                Explainer explainer = new Explainer(this, this.getEngine().isProofGenerationEnabled(), literal);
                LiteralReason literalReason = new LiteralReason(linVar, linVar.mUpperLiteral, linVar.getTightUpperBound().sub(linVar.getEpsilon()), true, lAEquality.negate());
                literalReason.setOldReason(lAReason);
                lAReason2.explain(explainer, linVar.getEpsilon(), Rational.MONE);
                explainer.addEQAnnotation(literalReason, Rational.ONE);
                return explainer.createClause(this.getEngine());
            }
            InfinitesimalNumber infinitesimalNumber = new InfinitesimalNumber(lAEquality.getBound(), 0);
            LAReason lAReason = linVar.mUpper;
            while (lAEquality.getStackPosition() >= 0 && lAReason != null && lAReason.getLastLiteral().getStackPosition() >= lAEquality.getStackPosition()) {
                lAReason = lAReason.getOldReason();
            }
            return this.createUnitClause(literal, lAReason != null && lAReason.getBound().less(infinitesimalNumber), infinitesimalNumber, linVar);
        }
        if (dPLLAtom instanceof CCEquality) {
            return this.generateEqualityClause(literal);
        }
        BoundConstraint boundConstraint = (BoundConstraint)dPLLAtom;
        LinVar linVar = boundConstraint.getVar();
        boolean bl = literal.getSign() > 0;
        return this.createUnitClause(literal, bl, bl ? boundConstraint.getInverseBound() : boundConstraint.getBound(), linVar);
    }

    private Clause generateEqualityClause(Literal literal) {
        CCEquality cCEquality = (CCEquality)literal.getAtom();
        Literal literal2 = cCEquality.getLASharedData();
        if (cCEquality == literal) {
            literal2 = literal2.negate();
        }
        return new Clause(new Literal[]{literal, literal2}, new LeafNode(-6, EQAnnotation.EQ));
    }

    private void insertReasonOfNewComposite(LinVar linVar, Literal literal) {
        boolean bl;
        BoundConstraint boundConstraint = (BoundConstraint)literal.getAtom();
        boolean bl2 = bl = literal == boundConstraint;
        if (bl) {
            InfinitesimalNumber infinitesimalNumber = boundConstraint.getBound();
            LiteralReason literalReason = null;
            LiteralReason literalReason2 = linVar.mUpperLiteral;
            while (literalReason2 != null && literalReason2.getBound().less(infinitesimalNumber)) {
                literalReason = literalReason2;
                literalReason2 = literalReason2.getOldLiteralReason();
            }
            LiteralReason literalReason3 = new LiteralReason(linVar, literalReason2, infinitesimalNumber, true, literal);
            if (literalReason != null) {
                literalReason.setOldLiteralReason(literalReason3);
            } else {
                linVar.mUpperLiteral = literalReason3;
            }
            if (infinitesimalNumber.less(linVar.getExactUpperBound())) {
                literalReason3.setOldReason(linVar.mUpper);
                linVar.mUpper = literalReason3;
            } else {
                LAReason lAReason = linVar.mUpper;
                while (lAReason.getOldReason().getExactBound().less(infinitesimalNumber)) {
                    lAReason = lAReason.getOldReason();
                }
                assert (lAReason.getExactBound().less(infinitesimalNumber) && infinitesimalNumber.less(lAReason.getOldReason().getExactBound()));
                literalReason3.setOldReason(lAReason.getOldReason());
                lAReason.setOldReason(literalReason3);
            }
            if (linVar.outOfBounds()) {
                if (linVar.mBasic) {
                    this.mOob.add(linVar);
                } else {
                    this.updateVariableValue(linVar, new ExactInfinitesimalNumber(infinitesimalNumber));
                }
            }
        } else {
            InfinitesimalNumber infinitesimalNumber = boundConstraint.getInverseBound();
            LiteralReason literalReason = null;
            LiteralReason literalReason4 = linVar.mLowerLiteral;
            while (literalReason4 != null && infinitesimalNumber.less(literalReason4.getBound())) {
                literalReason = literalReason4;
                literalReason4 = literalReason4.getOldLiteralReason();
            }
            LiteralReason literalReason5 = new LiteralReason(linVar, literalReason4, infinitesimalNumber, false, literal);
            if (literalReason != null) {
                literalReason.setOldLiteralReason(literalReason5);
            } else {
                linVar.mLowerLiteral = literalReason5;
            }
            if (linVar.getExactLowerBound().less(infinitesimalNumber)) {
                literalReason5.setOldReason(linVar.mLower);
                linVar.mLower = literalReason5;
            } else {
                LAReason lAReason = linVar.mLower;
                while (infinitesimalNumber.less(lAReason.getOldReason().getExactBound())) {
                    lAReason = lAReason.getOldReason();
                }
                assert (lAReason.getOldReason().getExactBound().less(infinitesimalNumber) && infinitesimalNumber.less(lAReason.getExactBound()));
                literalReason5.setOldReason(lAReason.getOldReason());
                lAReason.setOldReason(literalReason5);
            }
            if (linVar.outOfBounds()) {
                if (linVar.mBasic) {
                    this.mOob.add(linVar);
                } else {
                    this.updateVariableValue(linVar, new ExactInfinitesimalNumber(infinitesimalNumber));
                }
            }
        }
    }

    private Clause setBound(LAReason lAReason) {
        Object object;
        InfinitesimalNumber infinitesimalNumber;
        LinVar linVar = lAReason.getVar();
        InfinitesimalNumber infinitesimalNumber2 = lAReason.getBound();
        InfinitesimalNumber infinitesimalNumber3 = linVar.getEpsilon();
        LiteralReason literalReason = lAReason.getLastLiteral();
        if (lAReason instanceof LiteralReason) {
            if (lAReason.isUpper()) {
                lAReason.getVar().mUpperLiteral = (LiteralReason)lAReason;
            } else {
                lAReason.getVar().mLowerLiteral = (LiteralReason)lAReason;
            }
        }
        if (lAReason.isUpper()) {
            infinitesimalNumber = linVar.getTightUpperBound();
            assert (lAReason.getExactBound().less(linVar.getExactUpperBound()));
            lAReason.setOldReason(linVar.mUpper);
            linVar.mUpper = lAReason;
            while (infinitesimalNumber2.mEps == 0 && (object = linVar.getDiseq(infinitesimalNumber2.mReal)) != null) {
                infinitesimalNumber2 = infinitesimalNumber2.sub(infinitesimalNumber3);
                if (((DPLLAtom)object).getStackPosition() > literalReason.getStackPosition()) {
                    linVar.mUpperLiteral = literalReason = new LiteralReason(linVar, linVar.mUpperLiteral, infinitesimalNumber2, true, ((Literal)object).negate());
                    linVar.mUpper = linVar.mUpperLiteral;
                } else {
                    linVar.mUpperLiteral = new LiteralReason(linVar, linVar.mUpperLiteral, infinitesimalNumber2, true, ((Literal)object).negate(), literalReason);
                    linVar.mUpper = linVar.mUpperLiteral;
                    literalReason.addDependent(linVar.mUpper);
                }
                linVar.mUpper.setOldReason(lAReason);
                lAReason = linVar.mUpper;
            }
            if (!linVar.mBasic) {
                this.updateVariable(linVar, true, infinitesimalNumber, infinitesimalNumber2);
            } else if (linVar.outOfBounds()) {
                this.mOob.add(linVar);
            }
            for (BoundConstraint dPLLAtom : linVar.mConstraints.subMap(infinitesimalNumber2, infinitesimalNumber).values()) {
                assert (linVar.getTightUpperBound().lesseq(dPLLAtom.getBound()));
                this.mProplist.add(dPLLAtom);
            }
            for (LAEquality lAEquality : linVar.mEqualities.subMap(infinitesimalNumber2.add(linVar.getEpsilon()), infinitesimalNumber.add(linVar.getEpsilon())).values()) {
                this.mProplist.add(lAEquality.negate());
            }
        } else {
            infinitesimalNumber = linVar.getTightLowerBound();
            assert (linVar.getExactLowerBound().less(lAReason.getExactBound()));
            lAReason.setOldReason(linVar.mLower);
            linVar.mLower = lAReason;
            while (infinitesimalNumber2.mEps == 0 && (object = linVar.getDiseq(infinitesimalNumber2.mReal)) != null) {
                infinitesimalNumber2 = infinitesimalNumber2.add(infinitesimalNumber3);
                if (((DPLLAtom)object).getStackPosition() > literalReason.getStackPosition()) {
                    linVar.mLowerLiteral = literalReason = new LiteralReason(linVar, linVar.mLowerLiteral, infinitesimalNumber2, false, ((Literal)object).negate());
                    linVar.mLower = linVar.mLowerLiteral;
                } else {
                    linVar.mLowerLiteral = new LiteralReason(linVar, linVar.mLowerLiteral, infinitesimalNumber2, false, ((Literal)object).negate(), literalReason);
                    linVar.mLower = linVar.mLowerLiteral;
                    literalReason.addDependent(linVar.mLower);
                }
                linVar.mLower.setOldReason(lAReason);
                lAReason = linVar.mLower;
            }
            if (!linVar.mBasic) {
                this.updateVariable(linVar, false, infinitesimalNumber, infinitesimalNumber2);
            } else if (linVar.outOfBounds()) {
                this.mOob.add(linVar);
            }
            for (BoundConstraint boundConstraint : linVar.mConstraints.subMap(infinitesimalNumber, infinitesimalNumber2).values()) {
                assert (boundConstraint.getInverseBound().lesseq(linVar.getTightLowerBound()));
                this.mProplist.add(boundConstraint.negate());
            }
            for (LAEquality lAEquality : linVar.mEqualities.subMap(infinitesimalNumber, infinitesimalNumber2).values()) {
                this.mProplist.add(lAEquality.negate());
            }
        }
        infinitesimalNumber = linVar.getTightUpperBound();
        object = linVar.getTightLowerBound();
        if (((InfinitesimalNumber)object).equals(infinitesimalNumber)) {
            LAEquality lAEquality = (LAEquality)linVar.mEqualities.get(object);
            if (lAEquality != null && lAEquality.getDecideStatus() == null) {
                this.mProplist.add(lAEquality);
            }
        } else if (infinitesimalNumber.less((InfinitesimalNumber)object)) {
            this.mConflictVar = linVar;
            return this.checkPendingConflict();
        }
        assert (linVar.mBasic || !linVar.outOfBounds());
        return null;
    }

    @Override
    public Clause setLiteral(Literal literal) {
        Clause clause = this.checkPendingBoundPropagations();
        if (clause != null) {
            return clause;
        }
        assert (this.checkClean());
        if (this.mProplist.contains(literal.negate())) {
            return this.getUnitClause(literal.negate());
        }
        DPLLAtom dPLLAtom = literal.getAtom();
        if (dPLLAtom instanceof LAEquality) {
            LAEquality lAEquality = (LAEquality)dPLLAtom;
            for (CCEquality object2 : lAEquality.getDependentEqualities()) {
                if (object2.getDecideStatus() == null) {
                    this.mProplist.add(literal == dPLLAtom ? object2 : object2.negate());
                    continue;
                }
                if (object2.getDecideStatus().getSign() == literal.getSign()) continue;
                return this.generateEqualityClause(object2.getDecideStatus().negate());
            }
            LinVar linVar = lAEquality.getVar();
            InfinitesimalNumber infinitesimalNumber = new InfinitesimalNumber(lAEquality.getBound(), 0);
            if (literal.getSign() == 1) {
                if (this.mClausifier.getLogger().isDebugEnabled()) {
                    this.mClausifier.getLogger().debug("Setting " + String.valueOf(lAEquality.getVar()) + " to " + String.valueOf(lAEquality.getBound()));
                }
                if (infinitesimalNumber.less(linVar.getTightUpperBound())) {
                    clause = this.setBound(new LiteralReason(linVar, linVar.mUpperLiteral, infinitesimalNumber, true, literal));
                }
                if (clause != null) {
                    return clause;
                }
                if (linVar.getTightLowerBound().less(infinitesimalNumber)) {
                    clause = this.setBound(new LiteralReason(linVar, linVar.mLowerLiteral, infinitesimalNumber, false, literal));
                }
            } else {
                linVar.addDiseq(lAEquality);
                if (linVar.getTightUpperBound().equals(infinitesimalNumber)) {
                    clause = this.setBound(new LiteralReason(linVar, linVar.mUpperLiteral, infinitesimalNumber.sub(linVar.getEpsilon()), true, literal));
                } else if (linVar.getTightLowerBound().equals(infinitesimalNumber)) {
                    clause = this.setBound(new LiteralReason(linVar, linVar.mLowerLiteral, infinitesimalNumber.add(linVar.getEpsilon()), false, literal));
                }
            }
        } else if (dPLLAtom instanceof BoundConstraint) {
            BoundConstraint boundConstraint = (BoundConstraint)dPLLAtom;
            LinVar linVar = boundConstraint.getVar();
            if (literal == boundConstraint) {
                if (boundConstraint.getBound().less(linVar.getExactUpperBound())) {
                    clause = this.setBound(new LiteralReason(linVar, linVar.mUpperLiteral, boundConstraint.getBound(), true, literal));
                }
            } else if (linVar.getExactLowerBound().less(boundConstraint.getInverseBound())) {
                clause = this.setBound(new LiteralReason(linVar, linVar.mLowerLiteral, boundConstraint.getInverseBound(), false, literal));
            }
        }
        assert (clause != null || this.checkClean());
        return clause;
    }

    public boolean checkPendingPropagation() {
        Iterator iterator = this.mProplist.iterator();
        while (iterator.hasNext()) {
            Literal literal = (Literal)iterator.next();
            if (literal.getAtom().getDecideStatus() == literal) {
                iterator.remove();
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public Clause checkpoint() {
        do {
            Clause clause;
            if ((clause = this.checkPendingBoundPropagations()) != null) {
                return clause;
            }
            if (this.checkPendingPropagation()) {
                return null;
            }
            if (!this.mInCheck) {
                return null;
            }
            clause = this.fixOobs();
            if (clause == null) continue;
            return clause;
        } while (!this.mDirty.isEmpty());
        return null;
    }

    public Rational realValue(LinVar linVar) {
        if (this.mEps == null) {
            this.prepareModel();
        }
        ExactInfinitesimalNumber exactInfinitesimalNumber = linVar.getValue();
        return exactInfinitesimalNumber.getRealValue().addmul(exactInfinitesimalNumber.getEpsilon(), this.mEps);
    }

    public void dumpTableaux(LogProxy logProxy) {
        for (TableauxRow tableauxRow : this.mTableaux) {
            if (tableauxRow == null) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(tableauxRow.getRawCoeff(0)).append('*').append(this.mLinvars.get(tableauxRow.getRawIndex(0)));
            String string = "";
            int n = 0;
            while (n < tableauxRow.size()) {
                stringBuilder.append(string).append(tableauxRow.getRawCoeff(n)).append('*').append(this.mLinvars.get(tableauxRow.getRawIndex(n)));
                string = " ; ";
                ++n;
            }
            logProxy.debug(stringBuilder.toString());
        }
    }

    public void dumpConstraints(LogProxy logProxy) {
        for (LinVar linVar : this.mLinvars) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(linVar).append(linVar.mIsInt ? "[int]" : "[real]").append(": ");
            InfinitesimalNumber infinitesimalNumber = linVar.getLowerBound();
            if (infinitesimalNumber != InfinitesimalNumber.NEGATIVE_INFINITY) {
                stringBuilder.append("lower: ").append(linVar.getLowerBound()).append(" <= ");
            }
            stringBuilder.append(linVar.getValue());
            InfinitesimalNumber infinitesimalNumber2 = linVar.getUpperBound();
            if (infinitesimalNumber2 != InfinitesimalNumber.POSITIVE_INFINITY) {
                stringBuilder.append(" <= ").append(infinitesimalNumber2).append(" : upper");
            }
            logProxy.debug(stringBuilder);
        }
    }

    private void prepareModel() {
        if (this.mEps != null) {
            return;
        }
        TreeSet<Rational> treeSet = new TreeSet<Rational>();
        InfinitesimalNumber infinitesimalNumber = this.computeMaxEpsilon(treeSet);
        this.mEps = infinitesimalNumber == InfinitesimalNumber.POSITIVE_INFINITY ? Rational.ONE : infinitesimalNumber.inverse().ceil().mReal.inverse();
        TreeMap<Rational, Set<ExactInfinitesimalNumber>> treeMap = new TreeMap<Rational, Set<ExactInfinitesimalNumber>>();
        Map<ExactInfinitesimalNumber, List<LASharedTerm>> map = this.getSharedCongruences();
        for (ExactInfinitesimalNumber exactInfinitesimalNumber : map.keySet()) {
            Rational rational = exactInfinitesimalNumber.getEpsilon();
            TreeSet<ExactInfinitesimalNumber> treeSet2 = (TreeSet<ExactInfinitesimalNumber>)treeMap.get(rational);
            if (treeSet2 == null) {
                treeSet2 = new TreeSet<ExactInfinitesimalNumber>();
                treeMap.put(rational, treeSet2);
            }
            treeSet2.add(new ExactInfinitesimalNumber(exactInfinitesimalNumber.getRealValue()));
        }
        while (treeSet.contains(this.mEps) || this.hasSharing(treeMap, new ExactInfinitesimalNumber(this.mEps))) {
            this.mEps = this.mEps.inverse().add(Rational.ONE).inverse();
        }
    }

    @Override
    public void dumpModel(LogProxy logProxy) {
        if (logProxy.isInfoEnabled()) {
            this.prepareModel();
            logProxy.info("Assignments:");
            for (LinVar linVar : this.mLinvars) {
                if (linVar.isInitiallyBasic()) continue;
                logProxy.info(String.valueOf(linVar) + " = " + String.valueOf(this.realValue(linVar)));
            }
        }
    }

    @Override
    public void printStatistics(LogProxy logProxy) {
        if (logProxy.isInfoEnabled()) {
            logProxy.info("Number of Bland pivoting-Operations: " + this.mNumPivotsBland + "/" + this.mNumPivots);
            int n = 0;
            for (LinVar linVar : this.mLinvars) {
                if (linVar.isInitiallyBasic()) continue;
                ++n;
            }
            logProxy.info("Number of variables: " + this.mLinvars.size() + " nonbasic: " + n + " shared: " + this.mSharedVars.size());
            logProxy.info("Time for fix Oob          : " + this.mFixTime / 1000000L);
            logProxy.info("Time for pivoting         : " + this.mPivotTime / 1000000L);
            logProxy.info("Time for bound computation: " + this.mPropBoundTime / 1000000L);
            logProxy.info("Time for bound setting    : " + this.mPropBoundSetTime / 1000000L);
            logProxy.info("Time for bound comp(back) : " + this.mBacktrackPropTime / 1000000L);
            logProxy.info("Composite::createLit: " + this.mCompositeCreateLit);
            logProxy.info("Number of cuts: " + this.mNumCuts);
            logProxy.info("Time for cut-generation: " + this.mCutGenTime / 1000000L);
            logProxy.info("Count/Time for getUpperBound: %d / %d.%03d", this.mCountGetUpperBound, this.mTimeGetUpperBound / 1000000000L, this.mTimeGetUpperBound / 1000000L % 1000L);
            logProxy.info("Number of branchings: " + this.mNumBranches);
        }
    }

    final void pivot(int n, int n2) {
        Object object;
        ++this.mNumPivots;
        long l = System.nanoTime();
        LinVar linVar = (LinVar)this.mLinvars.get(n);
        LinVar linVar2 = (LinVar)this.mLinvars.get(n2);
        TableauxRow tableauxRow = this.mTableaux.get(n);
        if (this.mClausifier.getLogger().isDebugEnabled()) {
            this.mClausifier.getLogger().debug("pivot " + String.valueOf(linVar) + " / " + String.valueOf(linVar2));
        }
        assert (linVar.mBasic);
        assert (!linVar2.mBasic);
        linVar.mBasic = false;
        linVar2.mBasic = true;
        assert (linVar.checkCoeffChain(this));
        this.mTableaux.set(n, null);
        tableauxRow.swapRowCol(n2);
        this.mTableaux.set(n2, tableauxRow);
        BitSet bitSet = this.mDependentRows.set(n2, null);
        this.mDependentRows.set(n, new BitSet());
        int n3 = 1;
        while (n3 < tableauxRow.size()) {
            object = this.mDependentRows.get(tableauxRow.getRawIndex(n3));
            assert (tableauxRow.getRawIndex(n3) == n || ((BitSet)object).get(n));
            ((BitSet)object).clear(n);
            ((BitSet)object).set(n2);
            ++n3;
        }
        linVar.mCachedRowVars = null;
        linVar.mCachedRowCoeffs = null;
        this.mDirty.set(n2);
        assert (linVar2.mCachedRowCoeffs == null);
        assert (linVar2.checkCoeffChain(this));
        bitSet.clear(n);
        while (!bitSet.isEmpty()) {
            n3 = bitSet.nextSetBit(0);
            object = (LinVar)this.mLinvars.get(n3);
            bitSet.clear(n3);
            this.mTableaux.get(n3).addRow(this, tableauxRow);
            ((LinVar)object).mCachedRowVars = null;
            ((LinVar)object).mCachedRowCoeffs = null;
            this.mDirty.set(((LinVar)object).mMatrixpos);
            assert (((LinVar)object).checkCoeffChain(this));
        }
        this.mPivotTime += System.nanoTime() - l;
    }

    private Clause ensureIntegrals() {
        boolean bl = true;
        for (LinVar object2 : this.mIntVars) {
            ExactInfinitesimalNumber exactInfinitesimalNumber = object2.getValue();
            if (exactInfinitesimalNumber.getRealValue().isIntegral() && exactInfinitesimalNumber.getEpsilon().equals((Object)Rational.ZERO)) continue;
            bl = false;
        }
        if (bl) {
            return null;
        }
        LogProxy logProxy = this.mClausifier.getLogger();
        if (logProxy.isDebugEnabled()) {
            this.dumpTableaux(logProxy);
            this.dumpConstraints(logProxy);
        }
        assert (this.mOob.isEmpty());
        long l = System.nanoTime();
        CutCreator cutCreator = new CutCreator(this);
        cutCreator.generateCuts();
        this.mCutGenTime += System.nanoTime() - l;
        Clause clause = this.checkPendingConflict();
        if (clause != null) {
            return clause;
        }
        clause = this.checkpoint();
        if (clause != null) {
            return clause;
        }
        return null;
    }

    private Clause fixOobs() {
        long l = System.nanoTime();
        boolean bl = false;
        Object object = this.mOob.iterator();
        while (object.hasNext()) {
            LinVar linVar = object.next();
            if (linVar.outOfBounds()) {
                bl = true;
                continue;
            }
            object.remove();
        }
        if (!bl) {
            return null;
        }
        object = new SOIPivoter(this).fixOobs();
        if (object == null) {
            this.mOob.clear();
        }
        assert (this.checkClean());
        this.mFixTime += System.nanoTime() - l;
        return object;
    }

    private Clause propagateBound(LinVar linVar, InfinitesimalNumber infinitesimalNumber, boolean bl) {
        long l = System.nanoTime();
        if (bl ? infinitesimalNumber.less(linVar.getTightUpperBound()) : linVar.getTightLowerBound().less(infinitesimalNumber)) {
            Object object;
            Rational[] rationalArray;
            LAReason[] lAReasonArray;
            TableauxRow tableauxRow = this.mTableaux.get(linVar.mMatrixpos);
            BigInteger bigInteger = tableauxRow.getRawCoeff(0).negate();
            LiteralReason literalReason = null;
            if (linVar.mCachedRowCoeffs == null) {
                int n = tableauxRow.size() - 1;
                LinVar[] linVarArray = new LinVar[n];
                lAReasonArray = new LAReason[n];
                rationalArray = new Rational[n];
                int n2 = 0;
                while (n2 < n) {
                    object = (LinVar)this.mLinvars.get(tableauxRow.getRawIndex(n2 + 1));
                    Rational rational = Rational.valueOf((BigInteger)tableauxRow.getRawCoeff(n2 + 1), (BigInteger)bigInteger);
                    linVarArray[n2] = object;
                    lAReasonArray[n2] = rational.isNegative() == bl ? ((LinVar)object).mLowerLiteral : ((LinVar)object).mUpperLiteral;
                    rationalArray[n2] = rational;
                    LiteralReason literalReason2 = lAReasonArray[n2].getLastLiteral();
                    if (literalReason == null || literalReason2.getStackPosition() > literalReason.getStackPosition()) {
                        literalReason = literalReason2;
                    }
                    ++n2;
                }
                linVar.mCachedRowCoeffs = rationalArray;
                linVar.mCachedRowVars = linVarArray;
            } else {
                LinVar[] linVarArray = linVar.mCachedRowVars;
                rationalArray = linVar.mCachedRowCoeffs;
                lAReasonArray = new LAReason[linVarArray.length];
                int n = 0;
                while (n < linVarArray.length) {
                    lAReasonArray[n] = rationalArray[n].isNegative() == bl ? linVarArray[n].mLowerLiteral : linVarArray[n].mUpperLiteral;
                    LiteralReason literalReason3 = lAReasonArray[n].getLastLiteral();
                    if (literalReason == null || literalReason3.getStackPosition() > literalReason.getStackPosition()) {
                        literalReason = literalReason3;
                    }
                    ++n;
                }
            }
            CompositeReason compositeReason = new CompositeReason(linVar, infinitesimalNumber, bl, lAReasonArray, rationalArray, literalReason);
            literalReason.addDependent(compositeReason);
            long l2 = System.nanoTime();
            this.mPropBoundTime += l2 - l;
            object = this.setBound(compositeReason);
            this.mPropBoundSetTime += System.nanoTime() - l2;
            return object;
        }
        this.mPropBoundTime += System.nanoTime() - l;
        return null;
    }

    private Literal generateConstraint(LinVar linVar, Rational rational, boolean bl, boolean bl2) {
        InfinitesimalNumber infinitesimalNumber = new InfinitesimalNumber(rational, bl2 ^ bl ? -1 : 0);
        if (linVar.isInt()) {
            infinitesimalNumber = infinitesimalNumber.floor();
        }
        return this.generateConstraint(linVar, infinitesimalNumber, bl);
    }

    private Literal generateConstraint(LinVar linVar, InfinitesimalNumber infinitesimalNumber, boolean bl) {
        BoundConstraint boundConstraint = (BoundConstraint)linVar.mConstraints.get(infinitesimalNumber);
        if (boundConstraint == null) {
            boundConstraint = new BoundConstraint(infinitesimalNumber, linVar, this.getEngine().getAssertionStackLevel());
            assert (boundConstraint.mVar.checkCoeffChain(this));
            this.getEngine().addAtom(boundConstraint);
            if (linVar.getTightUpperBound().lesseq(infinitesimalNumber)) {
                this.mProplist.add(boundConstraint);
            }
            if (infinitesimalNumber.less(linVar.getTightLowerBound())) {
                this.mProplist.add(boundConstraint.negate());
            }
        }
        return bl ? boundConstraint.negate() : boundConstraint;
    }

    private void removeLinVar(LinVar linVar) {
        int n;
        Object object;
        if (!linVar.mBasic && !((BitSet)(object = this.mDependentRows.get(linVar.mMatrixpos))).isEmpty()) {
            n = ((BitSet)object).nextSetBit(0);
            this.pivot(n, linVar.mMatrixpos);
        }
        assert (linVar.mBasic || this.mDependentRows.get(linVar.mMatrixpos).isEmpty());
        assert (linVar.mMatrixpos == this.mLinvars.size() - 1);
        this.mLinvars.remove(linVar.mMatrixpos);
        if (linVar.mBasic) {
            object = this.mTableaux.get(linVar.mMatrixpos);
            n = 1;
            while (n < ((TableauxRow)object).size()) {
                LinVar linVar2 = (LinVar)this.mLinvars.get(((TableauxRow)object).getRawIndex(n));
                assert (!linVar2.mBasic);
                this.mDependentRows.get(linVar2.mMatrixpos).clear(linVar.mMatrixpos);
                ++n;
            }
        }
        this.mTableaux.remove(linVar.mMatrixpos);
        this.mDependentRows.remove(linVar.mMatrixpos);
    }

    private void unsimplifyAndAdd(LinVar linVar, Rational rational, Map<LinVar, Rational> map) {
        if (linVar.mBasic) {
            TableauxRow tableauxRow = this.mTableaux.get(linVar.mMatrixpos);
            BigInteger bigInteger = tableauxRow.getRawCoeff(0).negate();
            int n = 1;
            while (n < tableauxRow.size()) {
                Rational rational2 = Rational.valueOf((BigInteger)tableauxRow.getRawCoeff(n), (BigInteger)bigInteger);
                this.unsimplifyAndAdd((LinVar)this.mLinvars.get(tableauxRow.getRawIndex(n)), rational.mul(rational2), map);
                ++n;
            }
        } else {
            Rational rational3 = map.get(linVar);
            if (rational3 == null) {
                map.put(linVar, rational);
            } else {
                Rational rational4 = rational3.add(rational);
                if (rational4.equals((Object)Rational.ZERO)) {
                    map.remove(linVar);
                } else {
                    map.put(linVar, rational4);
                }
            }
        }
    }

    private ExactInfinitesimalNumber[] freedom(LinVar linVar) {
        ExactInfinitesimalNumber exactInfinitesimalNumber = linVar.getValue();
        ExactInfinitesimalNumber exactInfinitesimalNumber2 = exactInfinitesimalNumber.isub(linVar.getLowerBound());
        ExactInfinitesimalNumber exactInfinitesimalNumber3 = exactInfinitesimalNumber.isub(linVar.getUpperBound());
        for (MatrixEntry matrixEntry : linVar.getTableauxColumn(this)) {
            assert (exactInfinitesimalNumber2.signum() <= 0 && exactInfinitesimalNumber3.signum() >= 0);
            LinVar linVar2 = matrixEntry.getRow();
            Rational rational = Rational.valueOf((BigInteger)matrixEntry.getHeadCoeff().negate(), (BigInteger)matrixEntry.getCoeff());
            ExactInfinitesimalNumber exactInfinitesimalNumber4 = linVar2.getValue();
            ExactInfinitesimalNumber exactInfinitesimalNumber5 = exactInfinitesimalNumber4.isub(linVar2.getLowerBound()).mul(rational);
            ExactInfinitesimalNumber exactInfinitesimalNumber6 = exactInfinitesimalNumber4.isub(linVar2.getUpperBound()).mul(rational);
            if (rational.isNegative()) {
                assert (exactInfinitesimalNumber5.signum() >= 0 && exactInfinitesimalNumber6.signum() <= 0);
                if (exactInfinitesimalNumber5.compareTo(exactInfinitesimalNumber3) < 0) {
                    exactInfinitesimalNumber3 = exactInfinitesimalNumber5;
                }
                if (exactInfinitesimalNumber6.compareTo(exactInfinitesimalNumber2) <= 0) continue;
                exactInfinitesimalNumber2 = exactInfinitesimalNumber6;
                continue;
            }
            assert (exactInfinitesimalNumber5.signum() <= 0 && exactInfinitesimalNumber6.signum() >= 0);
            if (exactInfinitesimalNumber6.compareTo(exactInfinitesimalNumber3) < 0) {
                exactInfinitesimalNumber3 = exactInfinitesimalNumber6;
            }
            if (exactInfinitesimalNumber5.compareTo(exactInfinitesimalNumber2) <= 0) continue;
            exactInfinitesimalNumber2 = exactInfinitesimalNumber5;
        }
        assert (exactInfinitesimalNumber2.signum() <= 0 && exactInfinitesimalNumber3.signum() >= 0);
        return new ExactInfinitesimalNumber[]{exactInfinitesimalNumber2, exactInfinitesimalNumber3};
    }

    /*
     * WARNING - void declaration
     */
    private void mutate() {
        TreeMap<Rational, Set<ExactInfinitesimalNumber>> treeMap = new TreeMap<Rational, Set<ExactInfinitesimalNumber>>();
        TreeSet<ExactInfinitesimalNumber> treeSet = new TreeSet<ExactInfinitesimalNumber>();
        for (LinVar linVar : this.mLinvars) {
            Comparable<LinVar> comparable;
            Object object;
            LinVar linVar2;
            Rational rational32;
            ExactInfinitesimalNumber[] exactInfinitesimalNumberArray;
            if (linVar.mBasic || linVar.getTightUpperBound().equals(linVar.getTightLowerBound()) || (exactInfinitesimalNumberArray = this.freedom(linVar))[0].equals(exactInfinitesimalNumberArray[1])) continue;
            Rational rational2 = linVar.isInt() ? Rational.ONE : Rational.ZERO;
            ExactInfinitesimalNumber exactInfinitesimalNumber = linVar.getValue();
            treeMap.clear();
            treeSet.clear();
            if (linVar.mDisequalities != null) {
                for (Rational rational32 : linVar.mDisequalities.keySet()) {
                    treeSet.add(new ExactInfinitesimalNumber(rational32).sub(exactInfinitesimalNumber));
                }
            }
            rational32 = new HashMap();
            if (!linVar.isInitiallyBasic()) {
                rational32.put(linVar, Rational.ONE);
            }
            for (MatrixEntry matrixEntry : linVar.getTableauxColumn(this)) {
                linVar2 = matrixEntry.getRow();
                object = Rational.valueOf((BigInteger)matrixEntry.getCoeff().negate(), (BigInteger)matrixEntry.getHeadCoeff());
                if (!linVar2.isInitiallyBasic()) {
                    rational32.put(linVar2, object);
                }
                if (linVar2.isInt()) {
                    rational2 = rational2.gcd(object.abs());
                }
                if (linVar2.mDisequalities == null) continue;
                for (Rational rational : linVar2.mDisequalities.keySet()) {
                    comparable = linVar2.getValue();
                    treeSet.add(new ExactInfinitesimalNumber(rational).sub((ExactInfinitesimalNumber)comparable).div((Rational)object));
                }
            }
            for (LASharedTerm lASharedTerm : this.mSharedVars) {
                void var13_25;
                linVar2 = Rational.ZERO;
                object = new ExactInfinitesimalNumber(lASharedTerm.getOffset(), Rational.ZERO);
                for (Map.Entry<LinVar, Rational> entry : lASharedTerm.getSummands().entrySet()) {
                    comparable = entry.getKey();
                    Rational rational = entry.getValue();
                    if (rational32.containsKey(comparable)) {
                        linVar2 = linVar2.addmul((Rational)rational32.get(comparable), rational);
                    }
                    object = ((ExactInfinitesimalNumber)object).add(((LinVar)comparable).getValue().mul(rational));
                }
                Set set = (Set)treeMap.get(linVar2);
                if (set == null) {
                    TreeSet treeSet2 = new TreeSet();
                    treeMap.put((Rational)linVar2, treeSet2);
                }
                var13_25.add(object);
            }
            Rational object22 = rational2.inverse();
            ExactInfinitesimalNumber exactInfinitesimalNumber2 = this.choose(exactInfinitesimalNumberArray[0], exactInfinitesimalNumberArray[1], treeSet, treeMap, object22);
            assert (exactInfinitesimalNumber2.compareTo(exactInfinitesimalNumberArray[0]) >= 0 && exactInfinitesimalNumber2.compareTo(exactInfinitesimalNumberArray[1]) <= 0);
            if (exactInfinitesimalNumber2.signum() == 0) continue;
            this.updateVariableValue(linVar, linVar.getValue().add(exactInfinitesimalNumber2));
        }
    }

    /*
     * WARNING - void declaration
     */
    Map<ExactInfinitesimalNumber, List<LASharedTerm>> getSharedCongruences() {
        this.mClausifier.getLogger().debug("Shared Vars:");
        HashMap<ExactInfinitesimalNumber, List<LASharedTerm>> hashMap = new HashMap<ExactInfinitesimalNumber, List<LASharedTerm>>();
        for (LASharedTerm lASharedTerm : this.mSharedVars) {
            void linkedList2;
            ExactInfinitesimalNumber exactInfinitesimalNumber = new ExactInfinitesimalNumber(lASharedTerm.getOffset());
            for (Map.Entry<LinVar, Rational> entry : lASharedTerm.getSummands().entrySet()) {
                LinVar linVar = entry.getKey();
                Rational rational = entry.getValue();
                exactInfinitesimalNumber = exactInfinitesimalNumber.add(linVar.getValue().mul(rational));
            }
            this.mClausifier.getLogger().debug("%s = %s", lASharedTerm, exactInfinitesimalNumber);
            List list = (List)hashMap.get(exactInfinitesimalNumber);
            if (list == null) {
                LinkedList linkedList = new LinkedList();
                hashMap.put(exactInfinitesimalNumber, linkedList);
            }
            linkedList2.add(lASharedTerm);
        }
        return hashMap;
    }

    private Literal ensureDisequality(LAEquality lAEquality) {
        boolean bl;
        LinVar linVar = lAEquality.getVar();
        assert (lAEquality.getDecideStatus().getSign() == -1);
        ExactInfinitesimalNumber exactInfinitesimalNumber = linVar.getValue();
        if (!exactInfinitesimalNumber.getRealValue().equals((Object)lAEquality.getBound()) || exactInfinitesimalNumber.getEpsilon().signum() != 0) {
            return null;
        }
        InfinitesimalNumber infinitesimalNumber = new InfinitesimalNumber(lAEquality.getBound(), 0);
        BoundConstraint boundConstraint = (BoundConstraint)lAEquality.getVar().mConstraints.get(infinitesimalNumber);
        boolean bl2 = bl = boundConstraint == null;
        if (!bl && boundConstraint.getDecideStatus() == null) {
            return boundConstraint.negate();
        }
        InfinitesimalNumber infinitesimalNumber2 = infinitesimalNumber.sub(lAEquality.getVar().getEpsilon());
        BoundConstraint boundConstraint2 = (BoundConstraint)lAEquality.getVar().mConstraints.get(infinitesimalNumber2);
        if (boundConstraint2 != null && boundConstraint2.getDecideStatus() == null) {
            return boundConstraint2;
        }
        return bl ? this.generateConstraint(lAEquality.getVar(), lAEquality.getBound(), false, false).negate() : this.generateConstraint(lAEquality.getVar(), lAEquality.getBound(), false, true);
    }

    /*
     * Unable to fully structure code
     */
    private ExactInfinitesimalNumber choose(ExactInfinitesimalNumber var1_1, ExactInfinitesimalNumber var2_2, Set<ExactInfinitesimalNumber> var3_3, Map<Rational, Set<ExactInfinitesimalNumber>> var4_4, Rational var5_5) {
        block11: {
            block12: {
                var6_6 = ExactInfinitesimalNumber.ZERO;
                if (var2_2.equals(var1_1) || !var3_3.contains(var6_6) && !this.hasSharing(var4_4, var6_6)) {
                    return var6_6;
                }
                if (var5_5 != Rational.POSITIVE_INFINITY) break block11;
                if (!var1_1.getRealValue().equals((Object)var2_2.getRealValue())) break block12;
                var7_7 = (var2_2.signum() > 0 ? var2_2 : var1_1).div(Rational.TWO);
                if (LinArSolve.$assertionsDisabled || var7_7.signum() != 0 && var1_1.compareTo(var7_7) < 0 && var7_7.compareTo(var2_2) < 0) ** GOTO lbl10
                throw new AssertionError();
lbl-1000:
                // 1 sources

                {
                    var7_7 = var7_7.div(Rational.TWO);
lbl10:
                    // 2 sources

                    ** while (var3_3.contains((Object)var7_7) || this.hasSharing(var4_4, (ExactInfinitesimalNumber)var7_7))
                }
lbl11:
                // 1 sources

                return var7_7;
            }
            var7_8 = var2_2.getRealValue().signum() > 0 ? new ExactInfinitesimalNumber(Rational.ZERO, Rational.ONE) : new ExactInfinitesimalNumber(Rational.ZERO, Rational.MONE);
            var8_10 = var7_8;
            while (var3_3.contains(var8_10) || this.hasSharing(var4_4, var8_10)) {
                var8_10 = var8_10.add(var7_8);
            }
            return var8_10;
        }
        var7_9 = new ExactInfinitesimalNumber(var5_5);
        var8_11 = var7_9.negate();
        var9_12 = true;
        var10_13 = true;
        while (var9_12 || var10_13) {
            if (var9_12) {
                if (var7_9.compareTo(var2_2) > 0) {
                    var9_12 = false;
                } else if (!var3_3.contains(var7_9) && !this.hasSharing(var4_4, var7_9)) {
                    return var7_9;
                }
                var7_9 = var7_9.add(var5_5);
            }
            if (!var10_13) continue;
            if (var8_11.compareTo(var1_1) < 0) {
                var10_13 = false;
            } else if (!var3_3.contains(var8_11) && !this.hasSharing(var4_4, var8_11)) {
                return var8_11;
            }
            var8_11 = var8_11.add(var5_5.negate());
        }
        return ExactInfinitesimalNumber.ZERO;
    }

    private boolean hasSharing(Map<Rational, Set<ExactInfinitesimalNumber>> map, ExactInfinitesimalNumber exactInfinitesimalNumber) {
        TreeSet<ExactInfinitesimalNumber> treeSet = new TreeSet<ExactInfinitesimalNumber>();
        for (Map.Entry<Rational, Set<ExactInfinitesimalNumber>> entry : map.entrySet()) {
            ExactInfinitesimalNumber exactInfinitesimalNumber2 = exactInfinitesimalNumber.mul(entry.getKey());
            for (ExactInfinitesimalNumber exactInfinitesimalNumber3 : entry.getValue()) {
                if (treeSet.add(exactInfinitesimalNumber3.add(exactInfinitesimalNumber2))) continue;
                return true;
            }
        }
        return false;
    }

    private Clause mbtc(Map<ExactInfinitesimalNumber, List<LASharedTerm>> map) {
        for (Map.Entry<ExactInfinitesimalNumber, List<LASharedTerm>> entry : map.entrySet()) {
            List<LASharedTerm> list = entry.getValue();
            if (list.size() <= 1) continue;
            this.mClausifier.getLogger().debug("propagating MBTC: %s", list);
            Iterator<LASharedTerm> iterator = list.iterator();
            LASharedTerm lASharedTerm = iterator.next();
            LASharedTerm lASharedTerm2 = null;
            while (iterator.hasNext()) {
                LASharedTerm lASharedTerm3 = iterator.next();
                Term term = lASharedTerm.getTerm();
                Term term2 = lASharedTerm3.getTerm();
                if (term.getSort() != term2.getSort()) {
                    if (lASharedTerm2 == null) {
                        lASharedTerm2 = lASharedTerm3;
                        continue;
                    }
                    term = lASharedTerm2.getTerm();
                }
                assert (term.getSort() == term2.getSort());
                EqualityProxy equalityProxy = this.mClausifier.createEqualityProxy(term, term2, null);
                assert (equalityProxy != EqualityProxy.getTrueProxy());
                assert (equalityProxy != EqualityProxy.getFalseProxy());
                CCEquality cCEquality = equalityProxy.createCCEquality(term, term2);
                if (cCEquality.getLASharedData().getDecideStatus() != null) {
                    if (cCEquality.getDecideStatus() == cCEquality.negate()) {
                        return this.generateEqualityClause(cCEquality);
                    }
                    if (cCEquality.getDecideStatus() == null) {
                        this.mProplist.add(cCEquality);
                        continue;
                    }
                    this.mClausifier.getLogger().debug("already set: %s", cCEquality.getAtom().getDecideStatus());
                    continue;
                }
                this.mClausifier.getLogger().debug("MBTC: Suggesting literal %s", cCEquality);
                this.mSuggestions.add(cCEquality.getLASharedData());
            }
        }
        return null;
    }

    @Override
    public Literal getSuggestion() {
        Literal literal;
        do {
            if (!this.mSuggestions.isEmpty()) continue;
            return null;
        } while ((literal = this.mSuggestions.removeFirst()).getAtom().getDecideStatus() != null);
        return literal;
    }

    private InfinitesimalNumber computeMaxEpsilon(Set<Rational> set) {
        InfinitesimalNumber infinitesimalNumber = InfinitesimalNumber.POSITIVE_INFINITY;
        for (LinVar linVar : this.mLinvars) {
            InfinitesimalNumber infinitesimalNumber2;
            ExactInfinitesimalNumber exactInfinitesimalNumber = linVar.getValue();
            if (exactInfinitesimalNumber.getEpsilon().signum() > 0) {
                InfinitesimalNumber infinitesimalNumber3 = linVar.getUpperBound().sub(new InfinitesimalNumber(exactInfinitesimalNumber.getRealValue(), 0)).div(exactInfinitesimalNumber.getEpsilon());
                if (infinitesimalNumber3.compareTo(infinitesimalNumber) < 0) {
                    infinitesimalNumber = infinitesimalNumber3;
                }
            } else if (exactInfinitesimalNumber.getEpsilon().signum() < 0 && (infinitesimalNumber2 = linVar.getLowerBound().sub(new InfinitesimalNumber(exactInfinitesimalNumber.getRealValue(), 0)).div(exactInfinitesimalNumber.getEpsilon())).compareTo(infinitesimalNumber) < 0) {
                infinitesimalNumber = infinitesimalNumber2;
            }
            if (exactInfinitesimalNumber.getEpsilon().signum() == 0 || linVar.mDisequalities == null) continue;
            for (Rational rational : linVar.mDisequalities.keySet()) {
                set.add(rational.sub(exactInfinitesimalNumber.getRealValue()).div(exactInfinitesimalNumber.getEpsilon()));
            }
        }
        return infinitesimalNumber;
    }

    @Override
    public void decreasedDecideLevel(int n) {
    }

    @Override
    public void increasedDecideLevel(int n) {
    }

    @Override
    public void restart(int n) {
    }

    public LAEquality createEquality(MutableAffineTerm mutableAffineTerm) {
        InfinitesimalNumber infinitesimalNumber;
        Object object;
        Rational rational = mutableAffineTerm.getGCD().inverse();
        mutableAffineTerm.mul(rational);
        LinVar linVar = this.generateLinVar(this.getSummandMap(mutableAffineTerm));
        if (mutableAffineTerm.mSummands.size() == 1) {
            object = mutableAffineTerm.mSummands.values().iterator().next();
            infinitesimalNumber = mutableAffineTerm.mConstant.negate().div((Rational)object);
        } else {
            infinitesimalNumber = mutableAffineTerm.mConstant.negate();
        }
        assert (infinitesimalNumber.mEps == 0);
        object = linVar.getEquality(infinitesimalNumber);
        if (object == null) {
            object = new LAEquality(this.mClausifier.getStackLevel(), linVar, infinitesimalNumber.mReal);
            this.getEngine().addAtom((DPLLAtom)object);
            linVar.addEquality((LAEquality)object);
        }
        return object;
    }

    @Override
    public Clause startCheck() {
        this.mEps = null;
        this.mInCheck = true;
        return null;
    }

    @Override
    public void endCheck() {
        this.mInCheck = false;
    }

    public Literal createCompositeLiteral(LAReason lAReason, Literal literal) {
        InfinitesimalNumber infinitesimalNumber;
        ++this.mCompositeCreateLit;
        int n = lAReason.getLastLiteral().getDecideLevel();
        if (this.mClausifier.getLogger().isDebugEnabled()) {
            this.mClausifier.getLogger().debug("Create Propagated Literal for " + String.valueOf(lAReason) + " @ level " + n);
        }
        LinVar linVar = lAReason.getVar();
        InfinitesimalNumber infinitesimalNumber2 = lAReason.getBound();
        if (!lAReason.isUpper()) {
            infinitesimalNumber2 = infinitesimalNumber2.sub(linVar.getEpsilon());
        }
        BoundConstraint boundConstraint = new BoundConstraint(infinitesimalNumber2, linVar, this.mClausifier.getStackLevel());
        Literal literal2 = lAReason.isUpper() ? boundConstraint : boundConstraint.negate();
        int n2 = lAReason.getLastLiteral().getDecideLevel();
        if (literal != null && literal.getAtom().getDecideLevel() == n2) {
            this.getEngine().insertPropagatedLiteralBefore(this, literal2, literal);
        } else {
            this.getEngine().insertPropagatedLiteral(this, literal2, n2);
        }
        InfinitesimalNumber infinitesimalNumber3 = infinitesimalNumber = lAReason.isUpper() ? boundConstraint.getBound() : boundConstraint.getInverseBound();
        if (!lAReason.getExactBound().equals(infinitesimalNumber)) {
            this.insertReasonOfNewComposite(linVar, literal2);
        }
        return literal2;
    }

    public void addSharedTerm(LASharedTerm lASharedTerm) {
        assert (!this.mSharedVars.contains(lASharedTerm));
        this.mSharedVars.add(lASharedTerm);
        this.getLogger().info("LAShare %s", lASharedTerm.getTerm());
    }

    @Override
    public void removeAtom(DPLLAtom dPLLAtom) {
        if (dPLLAtom instanceof BoundConstraint) {
            BoundConstraint boundConstraint = (BoundConstraint)dPLLAtom;
            LinVar linVar = boundConstraint.getVar();
            linVar.mConstraints.remove(boundConstraint.getBound());
        } else if (dPLLAtom instanceof LAEquality) {
            LAEquality lAEquality = (LAEquality)dPLLAtom;
            InfinitesimalNumber infinitesimalNumber = new InfinitesimalNumber(lAEquality.getBound(), 0);
            lAEquality.getVar().mEqualities.remove(infinitesimalNumber);
            for (CCEquality cCEquality : lAEquality.getDependentEqualities()) {
                cCEquality.removeLASharedData();
            }
        }
    }

    @Override
    public void pop() {
        int n = this.mLinvars.getLastScopeSize();
        int n2 = this.mLinvars.size() - 1;
        while (n2 >= n) {
            LinVar linVar = (LinVar)this.mLinvars.get(n2);
            if (linVar == this.mConflictVar) {
                this.mConflictVar = null;
            }
            this.removeLinVar(linVar);
            this.mDirty.clear(n2);
            this.mOob.remove(linVar);
            linVar.mAssertionstacklevel = -1;
            if (linVar.isInt()) {
                this.mIntVars.remove(linVar);
            }
            --n2;
        }
        if (this.mPushPopLevel == this.mHasNonLinearVar) {
            this.mHasNonLinearVar = -1;
        }
        --this.mPushPopLevel;
        this.mLinvars.endScope();
        this.mSharedVars.endScope();
        this.mBasics.endScope();
        this.mSuggestions.clear();
        this.mProplist.clear();
        assert (this.popPost());
    }

    private final boolean popPost() {
        return true;
    }

    @Override
    public void push() {
        this.mBasics.beginScope();
        this.mSharedVars.beginScope();
        this.mLinvars.beginScope();
        ++this.mPushPopLevel;
    }

    @Override
    public Object[] getStatistics() {
        return new Object[]{":LA", new Object[][]{{"Pivot", this.mNumPivots}, {"PivotBland", this.mNumPivotsBland}, {"Vars", this.mLinvars.size()}, {"CompLits", this.mCompositeCreateLit}, {"Cuts", this.mNumCuts}, {"Branches", this.mNumBranches}, {"GetUpperBound", this.mCountGetUpperBound}, {"Times", new Object[][]{{"Pivot", this.mPivotTime / 1000000L}, {"Fix", this.mFixTime / 1000000L}, {"BoundComp", this.mPropBoundTime / 1000000L}, {"BoundSet", this.mPropBoundSetTime / 1000000L}, {"BoundBack", this.mBacktrackPropTime / 1000000L}, {"CutGen", this.mCutGenTime / 1000000L}, {"GetUpperBound", this.mTimeGetUpperBound / 1000000L}}}}};
    }

    private FunctionSymbol getsValueFromLA(Term term) {
        ApplicationTerm applicationTerm;
        if (term instanceof ApplicationTerm && (applicationTerm = (ApplicationTerm)term).getParameters().length == 0) {
            return applicationTerm.getFunction();
        }
        return null;
    }

    public void fillInModel(Model model, Theory theory, SharedTermEvaluator sharedTermEvaluator) {
        this.prepareModel();
        for (LinVar linVar : this.mLinvars) {
            Term term;
            FunctionSymbol functionSymbol;
            if (linVar.isInitiallyBasic() || (functionSymbol = this.getsValueFromLA(term = linVar.getTerm())) == null) continue;
            Term term2 = this.realValue(linVar).toTerm(term.getSort());
            NumericSortInterpretation numericSortInterpretation = (NumericSortInterpretation)model.provideSortInterpretation(term.getSort());
            numericSortInterpretation.register(term2);
            model.map(functionSymbol, term2);
        }
    }

    public InfinitesimalNumber getUpperBound(MutableAffineTerm mutableAffineTerm) {
        long l = System.nanoTime();
        ++this.mCountGetUpperBound;
        if (mutableAffineTerm.isConstant()) {
            this.mTimeGetUpperBound += System.nanoTime() - l;
            return mutableAffineTerm.getConstant();
        }
        InfinitesimalNumber infinitesimalNumber = mutableAffineTerm.getConstant();
        Rational rational = mutableAffineTerm.getGCD();
        MutableAffineTerm mutableAffineTerm2 = new MutableAffineTerm();
        mutableAffineTerm2.add(rational.inverse(), mutableAffineTerm);
        LinVar linVar = this.generateLinVar(mutableAffineTerm2.getSummands());
        InfinitesimalNumber infinitesimalNumber2 = rational.signum() > 0 ? linVar.getTightUpperBound() : linVar.getTightLowerBound();
        this.mTimeGetUpperBound += System.nanoTime() - l;
        return infinitesimalNumber2.mul(rational).add(infinitesimalNumber);
    }
}

