/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ILiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.DestructiveEqualityReasoning;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.InstClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.InstantiationManager;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantAuxEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantBoundConstraint;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantClause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantUtil;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMatching;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.Polynomial;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedArrayList;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class QuantifierTheory
implements ITheory {
    private final Clausifier mClausifier;
    private final LogProxy mLogger;
    private final Theory mTheory;
    private final DPLLEngine mEngine;
    final CClosure mCClosure;
    final LinArSolve mLinArSolve;
    private final EMatching mEMatching;
    private final InstantiationManager mInstantiationManager;
    private final Map<Sort, Term> mLambdas;
    private final ScopedArrayList<QuantClause> mQuantClauses;
    private final Map<Literal, Set<InstClause>> mPendingInstances;
    long mNumInstancesProduced;
    long mNumInstancesDER;
    long mNumInstancesProducedConfl;
    long mNumInstancesProducedEM;
    long mNumInstancesProducedEnum;
    private long mNumCheckpoints;
    private long mNumCheckpointsWithNewEval;
    private long mNumConflicts;
    private long mNumProps;
    private long mNumFinalcheck;
    private long mCheckpointTime;
    private long mFindEmatchingTime;
    private long mFinalCheckTime;
    private long mEMatchingTime;
    private long mDawgTime;
    int[] mNumInstancesOfAge;
    int[] mNumInstancesOfAgeEnum;
    InstantiationMethod mInstantiationMethod;
    boolean mUseUnknownTermValueInDawgs;
    boolean mPropagateNewAux;
    boolean mPropagateNewTerms;

    public QuantifierTheory(Theory theory, DPLLEngine dPLLEngine, Clausifier clausifier, InstantiationMethod instantiationMethod, boolean bl, boolean bl2, boolean bl3) {
        this.mClausifier = clausifier;
        this.mLogger = clausifier.getLogger();
        this.mTheory = theory;
        this.mEngine = dPLLEngine;
        this.mInstantiationMethod = instantiationMethod;
        this.mUseUnknownTermValueInDawgs = bl;
        this.mPropagateNewTerms = bl2;
        this.mPropagateNewAux = bl3;
        this.mCClosure = clausifier.getCClosure();
        this.mLinArSolve = clausifier.getLASolver();
        this.mEMatching = new EMatching(this);
        this.mInstantiationManager = new InstantiationManager(this);
        this.mLambdas = new HashMap<Sort, Term>();
        this.mQuantClauses = new ScopedArrayList();
        this.mPendingInstances = new LinkedHashMap<Literal, Set<InstClause>>();
        this.mNumInstancesOfAge = new int[32];
        this.mNumInstancesOfAgeEnum = new int[32];
    }

    @Override
    public Clause startCheck() {
        return null;
    }

    @Override
    public void endCheck() {
    }

    @Override
    public Clause setLiteral(Literal literal) {
        if (this.mQuantClauses.isEmpty()) {
            assert (this.mPendingInstances.isEmpty());
            return null;
        }
        if (this.mPendingInstances.containsKey(literal)) {
            for (InstClause instClause : this.mPendingInstances.remove(literal)) {
                assert (instClause.mLits.contains(literal));
                for (Literal literal2 : instClause.mLits) {
                    Set<InstClause> set;
                    if (literal2 == literal || (set = this.mPendingInstances.get(literal2)) == null) continue;
                    set.remove(instClause);
                    if (!set.isEmpty()) continue;
                    this.mPendingInstances.remove(literal2);
                }
            }
        }
        if (this.mPendingInstances.containsKey(literal.negate())) {
            for (InstClause instClause : this.mPendingInstances.remove(literal.negate())) {
                assert (instClause.mNumUndefLits > 0);
                --instClause.mNumUndefLits;
                if (!instClause.isConflict()) continue;
                this.mLogger.debug("Quant conflict: %s", instClause);
                ++this.mNumConflicts;
                return instClause.toClause(this.mEngine.isProofGenerationEnabled());
            }
        }
        return null;
    }

    @Override
    public void backtrackLiteral(Literal literal) {
    }

    @Override
    public Clause checkpoint() {
        long l = System.nanoTime();
        ++this.mNumCheckpoints;
        Clause clause = null;
        if (!this.mQuantClauses.isEmpty()) {
            Set<InstClause> set;
            if (!this.mPendingInstances.isEmpty()) {
                return null;
            }
            switch (this.mInstantiationMethod) {
                case E_MATCHING_CONFLICT: {
                    ++this.mNumCheckpointsWithNewEval;
                    this.mEMatching.run();
                    set = this.mInstantiationManager.findConflictAndUnitInstancesWithEMatching();
                    this.mFindEmatchingTime += System.nanoTime() - l;
                    break;
                }
                case AUF_CONFLICT: {
                    ++this.mNumCheckpointsWithNewEval;
                    set = this.mInstantiationManager.findConflictAndUnitInstances();
                    break;
                }
                case E_MATCHING_EAGER: {
                    ++this.mNumCheckpointsWithNewEval;
                    this.mEMatching.run();
                    set = this.mInstantiationManager.computeEMatchingInstances();
                    this.mFindEmatchingTime += System.nanoTime() - l;
                    break;
                }
                case E_MATCHING_LAZY: {
                    set = null;
                    break;
                }
                case E_MATCHING_CONFLICT_LAZY: {
                    set = null;
                    break;
                }
                default: {
                    throw new InternalError("Unknown instantiation method");
                }
            }
            clause = this.addInstClausesToPending(set);
            if (clause != null) {
                this.mLogger.debug("Quant conflict: %s", clause);
                this.mEngine.learnClause(clause);
                ++this.mNumConflicts;
            }
        }
        this.mCheckpointTime += System.nanoTime() - l;
        return clause;
    }

    @Override
    public Clause computeConflictClause() {
        long l = System.nanoTime();
        ++this.mNumFinalcheck;
        assert (this.mPendingInstances.isEmpty());
        Clause clause = null;
        if (!this.mQuantClauses.isEmpty()) {
            Set<Object> set = new LinkedHashSet();
            boolean bl = false;
            if (this.mInstantiationMethod == InstantiationMethod.E_MATCHING_LAZY) {
                this.mEMatching.run();
                set = this.mInstantiationManager.computeEMatchingInstances();
                this.mFindEmatchingTime += System.nanoTime() - l;
                for (InstClause instClause : set) {
                    if (instClause.countAndSetUndefLits() == -1) continue;
                    bl = true;
                    break;
                }
            } else if (this.mInstantiationMethod == InstantiationMethod.E_MATCHING_CONFLICT_LAZY) {
                this.mEMatching.run();
                set = this.mInstantiationManager.findConflictAndUnitInstancesWithEMatching();
                this.mFindEmatchingTime += System.nanoTime() - l;
                for (InstClause instClause : set) {
                    if (instClause.countAndSetUndefLits() == -1) continue;
                    bl = true;
                    break;
                }
            }
            if (this.mClausifier.getEngine().isTerminationRequested()) {
                return null;
            }
            if (set.isEmpty() || !bl) {
                set = this.mInstantiationManager.instantiateSomeNotSat();
            }
            if ((clause = this.addInstClausesToPending(set)) != null) {
                ++this.mNumConflicts;
                this.mEngine.learnClause(clause);
            }
        }
        this.mFinalCheckTime += System.nanoTime() - l;
        return clause;
    }

    @Override
    public Literal getPropagatedLiteral() {
        if (this.mQuantClauses.isEmpty()) {
            assert (this.mPendingInstances.isEmpty());
            return null;
        }
        for (Map.Entry<Literal, Set<InstClause>> entry : this.mPendingInstances.entrySet()) {
            if (this.mEngine.isTerminationRequested()) {
                return null;
            }
            Literal literal = entry.getKey();
            for (InstClause instClause : entry.getValue()) {
                if (instClause.isUnit()) {
                    Clause clause = instClause.toClause(this.mEngine.isProofGenerationEnabled());
                    literal.getAtom().mExplanation = clause;
                    this.mEngine.learnClause(clause);
                    ++this.mNumProps;
                    this.mLogger.debug("Quant Prop: %s Reason: %s", literal, literal.getAtom().mExplanation);
                    return literal;
                }
                if (this.mInstantiationMethod == InstantiationMethod.E_MATCHING_EAGER || this.mInstantiationMethod == InstantiationMethod.E_MATCHING_LAZY) continue;
                this.mLogger.debug("Not propagated: %s Clause: %s", literal, instClause.mLits);
            }
        }
        return null;
    }

    @Override
    public Clause getUnitClause(Literal literal) {
        assert (false) : "Should never be called.";
        return null;
    }

    @Override
    public Literal getSuggestion() {
        return null;
    }

    @Override
    public void printStatistics(LogProxy logProxy) {
        logProxy.info("Quant: DER produced %d ground clause(s).", this.mNumInstancesDER);
        logProxy.info("Quant: Instances produced: %d (Conflict/Unit: %d, E-Matching: %d, Enumeration: %d)", this.mNumInstancesProduced, this.mNumInstancesProducedConfl, this.mNumInstancesProducedEM, this.mNumInstancesProducedEnum);
        logProxy.info("Quant: Subs of age 0, 1, 2-3, 4-7, ... : %s, (Enumeration: %s)", Arrays.toString(this.mNumInstancesOfAge), Arrays.toString(this.mNumInstancesOfAgeEnum));
        logProxy.info("Quant: Conflicts: %d Props: %d Checkpoints (with new evaluation): %d (%d) Final Checks: %d", this.mNumConflicts, this.mNumProps, this.mNumCheckpoints, this.mNumCheckpointsWithNewEval, this.mNumFinalcheck);
        logProxy.info("Quant times: Checkpoint: %d.%03d Find with E-matching: %d.%03d E-Matching: %d.%03d Dawg: %d.%03d Final Check: %d.%03d", this.mCheckpointTime / 1000L / 1000L, this.mCheckpointTime / 1000L % 1000L, this.mFindEmatchingTime / 1000L / 1000L, this.mFindEmatchingTime / 1000L % 1000L, this.mEMatchingTime / 1000L / 1000L, this.mEMatchingTime / 1000L % 1000L, this.mDawgTime / 1000L / 1000L, this.mDawgTime / 1000L % 1000L, this.mFinalCheckTime / 1000L / 1000L, this.mFinalCheckTime / 1000L % 1000L);
    }

    @Override
    public void dumpModel(LogProxy logProxy) {
    }

    @Override
    public void increasedDecideLevel(int n) {
    }

    @Override
    public void decreasedDecideLevel(int n) {
    }

    @Override
    public void backtrackAll() {
        this.mEMatching.removeAllTriggers();
        this.mInstantiationManager.resetInterestingTerms();
        this.mPendingInstances.clear();
    }

    @Override
    public void backtrackStart() {
        this.mPendingInstances.clear();
    }

    @Override
    public Clause backtrackComplete() {
        int n = this.mClausifier.getEngine().getDecideLevel();
        this.mEMatching.undo(n);
        this.mInstantiationManager.resetInterestingTerms();
        this.mInstantiationManager.resetSubsAgeForFinalCheck();
        return null;
    }

    @Override
    public void restart(int n) {
    }

    @Override
    public void removeAtom(DPLLAtom dPLLAtom) {
    }

    @Override
    public void push() {
        this.mQuantClauses.beginScope();
    }

    @Override
    public void pop() {
        assert (this.mPendingInstances.isEmpty());
        this.mInstantiationManager.removeAllInstClauses();
        this.mEMatching.removeAllTriggers();
        for (QuantClause quantClause : this.mQuantClauses.currentScope()) {
            this.mInstantiationManager.removeClause(quantClause);
            this.mEMatching.removeClause(quantClause);
        }
        this.mQuantClauses.endScope();
        this.mEMatching.reAddClauses(this.mQuantClauses);
    }

    @Override
    public Object[] getStatistics() {
        return new Object[]{":Quant", new Object[][]{{"DER ground results", this.mNumInstancesDER}, {"Instances produced", this.mNumInstancesProduced}, {"thereof by conflict/unit search", this.mNumInstancesProducedConfl}, {"and by E-matching", this.mNumInstancesProducedEM}, {"and by enumeration", this.mNumInstancesProducedEnum}, {"Subs of age 0, 1, 2-3, 4-7, ...", Arrays.toString(this.mNumInstancesOfAge)}, {"thereof for enumeration", Arrays.toString(this.mNumInstancesOfAgeEnum)}, {"Conflicts", this.mNumConflicts}, {"Propagations", this.mNumProps}, {"Checkpoints", this.mNumCheckpoints}, {"Checkpoints with new evaluation", this.mNumCheckpointsWithNewEval}, {"Final Checks", this.mNumFinalcheck}, {"Times", new Object[][]{{"Checkpoint", this.mCheckpointTime}, {"Find E-matching", this.mFindEmatchingTime}, {"E-Matching", this.mEMatchingTime}, {"Final Check", this.mFinalCheckTime}}}}};
    }

    public QuantAuxEquality createAuxLiteral(Term term, Term term2, SourceAnnotation sourceAnnotation) {
        QuantAuxEquality quantAuxEquality = new QuantAuxEquality(term, (Term)this.mTheory.mTrue, term2);
        quantAuxEquality.negate().mIsEssentiallyUninterpreted = true;
        quantAuxEquality.mIsEssentiallyUninterpreted = true;
        return quantAuxEquality;
    }

    public ILiteral createAuxFalseLiteral(QuantAuxEquality quantAuxEquality, SourceAnnotation sourceAnnotation) {
        Term term = quantAuxEquality.getLhs();
        QuantAuxEquality quantAuxEquality2 = new QuantAuxEquality(term, (Term)this.mTheory.mFalse, quantAuxEquality.getDefinition());
        quantAuxEquality2.negate().mIsEssentiallyUninterpreted = true;
        quantAuxEquality2.mIsEssentiallyUninterpreted = true;
        return quantAuxEquality2;
    }

    public QuantLiteral getQuantEquality(Term term, Term term2, SourceAnnotation sourceAnnotation) {
        Object object;
        Object object2;
        Term term3;
        Term term4;
        block11: {
            block10: {
                term4 = term;
                term3 = term2;
                if (term.getSort().isNumericSort()) break block10;
                object2 = term instanceof TermVariable ? (TermVariable)term : null;
                Object object3 = object = term2 instanceof TermVariable ? (TermVariable)term2 : null;
                if (object2 != null || object == null) break block11;
                term4 = object;
                term3 = term;
                break block11;
            }
            object2 = new Polynomial(term);
            ((Polynomial)object2).add(Rational.MONE, term2);
            ((Polynomial)object2).mul(((Polynomial)object2).getGcd().inverse());
            object = Rational.ONE;
            for (Map<Term, Integer> map : ((Polynomial)object2).getSummands().keySet()) {
                Term term5 = null;
                if (map.size() == 1 && map.values().iterator().next() == 1) {
                    term5 = map.keySet().iterator().next();
                }
                if (!(term5 instanceof TermVariable)) continue;
                object = ((Polynomial)object2).getSummands().get(map);
                if (term5.getSort().getName() != "Real" && object.abs() != Rational.ONE) continue;
                term4 = term5;
                ((Polynomial)object2).add(object.negate(), map);
                ((Polynomial)object2).mul(object.negate().inverse());
                term3 = ((Polynomial)object2).toTerm(term.getSort());
                break;
            }
        }
        if ((object = (QuantLiteral)this.mClausifier.getILiteral((Term)(object2 = this.mTheory.term("=", new Term[]{term4, term3})))) != null) {
            return object;
        }
        this.addGroundCCTerms(term4, sourceAnnotation);
        this.addGroundCCTerms(term3, sourceAnnotation);
        object = new QuantEquality(term4, term3);
        if (!(term4 instanceof TermVariable)) {
            if (QuantUtil.isEssentiallyUninterpreted(term4) && QuantUtil.isEssentiallyUninterpreted(term3)) {
                ((QuantLiteral)object).negate().mIsEssentiallyUninterpreted = true;
                ((QuantLiteral)object).mIsEssentiallyUninterpreted = true;
            }
        } else if (!(term3 instanceof TermVariable)) {
            if (term3.getFreeVars().length == 0 && term3.getSort().getName() == "Int") {
                ((QuantLiteral)object).mIsArithmetical = true;
            }
            if (!Arrays.asList(term3.getFreeVars()).contains(term4)) {
                ((QuantLiteral)object).negate().mIsDERUsable = true;
            }
        } else {
            ((QuantLiteral)object).negate().mIsDERUsable = true;
        }
        this.mClausifier.setTermFlags((Term)object2, this.mClausifier.getTermFlags((Term)object2) | 4 | 8);
        this.mClausifier.setLiteral((Term)object2, (ILiteral)object);
        return object;
    }

    public QuantLiteral getQuantInequality(boolean bl, Term term, SourceAnnotation sourceAnnotation) {
        Object object;
        boolean bl2 = false;
        Polynomial polynomial = new Polynomial(term);
        TermVariable termVariable = null;
        Rational rational = Rational.ONE;
        boolean bl3 = false;
        for (Map<Term, Integer> term22 : polynomial.getSummands().keySet()) {
            if (term22.size() != 1 || term22.values().iterator().next() != 1 || !((object = term22.keySet().iterator().next()) instanceof TermVariable)) continue;
            rational = polynomial.getSummands().get(term22);
            if (object.getSort().getName() == "Real") {
                termVariable = (TermVariable)object;
                if (rational.isNegative()) {
                    bl3 = true;
                    break;
                }
                bl3 = false;
                break;
            }
            if (rational == Rational.MONE) {
                termVariable = (TermVariable)object;
                bl3 = true;
                break;
            }
            if (rational != Rational.ONE) continue;
            termVariable = (TermVariable)object;
            bl3 = false;
            break;
        }
        if (bl && termVariable != null && term.getSort().getName() == "Int") {
            bl2 = true;
            polynomial.mul(Rational.MONE);
            polynomial.add(Rational.ONE);
            bl3 = !bl3;
        } else if (termVariable != null && term.getSort().getName() == "Real") {
            polynomial.mul(rational.abs().inverse());
        }
        this.mClausifier.getTermCompiler();
        Term term2 = polynomial.toTerm(term.getSort());
        Term term3 = this.mTheory.term("<=", new Term[]{term2, Rational.ZERO.toTerm(term.getSort())});
        object = (QuantLiteral)this.mClausifier.getILiteral(term3);
        if (object != null) {
            return bl2 ? ((QuantLiteral)object).negate() : object;
        }
        object = new QuantBoundConstraint(term3, polynomial);
        this.addGroundCCTerms(term2, sourceAnnotation);
        if (termVariable == null) {
            boolean polynomial2 = true;
            for (Map<Term, Integer> term5 : polynomial.getSummands().keySet()) {
                for (Term term4 : term5.keySet()) {
                    boolean bl4 = polynomial2 = polynomial2 && QuantUtil.isEssentiallyUninterpreted(term4);
                }
            }
            if (polynomial2) {
                ((QuantLiteral)object).negate().mIsEssentiallyUninterpreted = true;
                ((QuantLiteral)object).mIsEssentiallyUninterpreted = true;
            }
        } else {
            Term term5;
            Polynomial polynomial2 = new Polynomial();
            polynomial2.add(Rational.ONE, polynomial);
            polynomial2.add(bl3 ? Rational.ONE : Rational.MONE, (Term)termVariable);
            if (!bl3) {
                polynomial2.mul(Rational.MONE);
            }
            if ((term5 = polynomial2.toTerm(term.getSort())) instanceof TermVariable || term5.getFreeVars().length == 0) {
                ((QuantLiteral)object).negate().mIsArithmetical = true;
            }
        }
        this.mClausifier.setTermFlags(term3, this.mClausifier.getTermFlags(term3) | 4 | 8);
        this.mClausifier.setLiteral(term3, (ILiteral)object);
        return bl2 ? ((QuantLiteral)object).negate() : object;
    }

    public QuantLiteral[] getLiteralCopies(QuantLiteral[] quantLiteralArray, QuantClause quantClause) {
        QuantLiteral[] quantLiteralArray2 = new QuantLiteral[quantLiteralArray.length];
        int n = 0;
        while (n < quantLiteralArray.length) {
            QuantLiteral quantLiteral;
            QuantLiteral quantLiteral2 = quantLiteralArray[n].getAtom();
            if (quantLiteral2 instanceof QuantBoundConstraint) {
                quantLiteral = new QuantBoundConstraint(quantLiteral2.getTerm(), ((QuantBoundConstraint)quantLiteral2).getAffineTerm());
            } else if (quantLiteral2 instanceof QuantAuxEquality) {
                QuantAuxEquality quantAuxEquality = (QuantAuxEquality)quantLiteral2;
                quantLiteral = new QuantAuxEquality(quantAuxEquality.getLhs(), quantAuxEquality.getRhs(), quantAuxEquality.getDefinition());
            } else {
                quantLiteral = new QuantEquality(((QuantEquality)quantLiteral2).getLhs(), ((QuantEquality)quantLiteral2).getRhs());
            }
            quantLiteral.mClause = quantClause;
            quantLiteral.mIsEssentiallyUninterpreted = quantLiteral2.mIsEssentiallyUninterpreted;
            quantLiteral.mIsArithmetical = quantLiteral2.mIsArithmetical;
            quantLiteral.mIsDERUsable = quantLiteral2.mIsDERUsable;
            quantLiteral.mNegated.mClause = quantClause;
            quantLiteral.mNegated.mIsEssentiallyUninterpreted = quantLiteral2.mNegated.mIsEssentiallyUninterpreted;
            quantLiteral.mNegated.mIsArithmetical = quantLiteral2.mNegated.mIsArithmetical;
            quantLiteral.mNegated.mIsDERUsable = quantLiteral2.mNegated.mIsDERUsable;
            quantLiteralArray2[n] = quantLiteralArray[n].isNegated() ? quantLiteral.negate() : quantLiteral;
            ++n;
        }
        return quantLiteralArray2;
    }

    public DestructiveEqualityReasoning.DERResult performDestructiveEqualityReasoning(TermVariable[] termVariableArray, Literal[] literalArray, QuantLiteral[] quantLiteralArray, SourceAnnotation sourceAnnotation) {
        DestructiveEqualityReasoning destructiveEqualityReasoning = new DestructiveEqualityReasoning(this, termVariableArray, literalArray, quantLiteralArray, sourceAnnotation);
        if (destructiveEqualityReasoning.applyDestructiveEqualityReasoning()) {
            DestructiveEqualityReasoning.DERResult dERResult = destructiveEqualityReasoning.getResult();
            if (dERResult.isGround() && !dERResult.isTriviallyTrue()) {
                this.mLogger.debug("Quant: DER returned ground clause.");
                ++this.mNumInstancesDER;
            }
            return dERResult;
        }
        return null;
    }

    public void addQuantClause(TermVariable[] termVariableArray, Literal[] literalArray, QuantLiteral[] quantLiteralArray, SourceAnnotation sourceAnnotation, Term term) {
        Object object;
        QuantLiteral[] quantLiteralArray2 = quantLiteralArray;
        int n = quantLiteralArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = quantLiteralArray2[n2];
            if (!((QuantLiteral)object).isAlmostUninterpreted()) {
                this.mLogger.info("Quant: Clause contains literal that is not almost uninterpreted: %s", object);
            } else if (((QuantLiteral)object).mIsDERUsable) {
                this.mLogger.warn("Quant: Clause contains disequality on variable not eliminated by DER: %s", object);
            }
            ++n2;
        }
        if (quantLiteralArray.length == 0) {
            throw new IllegalArgumentException("Cannot add clause to QuantifierTheory: No quantified literal!");
        }
        object = new QuantClause(termVariableArray, literalArray, quantLiteralArray, this, sourceAnnotation, term);
        this.mQuantClauses.add((QuantClause)object);
        this.mEMatching.addClause((QuantClause)object);
        this.mInstantiationManager.addClause((QuantClause)object);
        if (((QuantClause)object).hasArrayIndices()) {
            this.mClausifier.getArrayTheory().setNeedDiffIndices();
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug("Quant: Added clause: " + String.valueOf(object));
        }
    }

    public void addEMatchingTime(long l) {
        this.mEMatchingTime += l;
    }

    public void addDawgTime(long l) {
        this.mDawgTime += l;
    }

    public Clausifier getClausifier() {
        return this.mClausifier;
    }

    public CClosure getCClosure() {
        return this.mCClosure;
    }

    public EMatching getEMatching() {
        return this.mEMatching;
    }

    public DPLLEngine getEngine() {
        return this.mEngine;
    }

    public LinArSolve getLinAr() {
        return this.mLinArSolve;
    }

    public InstantiationManager getInstantiationManager() {
        return this.mInstantiationManager;
    }

    public LogProxy getLogger() {
        return this.mLogger;
    }

    public Collection<QuantClause> getQuantClauses() {
        return this.mQuantClauses;
    }

    public Theory getTheory() {
        return this.mTheory;
    }

    public InstantiationMethod getInstantiationMethod() {
        return this.mInstantiationMethod;
    }

    protected Term getLambda(Sort sort) {
        ApplicationTerm applicationTerm;
        if (this.mLambdas.containsKey(sort)) {
            return this.mLambdas.get(sort);
        }
        if (sort.getName().equals("Bool")) {
            applicationTerm = this.mTheory.mTrue;
        } else {
            FunctionSymbol functionSymbol = this.mTheory.getFunctionWithResult("@0", null, sort, new Sort[0]);
            applicationTerm = this.mTheory.term(functionSymbol, new Term[0]);
        }
        this.mLambdas.put(sort, (Term)applicationTerm);
        return applicationTerm;
    }

    @Override
    public int checkCompleteness() {
        for (QuantClause quantClause : this.mQuantClauses) {
            if (quantClause.hasTrueGroundLits()) continue;
            QuantLiteral[] quantLiteralArray = quantClause.getQuantLits();
            int n = quantLiteralArray.length;
            int n2 = 0;
            while (n2 < n) {
                QuantLiteral quantLiteral = quantLiteralArray[n2];
                if (!quantLiteral.isAlmostUninterpreted()) {
                    return 1;
                }
                ++n2;
            }
            for (Term term : this.mLambdas.values()) {
                CCTerm cCTerm;
                if (term.getSort().isNumericSort() || (cCTerm = this.mClausifier.getCCTerm(term)) == null || cCTerm.getNumMembers() <= 1) continue;
                return 1;
            }
        }
        return 0;
    }

    private Clause addInstClausesToPending(Collection<InstClause> collection) {
        if (collection == null) {
            return null;
        }
        for (InstClause instClause : collection) {
            if (this.mEngine.isTerminationRequested()) {
                return null;
            }
            int n = instClause.countAndSetUndefLits();
            if (n == -1) continue;
            if (n == 0) {
                return instClause.toClause(this.mEngine.isProofGenerationEnabled());
            }
            for (Literal literal : instClause.mLits) {
                if (literal.getAtom().getDecideStatus() != null) continue;
                if (!this.mPendingInstances.containsKey(literal)) {
                    this.mPendingInstances.put(literal, new LinkedHashSet());
                }
                this.mPendingInstances.get(literal).add(instClause);
            }
        }
        return null;
    }

    Term getRepresentativeTerm(Term term) {
        CCTerm cCTerm = this.getClausifier().getCCTerm(term);
        return cCTerm == null ? term : cCTerm.getRepresentative().getFlatTerm();
    }

    private void addGroundCCTerms(Term term, SourceAnnotation sourceAnnotation) {
        HashSet<Term> hashSet = new HashSet<Term>();
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        arrayDeque.add(term);
        while (!arrayDeque.isEmpty()) {
            CCTerm cCTerm;
            Term term2 = (Term)arrayDeque.pop();
            if (!(term2 instanceof ApplicationTerm) || !hashSet.add(term2)) continue;
            if (term2.getFreeVars().length == 0) {
                cCTerm = this.mClausifier.getCCTerm(term2);
                if (cCTerm != null || !Clausifier.needCCTerm(term2) && !term2.getSort().isArraySort()) continue;
                this.mClausifier.createCCTerm(term2, sourceAnnotation);
                continue;
            }
            Term[] termArray = ((ApplicationTerm)term2).getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                cCTerm = termArray[n2];
                arrayDeque.add(cCTerm);
                ++n2;
            }
        }
    }

    public static enum InstanceOrigin {
        CONFLICT(":conflict"),
        EMATCHING(":e-matching"),
        ENUMERATION(":enumeration");

        String mOrigin;

        private InstanceOrigin(String string2) {
            this.mOrigin = string2;
        }

        public String getOrigin() {
            return this.mOrigin;
        }
    }

    public static enum InstantiationMethod {
        AUF_CONFLICT,
        E_MATCHING_CONFLICT,
        E_MATCHING_EAGER,
        E_MATCHING_LAZY,
        E_MATCHING_CONFLICT_LAZY;

    }
}

