/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.XnfTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.List;
import java.util.function.Function;

public class DnfTransformer
extends XnfTransformer {
    public DnfTransformer(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider) {
        super(managedScript, iUltimateServiceProvider, (Integer n) -> false);
    }

    public DnfTransformer(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, Function<Integer, Boolean> function) {
        super(managedScript, iUltimateServiceProvider, function);
    }

    @Override
    protected NnfTransformer.NnfTransformerHelper getNnfTransformerHelper(IUltimateServiceProvider iUltimateServiceProvider) {
        return new DnfTransformerHelper(iUltimateServiceProvider);
    }

    protected class DnfTransformerHelper
    extends XnfTransformer.XnfTransformerHelper {
        protected DnfTransformerHelper(IUltimateServiceProvider iUltimateServiceProvider) {
            super(DnfTransformer.this, iUltimateServiceProvider);
        }

        @Override
        public String innerConnectiveSymbol() {
            return "and";
        }

        @Override
        public String outerConnectiveSymbol() {
            return "or";
        }

        @Override
        public String innerJunctionName() {
            return "conjunction";
        }

        @Override
        public String outerJunctionName() {
            return "disjunction";
        }

        @Override
        public Term innerConnective(Script script, List<Term> list) {
            Term term = SmtUtils.and(DnfTransformer.this.mScript, list);
            return term;
        }

        @Override
        public Term outerConnective(Script script, List<Term> list) {
            Term term = SmtUtils.or(DnfTransformer.this.mScript, list);
            return term;
        }

        @Override
        public Term[] getOuterJuncts(Term term) {
            return SmtUtils.getDisjuncts(term);
        }
    }
}

