/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.witnesschecking;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ConditionAnnotation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadOther;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.AnnotatedPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IMLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedIteratorNoopConstruction;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.TransformIterator;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Location;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Segment;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.ViolationSequence;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Waypoint;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.WaypointAssumption;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.WaypointBranching;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.WaypointFunctionEnter;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.WaypointFunctionReturn;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.WaypointTarget;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Witness;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;

public class YamlWitnessProductAutomaton<LETTER extends IIcfgTransition<?>>
implements INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> {
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> mAbstraction;
    private final Witness mWitness;
    private final ISLPredicate mEmptyStackState;
    private final Set<ProductPredicate<?>> mAllProductStates = new HashSet();
    private static final boolean CHECK_ASSUMPTION_LOCATIONS = false;
    private final Set<Waypoint> mMatchedFollowWaypoints = new HashSet<Waypoint>();

    public YamlWitnessProductAutomaton(INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> iNwaOutgoingLetterAndTransitionProvider, Witness witness, PredicateFactory predicateFactory) {
        this.mAbstraction = iNwaOutgoingLetterAndTransitionProvider;
        this.mWitness = witness;
        this.mEmptyStackState = predicateFactory.newEmptyStackPredicate();
    }

    @Deprecated
    public IStateFactory<IPredicate> getStateFactory() {
        return this.mAbstraction.getStateFactory();
    }

    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mAbstraction.getVpAlphabet();
    }

    public IPredicate getEmptyStackState() {
        return this.mEmptyStackState;
    }

    public Iterable<IPredicate> getInitialStates() {
        return () -> new NestedIteratorNoopConstruction(this.mAbstraction.getInitialStates().iterator(), iPredicate -> IntStream.range(0, this.mWitness.getEntries().size()).mapToObj(n -> this.createProductState((IPredicate)iPredicate, 0, n)).iterator());
    }

    public boolean isInitial(IPredicate iPredicate) {
        ProductPredicate productPredicate = (ProductPredicate)iPredicate;
        return this.mAbstraction.isInitial((Object)productPredicate.getUnderlying()) && productPredicate.getSegmentCounter() == 0;
    }

    public boolean isFinal(IPredicate iPredicate) {
        ProductPredicate productPredicate = (ProductPredicate)iPredicate;
        if (productPredicate.getSegmentCounter() == 0) {
            return false;
        }
        ViolationSequence violationSequence = (ViolationSequence)this.mWitness.getEntries().get(productPredicate.getViolationSequenceCounter());
        Segment segment = (Segment)violationSequence.getSegments().get(productPredicate.getSegmentCounter() - 1);
        return segment.getFollowOrCycleWaypoint() instanceof WaypointTarget && this.mAbstraction.isFinal((Object)productPredicate.getUnderlying()) && productPredicate.getSegmentCounter() == violationSequence.getSegments().size();
    }

    public int size() {
        return this.mAllProductStates.size();
    }

    public String sizeInformation() {
        return "has currently " + this.size() + " states, but on-demand construction may add more states";
    }

    public Iterable<OutgoingInternalTransition<LETTER, IPredicate>> internalSuccessors(IPredicate iPredicate, LETTER LETTER) {
        ProductPredicate productPredicate = (ProductPredicate)iPredicate;
        int n = this.getSuccessorCounter(productPredicate, LETTER);
        if (n == -1) {
            return List.of();
        }
        return () -> new TransformIterator(this.mAbstraction.internalSuccessors((Object)productPredicate.getUnderlying(), (Object)LETTER).iterator(), outgoingInternalTransition -> new OutgoingInternalTransition((Object)LETTER, (Object)this.createProductState((IPredicate)outgoingInternalTransition.getSucc(), n, productPredicate.getViolationSequenceCounter())));
    }

    public Iterable<OutgoingCallTransition<LETTER, IPredicate>> callSuccessors(IPredicate iPredicate, LETTER LETTER) {
        ProductPredicate productPredicate = (ProductPredicate)iPredicate;
        int n = this.getSuccessorCounter(productPredicate, LETTER);
        if (n == -1) {
            return List.of();
        }
        return () -> new TransformIterator(this.mAbstraction.callSuccessors((Object)productPredicate.getUnderlying(), (Object)LETTER).iterator(), outgoingCallTransition -> new OutgoingCallTransition((Object)LETTER, (Object)this.createProductState((IPredicate)outgoingCallTransition.getSucc(), n, productPredicate.getViolationSequenceCounter())));
    }

    public Iterable<OutgoingReturnTransition<LETTER, IPredicate>> returnSuccessors(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER) {
        ProductPredicate productPredicate = (ProductPredicate)iPredicate;
        ProductPredicate productPredicate2 = (ProductPredicate)iPredicate2;
        IPredicate iPredicate3 = productPredicate.getUnderlying();
        int n = this.getSuccessorCounter(productPredicate, LETTER);
        if (n == -1) {
            return List.of();
        }
        return () -> new TransformIterator(this.mAbstraction.returnSuccessors((Object)iPredicate3, (Object)productPredicate2.getUnderlying(), (Object)LETTER).iterator(), outgoingReturnTransition -> new OutgoingReturnTransition((Object)productPredicate2, (Object)LETTER, (Object)this.createProductState((IPredicate)outgoingReturnTransition.getSucc(), n, productPredicate.getViolationSequenceCounter())));
    }

    private int getSuccessorCounter(ProductPredicate<?> productPredicate, LETTER LETTER) {
        List list = ((ViolationSequence)this.mWitness.getEntries().get(productPredicate.getViolationSequenceCounter())).getSegments();
        int n = productPredicate.getSegmentCounter();
        while (n < list.size()) {
            Segment segment = (Segment)list.get(n);
            if (segment.getAvoidWaypoints().stream().anyMatch(waypoint -> this.matchesWaypoint(LETTER, (Waypoint)waypoint))) {
                return -1;
            }
            Waypoint waypoint2 = segment.getFollowOrCycleWaypoint();
            if (!(waypoint2 instanceof WaypointAssumption)) {
                if (this.matchesWaypoint(LETTER, waypoint2)) {
                    this.mMatchedFollowWaypoints.add(waypoint2);
                    return n + 1;
                }
                return n;
            }
            this.mMatchedFollowWaypoints.add(waypoint2);
            ++n;
        }
        return list.size();
    }

    private boolean matchesWaypoint(LETTER LETTER, Waypoint waypoint) {
        if (waypoint instanceof WaypointBranching && YamlWitnessProductAutomaton.matchesStartLocation(LETTER, waypoint)) {
            if (!"true".equals(waypoint.getConstraint()) && !"false".equals(waypoint.getConstraint())) {
                throw new UnsupportedOperationException("Branching waypoints at switch statements are not supported yet.");
            }
            ConditionAnnotation conditionAnnotation = ConditionAnnotation.getAnnotation(LETTER);
            return conditionAnnotation != null && Boolean.parseBoolean(waypoint.getConstraint()) == !conditionAnnotation.isNegated();
        }
        if (waypoint instanceof WaypointTarget) {
            return YamlWitnessProductAutomaton.matchesStartLocation(LETTER, waypoint);
        }
        if (waypoint instanceof WaypointFunctionEnter) {
            if (LETTER instanceof IIcfgForkTransitionThreadOther) {
                IIcfgForkTransitionThreadOther iIcfgForkTransitionThreadOther = (IIcfgForkTransitionThreadOther)LETTER;
                return YamlWitnessProductAutomaton.matchesEndLocation((IElement)iIcfgForkTransitionThreadOther.getCorrespondingIIcfgForkTransitionCurrentThread(), waypoint);
            }
            return YamlWitnessProductAutomaton.matchesEndLocation(LETTER, waypoint);
        }
        if (waypoint instanceof WaypointFunctionReturn) {
            if (LETTER instanceof IIcfgReturnTransition) {
                return YamlWitnessProductAutomaton.matchesEndLocation((IElement)((IIcfgReturnTransition)LETTER).getCorrespondingCall(), waypoint);
            }
            return YamlWitnessProductAutomaton.matchesEndLocation(LETTER, waypoint);
        }
        return false;
    }

    private static boolean matchesStartLocation(IElement iElement, Waypoint waypoint) {
        ILocation iLocation = ILocation.getAnnotation((IElement)iElement);
        if (iLocation == null) {
            return false;
        }
        Location location = waypoint.getLocation();
        return iLocation.getStartLine() == location.getLine().intValue() && (location.getColumn() == null || location.getColumn().intValue() == iLocation.getStartColumn());
    }

    private static boolean matchesEndLocation(IElement iElement, Waypoint waypoint) {
        ILocation iLocation = ILocation.getAnnotation((IElement)iElement);
        if (iLocation == null) {
            return false;
        }
        Location location = waypoint.getLocation();
        return iLocation.getEndLine() == location.getLine().intValue() && (location.getColumn() == null || location.getColumn() == iLocation.getEndColumn() - 1);
    }

    private IPredicate createProductState(IPredicate iPredicate, int n, int n2) {
        ProductPredicate productPredicate;
        if (iPredicate instanceof ISLPredicate) {
            productPredicate = new ProductSLPredicate((ISLPredicate)iPredicate, n, n2);
        } else if (iPredicate instanceof IMLPredicate) {
            productPredicate = new ProductMLPredicate((IMLPredicate)iPredicate, n, n2);
        } else {
            throw new AssertionError((Object)("Unknown predicate type " + iPredicate.getClass().getSimpleName()));
        }
        this.mAllProductStates.add(productPredicate);
        return productPredicate;
    }

    public List<Waypoint> getUnmatchedFollowWaypoints() {
        return this.mWitness.getEntries().stream().flatMap(witnessEntry -> ((ViolationSequence)witnessEntry).getSegments().stream().map(Segment::getFollowOrCycleWaypoint)).filter(waypoint -> !this.mMatchedFollowWaypoints.contains(waypoint)).toList();
    }

    private static final class ProductMLPredicate
    extends ProductPredicate<IMLPredicate>
    implements IMLPredicate {
        public ProductMLPredicate(IMLPredicate iMLPredicate, int n, int n2) {
            super(iMLPredicate, n, n2);
        }

        public IcfgLocation[] getProgramPoints() {
            return ((IMLPredicate)this.mUnderlying).getProgramPoints();
        }
    }

    private static class ProductPredicate<P extends IPredicate>
    extends AnnotatedPredicate<P, Pair<Integer, Integer>> {
        public ProductPredicate(P p, int n, int n2) {
            super(p, (Object)new Pair((Object)n, (Object)n2));
        }

        public int getSegmentCounter() {
            return (Integer)((Pair)this.mAnnotation).getFirst();
        }

        public int getViolationSequenceCounter() {
            return (Integer)((Pair)this.mAnnotation).getSecond();
        }
    }

    private static final class ProductSLPredicate
    extends ProductPredicate<ISLPredicate>
    implements ISLPredicate {
        public ProductSLPredicate(ISLPredicate iSLPredicate, int n, int n2) {
            super(iSLPredicate, n, n2);
        }

        public IcfgLocation getProgramPoint() {
            return ((ISLPredicate)this.mUnderlying).getProgramPoint();
        }
    }
}

