/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util;

import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class TarjanSCC {
    private int mMaxIndex;
    private Deque<String> mStack;
    private Map<String, Set<String>> mGraph;
    private Set<ImmutableSet<String>> mSccs;
    private Map<String, Integer> mIndices;
    private Map<String, Integer> mLowLink;

    public ImmutableSet<ImmutableSet<String>> getSCCs(Map<String, Set<String>> map) {
        if (map == null || map.containsValue(null)) {
            throw new IllegalArgumentException();
        }
        this.mGraph = map;
        this.mMaxIndex = 0;
        this.mStack = new ArrayDeque<String>();
        this.mSccs = new LinkedHashSet<ImmutableSet<String>>();
        this.mIndices = new LinkedHashMap<String, Integer>();
        this.mLowLink = new LinkedHashMap<String, Integer>();
        for (String string : this.mGraph.keySet()) {
            if (this.mIndices.containsKey(string)) continue;
            this.strongConnect(string);
        }
        return ImmutableSet.of(this.mSccs);
    }

    private void strongConnect(String string) {
        if (!this.mGraph.containsKey(string)) {
            return;
        }
        this.mIndices.put(string, this.mMaxIndex);
        this.mLowLink.put(string, this.mMaxIndex);
        ++this.mMaxIndex;
        this.mStack.push(string);
        for (String object : this.mGraph.get(string)) {
            if (!this.mGraph.containsKey(object)) {
                this.mStack.remove(object);
                continue;
            }
            if (!this.mIndices.containsKey(object)) {
                this.strongConnect(object);
                this.mLowLink.put(string, Math.min(this.mLowLink.get(string), this.mLowLink.get(object)));
                continue;
            }
            if (!this.mStack.contains(object)) continue;
            this.mLowLink.put(string, Math.min(this.mLowLink.get(string), this.mIndices.get(object)));
        }
        if (this.mLowLink.get(string).equals(this.mIndices.get(string))) {
            String string2;
            LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
            do {
                string2 = this.mStack.pop();
                linkedHashSet.add(string2);
            } while (!string2.equals(string));
            this.mSccs.add((ImmutableSet<String>)ImmutableSet.of(linkedHashSet));
        }
    }
}

