/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.util.BFSIterator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableList;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class EnumerateWords {
    public static <L> Iterable<Word<L>> enumerate(INwaOutgoingTransitionProvider<L, ?> iNwaOutgoingTransitionProvider) {
        return () -> new WordIterator(iNwaOutgoingTransitionProvider);
    }

    public static <L> Stream<Word<L>> stream(INwaOutgoingTransitionProvider<L, ?> iNwaOutgoingTransitionProvider) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new WordIterator(iNwaOutgoingTransitionProvider), 1040), false);
    }

    private static class WordIterator<L, S>
    extends BFSIterator<S, OutgoingInternalTransition<L, S>, Word<L>> {
        private final INwaOutgoingTransitionProvider<L, S> mAutomaton;

        public WordIterator(INwaOutgoingTransitionProvider<L, S> iNwaOutgoingTransitionProvider) {
            super(iNwaOutgoingTransitionProvider.getInitialStates());
            assert (NestedWordAutomataUtils.isFiniteAutomaton(iNwaOutgoingTransitionProvider)) : "only finite automata are supported";
            this.mAutomaton = iNwaOutgoingTransitionProvider;
        }

        protected Iterable<OutgoingInternalTransition<L, S>> getOutgoing(S s) {
            return this.mAutomaton.internalSuccessors(s);
        }

        protected S getSuccessor(S s, OutgoingInternalTransition<L, S> outgoingInternalTransition) {
            return outgoingInternalTransition.getSucc();
        }

        protected boolean isTarget(S s) {
            return this.mAutomaton.isFinal(s);
        }

        protected Word<L> finish(ImmutableList<Pair<S, OutgoingInternalTransition<L, S>>> immutableList, S s) {
            Object[] objectArray = new Object[immutableList.size()];
            int n = immutableList.size() - 1;
            for (Pair pair : immutableList) {
                objectArray[n] = ((OutgoingInternalTransition)pair.getSecond()).getLetter();
                --n;
            }
            return new Word<Object>(objectArray);
        }
    }
}

