/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.BaseBlockEncoder;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;

public abstract class BaseMinimizeStates
extends BaseBlockEncoder<IcfgLocation> {
    private final boolean mIgnoreBlowup;
    private final BiPredicate<IIcfg<?>, IcfgLocation> mFunHasToBePreserved;
    private final IcfgEdgeBuilder mEdgeBuilder;

    public BaseMinimizeStates(IcfgEdgeBuilder icfgEdgeBuilder, IUltimateServiceProvider iUltimateServiceProvider, BlockEncodingBacktranslator blockEncodingBacktranslator, BiPredicate<IIcfg<?>, IcfgLocation> biPredicate, ILogger iLogger, boolean bl) {
        super(iLogger, iUltimateServiceProvider, blockEncodingBacktranslator);
        this.mIgnoreBlowup = bl;
        this.mFunHasToBePreserved = biPredicate;
        this.mEdgeBuilder = icfgEdgeBuilder;
    }

    @Override
    public boolean isGraphStructureChanged() {
        return this.mRemovedLocations > 0 || this.mRemovedEdges > 0;
    }

    @Override
    protected final BasicIcfg<IcfgLocation> createResult(BasicIcfg<IcfgLocation> basicIcfg) {
        ArrayDeque<? extends IcfgLocation> arrayDeque = new ArrayDeque<IcfgLocation>();
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        arrayDeque.addAll(basicIcfg.getInitialNodes());
        while (!arrayDeque.isEmpty()) {
            this.checkForTimeoutOrCancellation();
            IcfgLocation icfgLocation = (IcfgLocation)arrayDeque.removeFirst();
            if (hashSet.contains(icfgLocation)) continue;
            hashSet.add(icfgLocation);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Processing node " + String.valueOf(icfgLocation) + " [" + icfgLocation.hashCode() + "]"));
            }
            arrayDeque.addAll(this.processCandidate((IIcfg<?>)basicIcfg, icfgLocation, (Set<IcfgLocation>)hashSet));
        }
        if (this.mRemovedEdges > 0) {
            this.removeDisconnectedLocations(basicIcfg);
        }
        this.mLogger.info((Object)("Removed " + this.mRemovedEdges + " edges and " + this.mRemovedLocations + " locations by large block encoding"));
        return basicIcfg;
    }

    protected abstract Collection<? extends IcfgLocation> processCandidate(IIcfg<?> var1, IcfgLocation var2, Set<IcfgLocation> var3);

    protected boolean isAllCombinableEdgePair(List<IcfgEdge> list, List<IcfgEdge> list2) {
        if (!this.mIgnoreBlowup && BaseMinimizeStates.isLarge(list, list2)) {
            return false;
        }
        return list.stream().map(icfgEdge -> icfgEdge2 -> this.isCombinableEdgePair((IcfgEdge)icfgEdge, (IcfgEdge)icfgEdge2)).allMatch(predicate -> list2.stream().allMatch(predicate));
    }

    protected boolean isCombinableEdgePair(IcfgEdge icfgEdge, IcfgEdge icfgEdge2) {
        if ((!(icfgEdge instanceof IIcfgCallTransition) || !(icfgEdge2 instanceof IIcfgReturnTransition)) && (icfgEdge instanceof IIcfgReturnTransition || icfgEdge instanceof IIcfgCallTransition || icfgEdge2 instanceof IIcfgReturnTransition || icfgEdge2 instanceof IIcfgCallTransition)) {
            return false;
        }
        return !Objects.equals(icfgEdge.getTarget(), icfgEdge.getSource()) && !Objects.equals(icfgEdge2.getTarget(), icfgEdge2.getSource());
    }

    protected boolean isAllNecessary(IIcfg<?> iIcfg, List<IcfgLocation> list) {
        return list.stream().allMatch(icfgLocation -> this.mFunHasToBePreserved.test(iIcfg, (IcfgLocation)icfgLocation));
    }

    protected boolean isNecessary(IIcfg<?> iIcfg, IcfgLocation icfgLocation) {
        return this.mFunHasToBePreserved.test(iIcfg, icfgLocation);
    }

    protected boolean isNotNecessary(IIcfg<?> iIcfg, IcfgLocation icfgLocation) {
        return this.mFunHasToBePreserved.negate().test(iIcfg, icfgLocation);
    }

    protected boolean isAnyNecessary(IIcfg<?> iIcfg, IcfgLocation icfgLocation, IcfgLocation icfgLocation2) {
        return this.mFunHasToBePreserved.test(iIcfg, icfgLocation) || this.mFunHasToBePreserved.test(iIcfg, icfgLocation2);
    }

    protected IcfgEdgeBuilder getEdgeBuilder() {
        return this.mEdgeBuilder;
    }

    private void checkForTimeoutOrCancellation() {
        if (!this.mServices.getProgressMonitorService().continueProcessing()) {
            this.mLogger.info((Object)("Stopping block encoding due to timeout after removing " + this.mRemovedEdges + " edges and " + this.mRemovedLocations + " locations (locations are removed at the end)"));
            throw new ToolchainCanceledException(this.getClass());
        }
    }

    private static boolean isLarge(List<IcfgEdge> list, List<IcfgEdge> list2) {
        int n;
        int n2 = list.size();
        return n2 + (n = list2.size()) < n2 * n;
    }
}

